/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.ReputationService;
import com.alan.VillagerTradeManager.services.SettingsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class PriceCalculationService {
    private final VillagerTradeManager plugin;
    private final ReputationService reputationService;
    private final SettingsService settingsService;
    private final TaskScheduler taskScheduler;
    private final Map<String, DemandData> tradeDemand = new ConcurrentHashMap<String, DemandData>();
    private static final long DEMAND_WINDOW_MS = 3600000L;
    private static final int MAX_DEMAND_ENTRIES = 10000;
    private double lowDemandMultiplier = 0.9;
    private double normalDemandMultiplier = 1.0;
    private double highDemandMultiplier = 1.15;
    private double veryHighDemandMultiplier = 1.3;
    private int lowDemandThreshold = 1;
    private int highDemandThreshold = 5;
    private int veryHighDemandThreshold = 10;

    public PriceCalculationService(VillagerTradeManager plugin, ReputationService reputationService, SettingsService settingsService, TaskScheduler taskScheduler) {
        this.plugin = plugin;
        this.reputationService = reputationService;
        this.settingsService = settingsService;
        this.taskScheduler = taskScheduler;
        this.loadConfiguration();
        this.startDemandCleanupTask();
    }

    private void loadConfiguration() {
        this.lowDemandThreshold = this.plugin.getConfig().getInt("price_dynamics.demand_tracking.low_threshold", 1);
        this.highDemandThreshold = this.plugin.getConfig().getInt("price_dynamics.demand_tracking.high_threshold", 5);
        this.veryHighDemandThreshold = this.plugin.getConfig().getInt("price_dynamics.demand_tracking.very_high_threshold", 10);
        this.lowDemandMultiplier = this.plugin.getConfig().getDouble("price_dynamics.demand_tracking.multipliers.low_demand", 0.9);
        this.normalDemandMultiplier = this.plugin.getConfig().getDouble("price_dynamics.demand_tracking.multipliers.normal_demand", 1.0);
        this.highDemandMultiplier = this.plugin.getConfig().getDouble("price_dynamics.demand_tracking.multipliers.high_demand", 1.15);
        this.veryHighDemandMultiplier = this.plugin.getConfig().getDouble("price_dynamics.demand_tracking.multipliers.very_high_demand", 1.3);
        if (this.plugin.getConfig().getBoolean("logging.debug_price_dynamics", false)) {
            this.plugin.getLogger().fine("Loaded price dynamics configuration: thresholds=[" + this.lowDemandThreshold + "," + this.highDemandThreshold + "," + this.veryHighDemandThreshold + "], multipliers=[" + this.lowDemandMultiplier + "," + this.normalDemandMultiplier + "," + this.highDemandMultiplier + "," + this.veryHighDemandMultiplier + "]");
        }
    }

    public int calculateDynamicPrice(Player player, MerchantRecipe recipe, String profession, String tradeId) {
        if (!this.isPriceDynamicsEnabled()) {
            return this.getBasePrice(recipe);
        }
        double finalMultiplier = 1.0;
        if (this.isReputationPricingEnabled()) {
            ReputationService.ReputationTier tier = this.reputationService.getReputationTier(player);
            finalMultiplier *= tier.getPriceMultiplier();
            if (this.plugin.getConfig().getBoolean("logging.debug_price_dynamics", false)) {
                this.plugin.getLogger().fine("Applied reputation multiplier for " + player.getName() + ": " + tier.getDisplayName() + " (" + String.format("%.2f", tier.getPriceMultiplier()) + "x)");
            }
        }
        if (this.isDemandPricingEnabled() && tradeId != null) {
            double demandMultiplier = this.calculateDemandMultiplier(profession, tradeId);
            finalMultiplier *= demandMultiplier;
            if (this.plugin.getConfig().getBoolean("logging.debug_price_dynamics", false)) {
                this.plugin.getLogger().fine("Applied demand multiplier for " + tradeId + ": " + String.format("%.2f", demandMultiplier) + "x");
            }
        }
        int basePrice = this.getBasePrice(recipe);
        int finalPrice = (int)Math.max(1L, Math.round((double)basePrice * finalMultiplier));
        if (this.plugin.getConfig().getBoolean("logging.debug_price_dynamics", false)) {
            this.plugin.getLogger().fine("Price calculation for " + player.getName() + " - " + tradeId + ": " + basePrice + " -> " + finalPrice + " (multiplier: " + String.format("%.2f", finalMultiplier) + "x)");
        }
        return finalPrice;
    }

    public void recordTradeUsage(String profession, String tradeId) {
        if (!this.isDemandPricingEnabled() || tradeId == null) {
            return;
        }
        String demandKey = profession + "_" + tradeId;
        long currentTime = System.currentTimeMillis();
        this.tradeDemand.compute(demandKey, (key, existing) -> {
            if (existing == null) {
                return new DemandData(1, currentTime);
            }
            return new DemandData(existing.usageCount + 1, currentTime);
        });
        if (this.tradeDemand.size() > 10000) {
            this.cleanupOldDemandEntries();
        }
    }

    private double calculateDemandMultiplier(String profession, String tradeId) {
        String demandKey = profession + "_" + tradeId;
        DemandData demand = this.tradeDemand.get(demandKey);
        if (demand == null || this.isDemandExpired(demand)) {
            return this.normalDemandMultiplier;
        }
        int usageCount = demand.usageCount;
        if (usageCount <= this.lowDemandThreshold) {
            return this.lowDemandMultiplier;
        }
        if (usageCount <= this.highDemandThreshold) {
            return this.normalDemandMultiplier;
        }
        if (usageCount <= this.veryHighDemandThreshold) {
            return this.highDemandMultiplier;
        }
        return this.veryHighDemandMultiplier;
    }

    private boolean isDemandExpired(DemandData demand) {
        return System.currentTimeMillis() - demand.lastUpdated > 3600000L;
    }

    public int getBasePrice(MerchantRecipe recipe) {
        List ingredients = recipe.getIngredients();
        int totalEmeralds = 0;
        for (ItemStack ingredient : ingredients) {
            if (ingredient.getType() != Material.EMERALD) continue;
            totalEmeralds += ingredient.getAmount();
        }
        return Math.max(1, totalEmeralds);
    }

    private void startDemandCleanupTask() {
        this.taskScheduler.runAsyncRepeating(() -> {
            try {
                this.cleanupOldDemandEntries();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error during demand cleanup: " + e.getMessage());
            }
        }, 1200L, 1200L);
    }

    private void cleanupOldDemandEntries() {
        long currentTime = System.currentTimeMillis();
        this.tradeDemand.entrySet().removeIf(entry -> currentTime - ((DemandData)entry.getValue()).lastUpdated > 3600000L);
        if (this.plugin.getConfig().getBoolean("logging.debug_price_dynamics", false)) {
            this.plugin.getLogger().fine("Cleaned up demand entries. Remaining: " + this.tradeDemand.size());
        }
    }

    public Map<String, Object> getDemandStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalDemandEntries", this.tradeDemand.size());
        stats.put("maxDemandEntries", 10000);
        stats.put("demandWindowMs", 3600000L);
        int lowDemand = 0;
        int normalDemand = 0;
        int highDemand = 0;
        int veryHighDemand = 0;
        for (DemandData demand : this.tradeDemand.values()) {
            if (this.isDemandExpired(demand)) continue;
            int count = demand.usageCount;
            if (count <= this.lowDemandThreshold) {
                ++lowDemand;
                continue;
            }
            if (count <= this.highDemandThreshold) {
                ++normalDemand;
                continue;
            }
            if (count <= this.veryHighDemandThreshold) {
                ++highDemand;
                continue;
            }
            ++veryHighDemand;
        }
        stats.put("lowDemandTrades", lowDemand);
        stats.put("normalDemandTrades", normalDemand);
        stats.put("highDemandTrades", highDemand);
        stats.put("veryHighDemandTrades", veryHighDemand);
        return stats;
    }

    private boolean isPriceDynamicsEnabled() {
        return this.settingsService.isPriceDynamicsEnabled();
    }

    private boolean isReputationPricingEnabled() {
        return this.settingsService.isReputationPricingEnabled();
    }

    private boolean isDemandPricingEnabled() {
        return this.settingsService.isDemandPricingEnabled();
    }

    public ReputationService getReputationService() {
        return this.reputationService;
    }

    private static class DemandData {
        final int usageCount;
        final long lastUpdated;

        DemandData(int usageCount, long lastUpdated) {
            this.usageCount = usageCount;
            this.lastUpdated = lastUpdated;
        }
    }
}

