/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.services.DatabaseService;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class ReputationService {
    private final VillagerTradeManager plugin;
    private final DatabaseService databaseService;
    public static final int RAID_PARTICIPATION_POINTS = 50;
    public static final int HERO_VILLAGER_KILL_POINTS = -30;
    public static final int MIN_REPUTATION = -500;
    public static final int MAX_REPUTATION = 1000;
    public static final int NEUTRAL_REPUTATION = 0;

    public ReputationService(VillagerTradeManager plugin, DatabaseService databaseService) {
        this.plugin = plugin;
        this.databaseService = databaseService;
    }

    public int getPlayerReputation(UUID playerUuid) {
        try {
            Integer reputation = this.databaseService.executeQuery("SELECT reputation_score FROM player_reputation WHERE player_uuid = ?", rs -> rs.next() ? rs.getInt("reputation_score") : 0, "getPlayerReputation");
            return reputation != null ? reputation : 0;
        }
        catch (DatabaseException e) {
            this.logDatabaseException("Could not get player reputation", e, Level.WARNING);
            return 0;
        }
    }

    public int getPlayerReputation(Player player) {
        return this.getPlayerReputation(player.getUniqueId());
    }

    public void addReputationPoints(UUID playerUuid, int points) {
        this.databaseService.executeAsync(() -> {
            try {
                int rowsAffected = this.databaseService.executeUpdate("UPDATE player_reputation SET reputation_score = MIN(?, reputation_score + ?), last_updated = ? WHERE player_uuid = ?", pstmt -> {
                    int newScore = Math.max(-500, Math.min(1000, this.getPlayerReputation(playerUuid) + points));
                    pstmt.setInt(1, 1000);
                    pstmt.setInt(2, points);
                    pstmt.setLong(3, System.currentTimeMillis());
                    pstmt.setString(4, playerUuid.toString());
                }, "addReputationPoints_update");
                if (rowsAffected == 0) {
                    int finalPoints = points;
                    this.databaseService.executeUpdate("INSERT INTO player_reputation (player_uuid, reputation_score, raid_participation_count, hero_villager_kills, last_updated, created_at) VALUES (?, ?, 0, 0, ?, ?)", pstmt -> {
                        int newScore = Math.max(-500, Math.min(1000, finalPoints));
                        pstmt.setString(1, playerUuid.toString());
                        pstmt.setInt(2, newScore);
                        pstmt.setLong(3, System.currentTimeMillis());
                        pstmt.setLong(4, System.currentTimeMillis());
                    }, "addReputationPoints_insert");
                }
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Added " + points + " reputation points to player " + String.valueOf(playerUuid) + " (new total: " + this.getPlayerReputation(playerUuid) + ")");
                }
                return null;
            }
            catch (DatabaseException e) {
                this.logDatabaseException("Could not add reputation points", e, Level.SEVERE);
                return null;
            }
        }, "addReputationPoints");
    }

    public void recordRaidParticipation(UUID playerUuid) {
        this.databaseService.executeAsync(() -> {
            try {
                int rowsAffected = this.databaseService.executeUpdate("UPDATE player_reputation SET reputation_score = MIN(?, reputation_score + ?), raid_participation_count = raid_participation_count + 1, last_updated = ? WHERE player_uuid = ?", pstmt -> {
                    pstmt.setInt(1, 1000);
                    pstmt.setInt(2, 50);
                    pstmt.setLong(3, System.currentTimeMillis());
                    pstmt.setString(4, playerUuid.toString());
                }, "recordRaidParticipation_update");
                if (rowsAffected == 0) {
                    this.databaseService.executeUpdate("INSERT INTO player_reputation (player_uuid, reputation_score, raid_participation_count, hero_villager_kills, last_updated, created_at) VALUES (?, ?, 1, 0, ?, ?)", pstmt -> {
                        pstmt.setString(1, playerUuid.toString());
                        pstmt.setInt(2, 50);
                        pstmt.setLong(3, System.currentTimeMillis());
                        pstmt.setLong(4, System.currentTimeMillis());
                    }, "recordRaidParticipation_insert");
                }
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Recorded raid participation for player " + String.valueOf(playerUuid));
                }
                return null;
            }
            catch (DatabaseException e) {
                this.logDatabaseException("Could not record raid participation", e, Level.SEVERE);
                return null;
            }
        }, "recordRaidParticipation");
    }

    public void recordHeroVillagerKill(UUID playerUuid) {
        this.databaseService.executeAsync(() -> {
            try {
                int rowsAffected = this.databaseService.executeUpdate("UPDATE player_reputation SET reputation_score = MAX(?, reputation_score + ?), hero_villager_kills = hero_villager_kills + 1, last_updated = ? WHERE player_uuid = ?", pstmt -> {
                    pstmt.setInt(1, -500);
                    pstmt.setInt(2, -30);
                    pstmt.setLong(3, System.currentTimeMillis());
                    pstmt.setString(4, playerUuid.toString());
                }, "recordHeroVillagerKill_update");
                if (rowsAffected == 0) {
                    this.databaseService.executeUpdate("INSERT INTO player_reputation (player_uuid, reputation_score, raid_participation_count, hero_villager_kills, last_updated, created_at) VALUES (?, ?, 0, 1, ?, ?)", pstmt -> {
                        pstmt.setString(1, playerUuid.toString());
                        pstmt.setInt(2, -30);
                        pstmt.setLong(3, System.currentTimeMillis());
                        pstmt.setLong(4, System.currentTimeMillis());
                    }, "recordHeroVillagerKill_insert");
                }
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Recorded hero villager kill for player " + String.valueOf(playerUuid));
                }
                return null;
            }
            catch (DatabaseException e) {
                this.logDatabaseException("Could not record hero villager kill", e, Level.SEVERE);
                return null;
            }
        }, "recordHeroVillagerKill");
    }

    public PlayerReputationStats getPlayerReputationStats(UUID playerUuid) {
        try {
            return this.databaseService.executeQuery("SELECT reputation_score, raid_participation_count, hero_villager_kills FROM player_reputation WHERE player_uuid = ?", rs -> {
                if (rs.next()) {
                    return new PlayerReputationStats(rs.getInt("reputation_score"), rs.getInt("raid_participation_count"), rs.getInt("hero_villager_kills"));
                }
                return new PlayerReputationStats(0, 0, 0);
            }, "getPlayerReputationStats");
        }
        catch (DatabaseException e) {
            this.logDatabaseException("Could not get player reputation stats", e, Level.WARNING);
            return new PlayerReputationStats(0, 0, 0);
        }
    }

    public ReputationTier getReputationTier(int reputationScore) {
        if (reputationScore >= 500) {
            return ReputationTier.HEROIC;
        }
        if (reputationScore >= 200) {
            return ReputationTier.TRUSTED;
        }
        if (reputationScore >= 50) {
            return ReputationTier.FRIENDLY;
        }
        if (reputationScore >= -50) {
            return ReputationTier.NEUTRAL;
        }
        if (reputationScore >= -200) {
            return ReputationTier.SUSPICIOUS;
        }
        return ReputationTier.HOSTILE;
    }

    public ReputationTier getReputationTier(UUID playerUuid) {
        return this.getReputationTier(this.getPlayerReputation(playerUuid));
    }

    public ReputationTier getReputationTier(Player player) {
        return this.getReputationTier(player.getUniqueId());
    }

    private void logDatabaseException(String context, Exception e, Level level) {
        DatabaseException dbException = new DatabaseException(context + ": " + e.getMessage(), "ReputationService", "database_operation", e);
        this.plugin.getLogger().log(level, dbException.getMessage());
    }

    public static class PlayerReputationStats {
        public final int reputationScore;
        public final int raidParticipationCount;
        public final int heroVillagerKills;

        public PlayerReputationStats(int reputationScore, int raidParticipationCount, int heroVillagerKills) {
            this.reputationScore = reputationScore;
            this.raidParticipationCount = raidParticipationCount;
            this.heroVillagerKills = heroVillagerKills;
        }
    }

    public static enum ReputationTier {
        HEROIC(0.7, "Heroic"),
        TRUSTED(0.8, "Trusted"),
        FRIENDLY(0.9, "Friendly"),
        NEUTRAL(1.0, "Neutral"),
        SUSPICIOUS(1.2, "Suspicious"),
        HOSTILE(1.5, "Hostile");

        private final double priceMultiplier;
        private final String displayName;

        private ReputationTier(double priceMultiplier, String displayName) {
            this.priceMultiplier = priceMultiplier;
            this.displayName = displayName;
        }

        public double getPriceMultiplier() {
            return this.priceMultiplier;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

