/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.services.DatabaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Material;

public class SettingsService {
    private final VillagerTradeManager plugin;
    private final DatabaseService databaseService;
    private boolean tradeManagementEnabled = true;
    private boolean customRestockEnabled = false;
    private boolean unlimitedRestock = false;
    private boolean instantRestockEnabled = false;
    private int restockIntervalMinutes = 30;
    private int restockLimitPerDay = 3;
    private boolean priceDynamicsEnabled = true;
    private boolean reputationPricingEnabled = true;
    private boolean heroDiscountEnabled = true;
    private boolean demandPricingEnabled = true;
    private final Map<String, Boolean> professionToggles = new HashMap<String, Boolean>();

    public SettingsService(VillagerTradeManager plugin, DatabaseService databaseService) {
        this.plugin = plugin;
        this.databaseService = databaseService;
        this.initializeDatabase();
        this.loadSettingsFromDatabase();
        this.initializeProfessionToggles();
    }

    public void initializeDatabase() {
        try {
            this.createTables();
            this.plugin.getLogger().info("Database tables initialized successfully");
        }
        catch (DatabaseException e) {
            this.logDatabaseException("Could not create database tables", e, Level.SEVERE);
        }
    }

    private void createTables() throws DatabaseException {
        this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS custom_prices (item_key TEXT PRIMARY KEY, price INTEGER NOT NULL)", null, "createTables");
        this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS settings (key TEXT PRIMARY KEY, value TEXT)", null, "createTables");
        this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS villager_restock_data (villager_uuid TEXT PRIMARY KEY, last_restock_time INTEGER, restock_count_today INTEGER, last_reset_day INTEGER)", null, "createTables");
        this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS villager_progression (villager_uuid TEXT PRIMARY KEY, current_xp INTEGER NOT NULL DEFAULT 0, current_level INTEGER NOT NULL DEFAULT 1, total_xp_earned INTEGER NOT NULL DEFAULT 0, profession TEXT, last_updated INTEGER NOT NULL, created_at INTEGER NOT NULL)", null, "createTables");
        this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS banned_items (item_type TEXT PRIMARY KEY, banned_by TEXT, banned_at INTEGER, reason TEXT)", null, "createTables");
        this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS player_reputation (player_uuid TEXT PRIMARY KEY, reputation_score INTEGER NOT NULL DEFAULT 0, raid_participation_count INTEGER NOT NULL DEFAULT 0, hero_villager_kills INTEGER NOT NULL DEFAULT 0, last_updated INTEGER NOT NULL, created_at INTEGER NOT NULL)", null, "createTables");
    }

    public void loadSettingsFromDatabase() {
        try {
            this.databaseService.executeQuery("SELECT key, value FROM settings", rs -> {
                block28: while (rs.next()) {
                    String key = rs.getString("key");
                    String value = rs.getString("value");
                    switch (key) {
                        case "trade_management_enabled": {
                            this.tradeManagementEnabled = Boolean.parseBoolean(value);
                            continue block28;
                        }
                        case "custom_restock_enabled": {
                            this.customRestockEnabled = Boolean.parseBoolean(value);
                            continue block28;
                        }
                        case "unlimited_restock": {
                            this.unlimitedRestock = Boolean.parseBoolean(value);
                            continue block28;
                        }
                        case "instant_restock_enabled": {
                            this.instantRestockEnabled = Boolean.parseBoolean(value);
                            continue block28;
                        }
                        case "restock_interval_minutes": {
                            try {
                                this.restockIntervalMinutes = Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                this.restockIntervalMinutes = 30;
                            }
                            continue block28;
                        }
                        case "restock_limit_per_day": {
                            try {
                                this.restockLimitPerDay = Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                this.restockLimitPerDay = 3;
                            }
                            continue block28;
                        }
                        case "price_dynamics_enabled": {
                            this.priceDynamicsEnabled = Boolean.parseBoolean(value);
                            continue block28;
                        }
                        case "reputation_pricing_enabled": {
                            this.reputationPricingEnabled = Boolean.parseBoolean(value);
                            continue block28;
                        }
                        case "hero_discount_enabled": {
                            this.heroDiscountEnabled = Boolean.parseBoolean(value);
                            continue block28;
                        }
                        case "demand_pricing_enabled": {
                            this.demandPricingEnabled = Boolean.parseBoolean(value);
                            continue block28;
                        }
                    }
                    if (!key.startsWith("profession_") || !key.endsWith("_enabled")) continue;
                    String profession = key.substring(11, key.length() - 8);
                    this.professionToggles.put(profession, Boolean.parseBoolean(value));
                }
                return null;
            }, "loadSettingsFromDatabase");
        }
        catch (DatabaseException e) {
            this.logDatabaseException("Could not load settings from database", e, Level.SEVERE);
        }
    }

    public boolean getBooleanSetting(String key) {
        try {
            Boolean result = this.databaseService.executeQuery("SELECT value FROM settings WHERE key = '" + key + "'", rs -> {
                if (rs.next()) {
                    return Boolean.parseBoolean(rs.getString("value"));
                }
                return null;
            }, "getBooleanSetting");
            if (result != null) {
                return result;
            }
        }
        catch (DatabaseException e) {
            this.logDatabaseException("Could not retrieve boolean setting '" + key + "' from database", e, Level.WARNING);
        }
        boolean defaultValue = this.getDefaultBooleanValue(key);
        return this.plugin.getConfig().getBoolean("settings." + key.replace("_", "_"), defaultValue);
    }

    public int getIntSetting(String key) {
        try {
            Integer result = this.databaseService.executeQuery("SELECT value FROM settings WHERE key = '" + key + "'", rs -> {
                if (rs.next()) {
                    return Integer.parseInt(rs.getString("value"));
                }
                return null;
            }, "getIntSetting");
            if (result != null) {
                return result;
            }
        }
        catch (DatabaseException | NumberFormatException e) {
            if (e instanceof DatabaseException) {
                this.logDatabaseException("Could not retrieve integer setting '" + key + "' from database", e, Level.WARNING);
            }
            this.plugin.getLogger().warning("Invalid integer value for setting '" + key + "': " + e.getMessage());
        }
        int defaultValue = this.getDefaultIntValue(key);
        return this.plugin.getConfig().getInt("settings." + key.replace("_", "_"), defaultValue);
    }

    public void populateFromMap(Map<String, String> settingsMap) {
        settingsMap.forEach((key, value) -> {
            try {
                switch (key) {
                    case "trade_management_enabled": {
                        this.tradeManagementEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "custom_restock_enabled": {
                        this.customRestockEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "unlimited_restock": {
                        this.unlimitedRestock = Boolean.parseBoolean(value);
                        break;
                    }
                    case "instant_restock_enabled": {
                        this.instantRestockEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "restock_interval_minutes": {
                        this.restockIntervalMinutes = Integer.parseInt(value);
                        break;
                    }
                    case "restock_limit_per_day": {
                        this.restockLimitPerDay = Integer.parseInt(value);
                        break;
                    }
                    case "price_dynamics_enabled": {
                        this.priceDynamicsEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "reputation_pricing_enabled": {
                        this.reputationPricingEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "hero_discount_enabled": {
                        this.heroDiscountEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "demand_pricing_enabled": {
                        this.demandPricingEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    default: {
                        if (key.startsWith("profession_") && key.endsWith("_enabled")) {
                            String profession = key.substring(11, key.length() - 8);
                            this.professionToggles.put(profession, Boolean.parseBoolean(value));
                        }
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Invalid value for setting '" + key + "': " + value);
            }
        });
    }

    private boolean getDefaultBooleanValue(String key) {
        switch (key) {
            case "trade_management_enabled": {
                return true;
            }
            case "custom_restock_enabled": 
            case "unlimited_restock": 
            case "instant_restock_enabled": {
                return false;
            }
        }
        return false;
    }

    private int getDefaultIntValue(String key) {
        switch (key) {
            case "restock_interval_minutes": {
                return 30;
            }
            case "restock_limit_per_day": {
                return 3;
            }
        }
        return 0;
    }

    public void saveSettingToDatabase(String key, String value) {
        this.databaseService.executeAsync(() -> {
            try {
                this.databaseService.executeUpdate("INSERT OR REPLACE INTO settings (key, value) VALUES (?, ?)", pstmt -> {
                    pstmt.setString(1, key);
                    pstmt.setString(2, value);
                }, "saveSettingToDatabase");
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Saved setting " + key + " = " + value);
                }
                return null;
            }
            catch (DatabaseException e) {
                this.logDatabaseException("Could not save setting to database", e, Level.SEVERE);
                return null;
            }
        }, "saveSettingToDatabase");
    }

    public boolean isTradeManagementEnabled() {
        return this.tradeManagementEnabled;
    }

    public void setTradeManagementEnabled(boolean enabled) {
        this.tradeManagementEnabled = enabled;
    }

    public boolean isCustomRestockEnabled() {
        return this.customRestockEnabled;
    }

    public void setCustomRestockEnabled(boolean enabled) {
        this.customRestockEnabled = enabled;
    }

    public boolean isUnlimitedRestock() {
        return this.unlimitedRestock;
    }

    public void setUnlimitedRestock(boolean unlimited) {
        this.unlimitedRestock = unlimited;
    }

    public boolean isInstantRestockEnabled() {
        return this.instantRestockEnabled;
    }

    public void setInstantRestockEnabled(boolean enabled) {
        this.instantRestockEnabled = enabled;
    }

    public int getRestockIntervalMinutes() {
        return this.restockIntervalMinutes;
    }

    public void setRestockIntervalMinutes(int minutes) {
        this.restockIntervalMinutes = minutes;
    }

    public int getRestockLimitPerDay() {
        return this.restockLimitPerDay;
    }

    public void setRestockLimitPerDay(int limit) {
        this.restockLimitPerDay = limit;
    }

    public boolean isPriceDynamicsEnabled() {
        return this.priceDynamicsEnabled;
    }

    public void setPriceDynamicsEnabled(boolean enabled) {
        this.priceDynamicsEnabled = enabled;
    }

    public boolean isReputationPricingEnabled() {
        return this.reputationPricingEnabled;
    }

    public void setReputationPricingEnabled(boolean enabled) {
        this.reputationPricingEnabled = enabled;
    }

    public boolean isHeroDiscountEnabled() {
        return this.heroDiscountEnabled;
    }

    public void setHeroDiscountEnabled(boolean enabled) {
        this.heroDiscountEnabled = enabled;
    }

    public boolean isDemandPricingEnabled() {
        return this.demandPricingEnabled;
    }

    public void setDemandPricingEnabled(boolean enabled) {
        this.demandPricingEnabled = enabled;
    }

    private void initializeProfessionToggles() {
        String[] professions;
        for (String profession : professions = new String[]{"armorer", "butcher", "cartographer", "cleric", "farmer", "fisherman", "fletcher", "leatherworker", "librarian", "mason", "shepherd", "toolsmith", "weaponsmith"}) {
            this.professionToggles.put(profession, this.plugin.getConfig().getBoolean("professions." + profession + ".enabled", true));
        }
    }

    public boolean isProfessionEnabled(String profession) {
        return this.professionToggles.getOrDefault(profession.toLowerCase(), true);
    }

    public void setProfessionEnabled(String profession, boolean enabled) {
        this.professionToggles.put(profession.toLowerCase(), enabled);
        this.saveSettingToDatabase("profession_" + profession.toLowerCase() + "_enabled", String.valueOf(enabled));
    }

    public Set<String> getEnabledProfessions() {
        return this.professionToggles.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getDisabledProfessions() {
        return this.professionToggles.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void banItem(String itemType, String bannedBy) {
        this.databaseService.executeAsync(() -> {
            try {
                this.databaseService.executeUpdate("INSERT OR REPLACE INTO banned_items (item_type, banned_by, banned_at, reason) VALUES (?, ?, ?, ?)", pstmt -> {
                    pstmt.setString(1, itemType.toUpperCase());
                    pstmt.setString(2, bannedBy);
                    pstmt.setLong(3, System.currentTimeMillis());
                    pstmt.setString(4, "Item disabled from villager trades");
                }, "banItem");
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Banned item: " + itemType + " (banned by: " + bannedBy + ")");
                }
                return null;
            }
            catch (DatabaseException e) {
                this.logDatabaseException("Could not ban item in database", e, Level.SEVERE);
                return null;
            }
        }, "banItem");
    }

    public void unbanItem(String itemType) {
        this.databaseService.executeAsync(() -> {
            try {
                int rowsAffected = this.databaseService.executeUpdate("DELETE FROM banned_items WHERE item_type = ?", pstmt -> pstmt.setString(1, itemType.toUpperCase()), "unbanItem");
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Unbanned item: " + itemType + " (rows affected: " + rowsAffected + ")");
                }
                return null;
            }
            catch (DatabaseException e) {
                this.logDatabaseException("Could not unban item in database", e, Level.SEVERE);
                return null;
            }
        }, "unbanItem");
    }

    public boolean isItemBanned(String itemType) {
        try {
            return this.databaseService.executeQuery("SELECT item_type FROM banned_items WHERE item_type = '" + itemType.toUpperCase() + "'", rs -> rs.next(), "isItemBanned");
        }
        catch (DatabaseException e) {
            this.logDatabaseException("Could not check if item is banned", e, Level.WARNING);
            return false;
        }
    }

    public boolean isItemBanned(Material material) {
        return this.isItemBanned(material.name());
    }

    public List<String> getAllBannedItems() {
        ArrayList<String> bannedItems = new ArrayList<String>();
        try {
            this.databaseService.executeQuery("SELECT item_type FROM banned_items ORDER BY item_type", rs -> {
                while (rs.next()) {
                    String itemType = rs.getString("item_type");
                    bannedItems.add(itemType);
                }
                return null;
            }, "getAllBannedItems");
        }
        catch (DatabaseException e) {
            this.logDatabaseException("Failed to retrieve banned items", e, Level.SEVERE);
        }
        return bannedItems;
    }

    private void logDatabaseException(String context, Exception e, Level level) {
        DatabaseException dbException = new DatabaseException(context + ": " + e.getMessage(), "SettingsService", "database_operation", e);
        this.plugin.getLogger().log(level, dbException.getMessage());
    }
}

