/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.services.TradeRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;

public class SimpleTradeMapper {
    private static final Map<String, Map<String, String>> PROFESSION_ITEM_MAP = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> REVERSE_MAP = new HashMap<String, Map<String, String>>();

    public static void initialize() {
        SimpleTradeMapper.initializeMappings();
    }

    private static void initializeMappings() {
        SimpleTradeMapper.generateMappingsFromRegistry();
        SimpleTradeMapper.loadSpecialMappings();
        SimpleTradeMapper.buildReverseMappings();
    }

    private static void generateMappingsFromRegistry() {
        for (String tradeId : TradeRegistry.getAllTradeIds()) {
            String simpleName;
            TradeRegistry.TradeDefinition def = TradeRegistry.getTradeDefinition(tradeId);
            if (def == null || (simpleName = SimpleTradeMapper.deriveSimpleName(def)) == null) continue;
            SimpleTradeMapper.addMapping(def.getProfession(), simpleName, tradeId);
        }
    }

    private static String deriveSimpleName(TradeRegistry.TradeDefinition def) {
        if (def.isEnchantedBook()) {
            return def.getEnchantment().getKey().getKey().toLowerCase() + "_" + def.getEnchantmentLevel();
        }
        if (def.getOutputMaterial() == Material.EMERALD) {
            return def.getInputMaterial().name().toLowerCase();
        }
        if (def.getInputMaterial() == Material.EMERALD) {
            return def.getOutputMaterial().name().toLowerCase();
        }
        if (def.getOutputMaterial() != Material.EMERALD) {
            return def.getOutputMaterial().name().toLowerCase();
        }
        return null;
    }

    private static void addMapping(String profession, String simpleName, String tradeId) {
        PROFESSION_ITEM_MAP.computeIfAbsent(profession.toLowerCase(), k -> new LinkedHashMap()).put(simpleName.toLowerCase(), tradeId);
    }

    private static void loadSpecialMappings() {
        SimpleTradeMapper.addMapping("armorer", "diamond_helmet_respiration_3", "armorer_l5_emerald_30_diamond_helmet_respiration_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_helmet_aqua_affinity_1", "armorer_l5_emerald_30_diamond_helmet_aqua_affinity_1");
        SimpleTradeMapper.addMapping("armorer", "diamond_chestplate_protection_3", "armorer_l5_emerald_30_diamond_chestplate_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_chestplate_fire_protection_3", "armorer_l5_emerald_30_diamond_chestplate_fire_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_chestplate_blast_protection_3", "armorer_l5_emerald_30_diamond_chestplate_blast_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_chestplate_projectile_protection_3", "armorer_l5_emerald_30_diamond_chestplate_projectile_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_leggings_blast_protection_3", "armorer_l5_emerald_30_diamond_leggings_blast_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_leggings_fire_protection_3", "armorer_l5_emerald_30_diamond_leggings_fire_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_leggings_protection_3", "armorer_l5_emerald_30_diamond_leggings_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_leggings_projectile_protection_3", "armorer_l5_emerald_30_diamond_leggings_projectile_protection_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_boots_feather_falling_3", "armorer_l5_emerald_30_diamond_boots_feather_falling_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_boots_depth_strider_3", "armorer_l5_emerald_30_diamond_boots_depth_strider_3");
        SimpleTradeMapper.addMapping("armorer", "diamond_boots_frost_walker_2", "armorer_l5_emerald_30_diamond_boots_frost_walker_2");
        SimpleTradeMapper.addMapping("armorer", "diamond_boots_soul_speed_3", "armorer_l5_emerald_30_diamond_boots_soul_speed_3");
        SimpleTradeMapper.addMapping("armorer", "netherite_helmet", "armorer_l5_emerald_13_netherite_helmet_1");
        SimpleTradeMapper.addMapping("armorer", "netherite_chestplate", "armorer_l5_emerald_21_netherite_chestplate_1");
        SimpleTradeMapper.addMapping("armorer", "netherite_leggings", "armorer_l5_emerald_19_netherite_leggings_1");
        SimpleTradeMapper.addMapping("armorer", "netherite_boots", "armorer_l5_emerald_10_netherite_boots_1");
        SimpleTradeMapper.addMapping("cartographer", "ocean_explorer_map", "cartographer_l3_emerald_12_ocean_explorer_map_1");
        SimpleTradeMapper.addMapping("cartographer", "woodland_explorer_map", "cartographer_l3_emerald_12_woodland_explorer_map_1");
        SimpleTradeMapper.addMapping("cartographer", "trial_explorer_map", "cartographer_l5_emerald_12_trial_explorer_map_1");
        SimpleTradeMapper.addMapping("fletcher", "bow_power_4", "fletcher_l5_emerald_2_bow_power_4");
        SimpleTradeMapper.addMapping("fletcher", "bow_punch_2", "fletcher_l5_emerald_2_bow_punch_2");
        SimpleTradeMapper.addMapping("fletcher", "bow_flame_1", "fletcher_l5_emerald_2_bow_flame_1");
        SimpleTradeMapper.addMapping("fletcher", "bow_infinity_1", "fletcher_l5_emerald_2_bow_infinity_1");
        SimpleTradeMapper.addMapping("fletcher", "crossbow_quick_charge_3", "fletcher_l5_emerald_2_crossbow_quick_charge_3");
        SimpleTradeMapper.addMapping("fletcher", "crossbow_multishot_1", "fletcher_l5_emerald_2_crossbow_multishot_1");
        SimpleTradeMapper.addMapping("fletcher", "crossbow_piercing_4", "fletcher_l5_emerald_2_crossbow_piercing_4");
        SimpleTradeMapper.addMapping("fletcher", "trident_loyalty_3", "fletcher_l5_emerald_2_trident_loyalty_3");
        SimpleTradeMapper.addMapping("fletcher", "trident_impaling_5", "fletcher_l5_emerald_2_trident_impaling_5");
        SimpleTradeMapper.addMapping("fletcher", "trident_channeling_1", "fletcher_l5_emerald_2_trident_channeling_1");
        SimpleTradeMapper.addMapping("fletcher", "trident_riptide_3", "fletcher_l5_emerald_2_trident_riptide_3");
        SimpleTradeMapper.addMapping("leatherworker", "leather_helmet_protection_4", "leatherworker_l5_emerald_7_leather_helmet_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_helmet_fire_protection_4", "leatherworker_l5_emerald_7_leather_helmet_fire_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_helmet_blast_protection_4", "leatherworker_l5_emerald_7_leather_helmet_blast_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_helmet_projectile_protection_4", "leatherworker_l5_emerald_7_leather_helmet_projectile_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_helmet_thorns_3", "leatherworker_l5_emerald_7_leather_helmet_thorns_3");
        SimpleTradeMapper.addMapping("leatherworker", "leather_chestplate_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_chestplate_fire_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_fire_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_chestplate_blast_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_blast_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_chestplate_projectile_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_projectile_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_chestplate_thorns_3", "leatherworker_l5_emerald_7_leather_chestplate_thorns_3");
        SimpleTradeMapper.addMapping("leatherworker", "leather_leggings_protection_4", "leatherworker_l5_emerald_4_leather_leggings_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_leggings_fire_protection_4", "leatherworker_l5_emerald_4_leather_leggings_fire_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_leggings_blast_protection_4", "leatherworker_l5_emerald_4_leather_leggings_blast_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_leggings_projectile_protection_4", "leatherworker_l5_emerald_4_leather_leggings_projectile_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_leggings_thorns_3", "leatherworker_l5_emerald_4_leather_leggings_thorns_3");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_protection_4", "leatherworker_l5_emerald_4_leather_boots_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_fire_protection_4", "leatherworker_l5_emerald_4_leather_boots_fire_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_blast_protection_4", "leatherworker_l5_emerald_4_leather_boots_blast_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_projectile_protection_4", "leatherworker_l5_emerald_4_leather_boots_projectile_protection_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_feather_falling_4", "leatherworker_l5_emerald_4_leather_boots_feather_falling_4");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_depth_strider_3", "leatherworker_l5_emerald_4_leather_boots_depth_strider_3");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_frost_walker_2", "leatherworker_l5_emerald_4_leather_boots_frost_walker_2");
        SimpleTradeMapper.addMapping("leatherworker", "leather_boots_soul_speed_3", "leatherworker_l5_emerald_4_leather_boots_soul_speed_3");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_pickaxe_efficiency_4", "toolsmith_l5_emerald_36_diamond_pickaxe_efficiency_4");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_pickaxe_fortune_3", "toolsmith_l5_emerald_36_diamond_pickaxe_fortune_3");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_axe_efficiency_4", "toolsmith_l5_emerald_36_diamond_axe_efficiency_4");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_axe_sharpness_4", "toolsmith_l5_emerald_36_diamond_axe_sharpness_4");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_shovel_efficiency_4", "toolsmith_l5_emerald_36_diamond_shovel_efficiency_4");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_shovel_fortune_3", "toolsmith_l5_emerald_36_diamond_shovel_fortune_3");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_hoe_efficiency_4", "toolsmith_l5_emerald_36_diamond_hoe_efficiency_4");
        SimpleTradeMapper.addMapping("toolsmith", "diamond_hoe_fortune_3", "toolsmith_l5_emerald_36_diamond_hoe_fortune_3");
        SimpleTradeMapper.addMapping("toolsmith", "netherite_pickaxe", "toolsmith_l5_emerald_36_netherite_pickaxe_1");
        SimpleTradeMapper.addMapping("toolsmith", "netherite_axe", "toolsmith_l5_emerald_36_netherite_axe_1");
        SimpleTradeMapper.addMapping("toolsmith", "netherite_shovel", "toolsmith_l5_emerald_36_netherite_shovel_1");
        SimpleTradeMapper.addMapping("toolsmith", "netherite_hoe", "toolsmith_l5_emerald_36_netherite_hoe_1");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_sword_sharpness_4", "weaponsmith_l5_emerald_13_diamond_sword_sharpness_4");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_sword_looting_3", "weaponsmith_l5_emerald_13_diamond_sword_looting_3");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_sword_fire_aspect_2", "weaponsmith_l5_emerald_13_diamond_sword_fire_aspect_2");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_sword_knockback_2", "weaponsmith_l5_emerald_13_diamond_sword_knockback_2");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_sword_sweeping_edge_3", "weaponsmith_l5_emerald_13_diamond_sword_sweeping_edge_3");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_axe_sharpness_4", "weaponsmith_l5_emerald_13_diamond_axe_sharpness_4");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_axe_efficiency_4", "weaponsmith_l5_emerald_13_diamond_axe_efficiency_4");
        SimpleTradeMapper.addMapping("weaponsmith", "diamond_axe_fortune_3", "weaponsmith_l5_emerald_13_diamond_axe_fortune_3");
        SimpleTradeMapper.addMapping("weaponsmith", "netherite_sword", "weaponsmith_l5_emerald_13_netherite_sword_1");
        SimpleTradeMapper.addMapping("weaponsmith", "netherite_axe", "weaponsmith_l5_emerald_13_netherite_axe_1");
    }

    private static void buildReverseMappings() {
        for (Map.Entry<String, Map<String, String>> professionEntry : PROFESSION_ITEM_MAP.entrySet()) {
            String profession = professionEntry.getKey();
            Map<String, String> itemMap = professionEntry.getValue();
            HashMap<String, String> reverseMap = new HashMap<String, String>();
            for (Map.Entry<String, String> itemEntry : itemMap.entrySet()) {
                reverseMap.put(itemEntry.getValue(), itemEntry.getKey());
            }
            REVERSE_MAP.put(profession, reverseMap);
        }
    }

    public static String getTechnicalId(String profession, String simpleName) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null ? professionMap.get(simpleName.toLowerCase()) : null;
    }

    public static String getSimpleName(String profession, String technicalId) {
        Map<String, String> reverseMap = REVERSE_MAP.get(profession.toLowerCase());
        return reverseMap != null ? reverseMap.get(technicalId) : null;
    }

    public static Set<String> getSimpleNames(String profession) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null ? professionMap.keySet() : Collections.emptySet();
    }

    public static Set<String> getAllProfessions() {
        return PROFESSION_ITEM_MAP.keySet();
    }

    public static boolean hasProfession(String profession) {
        return PROFESSION_ITEM_MAP.containsKey(profession.toLowerCase());
    }

    public static boolean hasSimpleName(String profession, String simpleName) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null && professionMap.containsKey(simpleName.toLowerCase());
    }

    public static Collection<String> getTechnicalIds(String profession) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null ? professionMap.values() : Collections.emptyList();
    }

    public static void clearAllStaticReferences() {
        PROFESSION_ITEM_MAP.clear();
        REVERSE_MAP.clear();
    }
}

