/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.cache.AdaptiveCache;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.exception.VillagerTradeException;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.DynamicTradeDetector;
import com.alan.VillagerTradeManager.services.DynamicTradeStorageService;
import com.alan.VillagerTradeManager.services.PerformanceMonitorService;
import com.alan.VillagerTradeManager.services.PriceCalculationService;
import com.alan.VillagerTradeManager.services.ReputationService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.StockService;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import com.alan.VillagerTradeManager.services.VillagerLevelService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.potion.PotionEffectType;

public class TradeService {
    private final VillagerTradeManager plugin;
    private final SettingsService settingsService;
    private final DynamicTradeDetector dynamicTradeDetector;
    private final DynamicTradeStorageService dynamicTradeStorage;
    private final PerformanceMonitorService performanceMonitor;
    private final VillagerLevelService villagerLevelService;
    private final StockService stockService;
    private final PriceCalculationService priceCalculationService;
    private boolean tradeManagementEnabled;
    private boolean hasHeroOfTheVillageEffect = true;
    private boolean hasRaidEvents = true;
    private Map<String, Integer> customPrices = new ConcurrentHashMap<String, Integer>();
    private static final int MAX_CUSTOM_PRICES_SIZE = 10000;
    private final Map<UUID, VillagerCacheEntry> villagerCache = new ConcurrentHashMap<UUID, VillagerCacheEntry>();
    private final Map<UUID, Long> playerCacheTimestamps = new ConcurrentHashMap<UUID, Long>();
    private static final long CACHE_TIMEOUT_MS = 60000L;
    private static final int MAX_VILLAGER_CACHE_SIZE = 2000;
    private static final int MAX_PLAYER_CACHE_SIZE = 500;
    private static final int VILLAGER_CACHE_CLEANUP_BATCH_SIZE = 50;
    private static final int PLAYER_CACHE_CLEANUP_BATCH_SIZE = 25;
    private final AdaptiveCache<String, DynamicTradeDetector.DetectedTrade> detectedTradeCache = new AdaptiveCache(100, 2000, 85.0, 60000L, 0.2);

    public TradeService(VillagerTradeManager plugin, SettingsService settingsService, DynamicTradeStorageService dynamicTradeStorage, PerformanceMonitorService performanceMonitor, StockService stockService, ReputationService reputationService, TaskScheduler taskScheduler) {
        this.plugin = plugin;
        this.settingsService = settingsService;
        this.dynamicTradeStorage = dynamicTradeStorage;
        this.performanceMonitor = performanceMonitor;
        this.stockService = stockService;
        this.villagerLevelService = plugin.getVillagerLevelService();
        this.dynamicTradeDetector = new DynamicTradeDetector(new TradeRegistry(), new SimpleTradeMapper(), performanceMonitor, plugin.getLogger());
        this.priceCalculationService = new PriceCalculationService(plugin, reputationService, settingsService, taskScheduler);
        this.tradeManagementEnabled = settingsService.isTradeManagementEnabled();
        try {
            this.detectServerCapabilities();
        }
        catch (Exception e) {
            plugin.getLogger().info("Server capability detection failed, using defaults");
        }
    }

    private void detectServerCapabilities() {
        try {
            PotionEffectType.HERO_OF_THE_VILLAGE.getClass();
        }
        catch (NoSuchFieldError e) {
            this.hasHeroOfTheVillageEffect = false;
            this.plugin.getLogger().info("Hero of the Village effect not available on this server version");
        }
        try {
            Class.forName("org.bukkit.event.raid.RaidFinishEvent");
        }
        catch (ClassNotFoundException e) {
            this.hasRaidEvents = false;
            this.plugin.getLogger().info("Raid events not available on this server version");
        }
    }

    private boolean validateVillagerForProcessing(Villager villager) {
        if (villager == null || !villager.isValid()) {
            return false;
        }
        if (!this.tradeManagementEnabled) {
            if (this.plugin != null && this.plugin.getConfig() != null && this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                this.plugin.getLogger().fine("Trade management disabled, skipping villager: " + String.valueOf(villager.getUniqueId()));
            }
            return false;
        }
        return true;
    }

    private void processVillagerRecipes(Villager villager, List<MerchantRecipe> recipes, boolean[] modified, Map<MerchantRecipe, Integer> originalUses, String profession, Map<MerchantRecipe, String> recipeTradeIds) {
        List ingredients;
        ItemStack result;
        for (MerchantRecipe recipe : villager.getRecipes()) {
            String cacheKey;
            DynamicTradeDetector.DetectedTrade cachedTrade;
            originalUses.put(recipe, this.getRecipeUses(recipe));
            result = recipe.getResult();
            ingredients = recipe.getIngredients();
            String recipeTradeId = TradeRegistry.identifyTrade(profession, result, ingredients);
            if (recipeTradeId == null && (cachedTrade = this.getCachedDetectedTrade(cacheKey = this.generateTradeCacheKey(profession, villager.getVillagerLevel(), ingredients, result))) != null) {
                recipeTradeId = cachedTrade.getTradeId();
            }
            recipeTradeIds.put(recipe, recipeTradeId);
        }
        for (MerchantRecipe recipe : villager.getRecipes()) {
            MerchantRecipe customRecipe;
            boolean isBanned;
            result = recipe.getResult();
            ingredients = recipe.getIngredients();
            String tradeId = TradeRegistry.identifyTrade(profession, result, ingredients);
            String priceKey = null;
            Integer customPrice = null;
            if (tradeId != null) {
                priceKey = profession + "_" + tradeId;
                customPrice = this.customPrices.get(priceKey);
            } else {
                String cacheKey = this.generateTradeCacheKey(profession, villager.getVillagerLevel(), ingredients, result);
                DynamicTradeDetector.DetectedTrade cachedTrade = this.getCachedDetectedTrade(cacheKey);
                if (cachedTrade != null) {
                    tradeId = cachedTrade.getTradeId();
                    priceKey = profession + "_" + tradeId;
                    customPrice = this.customPrices.get(priceKey);
                } else {
                    DynamicTradeDetector.DetectedTrade detectedTrade = this.dynamicTradeDetector.detectTrade(villager, recipe);
                    if (detectedTrade != null) {
                        tradeId = detectedTrade.getTradeId();
                        priceKey = profession + "_" + tradeId;
                        customPrice = this.customPrices.get(priceKey);
                        this.cacheDetectedTrade(cacheKey, detectedTrade);
                        if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                            this.plugin.getLogger().fine("Dynamically detected trade: " + tradeId + " (" + detectedTrade.getSimpleName() + ") for villager: " + String.valueOf(villager.getUniqueId()));
                        }
                    }
                }
            }
            if (tradeId != null && this.plugin.getTradeEnhancementService() != null) {
                Player nearestPlayer = this.findNearestPlayer(villager);
                HashMap<String, Object> context = new HashMap<String, Object>();
                if (this.plugin.getTradeEnhancementService().isEnhancementsEnabled()) {
                    if (!this.plugin.getTradeEnhancementService().arePrerequisitesMet(tradeId, nearestPlayer, villager, context)) {
                        List<String> unmet = this.plugin.getTradeEnhancementService().getUnmetPrerequisites(tradeId, nearestPlayer, villager, context);
                        if (nearestPlayer != null) {
                            nearestPlayer.sendMessage("\u00a7cPrerequisites not met for this trade:");
                            unmet.forEach(desc -> nearestPlayer.sendMessage("\u00a77- " + desc));
                        }
                        if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false)) continue;
                        this.plugin.getLogger().fine("Skipped trade " + tradeId + " due to unmet prerequisites for villager: " + String.valueOf(villager.getUniqueId()));
                        continue;
                    }
                    boolean available = this.plugin.getTradeEnhancementService().isTradeRandomlyAvailable(tradeId, nearestPlayer, villager);
                    if (!available) {
                        if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false)) continue;
                        this.plugin.getLogger().fine("Trade " + tradeId + " randomly unavailable for villager: " + String.valueOf(villager.getUniqueId()));
                        continue;
                    }
                }
            }
            boolean bl = isBanned = result != null && this.settingsService.isItemBanned(result.getType());
            if (isBanned) {
                if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false)) continue;
                this.plugin.getLogger().fine("Skipped banned trade: " + tradeId + " for villager: " + String.valueOf(villager.getUniqueId()));
                continue;
            }
            if (this.villagerLevelService != null && !this.isTradeAvailableForLevel(villager, tradeId)) {
                if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false)) continue;
                this.plugin.getLogger().fine("Skipped unavailable trade: " + tradeId + " for villager level " + villager.getVillagerLevel() + " (id: " + String.valueOf(villager.getUniqueId()) + ")");
                continue;
            }
            if (this.stockService != null && !this.stockService.isTradeAvailable(villager, profession, tradeId)) {
                if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false)) continue;
                this.plugin.getLogger().fine("Skipped out-of-stock trade: " + tradeId + " for villager: " + String.valueOf(villager.getUniqueId()));
                continue;
            }
            if (tradeId != null) {
                Player nearestPlayer = this.findNearestPlayer(villager);
                int dynamicPrice = nearestPlayer != null ? this.priceCalculationService.calculateDynamicPrice(nearestPlayer, recipe, profession, tradeId) : this.calculateBasePrice(recipe);
                this.priceCalculationService.recordTradeUsage(profession, tradeId);
                MerchantRecipe customRecipe2 = this.createCustomTradeRecipe(recipe, dynamicPrice);
                if (customRecipe2 != null) {
                    recipes.add(customRecipe2);
                    modified[0] = true;
                    continue;
                }
            } else if (customPrice != null && tradeId != null && (customRecipe = this.createCustomTradeRecipe(recipe, customPrice)) != null) {
                recipes.add(customRecipe);
                modified[0] = true;
                continue;
            }
            if (result.getType() == Material.ENCHANTED_BOOK && result.hasItemMeta() && (customRecipe = this.createCustomEnchantedBookRecipe(recipe)) != null) {
                recipes.add(customRecipe);
                modified[0] = true;
                continue;
            }
            MerchantRecipe neutralizedRecipe = this.createNeutralizedRecipe(recipe);
            if (neutralizedRecipe != null) {
                recipes.add(neutralizedRecipe);
                modified[0] = true;
                continue;
            }
            recipes.add(recipe);
        }
    }

    private void updateVillagerRecipes(Villager villager, List<MerchantRecipe> recipes, boolean modified, Map<MerchantRecipe, Integer> originalUses, String profession, Map<MerchantRecipe, String> recipeTradeIds) {
        if (modified) {
            villager.setRecipes(recipes);
            if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                this.plugin.getLogger().fine("Modified " + recipes.size() + " trades for villager: " + String.valueOf(villager.getUniqueId()));
            }
        }
        this.awardXpForCompletedTrades(villager, profession, originalUses, recipeTradeIds);
    }

    private void awardXpForCompletedTrades(Villager villager, String profession, Map<MerchantRecipe, Integer> originalUses, Map<MerchantRecipe, String> recipeTradeIds) {
        if (this.villagerLevelService == null) {
            return;
        }
        try {
            for (MerchantRecipe recipe : villager.getRecipes()) {
                int i;
                int currentUseCount;
                int completedTrades;
                Integer originalUseCount = originalUses.get(recipe);
                if (originalUseCount == null || (completedTrades = (currentUseCount = this.getRecipeUses(recipe)) - originalUseCount) <= 0) continue;
                int tradeTier = this.determineTradeTier(villager, recipe);
                String recipeTradeId = recipeTradeIds.get(recipe);
                if (this.stockService != null && recipeTradeId != null) {
                    for (i = 0; i < completedTrades; ++i) {
                        this.stockService.recordTradeUsage(villager, profession, recipeTradeId);
                    }
                }
                for (i = 0; i < completedTrades; ++i) {
                    this.villagerLevelService.awardXpForTrade(villager, tradeTier);
                }
                if (this.plugin.getTradeHookManager() != null && recipeTradeId != null) {
                    ItemStack result = recipe.getResult();
                    this.plugin.getTradeHookManager().fireTradeEvent(null, villager, recipe, result, tradeTier, tradeTier * completedTrades);
                }
                if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false)) continue;
                this.plugin.getLogger().fine("Awarded XP for " + completedTrades + " completed trades (tier " + tradeTier + ") for villager: " + String.valueOf(villager.getUniqueId()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to award XP for completed trades: " + e.getMessage());
        }
    }

    private int determineTradeTier(Villager villager, MerchantRecipe recipe) {
        int villagerLevel = villager.getVillagerLevel();
        if (villagerLevel <= 1) {
            return 1;
        }
        if (villagerLevel <= 2) {
            return 2;
        }
        if (villagerLevel <= 3) {
            return 3;
        }
        if (villagerLevel <= 4) {
            return 4;
        }
        return 5;
    }

    private boolean isTradeAvailableForLevel(Villager villager, String tradeId) {
        if (this.villagerLevelService == null) {
            return true;
        }
        try {
            int tradeTier = this.extractTradeTierFromId(tradeId);
            return this.villagerLevelService.isTradeTierAvailable(villager, tradeTier);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to check trade availability for " + tradeId + ": " + e.getMessage());
            return true;
        }
    }

    private int extractTradeTierFromId(String tradeId) {
        if (tradeId == null) {
            return 1;
        }
        if (tradeId.contains("master") || tradeId.contains("5")) {
            return 5;
        }
        if (tradeId.contains("expert") || tradeId.contains("4")) {
            return 4;
        }
        if (tradeId.contains("journeyman") || tradeId.contains("3")) {
            return 3;
        }
        if (tradeId.contains("apprentice") || tradeId.contains("2")) {
            return 2;
        }
        return 1;
    }

    public void processVillagerTrades(Villager villager) {
        block6: {
            MerchantRecipe firstRecipe;
            List currentRecipes;
            if (!this.validateVillagerForProcessing(villager)) {
                return;
            }
            UUID villagerId = villager.getUniqueId();
            VillagerCacheEntry cacheEntry = this.villagerCache.get(villagerId);
            if (cacheEntry != null && !cacheEntry.isExpired() && (currentRecipes = villager.getRecipes()) != null && currentRecipes.size() > 0 && (firstRecipe = (MerchantRecipe)currentRecipes.get(0)) != null && firstRecipe.getResult() != null) {
                if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                    this.plugin.getLogger().fine("Skipping trade processing for cached villager: " + String.valueOf(villagerId));
                }
                return;
            }
            long startTime = System.currentTimeMillis();
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            boolean[] modified = new boolean[]{false};
            HashMap<MerchantRecipe, Integer> originalUses = new HashMap<MerchantRecipe, Integer>();
            String profession = this.getVillagerProfession(villager);
            HashMap<MerchantRecipe, String> recipeTradeIds = new HashMap<MerchantRecipe, String>();
            try {
                this.processVillagerRecipes(villager, recipes, modified, originalUses, profession, recipeTradeIds);
                this.updateVillagerRecipes(villager, recipes, modified[0], originalUses, profession, recipeTradeIds);
                long duration = System.currentTimeMillis() - startTime;
                if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false) || duration <= 10L) break block6;
                this.plugin.getLogger().info("Trade processing took " + duration + "ms for villager: " + String.valueOf(villager.getUniqueId()));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Unexpected error processing trades for villager " + String.valueOf(villager.getUniqueId()) + ": " + e.getMessage());
                if (!this.plugin.getConfig().getBoolean("logging.debug_database", false)) break block6;
                this.plugin.getLogger().severe("Stack trace for trade processing failure: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                for (StackTraceElement element : e.getStackTrace()) {
                    this.plugin.getLogger().severe("  at " + element.toString());
                }
            }
        }
    }

    private String generateTradeCacheKey(String profession, int level, List<ItemStack> ingredients, ItemStack result) {
        StringBuilder key = new StringBuilder();
        key.append(profession).append("_").append(level).append("_");
        ingredients.stream().map(this::itemToSimpleString).sorted().forEach(s -> key.append((String)s).append(","));
        key.append("_").append(this.itemToSimpleString(result));
        return key.toString();
    }

    private String itemToSimpleString(ItemStack item) {
        if (item == null) {
            return "null";
        }
        return item.getType().name() + ":" + item.getAmount();
    }

    private DynamicTradeDetector.DetectedTrade getCachedDetectedTrade(String cacheKey) {
        return this.detectedTradeCache.get(cacheKey);
    }

    private void cacheDetectedTrade(String cacheKey, DynamicTradeDetector.DetectedTrade trade) {
        this.detectedTradeCache.put(cacheKey, trade);
    }

    private MerchantRecipe createCustomEnchantedBookRecipe(MerchantRecipe originalRecipe) {
        EnchantmentStorageMeta meta;
        ItemStack result = originalRecipe.getResult();
        Object enchantKey = "enchanted_book";
        if (result.hasItemMeta() && result.getItemMeta() instanceof EnchantmentStorageMeta && (meta = (EnchantmentStorageMeta)result.getItemMeta()).hasStoredEnchants()) {
            Map.Entry firstEnchant = meta.getStoredEnchants().entrySet().iterator().next();
            String enchantName = this.getEnchantmentKey((Enchantment)firstEnchant.getKey());
            int level = (Integer)firstEnchant.getValue();
            enchantKey = "enchanted_book_" + enchantName + "_" + level;
        }
        int emeraldCost = Math.min(this.customPrices.getOrDefault(enchantKey, 15), 64);
        MerchantRecipe customRecipe = this.createMerchantRecipe(result, this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack books = new ItemStack(Material.BOOK, 1);
        ingredients.add(books);
        ItemStack emeralds = new ItemStack(Material.EMERALD, emeraldCost);
        ingredients.add(emeralds);
        customRecipe.setIngredients(ingredients);
        this.setRecipeDemand(customRecipe, 0);
        this.setRecipeSpecialPrice(customRecipe, 0);
        this.setRecipePriceMultiplier(customRecipe, 0.0f);
        return customRecipe;
    }

    private MerchantRecipe createNeutralizedRecipe(MerchantRecipe originalRecipe) {
        MerchantRecipe neutralizedRecipe = this.createMerchantRecipe(originalRecipe.getResult(), this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        neutralizedRecipe.setIngredients(new ArrayList(originalRecipe.getIngredients()));
        this.setRecipeDemand(neutralizedRecipe, 0);
        this.setRecipeSpecialPrice(neutralizedRecipe, 0);
        this.setRecipePriceMultiplier(neutralizedRecipe, 0.0f);
        return neutralizedRecipe;
    }

    private MerchantRecipe createCustomTradeRecipe(MerchantRecipe originalRecipe, int emeraldCost) {
        MerchantRecipe customRecipe = this.createMerchantRecipe(originalRecipe.getResult(), this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(originalRecipe.getIngredients());
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack ingredient = (ItemStack)ingredients.get(i);
            if (ingredient.getType() != Material.EMERALD) continue;
            ingredients.set(i, new ItemStack(Material.EMERALD, Math.min(emeraldCost, 64)));
            break;
        }
        customRecipe.setIngredients(ingredients);
        this.setRecipeDemand(customRecipe, 0);
        this.setRecipeSpecialPrice(customRecipe, 0);
        this.setRecipePriceMultiplier(customRecipe, 0.0f);
        return customRecipe;
    }

    private String getVillagerProfession(Villager villager) {
        if (villager.getProfession() == null) {
            return "none";
        }
        try {
            return villager.getProfession().getKey().getKey().toLowerCase();
        }
        catch (Exception e) {
            try {
                Registry registry = Registry.VILLAGER_PROFESSION;
                for (Villager.Profession prof : registry) {
                    if (!prof.equals((Object)villager.getProfession())) continue;
                    return prof.getKey().getKey().toLowerCase();
                }
                return villager.getProfession().toString().toLowerCase();
            }
            catch (Exception ex) {
                return "none";
            }
        }
    }

    public void removeHeroEffect(Player player) {
        if (!this.tradeManagementEnabled || !this.hasHeroOfTheVillageEffect) {
            return;
        }
        try {
            player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
        }
        catch (NoSuchMethodError e) {
            try {
                Method removePotionEffectMethod = player.getClass().getMethod("removePotionEffect", PotionEffectType.class);
                removePotionEffectMethod.invoke((Object)player, PotionEffectType.HERO_OF_THE_VILLAGE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getEnchantmentKey(Enchantment enchantment) {
        try {
            return enchantment.getKey().getKey();
        }
        catch (NoSuchMethodError e) {
            return enchantment.getName().toLowerCase();
        }
    }

    private int getRecipeUses(MerchantRecipe recipe) {
        try {
            return recipe.getUses();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private int getRecipeMaxUses(MerchantRecipe recipe) {
        try {
            return recipe.getMaxUses();
        }
        catch (NoSuchMethodError e) {
            return 99999;
        }
    }

    private boolean getRecipeHasExperienceReward(MerchantRecipe recipe) {
        try {
            return recipe.hasExperienceReward();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private int getRecipeVillagerExperience(MerchantRecipe recipe) {
        try {
            return recipe.getVillagerExperience();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private void setRecipeDemand(MerchantRecipe recipe, int demand) {
        try {
            recipe.setDemand(demand);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipeSpecialPrice(MerchantRecipe recipe, int specialPrice) {
        try {
            recipe.setSpecialPrice(specialPrice);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipePriceMultiplier(MerchantRecipe recipe, float multiplier) {
        try {
            recipe.setPriceMultiplier(multiplier);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private MerchantRecipe createMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int villagerExperience, float priceMultiplier) {
        try {
            return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
        }
        catch (NoSuchMethodError e) {
            try {
                return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
            }
            catch (Exception ex) {
                return new MerchantRecipe(result, maxUses);
            }
        }
    }

    public void saveCustomPricesToFile(File pricesFile) throws DatabaseException {
        try {
            this.validateFilePath(pricesFile);
            File parentDir = pricesFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!pricesFile.exists()) {
                pricesFile.createNewFile();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(pricesFile));){
                oos.writeObject(new HashMap<String, Integer>(this.customPrices));
            }
        }
        catch (IOException e) {
            throw new DatabaseException("Could not save custom prices to file: " + pricesFile.getName(), "saveCustomPricesToFile", "prices_file", e);
        }
        catch (SecurityException e) {
            throw new DatabaseException("Invalid file path: " + pricesFile.getPath(), "saveCustomPricesToFile", "prices_file", e);
        }
    }

    public void loadCustomPricesFromFile(File pricesFile) throws DatabaseException {
        if (!pricesFile.exists()) {
            return;
        }
        try {
            this.validateFilePath(pricesFile);
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(pricesFile));){
                Object obj = ois.readObject();
                if (obj instanceof Map) {
                    this.customPrices = new ConcurrentHashMap<String, Integer>((Map)obj);
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new DatabaseException("Could not load custom prices from file: " + pricesFile.getName(), "loadCustomPricesFromFile", "prices_file", e);
        }
        catch (SecurityException e) {
            throw new DatabaseException("Invalid file path: " + pricesFile.getPath(), "loadCustomPricesFromFile", "prices_file", e);
        }
    }

    private void validateFilePath(File file) throws SecurityException {
        if (file == null) {
            throw new SecurityException("File cannot be null");
        }
        try {
            File dataFolder;
            String dataFolderCanonical;
            File dataFolder2;
            String canonicalPath = file.getCanonicalPath();
            String absolutePath = file.getAbsolutePath();
            if (!(canonicalPath.equals(absolutePath) || canonicalPath.replace('\\', '/').equals(absolutePath.replace('\\', '/')) || (dataFolder2 = this.plugin.getDataFolder()) == null || canonicalPath.startsWith(dataFolderCanonical = dataFolder2.getCanonicalPath()))) {
                throw new SecurityException("File path outside plugin data folder: " + canonicalPath);
            }
            String path = file.getPath();
            if ((path.contains("..") || path.contains("~") || path.startsWith("/") || path.length() > 1 && path.charAt(1) == ':' && !path.startsWith(this.plugin.getDataFolder().getPath())) && (dataFolder = this.plugin.getDataFolder()) != null && !canonicalPath.startsWith(dataFolder.getCanonicalPath())) {
                throw new SecurityException("Suspicious file path detected: " + path);
            }
        }
        catch (IOException e) {
            throw new SecurityException("Failed to validate file path: " + e.getMessage(), e);
        }
    }

    public String convertToUserFriendlyFormat(String internalKey) {
        if (internalKey.startsWith("enchanted_book_")) {
            return internalKey.substring(15).replace("_", " ");
        }
        return internalKey;
    }

    public void startTradeMonitor(PlatformService platformService, TaskScheduler taskScheduler) {
        long frequencyTicks = this.plugin.getConfig().getLong("performance.trade_monitor_frequency", 200L);
        long initialDelay = 40L;
        taskScheduler.runSyncRepeating(() -> {
            if (!this.tradeManagementEnabled) {
                return;
            }
            if (this.hasHeroOfTheVillageEffect) {
                for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                    this.removeHeroEffect(player);
                }
            }
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                platformService.executeRegionSafe(taskScheduler, player.getLocation(), () -> this.processPlayerVillagers(player));
            }
        }, initialDelay, frequencyTicks);
    }

    private void processPlayerVillagers(Player player) {
        boolean useCache;
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        int scanRadius = this.plugin.getConfig().getInt("performance.villager_scan_radius", 32);
        Long lastScanTime = this.playerCacheTimestamps.get(playerId);
        boolean bl = useCache = lastScanTime != null && currentTime - lastScanTime < 30000L;
        if (useCache) {
            Set<UUID> cachedVillagerIds = this.getCachedVillagersForPlayer(player, scanRadius);
            int processedCount = 0;
            for (UUID villagerId : cachedVillagerIds) {
                Villager villager = this.getVillagerById(villagerId);
                if (villager == null || !this.isVillagerNearPlayer(villager, player, scanRadius)) continue;
                this.processVillagerTrades(villager);
                ++processedCount;
            }
            if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                this.plugin.getLogger().fine("Processed " + processedCount + " cached villagers for player: " + player.getName());
            }
            return;
        }
        this.playerCacheTimestamps.put(playerId, currentTime);
        List<Object> nearbyVillagers = new ArrayList();
        try {
            nearbyVillagers = player.getNearbyEntities((double)scanRadius, (double)scanRadius, (double)scanRadius).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).collect(Collectors.toList());
        }
        catch (NoSuchMethodError e) {
            for (Entity entity2 : player.getWorld().getEntities()) {
                if (!(entity2 instanceof Villager) || !(entity2.getLocation().distance(player.getLocation()) <= (double)scanRadius)) continue;
                nearbyVillagers.add((Villager)entity2);
            }
        }
        for (Villager villager : nearbyVillagers) {
            UUID villagerId = villager.getUniqueId();
            if (this.villagerCache.size() >= 2000) {
                this.villagerCache.entrySet().removeIf(entry -> ((VillagerCacheEntry)entry.getValue()).isExpired());
                if (this.villagerCache.size() >= 2000) {
                    Iterator<Map.Entry<UUID, VillagerCacheEntry>> iterator = this.villagerCache.entrySet().iterator();
                    int toRemove = Math.max(50, this.villagerCache.size() - 2000 + 50);
                    for (int i = 0; i < toRemove && iterator.hasNext(); ++i) {
                        iterator.next();
                        iterator.remove();
                    }
                }
            }
            this.villagerCache.put(villagerId, new VillagerCacheEntry(villagerId, villager.getLocation().clone()));
            this.processVillagerTrades(villager);
        }
        if (this.playerCacheTimestamps.size() >= 500) {
            this.playerCacheTimestamps.entrySet().removeIf(entry -> System.currentTimeMillis() - (Long)entry.getValue() > 120000L);
            if (this.playerCacheTimestamps.size() >= 500) {
                Iterator<Map.Entry<UUID, Long>> iterator = this.playerCacheTimestamps.entrySet().iterator();
                int n = Math.max(25, this.playerCacheTimestamps.size() - 500 + 25);
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    iterator.next();
                    iterator.remove();
                }
            }
        }
        if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
            this.plugin.getLogger().fine("Scanned and cached " + nearbyVillagers.size() + " villagers for player: " + player.getName());
        }
    }

    private Set<UUID> getCachedVillagersForPlayer(Player player, int radius) {
        HashSet<UUID> validVillagers = new HashSet<UUID>();
        Location playerLoc = player.getLocation();
        for (Map.Entry<UUID, VillagerCacheEntry> entry : this.villagerCache.entrySet()) {
            if (entry.getValue().isExpired() || !entry.getValue().isWithinRadius(playerLoc, radius)) continue;
            validVillagers.add(entry.getKey());
        }
        return validVillagers;
    }

    private boolean isVillagerNearPlayer(Villager villager, Player player, int radius) {
        if (villager == null || !villager.isValid()) {
            return false;
        }
        return villager.getLocation().distance(player.getLocation()) <= (double)radius;
    }

    private Villager getVillagerById(UUID villagerId) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            Chunk playerChunk = player.getLocation().getChunk();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Chunk chunk = player.getWorld().getChunkAt(playerChunk.getX() + x, playerChunk.getZ() + z);
                    if (!chunk.isLoaded()) continue;
                    for (Entity entity : chunk.getEntities()) {
                        if (!(entity instanceof Villager) || !entity.getUniqueId().equals(villagerId)) continue;
                        return (Villager)entity;
                    }
                }
            }
        }
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                for (Entity entity : chunk.getEntities()) {
                    if (!(entity instanceof Villager) || !entity.getUniqueId().equals(villagerId)) continue;
                    return (Villager)entity;
                }
            }
        }
        return null;
    }

    public void saveTradeManagementEnabled(boolean enabled) {
        this.tradeManagementEnabled = enabled;
        this.settingsService.saveSettingToDatabase("trade_management_enabled", String.valueOf(enabled));
        if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
            this.plugin.getLogger().fine("Persisted trade management enabled state: " + enabled);
        }
    }

    public void persistState() {
        this.settingsService.setTradeManagementEnabled(this.tradeManagementEnabled);
        this.settingsService.saveSettingToDatabase("trade_management_enabled", String.valueOf(this.tradeManagementEnabled));
    }

    public void shutdown() {
        this.villagerCache.clear();
        this.playerCacheTimestamps.clear();
        this.detectedTradeCache.clear();
        this.customPrices.clear();
        this.plugin.getLogger().info("TradeService caches cleared during shutdown");
    }

    public DynamicTradeDetector getDynamicTradeDetector() {
        return this.dynamicTradeDetector;
    }

    public Map<String, Object> getCacheStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("villagerCacheSize", this.villagerCache.size());
        stats.put("villagerCacheMax", 2000);
        stats.put("playerCacheSize", this.playerCacheTimestamps.size());
        stats.put("playerCacheMax", 500);
        stats.put("detectedTradeCacheSize", this.detectedTradeCache.size());
        stats.put("detectedTradeCacheMax", this.detectedTradeCache.getMaxSize());
        stats.put("customPricesSize", this.customPrices.size());
        stats.put("customPricesMax", 10000);
        Map<String, Object> adaptiveStats = this.detectedTradeCache.getStatistics();
        stats.put("detectedTradeCacheHitRate", adaptiveStats.get("hitRate"));
        stats.put("detectedTradeCacheMissRate", adaptiveStats.get("missRate"));
        stats.put("detectedTradeCacheEvictionRate", adaptiveStats.get("evictionRate"));
        stats.put("detectedTradeCacheAvgHitTime", adaptiveStats.get("averageHitTime"));
        stats.put("detectedTradeCacheAvgMissTime", adaptiveStats.get("averageMissTime"));
        stats.put("detectedTradeCacheSizeAdjustments", adaptiveStats.get("sizeAdjustments"));
        stats.put("detectedTradeCacheMemoryUsage", adaptiveStats.get("estimatedMemoryUsage"));
        return stats;
    }

    private void logVillagerTradeException(String context, VillagerTradeException e, Level level) {
        StringBuilder message = new StringBuilder(context);
        message.append(" - ").append(e.getMessage());
        if (e.getComponent() != null) {
            message.append(" [Component: ").append(e.getComponent()).append("]");
        }
        if (e.getOperation() != null) {
            message.append(" [Operation: ").append(e.getOperation()).append("]");
        }
        if (e.isRecoverable()) {
            message.append(" [Recoverable: true]");
        }
        this.plugin.getLogger().log(level, message.toString());
        if (e.getCause() != null && this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
            this.plugin.getLogger().log(level, "Caused by: " + e.getCause().getClass().getSimpleName() + ": " + e.getCause().getMessage());
        }
    }

    private void executeWithRetry(Runnable operation, String operationName, int maxRetries) {
        int attempts = 0;
        while (attempts < maxRetries) {
            try {
                operation.run();
                return;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Attempt " + ++attempts + " failed for " + operationName + ": " + e.getMessage());
                if (attempts < maxRetries) continue;
                this.plugin.getLogger().severe("All retry attempts exhausted for " + operationName);
                return;
            }
        }
    }

    public boolean isTradeManagementEnabled() {
        return this.tradeManagementEnabled;
    }

    public void setTradeManagementEnabled(boolean enabled) {
        this.tradeManagementEnabled = enabled;
        this.persistState();
    }

    public boolean hasHeroOfTheVillageEffect() {
        return this.hasHeroOfTheVillageEffect;
    }

    public boolean hasRaidEvents() {
        return this.hasRaidEvents;
    }

    public Map<String, Integer> getCustomPrices() {
        return this.customPrices;
    }

    public void setCustomPrice(String tradeKey, int price) {
        this.customPrices.put(tradeKey, price);
    }

    public void removeCustomPrice(String tradeKey) {
        this.customPrices.remove(tradeKey);
    }

    private int calculateBasePrice(MerchantRecipe recipe) {
        List ingredients = recipe.getIngredients();
        int totalEmeralds = 0;
        for (ItemStack ingredient : ingredients) {
            if (ingredient.getType() != Material.EMERALD) continue;
            totalEmeralds += ingredient.getAmount();
        }
        return Math.max(1, totalEmeralds);
    }

    private Player findNearestPlayer(Villager villager) {
        Location villagerLocation = villager.getLocation();
        Player nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            double distance;
            if (!player.getWorld().equals((Object)villager.getWorld()) || !((distance = player.getLocation().distance(villagerLocation)) < nearestDistance) || !(distance <= 32.0)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    private static class VillagerCacheEntry {
        final UUID villagerId;
        final Location location;
        final long lastProcessed;

        VillagerCacheEntry(UUID villagerId, Location location) {
            this.villagerId = villagerId;
            this.location = location;
            this.lastProcessed = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.lastProcessed > 60000L;
        }

        boolean isWithinRadius(Location playerLocation, int radius) {
            if (!this.location.getWorld().equals((Object)playerLocation.getWorld())) {
                return false;
            }
            return this.location.distance(playerLocation) <= (double)radius;
        }
    }
}

