/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class ValidationResult<T> {
    private final boolean valid;
    private final T value;
    private final List<String> errors;

    private ValidationResult(boolean valid, T value, List<String> errors) {
        this.valid = valid;
        this.value = value;
        this.errors = errors != null ? new ArrayList<String>(errors) : new ArrayList();
    }

    public static <T> ValidationResult<T> success(T value) {
        return new ValidationResult<T>(true, value, null);
    }

    public static <T> ValidationResult<T> failure(String ... errors) {
        return new ValidationResult<Object>(false, null, List.of(errors));
    }

    public static <T> ValidationResult<T> failure(List<String> errors) {
        return new ValidationResult<Object>(false, null, errors);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public T getValue() {
        if (!this.valid) {
            throw new IllegalStateException("Cannot get value from invalid validation result");
        }
        return this.value;
    }

    public Optional<T> getValueOptional() {
        return Optional.ofNullable(this.value);
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public Optional<String> getFirstError() {
        return this.errors.isEmpty() ? Optional.empty() : Optional.of(this.errors.get(0));
    }

    public <U> ValidationResult<CombinedResult<T, U>> and(ValidationResult<U> other) {
        if (this.valid && other.isValid()) {
            return ValidationResult.success(new CombinedResult<T, U>(this.value, other.getValue()));
        }
        ArrayList<String> combinedErrors = new ArrayList<String>(this.errors);
        combinedErrors.addAll(other.errors);
        return ValidationResult.failure(combinedErrors);
    }

    public ValidationResult<T> or(ValidationResult<T> other) {
        if (this.valid) {
            return this;
        }
        if (other.isValid()) {
            return other;
        }
        ArrayList<String> combinedErrors = new ArrayList<String>(this.errors);
        combinedErrors.addAll(other.errors);
        return ValidationResult.failure(combinedErrors);
    }

    public <U> ValidationResult<U> map(Function<T, U> mapper) {
        if (this.valid) {
            return ValidationResult.success(mapper.apply(this.value));
        }
        return ValidationResult.failure(this.errors);
    }

    public <U> ValidationResult<U> flatMap(Function<T, ValidationResult<U>> mapper) {
        if (this.valid) {
            return mapper.apply(this.value);
        }
        return ValidationResult.failure(this.errors);
    }

    public ValidationResult<T> ifValid(Consumer<T> consumer) {
        if (this.valid) {
            consumer.accept(this.value);
        }
        return this;
    }

    public ValidationResult<T> ifInvalid(Consumer<List<String>> consumer) {
        if (!this.valid) {
            consumer.accept(this.errors);
        }
        return this;
    }

    public String getErrorMessage() {
        if (this.valid) {
            return "";
        }
        return String.join((CharSequence)" ", this.errors);
    }

    public String getErrorMessage(String separator) {
        if (this.valid) {
            return "";
        }
        return String.join((CharSequence)separator, this.errors);
    }

    public String toString() {
        if (this.valid) {
            return "ValidationResult{valid=true, value=" + String.valueOf(this.value) + "}";
        }
        return "ValidationResult{valid=false, errors=" + String.valueOf(this.errors) + "}";
    }

    public static class CombinedResult<T, U> {
        private final T first;
        private final U second;

        public CombinedResult(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public T getFirst() {
            return this.first;
        }

        public U getSecond() {
            return this.second;
        }
    }
}

