/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager;

import com.alan.VillagerTradeManager.commands.MigrationCommand;
import com.alan.VillagerTradeManager.commands.VillagerTradeCommand;
import com.alan.VillagerTradeManager.database.AsyncDatabaseExecutor;
import com.alan.VillagerTradeManager.database.DatabaseManager;
import com.alan.VillagerTradeManager.database.DatabaseMigrationManager;
import com.alan.VillagerTradeManager.database.DatabaseMigrationUtils;
import com.alan.VillagerTradeManager.database.SQLiteDatabaseProvider;
import com.alan.VillagerTradeManager.listeners.VillagerTradeListener;
import com.alan.VillagerTradeManager.metrics.HealthCheckService;
import com.alan.VillagerTradeManager.metrics.MetricsEndpoint;
import com.alan.VillagerTradeManager.metrics.MetricsService;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.DynamicTradeStorageService;
import com.alan.VillagerTradeManager.services.PerformanceMonitorService;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.TradeCompletionService;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import com.alan.VillagerTradeManager.services.TradeService;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class VillagerTradeManager
extends JavaPlugin {
    private PlatformService platformService;
    private TaskScheduler taskScheduler;
    private DatabaseManager databaseManager;
    private DatabaseMigrationManager migrationManager;
    private AsyncDatabaseExecutor databaseExecutor;
    private TradeService tradeService;
    private RestockService restockService;
    private SettingsService settingsService;
    private DynamicTradeStorageService dynamicTradeStorageService;
    private TradeCompletionService tradeCompletionService;
    private PerformanceMonitorService performanceMonitorService;
    private MetricsService metricsService;
    private HealthCheckService healthCheckService;
    private MetricsEndpoint metricsEndpoint;
    private Connection databaseConnection;
    private File pricesFile;

    public void onEnable() {
        this.platformService = new PlatformService((Plugin)this);
        this.taskScheduler = this.platformService.getScheduler();
        this.pricesFile = new File(this.getDataFolder(), "prices.dat");
        this.getDataFolder().mkdirs();
        this.saveDefaultConfig();
        this.reloadConfig();
        try {
            this.databaseManager = new DatabaseManager((Plugin)this);
            this.databaseManager.initialize(this.getConfig().getConfigurationSection("database"));
            this.getLogger().info("V11 Database system initialized successfully");
            this.migrationManager = new DatabaseMigrationManager(this, this.databaseManager);
            this.getLogger().info("V11 Migration system initialized successfully");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize V11 database system: " + e.getMessage());
            this.getLogger().severe("Falling back to legacy database system");
        }
        int poolSize = this.getConfig().getInt("advanced.db_thread_pool_size", 2);
        this.databaseExecutor = new AsyncDatabaseExecutor((Plugin)this, poolSize);
        this.initializeDatabase();
        this.settingsService = new SettingsService(this, this.databaseConnection, this.databaseExecutor);
        DatabaseMigrationUtils migrationUtils = new DatabaseMigrationUtils(this, this.databaseConnection);
        migrationUtils.performMigrations();
        if (!migrationUtils.validateSchema()) {
            this.getLogger().severe("Database schema validation failed! Plugin may not work correctly.");
        }
        this.performanceMonitorService = new PerformanceMonitorService(this);
        this.getLogger().info("Performance monitoring service initialized successfully");
        try {
            SQLiteDatabaseProvider dbProvider = new SQLiteDatabaseProvider(new File(this.getDataFolder(), "villager_data.db").getAbsolutePath());
            this.dynamicTradeStorageService = new DynamicTradeStorageService(this, dbProvider, this.databaseExecutor);
            this.tradeCompletionService = new TradeCompletionService(this, new TradeRegistry(), new SimpleTradeMapper(), this.dynamicTradeStorageService);
            this.tradeCompletionService.refreshCache();
            this.getLogger().info("Dynamic Trade Detection services initialized successfully");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize Dynamic Trade Detection services: " + e.getMessage());
            this.getLogger().severe("Plugin will continue with basic functionality only");
        }
        this.tradeService = new TradeService(this, this.settingsService, this.dynamicTradeStorageService, this.performanceMonitorService);
        this.restockService = new RestockService(this, this.databaseConnection, this.databaseExecutor, this.settingsService);
        try {
            this.metricsService = new MetricsService(this);
            this.healthCheckService = new HealthCheckService(this, this.metricsService);
            this.metricsEndpoint = new MetricsEndpoint(this, this.metricsService, this.healthCheckService);
            this.metricsEndpoint.initialize();
            this.getLogger().info("V11 Enterprise metrics and monitoring initialized successfully");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize V11 enterprise features: " + e.getMessage());
            this.getLogger().severe("Plugin will continue without metrics and monitoring");
        }
        this.loadCustomPricesFromFile();
        this.getServer().getPluginManager().registerEvents((Listener)new VillagerTradeListener(this, this.tradeService, this.restockService, this.platformService), (Plugin)this);
        this.getCommand("villagertrade").setExecutor((CommandExecutor)new VillagerTradeCommand(this, this.settingsService, this.tradeService, this.restockService));
        this.getCommand("villagertrade").setTabCompleter((TabCompleter)new VillagerTradeCommand(this, this.settingsService, this.tradeService, this.restockService));
        if (this.migrationManager != null) {
            this.getCommand("vtm").setExecutor((CommandExecutor)new MigrationCommand(this, this.migrationManager));
            this.getCommand("vtm").setTabCompleter((TabCompleter)new MigrationCommand(this, this.migrationManager));
        }
        this.startTradeMonitor();
        this.startRestockMonitor();
        this.getLogger().info("Minecraft Villager Trade Manager plugin enabled!");
        this.getLogger().info("Complete control over villager trading economics.");
        this.getLogger().info("Compatible with Minecraft versions 1.20.x - 1.21.x");
        this.getLogger().info("Platform: " + String.valueOf((Object)this.platformService.getDetectedPlatform()) + " | Scheduler: " + this.taskScheduler.getSchedulerName());
    }

    public void onDisable() {
        if (this.taskScheduler != null) {
            this.taskScheduler.cancelAllTasks();
        }
        if (this.databaseExecutor != null) {
            this.databaseExecutor.shutdown();
        }
        if (this.metricsEndpoint != null) {
            this.metricsEndpoint.shutdown();
        }
        if (this.tradeService != null) {
            this.saveCustomPricesToFile();
        }
        this.closeDatabase();
    }

    private void initializeDatabase() {
        try {
            File dbFile = new File(this.getDataFolder(), "villager_data.db");
            if (!dbFile.exists()) {
                this.getDataFolder().mkdirs();
            }
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.databaseConnection = DriverManager.getConnection(url);
            this.getLogger().info("Database connection established successfully");
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not initialize database: " + e.getMessage());
        }
    }

    private void closeDatabase() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
                this.getLogger().info("Database connection closed successfully");
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not close database connection: " + e.getMessage());
        }
    }

    private void startTradeMonitor() {
        if (this.tradeService != null) {
            this.tradeService.startTradeMonitor(this.platformService, this.taskScheduler);
        }
    }

    private void startRestockMonitor() {
        if (this.restockService != null) {
            this.restockService.startRestockMonitor(this.platformService, this.taskScheduler);
        }
    }

    private void saveCustomPricesToFile() {
        if (this.tradeService != null) {
            this.tradeService.saveCustomPricesToFile(this.pricesFile);
        }
    }

    private void loadCustomPricesFromFile() {
        if (this.tradeService != null) {
            this.tradeService.loadCustomPricesFromFile(this.pricesFile);
        }
    }

    public PlatformService getPlatformService() {
        return this.platformService;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public DatabaseMigrationManager getMigrationManager() {
        return this.migrationManager;
    }

    public AsyncDatabaseExecutor getDatabaseExecutor() {
        return this.databaseExecutor;
    }

    public TradeService getTradeService() {
        return this.tradeService;
    }

    public RestockService getRestockService() {
        return this.restockService;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    public DynamicTradeStorageService getDynamicTradeStorageService() {
        return this.dynamicTradeStorageService;
    }

    public TradeCompletionService getTradeCompletionService() {
        return this.tradeCompletionService;
    }

    public PerformanceMonitorService getPerformanceMonitorService() {
        return this.performanceMonitorService;
    }

    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    public HealthCheckService getHealthCheckService() {
        return this.healthCheckService;
    }

    public MetricsEndpoint getMetricsEndpoint() {
        return this.metricsEndpoint;
    }

    public Connection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public File getPricesFile() {
        return this.pricesFile;
    }
}

