/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.database.DatabaseMigrationManager;
import com.alan.VillagerTradeManager.database.DatabaseType;
import com.alan.VillagerTradeManager.database.MigrationOptions;
import com.alan.VillagerTradeManager.database.MigrationProgress;
import com.alan.VillagerTradeManager.database.MigrationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MigrationCommand
implements CommandExecutor,
TabCompleter {
    private final VillagerTradeManager plugin;
    private final DatabaseMigrationManager migrationManager;

    public MigrationCommand(VillagerTradeManager plugin, DatabaseMigrationManager migrationManager) {
        this.plugin = plugin;
        this.migrationManager = migrationManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        String subCommand;
        if (!sender.hasPermission("vtm.admin.migrate")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args2.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args2[0].toLowerCase()) {
            case "migrate": {
                return this.handleMigrate(sender, Arrays.copyOfRange(args2, 1, args2.length));
            }
            case "status": {
                return this.handleStatus(sender);
            }
            case "cancel": {
                return this.handleCancel(sender);
            }
            case "rollback": {
                return this.handleRollback(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleMigrate(CommandSender sender, String[] args2) {
        DatabaseType targetType;
        DatabaseType sourceType;
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /vtm migrate <source> <target> [options]");
            sender.sendMessage("\u00a7cExample: /vtm migrate sqlite supabase --backup --batch-size 500");
            return true;
        }
        try {
            sourceType = DatabaseType.valueOf(args2[0].toUpperCase());
            targetType = DatabaseType.valueOf(args2[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cInvalid database type. Valid types: sqlite, supabase");
            return true;
        }
        MigrationOptions options = this.parseMigrationOptions(Arrays.copyOfRange(args2, 2, args2.length));
        sender.sendMessage("\u00a76Starting database migration: " + String.valueOf((Object)sourceType) + " \u2192 " + String.valueOf((Object)targetType));
        sender.sendMessage("\u00a77Options: " + options.toString());
        CompletableFuture<MigrationResult> migrationFuture = this.migrationManager.migrateDatabase(sourceType, targetType, options);
        migrationFuture.thenAccept(result -> {
            if (result.isSuccess()) {
                sender.sendMessage("\u00a7aMigration completed successfully!");
                sender.sendMessage("\u00a7aRecords migrated: " + result.getRecordsMigrated());
            } else {
                sender.sendMessage("\u00a7cMigration failed: " + result.getErrorMessage());
            }
        });
        this.startProgressMonitoring(sender);
        return true;
    }

    private boolean handleStatus(CommandSender sender) {
        if (!this.migrationManager.isMigrationInProgress()) {
            sender.sendMessage("\u00a77No migration is currently in progress.");
            return true;
        }
        MigrationProgress progress = this.migrationManager.getCurrentProgress();
        if (progress != null) {
            sender.sendMessage("\u00a76Migration Status:");
            sender.sendMessage("\u00a77" + progress.getStatus());
            sender.sendMessage("\u00a77Progress: " + progress.getFormattedProgress());
            sender.sendMessage("\u00a77Elapsed: " + this.formatDuration(progress.getElapsedTimeMs()));
            sender.sendMessage("\u00a77ETA: " + progress.getFormattedTimeRemaining());
        } else {
            sender.sendMessage("\u00a77Migration in progress but no progress information available.");
        }
        return true;
    }

    private boolean handleCancel(CommandSender sender) {
        if (this.migrationManager.cancelMigration()) {
            sender.sendMessage("\u00a7aMigration cancelled successfully.");
        } else {
            sender.sendMessage("\u00a7cNo migration is currently in progress.");
        }
        return true;
    }

    private boolean handleRollback(CommandSender sender) {
        sender.sendMessage("\u00a7cRollback functionality is not yet implemented.");
        sender.sendMessage("\u00a77Please restore from backup manually if needed.");
        return true;
    }

    private MigrationOptions parseMigrationOptions(String[] args2) {
        MigrationOptions.Builder builder = MigrationOptions.builder();
        for (String arg : args2) {
            if (arg.startsWith("--")) {
                String option;
                switch (option = arg.substring(2)) {
                    case "no-backup": {
                        builder.createBackup(false);
                        break;
                    }
                    case "backup": {
                        builder.createBackup(true);
                        break;
                    }
                    case "no-clear": {
                        builder.clearTargetTables(false);
                        break;
                    }
                    case "clear": {
                        builder.clearTargetTables(true);
                        break;
                    }
                    case "no-rollback": {
                        builder.rollbackOnFailure(false);
                        break;
                    }
                    case "rollback": {
                        builder.rollbackOnFailure(true);
                        break;
                    }
                    case "dry-run": {
                        builder.dryRun(true);
                        break;
                    }
                    case "continue-on-error": {
                        builder.continueOnError(true);
                    }
                }
                continue;
            }
            if (arg.startsWith("--batch-size=")) {
                try {
                    int batchSize = Integer.parseInt(arg.substring(13));
                    builder.batchSize(Math.max(1, Math.min(10000, batchSize)));
                }
                catch (NumberFormatException batchSize) {}
                continue;
            }
            if (!arg.startsWith("--timeout=")) continue;
            try {
                long timeoutMs = Long.parseLong(arg.substring(10));
                builder.timeoutMs(Math.max(1000L, Math.min(36000000L, timeoutMs)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    private void startProgressMonitoring(CommandSender sender) {
        this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.migrationManager.isMigrationInProgress()) {
                return;
            }
            MigrationProgress progress = this.migrationManager.getCurrentProgress();
            if (progress == null || sender instanceof Player) {
                // empty if block
            }
        }, 40L, 40L);
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76VillagerTradeManager Migration Commands:");
        sender.sendMessage("\u00a7e/vtm migrate <source> <target> [options] \u00a77- Start database migration");
        sender.sendMessage("\u00a7e/vtm migration status \u00a77- Check migration progress");
        sender.sendMessage("\u00a7e/vtm migration cancel \u00a77- Cancel current migration");
        sender.sendMessage("\u00a7e/vtm migration rollback \u00a77- Rollback completed migration");
        sender.sendMessage("\u00a7e/vtm migration help \u00a77- Show this help");
        sender.sendMessage("");
        sender.sendMessage("\u00a76Database Types:");
        sender.sendMessage("\u00a77sqlite \u00a77- SQLite database");
        sender.sendMessage("\u00a77supabase \u00a77- Supabase cloud database");
        sender.sendMessage("");
        sender.sendMessage("\u00a76Migration Options:");
        sender.sendMessage("\u00a77--backup \u00a77- Create backup before migration (default)");
        sender.sendMessage("\u00a77--no-backup \u00a77- Skip backup creation");
        sender.sendMessage("\u00a77--clear \u00a77- Clear target tables before migration (default)");
        sender.sendMessage("\u00a77--no-clear \u00a77- Don't clear target tables");
        sender.sendMessage("\u00a77--rollback \u00a77- Rollback on failure (default)");
        sender.sendMessage("\u00a77--no-rollback \u00a77- Don't rollback on failure");
        sender.sendMessage("\u00a77--dry-run \u00a77- Preview migration without making changes");
        sender.sendMessage("\u00a77--batch-size=<n> \u00a77- Records per batch (default: 1000)");
        sender.sendMessage("\u00a77--timeout=<ms> \u00a77- Migration timeout in milliseconds");
        sender.sendMessage("\u00a77--continue-on-error \u00a77- Continue migration despite errors");
        sender.sendMessage("");
        sender.sendMessage("\u00a76Examples:");
        sender.sendMessage("\u00a7e/vtm migrate sqlite supabase");
        sender.sendMessage("\u00a7e/vtm migrate supabase sqlite --no-backup --batch-size=500");
        sender.sendMessage("\u00a7e/vtm migrate sqlite supabase --dry-run");
    }

    private String formatDuration(long ms) {
        if (ms < 1000L) {
            return ms + "ms";
        }
        if (ms < 60000L) {
            return String.format("%.1fs", (double)ms / 1000.0);
        }
        if (ms < 3600000L) {
            return String.format("%.1fm", (double)ms / 60000.0);
        }
        return String.format("%.1fh", (double)ms / 3600000.0);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        ArrayList<String> completions;
        block5: {
            block7: {
                String[] dbTypes;
                block6: {
                    String[] dbTypes2;
                    block4: {
                        String[] subCommands;
                        completions = new ArrayList<String>();
                        if (args2.length != 1) break block4;
                        for (String subCmd : subCommands = new String[]{"migrate", "status", "cancel", "rollback", "help"}) {
                            if (!subCmd.startsWith(args2[0].toLowerCase())) continue;
                            completions.add(subCmd);
                        }
                        break block5;
                    }
                    if (args2.length != 2 || !"migrate".equals(args2[0])) break block6;
                    for (String dbType : dbTypes2 = new String[]{"sqlite", "supabase"}) {
                        if (!dbType.startsWith(args2[1].toLowerCase())) continue;
                        completions.add(dbType);
                    }
                    break block5;
                }
                if (args2.length != 3 || !"migrate".equals(args2[0])) break block7;
                for (String dbType : dbTypes = new String[]{"sqlite", "supabase"}) {
                    if (dbType.equals(args2[1]) || !dbType.startsWith(args2[2].toLowerCase())) continue;
                    completions.add(dbType);
                }
                break block5;
            }
            if (args2.length < 4 || !"migrate".equals(args2[0])) break block5;
            String[] options = new String[]{"--backup", "--no-backup", "--clear", "--no-clear", "--rollback", "--no-rollback", "--dry-run", "--continue-on-error"};
            String current = args2[args2.length - 1];
            for (String option : options) {
                if (!option.startsWith(current)) continue;
                completions.add(option);
            }
        }
        return completions;
    }
}

