/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.services.DynamicTradeDetector;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.TradeCompletionService;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import com.alan.VillagerTradeManager.services.TradeService;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StringUtil;

public class VillagerTradeCommand
implements CommandExecutor,
TabCompleter {
    private final VillagerTradeManager plugin;
    private final SettingsService settingsService;
    private final TradeService tradeService;
    private final RestockService restockService;
    private final TradeCompletionService tradeCompletionService;

    public VillagerTradeCommand(VillagerTradeManager plugin, SettingsService settingsService, TradeService tradeService, RestockService restockService) {
        this.plugin = plugin;
        this.settingsService = settingsService;
        this.tradeService = tradeService;
        this.restockService = restockService;
        this.tradeCompletionService = plugin.getTradeCompletionService();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (command.getName().equalsIgnoreCase("villagertrade")) {
            if (args2.length == 0) {
                sender.sendMessage("\u00a7cUsage: /villagertrade <on|off|status|setprice|listtrades|resetprice|restock|restocktime|restocklimit|unlimitedrestock|instantrestock>");
                sender.sendMessage("\u00a77Current status: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
                return true;
            }
            switch (args2[0].toLowerCase()) {
                case "on": {
                    return this.handleOnCommand(sender);
                }
                case "off": {
                    return this.handleOffCommand(sender);
                }
                case "status": {
                    return this.handleStatusCommand(sender);
                }
                case "setprice": {
                    return this.handleSetPriceCommand(sender, args2);
                }
                case "listtrades": {
                    return this.handleListTradesCommand(sender, args2);
                }
                case "resetprice": {
                    return this.handleResetPriceCommand(sender, args2);
                }
                case "inspectvillager": {
                    return this.handleInspectVillagerCommand(sender, args2);
                }
                case "analyzetrades": {
                    return this.handleAnalyzeTradesCommand(sender, args2);
                }
                case "exporttrades": {
                    return this.handleExportTradesCommand(sender, args2);
                }
                case "importtrades": {
                    return this.handleImportTradesCommand(sender, args2);
                }
                case "cleardynamictrades": {
                    return this.handleClearDynamicTradesCommand(sender, args2);
                }
                case "tradedetection": {
                    return this.handleTradeDetectionCommand(sender, args2);
                }
                case "restock": {
                    return this.handleRestockCommand(sender, args2);
                }
                case "restocktime": {
                    return this.handleRestockTimeCommand(sender, args2);
                }
                case "restocklimit": {
                    return this.handleRestockLimitCommand(sender, args2);
                }
                case "unlimitedrestock": {
                    return this.handleUnlimitedRestockCommand(sender, args2);
                }
                case "instantrestock": {
                    return this.handleInstantRestockCommand(sender, args2);
                }
                case "bantrade": {
                    return this.handleBanTradeCommand(sender, args2);
                }
                case "unbantrade": {
                    return this.handleUnbanTradeCommand(sender, args2);
                }
                case "listbannedtrades": {
                    return this.handleListBannedTradesCommand(sender, args2);
                }
                case "banitem": {
                    return this.handleBanItemCommand(sender, args2);
                }
                case "unbanitem": {
                    return this.handleUnbanItemCommand(sender, args2);
                }
                case "listbanneditems": {
                    return this.handleListBannedItemsCommand(sender, args2);
                }
            }
            sender.sendMessage("\u00a7cUsage: /villagertrade <on|off|status|setprice|listtrades|resetprice|inspectvillager|analyzetrades|exporttrades|importtrades|cleardynamictrades|tradedetection|restock|restocktime|restocklimit|unlimitedrestock|instantrestock|bantrade|unbantrade|listbannedtrades|banitem|unbanitem|listbanneditems>");
            sender.sendMessage("\u00a77Current status: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
            return true;
        }
        return false;
    }

    private boolean handleOnCommand(CommandSender sender) {
        if (this.tradeService.isTradeManagementEnabled()) {
            sender.sendMessage("\u00a7cVillager trade management is already active!");
            return true;
        }
        this.tradeService.setTradeManagementEnabled(true);
        this.settingsService.saveSettingToDatabase("trade_management_enabled", "true");
        sender.sendMessage("\u00a7aVillager trade management activated!");
        return true;
    }

    private boolean handleOffCommand(CommandSender sender) {
        if (!this.tradeService.isTradeManagementEnabled()) {
            sender.sendMessage("\u00a7cVillager trade management is already inactive!");
            return true;
        }
        this.tradeService.setTradeManagementEnabled(false);
        this.settingsService.saveSettingToDatabase("trade_management_enabled", "false");
        sender.sendMessage("\u00a7aVillager trade management deactivated!");
        return true;
    }

    private boolean handleStatusCommand(CommandSender sender) {
        sender.sendMessage("\u00a77Villager trade management is currently: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
        sender.sendMessage("\u00a77Dynamic Trade Detection: \u00a7aEnabled \u00a77(All villager trades supported)");
        sender.sendMessage("\u00a77Custom prices:");
        if (this.tradeService.getCustomPrices().isEmpty()) {
            sender.sendMessage("  \u00a77No custom prices set");
        } else {
            for (Map.Entry<String, Integer> entry2 : this.tradeService.getCustomPrices().entrySet()) {
                String userFriendlyKey = this.tradeService.convertToUserFriendlyFormat(entry2.getKey());
                sender.sendMessage("  \u00a77" + userFriendlyKey + ": \u00a7a" + String.valueOf(entry2.getValue()) + " \u00a77emeralds");
            }
        }
        sender.sendMessage("\u00a77Restock Settings:");
        sender.sendMessage("  \u00a77Custom Restock: " + (this.restockService.isCustomRestockEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("  \u00a77Restock Interval: \u00a7a" + this.restockService.getRestockIntervalMinutes() + " \u00a77minutes");
        sender.sendMessage("  \u00a77Restock Limit: \u00a7a" + this.restockService.getRestockLimitPerDay() + " \u00a77per day");
        sender.sendMessage("  \u00a77Unlimited Restock: " + (this.restockService.isUnlimitedRestock() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("  \u00a77Instant Restock: " + (this.restockService.isInstantRestockEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("\u00a77Banned Trades:");
        Map<String, String> bannedTrades = this.settingsService.getAllBannedTrades();
        sender.sendMessage("  \u00a77Total Banned Trades: \u00a7c" + bannedTrades.size());
        if (!bannedTrades.isEmpty()) {
            HashMap<String, Integer> bannedByProfession = new HashMap<String, Integer>();
            for (String profession : bannedTrades.values()) {
                bannedByProfession.put(profession, bannedByProfession.getOrDefault(profession, 0) + 1);
            }
            sender.sendMessage("  \u00a77Banned by Profession:");
            bannedByProfession.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> {
                String professionDisplay = TradeRegistry.getProfessionDisplayName((String)entry.getKey());
                sender.sendMessage("    \u00a77" + professionDisplay + ": \u00a7c" + String.valueOf(entry.getValue()));
            });
        }
        sender.sendMessage("\u00a77Banned Items:");
        List<String> bannedItems = this.settingsService.getAllBannedItems();
        sender.sendMessage("  \u00a77Total Banned Items: \u00a7c" + bannedItems.size());
        if (!bannedItems.isEmpty()) {
            sender.sendMessage("  \u00a77Banned item types:");
            for (String itemType : bannedItems) {
                sender.sendMessage("    \u00a77- \u00a7c" + itemType.toLowerCase());
            }
        }
        sender.sendMessage("\u00a77Platform Info:");
        sender.sendMessage("  \u00a77Platform: \u00a7a" + String.valueOf((Object)this.plugin.getPlatformService().getDetectedPlatform()));
        sender.sendMessage("  \u00a77Scheduler: \u00a7a" + this.plugin.getTaskScheduler().getSchedulerName());
        return true;
    }

    private boolean handleSetPriceCommand(CommandSender sender, String[] args2) {
        if (args2.length == 3) {
            return this.handleLegacySetPriceCommand(sender, args2);
        }
        if (args2.length == 4) {
            return this.handleSimpleSetPriceCommand(sender, args2);
        }
        if (args2.length == 5) {
            return this.handleUniversalSetPriceCommand(sender, args2);
        }
        sender.sendMessage("\u00a7cUsage:");
        sender.sendMessage("\u00a77Simple: /villagertrade setprice <profession> <item_name> <emerald_cost>");
        sender.sendMessage("\u00a77Legacy: /villagertrade setprice <enchant> <level> <price>");
        sender.sendMessage("\u00a77Universal: /villagertrade setprice <profession> <trade_id> <price> <emerald_cost>");
        sender.sendMessage("\u00a77Examples:");
        sender.sendMessage("  \u00a77/villagertrade setprice armorer diamond_leggings 30");
        sender.sendMessage("  \u00a77/villagertrade setprice efficiency 1 20");
        sender.sendMessage("  \u00a77/villagertrade setprice armorer armorer_l1_coal_15_emerald_1 5 10");
        return true;
    }

    private boolean isLegacyEnchantFormat(String[] args2) {
        if (args2.length != 3) {
            return false;
        }
        String enchantName = args2[1].toLowerCase();
        return enchantName.matches("^(efficiency|fortune|silk_touch|unbreaking|sharpness|smite|bane_of_arthropods|knockback|fire_aspect|looting|sweeping|protection|fire_protection|feather_falling|blast_protection|projectile_protection|respiration|aqua_affinity|thorns|depth_strider|frost_walker|mending|curse_of_vanishing|curse_of_binding|power|punch|flame|infinity|mending|loyalty|impaling|riptide|channeling|multishot|piercing|quick_charge|soul_speed|swift_sneak)$");
    }

    private boolean handleLegacySetPriceCommand(CommandSender sender, String[] args2) {
        int price;
        int level;
        String enchantName = args2[1].toLowerCase();
        try {
            level = Integer.parseInt(args2[2]);
            price = Integer.parseInt(args2[3]);
            if (level <= 0) {
                sender.sendMessage("\u00a7cLevel must be a positive number!");
                return true;
            }
            if (price <= 0) {
                sender.sendMessage("\u00a7cPrice must be a positive number!");
                return true;
            }
            price = Math.min(price, 64);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid level or price! Please enter valid numbers.");
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            sender.sendMessage("\u00a7cUsage: /villagertrade setprice <enchant> <level> <price>");
            return true;
        }
        String itemKey = "enchanted_book_" + enchantName + "_" + level;
        this.tradeService.getCustomPrices().put(itemKey, price);
        this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
        sender.sendMessage("\u00a7aSet custom price for \u00a77" + enchantName + " " + level + " \u00a7ato \u00a7e" + price + " \u00a7aemeralds.");
        return true;
    }

    private boolean handleUniversalSetPriceCommand(CommandSender sender, String[] args2) {
        int emeraldCost;
        String profession = args2[1].toLowerCase();
        String tradeId = args2[2];
        try {
            int price = Integer.parseInt(args2[3]);
            emeraldCost = Integer.parseInt(args2[4]);
            if (price <= 0 || emeraldCost <= 0) {
                sender.sendMessage("\u00a7cPrice and emerald cost must be positive numbers!");
                return true;
            }
            emeraldCost = Math.min(emeraldCost, 64);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid price or emerald cost! Please enter valid numbers.");
            return true;
        }
        if (!TradeRegistry.isValidProfession(profession)) {
            sender.sendMessage("\u00a7cInvalid profession! Valid professions: " + TradeRegistry.getAllProfessions().stream().map(TradeRegistry::getProfessionDisplayName).collect(Collectors.joining(", ")));
            return true;
        }
        if (TradeRegistry.getTradeDefinition(tradeId) == null) {
            sender.sendMessage("\u00a7cInvalid trade ID! Use \u00a77/villagertrade listtrades " + profession + " \u00a7cto see available trades.");
            return true;
        }
        String priceKey = profession + "_" + tradeId;
        this.tradeService.getCustomPrices().put(priceKey, emeraldCost);
        this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
        String tradeDescription = TradeRegistry.getTradeDescription(tradeId);
        sender.sendMessage("\u00a7aSet custom price for \u00a77" + TradeRegistry.getProfessionDisplayName(profession) + " \u00a7f" + tradeDescription + " \u00a7ato \u00a7e" + emeraldCost + " \u00a7aemeralds.");
        return true;
    }

    private boolean handleSimpleSetPriceCommand(CommandSender sender, String[] args2) {
        String simpleDisplayName;
        int emeraldCost;
        String profession = args2[1].toLowerCase();
        String simpleName = args2[2].toLowerCase();
        try {
            emeraldCost = Integer.parseInt(args2[3]);
            if (emeraldCost <= 0) {
                sender.sendMessage("\u00a7cEmerald cost must be a positive number!");
                return true;
            }
            emeraldCost = Math.min(emeraldCost, 64);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid emerald cost! Please enter a valid number.");
            return true;
        }
        boolean hasProfessionInSimpleMapper = SimpleTradeMapper.hasProfession(profession);
        boolean hasProfessionInRegistry = TradeRegistry.isValidProfession(profession);
        if (!hasProfessionInSimpleMapper && !hasProfessionInRegistry) {
            sender.sendMessage("\u00a7cInvalid profession! Valid professions: " + TradeRegistry.getAllProfessions().stream().map(TradeRegistry::getProfessionDisplayName).collect(Collectors.joining(", ")));
            return true;
        }
        String technicalId = null;
        String displayName = simpleName;
        if (hasProfessionInSimpleMapper && SimpleTradeMapper.hasSimpleName(profession, simpleName)) {
            technicalId = SimpleTradeMapper.getTechnicalId(profession, simpleName);
        } else if (hasProfessionInRegistry && TradeRegistry.getTradeDefinition(simpleName) != null && (simpleDisplayName = SimpleTradeMapper.getSimpleName(profession, technicalId = simpleName)) != null) {
            displayName = simpleDisplayName;
        }
        if (technicalId == null) {
            sender.sendMessage("\u00a7cInvalid trade! Use \u00a77/villagertrade listtrades " + profession + " \u00a7cto see available trades.");
            sender.sendMessage("\u00a77You can use either simple names (e.g., 'diamond_leggings') or technical IDs.");
            if (simpleName.toLowerCase().matches("^(efficiency|fortune|silk_touch|unbreaking|sharpness|smite|bane_of_arthropods|knockback|fire_aspect|looting|sweeping|protection|fire_protection|feather_falling|blast_protection|projectile_protection|respiration|aqua_affinity|thorns|depth_strider|frost_walker|mending|curse_of_vanishing|curse_of_binding|power|punch|flame|infinity|mending|loyalty|impaling|riptide|channeling|multishot|piercing|quick_charge|soul_speed|swift_sneak)$")) {
                sender.sendMessage("\u00a77For enchantments, you must specify the level: \u00a7f" + simpleName + "_1\u00a77, \u00a7f" + simpleName + "_2\u00a77, etc.");
            }
            return true;
        }
        String priceKey = profession + "_" + technicalId;
        this.tradeService.getCustomPrices().put(priceKey, emeraldCost);
        this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
        sender.sendMessage("\u00a7aSet custom price for \u00a77" + profession + " " + displayName + " \u00a7ato \u00a7e" + emeraldCost + " \u00a7aemeralds.");
        return true;
    }

    private boolean handleListTradesCommand(CommandSender sender, String[] args2) {
        Object priceInfo;
        Integer customPrice;
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade listtrades <profession>");
            sender.sendMessage("\u00a77Available professions: " + TradeRegistry.getAllProfessions().stream().map(TradeRegistry::getProfessionDisplayName).collect(Collectors.joining(", ")));
            return true;
        }
        String profession = args2[1].toLowerCase();
        if (!TradeRegistry.isValidProfession(profession)) {
            sender.sendMessage("\u00a7cInvalid profession! Valid professions: " + TradeRegistry.getAllProfessions().stream().map(TradeRegistry::getProfessionDisplayName).collect(Collectors.joining(", ")));
            return true;
        }
        List<String> tradeIds = TradeRegistry.getTradesForProfession(profession);
        sender.sendMessage("\u00a76" + TradeRegistry.getProfessionDisplayName(profession) + " Trades:");
        Set<String> simpleNames = SimpleTradeMapper.getSimpleNames(profession);
        if (!simpleNames.isEmpty()) {
            sender.sendMessage("\u00a77Simple Names (recommended):");
            for (String simpleName : simpleNames) {
                String technicalId = SimpleTradeMapper.getTechnicalId(profession, simpleName);
                customPrice = this.tradeService.getCustomPrices().get(profession + "_" + technicalId);
                priceInfo = customPrice != null ? " \u00a77(Custom: \u00a7e" + customPrice + "\u00a77)" : "";
                sender.sendMessage("  \u00a7a" + simpleName + (String)priceInfo);
            }
            sender.sendMessage("");
        }
        sender.sendMessage("\u00a77Technical IDs:");
        for (String tradeId : tradeIds) {
            String description = TradeRegistry.getTradeDescription(tradeId);
            customPrice = this.tradeService.getCustomPrices().get(profession + "_" + tradeId);
            priceInfo = customPrice != null ? " \u00a77(Custom: \u00a7e" + customPrice + "\u00a77)" : "";
            sender.sendMessage("  \u00a77" + tradeId + ": \u00a7f" + description + (String)priceInfo);
        }
        sender.sendMessage("\u00a77Use \u00a7f/villagertrade setprice " + profession + " <simple_name> <emerald_cost> \u00a77for simple commands.");
        sender.sendMessage("\u00a77Or \u00a7f/villagertrade setprice " + profession + " <trade_id> <price> <emerald_cost> \u00a77for technical commands.");
        return true;
    }

    private boolean handleResetPriceCommand(CommandSender sender, String[] args2) {
        if (args2.length < 3) {
            sender.sendMessage("\u00a7cUsage: /villagertrade resetprice <profession> <trade_id>");
            sender.sendMessage("\u00a77Use \u00a7f/villagertrade listtrades <profession> \u00a77to see available trades.");
            return true;
        }
        String profession = args2[1].toLowerCase();
        String tradeId = args2[2];
        if (!TradeRegistry.isValidProfession(profession)) {
            sender.sendMessage("\u00a7cInvalid profession! Valid professions: " + TradeRegistry.getAllProfessions().stream().map(TradeRegistry::getProfessionDisplayName).collect(Collectors.joining(", ")));
            return true;
        }
        if (TradeRegistry.getTradeDefinition(tradeId) == null) {
            sender.sendMessage("\u00a7cInvalid trade ID! Use \u00a77/villagertrade listtrades " + profession + " \u00a7cto see available trades.");
            return true;
        }
        String priceKey = profession + "_" + tradeId;
        Integer removedPrice = this.tradeService.getCustomPrices().remove(priceKey);
        if (removedPrice != null) {
            this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
            String tradeDescription = TradeRegistry.getTradeDescription(tradeId);
            sender.sendMessage("\u00a7aReset price for \u00a77" + TradeRegistry.getProfessionDisplayName(profession) + " \u00a7f" + tradeDescription + " \u00a7ato default.");
        } else {
            sender.sendMessage("\u00a77No custom price was set for this trade.");
        }
        return true;
    }

    private boolean handleRestockCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
            return true;
        }
        if (args2[1].equalsIgnoreCase("on")) {
            this.restockService.setCustomRestockEnabled(true);
            this.settingsService.saveSettingToDatabase("custom_restock_enabled", "true");
            sender.sendMessage("\u00a7aCustom villager restock system enabled!");
            return true;
        }
        if (args2[1].equalsIgnoreCase("off")) {
            this.restockService.setCustomRestockEnabled(false);
            this.settingsService.saveSettingToDatabase("custom_restock_enabled", "false");
            sender.sendMessage("\u00a7aCustom villager restock system disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
        return true;
    }

    private boolean handleRestockTimeCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restocktime <minutes>");
            sender.sendMessage("\u00a77Current restock time: \u00a7a" + this.restockService.getRestockIntervalMinutes() + " \u00a77minutes");
            return true;
        }
        try {
            int minutes = Integer.parseInt(args2[1]);
            if (minutes <= 0) {
                sender.sendMessage("\u00a7cRestock time must be a positive number!");
                return true;
            }
            this.restockService.setRestockIntervalMinutes(minutes);
            this.settingsService.saveSettingToDatabase("restock_interval_minutes", String.valueOf(minutes));
            sender.sendMessage("\u00a7aSet villager restock interval to \u00a7e" + minutes + " \u00a7aminutes.");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid number! Please enter a valid number of minutes.");
            return true;
        }
    }

    private boolean handleRestockLimitCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restocklimit <count>");
            sender.sendMessage("\u00a77Current restock limit: \u00a7a" + this.restockService.getRestockLimitPerDay() + " \u00a77per day");
            return true;
        }
        try {
            int limit = Integer.parseInt(args2[1]);
            if (limit <= 0) {
                sender.sendMessage("\u00a7cRestock limit must be a positive number!");
                return true;
            }
            this.restockService.setRestockLimitPerDay(limit);
            this.settingsService.saveSettingToDatabase("restock_limit_per_day", String.valueOf(limit));
            sender.sendMessage("\u00a7aSet villager restock limit to \u00a7e" + limit + " \u00a7aper day.");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid number! Please enter a valid restock limit.");
            return true;
        }
    }

    private boolean handleUnlimitedRestockCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
            return true;
        }
        if (args2[1].equalsIgnoreCase("on")) {
            this.restockService.setUnlimitedRestock(true);
            this.settingsService.saveSettingToDatabase("unlimited_restock", "true");
            sender.sendMessage("\u00a7aUnlimited villager restock enabled!");
            return true;
        }
        if (args2[1].equalsIgnoreCase("off")) {
            this.restockService.setUnlimitedRestock(false);
            this.settingsService.saveSettingToDatabase("unlimited_restock", "false");
            sender.sendMessage("\u00a7aUnlimited villager restock disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
        return true;
    }

    private boolean handleInstantRestockCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade instantrestock <on|off>");
            return true;
        }
        if (args2[1].equalsIgnoreCase("on")) {
            this.restockService.setInstantRestockEnabled(true);
            this.settingsService.saveSettingToDatabase("instant_restock_enabled", "true");
            sender.sendMessage("\u00a7aInstant villager restock enabled!");
            return true;
        }
        if (args2[1].equalsIgnoreCase("off")) {
            this.restockService.setInstantRestockEnabled(false);
            this.settingsService.saveSettingToDatabase("instant_restock_enabled", "false");
            sender.sendMessage("\u00a7aInstant villager restock disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade instantrestock <on|off>");
        return true;
    }

    private boolean handleInspectVillagerCommand(CommandSender sender, String[] args2) {
        RayTraceResult rayTrace;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        Villager targetVillager = null;
        Block targetBlock = player.getTargetBlockExact(5);
        if (targetBlock != null && targetBlock.getState() instanceof CreatureSpawner) {
            for (Entity entity2 : targetBlock.getWorld().getNearbyEntities(targetBlock.getLocation(), 3.0, 3.0, 3.0)) {
                if (!(entity2 instanceof Villager)) continue;
                targetVillager = (Villager)entity2;
                break;
            }
        }
        if (targetVillager == null && (rayTrace = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 5.0, entity -> entity instanceof Villager)) != null && rayTrace.getHitEntity() instanceof Villager) {
            targetVillager = (Villager)rayTrace.getHitEntity();
        }
        if (targetVillager == null) {
            sender.sendMessage("\u00a7cNo villager found! Look directly at a villager and try again.");
            sender.sendMessage("\u00a77Make sure you're within 5 blocks of the villager.");
            return true;
        }
        String profession = null;
        try {
            if (targetVillager.getProfession() != null && targetVillager.getProfession().getKey() != null) {
                profession = targetVillager.getProfession().getKey().getKey().toLowerCase();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get villager profession: " + e.getMessage());
        }
        String professionDisplay = "Unknown";
        if (profession != null) {
            professionDisplay = TradeRegistry.getProfessionDisplayName(profession);
        }
        sender.sendMessage("\u00a76=== Villager Inspection ===");
        sender.sendMessage("\u00a77Profession: \u00a7a" + professionDisplay);
        sender.sendMessage("\u00a77Location: \u00a7a" + targetVillager.getLocation().getBlockX() + ", " + targetVillager.getLocation().getBlockY() + ", " + targetVillager.getLocation().getBlockZ());
        sender.sendMessage("\u00a77UUID: \u00a77" + targetVillager.getUniqueId().toString().substring(0, 8) + "...");
        sender.sendMessage("");
        List recipes = targetVillager.getRecipes();
        if (recipes.isEmpty()) {
            sender.sendMessage("\u00a77This villager has no trades available.");
            return true;
        }
        sender.sendMessage("\u00a76Current Trades (" + recipes.size() + "):");
        for (int i = 0; i < recipes.size(); ++i) {
            Integer customPrice;
            MerchantRecipe recipe = (MerchantRecipe)recipes.get(i);
            ItemStack result = recipe.getResult();
            List ingredients = recipe.getIngredients();
            String tradeId = TradeRegistry.identifyTrade(profession, result, ingredients);
            String simpleName = null;
            String tradeType = "\u00a7cUnknown";
            if (tradeId != null) {
                tradeType = "\u00a7aRegistry";
                simpleName = SimpleTradeMapper.getSimpleName(profession, tradeId);
            } else {
                try {
                    DynamicTradeDetector.DetectedTrade detectedTrade = this.plugin.getDynamicTradeStorageService().getDetectedTrade(profession, result, ingredients).get();
                    if (detectedTrade != null) {
                        tradeId = detectedTrade.getTradeId();
                        simpleName = detectedTrade.getSimpleName();
                        tradeType = "\u00a7eDynamic";
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    this.plugin.getLogger().warning("Failed to check for dynamic trade: " + e.getMessage());
                }
            }
            StringBuilder ingredientsStr = new StringBuilder();
            for (int j = 0; j < ingredients.size(); ++j) {
                if (j > 0) {
                    ingredientsStr.append(" + ");
                }
                ItemStack ingredient = (ItemStack)ingredients.get(j);
                ingredientsStr.append(ingredient.getAmount()).append(" ").append(ingredient.getType().name().toLowerCase().replace("_", " "));
            }
            sender.sendMessage("\u00a77" + (i + 1) + ". \u00a7f" + result.getAmount() + " " + result.getType().name().toLowerCase().replace("_", " ") + " \u00a77\u2190 \u00a7e" + ingredientsStr.toString());
            StringBuilder metaInfo = new StringBuilder();
            metaInfo.append("     \u00a77Type: ").append(tradeType);
            if (simpleName != null) {
                metaInfo.append(" \u00a77| \u00a77Simple: \u00a7a").append(simpleName);
            }
            if (tradeId != null && (customPrice = this.tradeService.getCustomPrices().get(profession + "_" + tradeId)) != null) {
                metaInfo.append(" \u00a77| \u00a77Price: \u00a7e").append(customPrice).append(" emeralds");
            }
            sender.sendMessage(metaInfo.toString());
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a77Use \u00a7f/villagertrade setprice \u00a77to customize prices for these trades.");
        return true;
    }

    private boolean handleAnalyzeTradesCommand(CommandSender sender, String[] args2) {
        sender.sendMessage("\u00a76=== Trade Analysis ===");
        try {
            Map<String, Integer> stats = this.plugin.getDynamicTradeStorageService().getTradeStatistics().get();
            sender.sendMessage("\u00a77Dynamic Trade Detection:");
            sender.sendMessage("  \u00a77Total Detected Trades: \u00a7a" + String.valueOf(stats.getOrDefault("total", 0)));
            sender.sendMessage("  \u00a77Active Trades: \u00a7a" + String.valueOf(stats.getOrDefault("total", 0)));
            sender.sendMessage("  \u00a77Unique Trade Types: \u00a7a" + stats.size());
            sender.sendMessage("  \u00a77Last Detection: \u00a7aReal-time");
            if (!stats.isEmpty()) {
                sender.sendMessage("");
                sender.sendMessage("\u00a77Trades by Profession:");
                stats.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("total")).sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> {
                    String professionDisplay = TradeRegistry.getProfessionDisplayName((String)entry.getKey());
                    sender.sendMessage("  \u00a77" + professionDisplay + ": \u00a7a" + String.valueOf(entry.getValue()));
                });
            }
        }
        catch (InterruptedException | ExecutionException e) {
            sender.sendMessage("\u00a7cFailed to retrieve trade statistics: " + e.getMessage());
        }
        Map<String, Integer> customPrices = this.tradeService.getCustomPrices();
        sender.sendMessage("");
        sender.sendMessage("\u00a77Custom Pricing:");
        sender.sendMessage("  \u00a77Total Custom Prices: \u00a7a" + customPrices.size());
        if (!customPrices.isEmpty()) {
            HashMap<String, Integer> professionPrices = new HashMap<String, Integer>();
            for (String key : customPrices.keySet()) {
                String profession = key.split("_")[0];
                professionPrices.put(profession, professionPrices.getOrDefault(profession, 0) + 1);
            }
            sender.sendMessage("  \u00a77Prices by Profession:");
            professionPrices.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> {
                String professionDisplay = TradeRegistry.getProfessionDisplayName((String)entry.getKey());
                sender.sendMessage("    \u00a77" + professionDisplay + ": \u00a7a" + String.valueOf(entry.getValue()));
            });
        }
        return true;
    }

    private boolean handleExportTradesCommand(CommandSender sender, String[] args2) {
        String format;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        String string = format = args2.length > 1 ? args2[1].toLowerCase() : "json";
        if (!format.equals("json") && !format.equals("yaml")) {
            sender.sendMessage("\u00a7cInvalid format! Use 'json' or 'yaml'.");
            return true;
        }
        try {
            File exportFile = new File(this.plugin.getDataFolder(), "trade_export_" + System.currentTimeMillis() + "." + format);
            HashMap<String, Object> exportData = new HashMap<String, Object>();
            exportData.put("export_timestamp", System.currentTimeMillis());
            exportData.put("plugin_version", "11.0");
            exportData.put("server_version", this.plugin.getServer().getVersion());
            exportData.put("custom_prices", this.tradeService.getCustomPrices());
            try {
                Map<String, Integer> dynamicStats = this.plugin.getDynamicTradeStorageService().getTradeStatistics().get();
                exportData.put("dynamic_trade_stats", dynamicStats);
            }
            catch (InterruptedException | ExecutionException e) {
                exportData.put("dynamic_trade_stats", "Export failed: " + e.getMessage());
            }
            try (FileWriter writer = new FileWriter(exportFile);){
                if (format.equals("json")) {
                    writer.write("{\n");
                    writer.write("  \"export_info\": {\n");
                    writer.write("    \"timestamp\": " + String.valueOf(exportData.get("export_timestamp")) + ",\n");
                    writer.write("    \"plugin_version\": \"" + String.valueOf(exportData.get("plugin_version")) + "\",\n");
                    writer.write("    \"server_version\": \"" + String.valueOf(exportData.get("server_version")) + "\"\n");
                    writer.write("  },\n");
                    writer.write("  \"custom_prices\": {\n");
                    Map prices = (Map)exportData.get("custom_prices");
                    int i = 0;
                    for (Map.Entry entry : prices.entrySet()) {
                        writer.write("    \"" + (String)entry.getKey() + "\": " + String.valueOf(entry.getValue()));
                        if (i < prices.size() - 1) {
                            writer.write(",");
                        }
                        writer.write("\n");
                        ++i;
                    }
                    writer.write("  }\n");
                    writer.write("}\n");
                } else {
                    writer.write("# Villager Trade Manager Export\n");
                    writer.write("# Generated: " + String.valueOf(new Date()) + "\n");
                    writer.write("# Plugin Version: " + String.valueOf(exportData.get("plugin_version")) + "\n\n");
                    writer.write("export_info:\n");
                    writer.write("  timestamp: " + String.valueOf(exportData.get("export_timestamp")) + "\n");
                    writer.write("  plugin_version: \"" + String.valueOf(exportData.get("plugin_version")) + "\"\n");
                    writer.write("  server_version: \"" + String.valueOf(exportData.get("server_version")) + "\"\n\n");
                    writer.write("custom_prices:\n");
                    Map prices = (Map)exportData.get("custom_prices");
                    for (Map.Entry entry : prices.entrySet()) {
                        writer.write("  " + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()) + "\n");
                    }
                }
            }
            sender.sendMessage("\u00a7aTrade configuration exported to: \u00a7f" + exportFile.getName());
            sender.sendMessage("\u00a77File location: \u00a7f" + exportFile.getAbsolutePath());
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to export trade configuration: " + e.getMessage());
        }
        return true;
    }

    private boolean handleImportTradesCommand(CommandSender sender, String[] args2) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade importtrades <filename>");
            sender.sendMessage("\u00a77File should be in the plugin's data folder.");
            return true;
        }
        String filename = args2[1];
        File importFile = new File(this.plugin.getDataFolder(), filename);
        if (!importFile.exists()) {
            sender.sendMessage("\u00a7cFile not found: \u00a7f" + filename);
            sender.sendMessage("\u00a77Files should be placed in: \u00a7f" + this.plugin.getDataFolder().getAbsolutePath());
            return true;
        }
        try {
            sender.sendMessage("\u00a76Importing trade configuration from: \u00a7f" + filename);
            sender.sendMessage("\u00a77Note: Import functionality is under development.");
            sender.sendMessage("\u00a77Please manually edit the prices.dat file for now.");
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to import trade configuration: " + e.getMessage());
        }
        return true;
    }

    private boolean handleClearDynamicTradesCommand(CommandSender sender, String[] args2) {
        sender.sendMessage("\u00a76=== Clearing Dynamic Trade Data ===");
        try {
            int clearedCount = this.plugin.getDynamicTradeStorageService().clearOldTrades(30).get();
            sender.sendMessage("\u00a7aCleared \u00a7f" + clearedCount + " \u00a7aold dynamic trade records.");
            this.plugin.getTradeCompletionService().refreshCache();
            sender.sendMessage("\u00a7aTrade completion cache refreshed.");
        }
        catch (InterruptedException | ExecutionException e) {
            sender.sendMessage("\u00a7cFailed to clear dynamic trade data: " + e.getMessage());
        }
        return true;
    }

    private boolean handleTradeDetectionCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade tradedetection <on|off|status>");
            boolean isEnabled = this.settingsService.getBooleanSetting("dynamic_trade_detection_enabled");
            sender.sendMessage("\u00a77Current status: " + (isEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            return true;
        }
        String action = args2[1].toLowerCase();
        if (action.equals("on")) {
            this.settingsService.saveSettingToDatabase("dynamic_trade_detection_enabled", "true");
            sender.sendMessage("\u00a7aDynamic trade detection enabled!");
        } else if (action.equals("off")) {
            this.settingsService.saveSettingToDatabase("dynamic_trade_detection_enabled", "false");
            sender.sendMessage("\u00a7aDynamic trade detection disabled!");
        } else if (action.equals("status")) {
            boolean isEnabled = this.settingsService.getBooleanSetting("dynamic_trade_detection_enabled");
            sender.sendMessage("\u00a77Dynamic trade detection is currently: " + (isEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        } else {
            sender.sendMessage("\u00a7cInvalid action! Use 'on', 'off', or 'status'.");
        }
        return true;
    }

    private boolean handleBanTradeCommand(CommandSender sender, String[] args2) {
        String reason;
        if (args2.length < 3) {
            sender.sendMessage("\u00a7cUsage: /villagertrade bantrade <profession> <trade_id> [reason]");
            sender.sendMessage("\u00a77Use \u00a7f/villagertrade listtrades <profession> \u00a77to see available trades.");
            return true;
        }
        String profession = args2[1].toLowerCase();
        String tradeId = args2[2];
        String string = reason = args2.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args2, 3, args2.length)) : "No reason specified";
        if (!SimpleTradeMapper.hasProfession(profession)) {
            sender.sendMessage("\u00a7cInvalid profession! Valid professions: " + SimpleTradeMapper.getAllProfessions().stream().map(String::toLowerCase).collect(Collectors.joining(", ")));
            return true;
        }
        String technicalId = null;
        String displayName = tradeId;
        if (SimpleTradeMapper.hasSimpleName(profession, tradeId.toLowerCase())) {
            technicalId = SimpleTradeMapper.getTechnicalId(profession, tradeId.toLowerCase());
            displayName = tradeId.toLowerCase();
        } else {
            technicalId = tradeId;
            String simpleName = SimpleTradeMapper.getSimpleName(profession, technicalId);
            if (simpleName != null) {
                displayName = simpleName;
            }
        }
        if (technicalId == null) {
            sender.sendMessage("\u00a7cInvalid trade! Use \u00a77/villagertrade listtrades " + profession + " \u00a7cto see available trades.");
            return true;
        }
        if (this.settingsService.isTradeBanned(technicalId)) {
            sender.sendMessage("\u00a7cThis trade is already banned!");
            return true;
        }
        String bannedBy = sender.getName();
        this.settingsService.banTrade(technicalId, profession, bannedBy, reason);
        sender.sendMessage("\u00a7aSuccessfully banned trade \u00a77" + profession + " " + displayName + "\u00a7a.");
        sender.sendMessage("\u00a77Reason: \u00a7f" + reason);
        sender.sendMessage("\u00a77Banned by: \u00a7f" + bannedBy);
        return true;
    }

    private boolean handleUnbanTradeCommand(CommandSender sender, String[] args2) {
        if (args2.length < 3) {
            sender.sendMessage("\u00a7cUsage: /villagertrade unbantrade <profession> <trade_id>");
            sender.sendMessage("\u00a77Use \u00a7f/villagertrade listbannedtrades \u00a77to see banned trades.");
            return true;
        }
        String profession = args2[1].toLowerCase();
        String tradeId = args2[2];
        if (!SimpleTradeMapper.hasProfession(profession)) {
            sender.sendMessage("\u00a7cInvalid profession! Valid professions: " + SimpleTradeMapper.getAllProfessions().stream().map(String::toLowerCase).collect(Collectors.joining(", ")));
            return true;
        }
        String technicalId = null;
        String displayName = tradeId;
        if (SimpleTradeMapper.hasSimpleName(profession, tradeId.toLowerCase())) {
            technicalId = SimpleTradeMapper.getTechnicalId(profession, tradeId.toLowerCase());
            displayName = tradeId.toLowerCase();
        } else {
            technicalId = tradeId;
            String simpleName = SimpleTradeMapper.getSimpleName(profession, technicalId);
            if (simpleName != null) {
                displayName = simpleName;
            }
        }
        if (technicalId == null) {
            sender.sendMessage("\u00a7cInvalid trade! Use \u00a77/villagertrade listbannedtrades \u00a77to see banned trades.");
            return true;
        }
        if (!this.settingsService.isTradeBanned(technicalId)) {
            sender.sendMessage("\u00a7cThis trade is not currently banned!");
            return true;
        }
        this.settingsService.unbanTrade(technicalId);
        sender.sendMessage("\u00a7aSuccessfully unbanned trade \u00a77" + profession + " " + displayName + "\u00a7a.");
        sender.sendMessage("\u00a77Unbanned by: \u00a7f" + sender.getName());
        return true;
    }

    private boolean handleListBannedTradesCommand(CommandSender sender, String[] args2) {
        Map<String, String> bannedTrades = this.settingsService.getAllBannedTrades();
        if (bannedTrades.isEmpty()) {
            sender.sendMessage("\u00a76=== Banned Trades ===");
            sender.sendMessage("\u00a77No trades are currently banned.");
            return true;
        }
        String filterProfession = null;
        if (args2.length > 1 && !SimpleTradeMapper.hasProfession(filterProfession = args2[1].toLowerCase())) {
            sender.sendMessage("\u00a7cInvalid profession! Valid professions: " + SimpleTradeMapper.getAllProfessions().stream().map(String::toLowerCase).collect(Collectors.joining(", ")));
            return true;
        }
        sender.sendMessage("\u00a76=== Banned Trades ===");
        HashMap<String, List> tradesByProfession = new HashMap<String, List>();
        for (Map.Entry<String, String> entry : bannedTrades.entrySet()) {
            String tradeId = entry.getKey();
            String profession = entry.getValue();
            if (filterProfession != null && !profession.equals(filterProfession)) continue;
            tradesByProfession.computeIfAbsent(profession, k -> new ArrayList()).add(tradeId);
        }
        if (tradesByProfession.isEmpty()) {
            sender.sendMessage("\u00a77No banned trades found for profession \u00a7f" + filterProfession + "\u00a77.");
            return true;
        }
        for (Map.Entry<String, String> entry : tradesByProfession.entrySet()) {
            String profession = entry.getKey();
            List tradeIds = (List)((Object)entry.getValue());
            sender.sendMessage("\u00a7e" + TradeRegistry.getProfessionDisplayName(profession) + " (" + tradeIds.size() + " banned):");
            for (String tradeId : tradeIds) {
                String simpleName = SimpleTradeMapper.getSimpleName(profession, tradeId);
                String displayName = simpleName != null ? simpleName : tradeId;
                sender.sendMessage("  \u00a77- \u00a7c" + displayName + " \u00a77(" + tradeId + ")");
            }
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a77Use \u00a7f/villagertrade unbantrade <profession> <trade> \u00a77to unban a trade.");
        sender.sendMessage("\u00a77Total banned trades: \u00a7c" + bannedTrades.size());
        return true;
    }

    private boolean handleBanItemCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade banitem <item_type>");
            sender.sendMessage("\u00a77Example: /villagertrade banitem diamond_helmet");
            sender.sendMessage("\u00a77This will disable ALL trades that result in diamond helmets (including enchanted ones).");
            return true;
        }
        String itemType = args2[1].toUpperCase();
        try {
            Material.valueOf((String)itemType);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cInvalid item type! \u00a7f" + itemType + " \u00a7cis not a valid Minecraft item.");
            sender.sendMessage("\u00a77Use item names like: DIAMOND_HELMET, ENCHANTED_GOLDEN_APPLE, etc.");
            return true;
        }
        if (this.settingsService.isItemBanned(itemType)) {
            sender.sendMessage("\u00a7cItem \u00a7f" + itemType.toLowerCase() + " \u00a7cis already banned!");
            return true;
        }
        String bannedBy = sender.getName();
        this.settingsService.banItem(itemType, bannedBy);
        sender.sendMessage("\u00a7aSuccessfully banned item \u00a7f" + itemType.toLowerCase() + "\u00a7a from villager trades.");
        sender.sendMessage("\u00a77All villagers will no longer offer trades for this item.");
        sender.sendMessage("\u00a77Banned by: \u00a7f" + bannedBy);
        return true;
    }

    private boolean handleUnbanItemCommand(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade unbanitem <item_type>");
            sender.sendMessage("\u00a77Use \u00a7f/villagertrade listbanneditems \u00a77to see banned items.");
            return true;
        }
        String itemType = args2[1].toUpperCase();
        if (!this.settingsService.isItemBanned(itemType)) {
            sender.sendMessage("\u00a7cItem \u00a7f" + itemType.toLowerCase() + " \u00a7cis not currently banned!");
            return true;
        }
        this.settingsService.unbanItem(itemType);
        sender.sendMessage("\u00a7aSuccessfully unbanned item \u00a7f" + itemType.toLowerCase() + "\u00a7a.");
        sender.sendMessage("\u00a77Villagers can now offer trades for this item again.");
        sender.sendMessage("\u00a77Unbanned by: \u00a7f" + sender.getName());
        return true;
    }

    private boolean handleListBannedItemsCommand(CommandSender sender, String[] args2) {
        List<String> bannedItems = this.settingsService.getAllBannedItems();
        if (bannedItems.isEmpty()) {
            sender.sendMessage("\u00a76=== Banned Items ===");
            sender.sendMessage("\u00a77No items are currently banned from villager trades.");
            return true;
        }
        sender.sendMessage("\u00a76=== Banned Items ===");
        sender.sendMessage("\u00a77These items cannot be obtained through villager trades:");
        for (String itemType : bannedItems) {
            sender.sendMessage("  \u00a77- \u00a7c" + itemType.toLowerCase());
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a77Use \u00a7f/villagertrade unbanitem <item> \u00a77to allow trades for an item again.");
        sender.sendMessage("\u00a77Total banned items: \u00a7c" + bannedItems.size());
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        if (command.getName().equalsIgnoreCase("villagertrade")) {
            if (args2.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                List<String> commands = Arrays.asList("on", "off", "status", "setprice", "listtrades", "resetprice", "inspectvillager", "analyzetrades", "exporttrades", "importtrades", "cleardynamictrades", "tradedetection", "restock", "restocktime", "restocklimit", "unlimitedrestock", "instantrestock", "bantrade", "unbantrade", "listbannedtrades", "banitem", "unbanitem", "listbanneditems");
                StringUtil.copyPartialMatches((String)args2[0], commands, completions);
                Collections.sort(completions);
                return completions;
            }
            if (args2.length == 2 && args2[0].equalsIgnoreCase("setprice")) {
                return this.tradeCompletionService.getProfessionCompletions(args2[1]);
            }
            if (args2.length == 2 && (args2[0].equalsIgnoreCase("listtrades") || args2[0].equalsIgnoreCase("bantrade") || args2[0].equalsIgnoreCase("unbantrade") || args2[0].equalsIgnoreCase("listbannedtrades"))) {
                return this.tradeCompletionService.getProfessionCompletions(args2[1]);
            }
            if (args2.length == 2 && args2[0].equalsIgnoreCase("resetprice")) {
                return this.tradeCompletionService.getProfessionCompletions(args2[1]);
            }
            if (args2.length == 2 && (args2[0].equalsIgnoreCase("restock") || args2[0].equalsIgnoreCase("unlimitedrestock") || args2[0].equalsIgnoreCase("instantrestock") || args2[0].equalsIgnoreCase("tradedetection"))) {
                List<String> completions = Arrays.asList("on", "off", "status");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args2[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args2.length == 2 && args2[0].equalsIgnoreCase("exporttrades")) {
                List<String> completions = Arrays.asList("json", "yaml");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args2[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args2.length == 2 && (args2[0].equalsIgnoreCase("banitem") || args2[0].equalsIgnoreCase("unbanitem"))) {
                List itemCompletions = Arrays.stream(Material.values()).map(material -> material.name().toLowerCase()).collect(Collectors.toList());
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args2[1], itemCompletions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args2.length == 3 && (args2[0].equalsIgnoreCase("setprice") || args2[0].equalsIgnoreCase("resetprice") || args2[0].equalsIgnoreCase("bantrade") || args2[0].equalsIgnoreCase("unbantrade"))) {
                String profession = args2[1].toLowerCase();
                return this.tradeCompletionService.getTradeCompletions(profession, args2[2]);
            }
            if (args2.length == 4 && args2[0].equalsIgnoreCase("setprice")) {
                String firstArg = args2[1].toLowerCase();
                if (SimpleTradeMapper.hasProfession(firstArg) && SimpleTradeMapper.hasSimpleName(firstArg, args2[2].toLowerCase())) {
                    List<String> completions = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "64");
                    ArrayList<String> matches = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args2[3], completions, matches);
                    Collections.sort(matches);
                    return matches;
                }
                if (TradeRegistry.isValidProfession(firstArg)) {
                    List<String> completions = Arrays.asList("1", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "64");
                    ArrayList<String> matches = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args2[3], completions, matches);
                    Collections.sort(matches);
                    return matches;
                }
                List<String> completions = Arrays.asList("10", "20", "30", "40", "50", "60", "64");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args2[3], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args2.length == 5 && args2[0].equalsIgnoreCase("setprice")) {
                List<String> completions = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "64");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args2[4], completions, matches);
                Collections.sort(matches);
                return matches;
            }
        }
        return Collections.emptyList();
    }
}

