/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import java.sql.Connection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;

public class AsyncDatabaseExecutor {
    private final Plugin plugin;
    private final ExecutorService databaseExecutor;
    private final int threadPoolSize;

    public AsyncDatabaseExecutor(Plugin plugin, int threadPoolSize) {
        this.plugin = plugin;
        this.threadPoolSize = threadPoolSize;
        this.databaseExecutor = Executors.newFixedThreadPool(threadPoolSize);
        plugin.getLogger().info("Async Database Executor started (" + threadPoolSize + " threads)");
    }

    public void executeAsync(Runnable operation) {
        this.databaseExecutor.execute(() -> {
            block2: {
                try {
                    operation.run();
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Async database operation failed: " + e.getMessage());
                    if (!this.plugin.getConfig().getBoolean("logging.debug_database", false)) break block2;
                    e.printStackTrace();
                }
            }
        });
    }

    public <T> CompletableFuture<T> queryAsync(Function<Connection, T> queryFunction, Connection connection) {
        return CompletableFuture.supplyAsync(() -> queryFunction.apply(connection), this.databaseExecutor);
    }

    public void shutdown() {
        this.plugin.getLogger().info("Shutting down Async Database Executor...");
        this.databaseExecutor.shutdown();
        try {
            if (!this.databaseExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.plugin.getLogger().warning("Database executor did not terminate in time, forcing shutdown");
                this.databaseExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.plugin.getLogger().severe("Interrupted while shutting down database executor: " + e.getMessage());
            this.databaseExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.plugin.getLogger().info("Async Database Executor shutdown complete");
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }
}

