/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

public class DatabaseCapabilities {
    private final boolean supportsTransactions;
    private final boolean supportsRealTime;
    private final boolean supportsAdvancedQueries;
    private final boolean supportsFullTextSearch;
    private final boolean supportsStoredProcedures;
    private final int maxConnections;
    private final long expectedLatencyMs;
    private final boolean requiresNetwork;

    private DatabaseCapabilities(Builder builder) {
        this.supportsTransactions = builder.supportsTransactions;
        this.supportsRealTime = builder.supportsRealTime;
        this.supportsAdvancedQueries = builder.supportsAdvancedQueries;
        this.supportsFullTextSearch = builder.supportsFullTextSearch;
        this.supportsStoredProcedures = builder.supportsStoredProcedures;
        this.maxConnections = builder.maxConnections;
        this.expectedLatencyMs = builder.expectedLatencyMs;
        this.requiresNetwork = builder.requiresNetwork;
    }

    public static DatabaseCapabilities sqlite() {
        return new Builder().supportsTransactions(true).supportsRealTime(false).supportsAdvancedQueries(true).supportsFullTextSearch(true).supportsStoredProcedures(false).maxConnections(1).expectedLatencyMs(1L).requiresNetwork(false).build();
    }

    public static DatabaseCapabilities supabase() {
        return new Builder().supportsTransactions(true).supportsRealTime(true).supportsAdvancedQueries(true).supportsFullTextSearch(true).supportsStoredProcedures(false).maxConnections(100).expectedLatencyMs(50L).requiresNetwork(true).build();
    }

    public static DatabaseCapabilities postgresql() {
        return new Builder().supportsTransactions(true).supportsRealTime(false).supportsAdvancedQueries(true).supportsFullTextSearch(true).supportsStoredProcedures(true).maxConnections(50).expectedLatencyMs(10L).requiresNetwork(true).build();
    }

    public boolean supportsTransactions() {
        return this.supportsTransactions;
    }

    public boolean supportsRealTime() {
        return this.supportsRealTime;
    }

    public boolean supportsAdvancedQueries() {
        return this.supportsAdvancedQueries;
    }

    public boolean supportsFullTextSearch() {
        return this.supportsFullTextSearch;
    }

    public boolean supportsStoredProcedures() {
        return this.supportsStoredProcedures;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getExpectedLatencyMs() {
        return this.expectedLatencyMs;
    }

    public boolean requiresNetwork() {
        return this.requiresNetwork;
    }

    public static class Builder {
        private boolean supportsTransactions = false;
        private boolean supportsRealTime = false;
        private boolean supportsAdvancedQueries = false;
        private boolean supportsFullTextSearch = false;
        private boolean supportsStoredProcedures = false;
        private int maxConnections = 1;
        private long expectedLatencyMs = 1L;
        private boolean requiresNetwork = false;

        public Builder supportsTransactions(boolean supports) {
            this.supportsTransactions = supports;
            return this;
        }

        public Builder supportsRealTime(boolean supports) {
            this.supportsRealTime = supports;
            return this;
        }

        public Builder supportsAdvancedQueries(boolean supports) {
            this.supportsAdvancedQueries = supports;
            return this;
        }

        public Builder supportsFullTextSearch(boolean supports) {
            this.supportsFullTextSearch = supports;
            return this;
        }

        public Builder supportsStoredProcedures(boolean supports) {
            this.supportsStoredProcedures = supports;
            return this;
        }

        public Builder maxConnections(int max) {
            this.maxConnections = max;
            return this;
        }

        public Builder expectedLatencyMs(long latency) {
            this.expectedLatencyMs = latency;
            return this;
        }

        public Builder requiresNetwork(boolean requires) {
            this.requiresNetwork = requires;
            return this;
        }

        public DatabaseCapabilities build() {
            return new DatabaseCapabilities(this);
        }
    }
}

