/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.DatabaseException;
import com.alan.VillagerTradeManager.database.DatabaseType;
import org.bukkit.configuration.ConfigurationSection;

public class DatabaseConfig {
    private final DatabaseType type;
    private final SQLiteConfig sqliteConfig;
    private final SupabaseConfig supabaseConfig;
    private final PostgreSQLConfig postgresqlConfig;

    public DatabaseConfig(ConfigurationSection config) throws DatabaseException {
        String typeString = config.getString("type", "sqlite").toLowerCase();
        try {
            this.type = DatabaseType.valueOf(typeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException("Invalid database type: " + typeString + ". Supported types: sqlite, supabase, postgresql");
        }
        switch (this.type) {
            case SQLITE: {
                this.sqliteConfig = new SQLiteConfig(config.getConfigurationSection("sqlite"));
                this.supabaseConfig = null;
                this.postgresqlConfig = null;
                break;
            }
            case SUPABASE: {
                this.supabaseConfig = new SupabaseConfig(config.getConfigurationSection("supabase"));
                this.sqliteConfig = null;
                this.postgresqlConfig = null;
                break;
            }
            case POSTGRESQL: {
                this.postgresqlConfig = new PostgreSQLConfig(config.getConfigurationSection("postgresql"));
                this.sqliteConfig = null;
                this.supabaseConfig = null;
                break;
            }
            default: {
                throw new DatabaseException("Unsupported database type: " + String.valueOf((Object)this.type));
            }
        }
    }

    public DatabaseType getType() {
        return this.type;
    }

    public SQLiteConfig getSqliteConfig() {
        return this.sqliteConfig;
    }

    public SupabaseConfig getSupabaseConfig() {
        return this.supabaseConfig;
    }

    public PostgreSQLConfig getPostgreSQLConfig() {
        return this.postgresqlConfig;
    }

    public void validate() throws DatabaseException {
        switch (this.type) {
            case SQLITE: {
                if (this.sqliteConfig == null) break;
                this.sqliteConfig.validate();
                break;
            }
            case SUPABASE: {
                if (this.supabaseConfig == null) break;
                this.supabaseConfig.validate();
                break;
            }
            case POSTGRESQL: {
                if (this.postgresqlConfig == null) break;
                this.postgresqlConfig.validate();
            }
        }
    }

    public static class SQLiteConfig {
        private final String file;

        public SQLiteConfig(ConfigurationSection config) {
            this.file = config == null ? "plugins/VillagerTradeManager/villager_data.db" : config.getString("file", "plugins/VillagerTradeManager/villager_data.db");
        }

        public String getFile() {
            return this.file;
        }

        public void validate() throws DatabaseException {
            if (this.file == null || this.file.trim().isEmpty()) {
                throw new DatabaseException("SQLite database file path cannot be empty");
            }
        }
    }

    public static class SupabaseConfig {
        private final String url;
        private final String apiKey;
        private final String serviceKey;
        private final String schema;

        public SupabaseConfig(ConfigurationSection config) throws DatabaseException {
            if (config == null) {
                throw new DatabaseException("Supabase configuration section is required when using supabase database type");
            }
            this.url = config.getString("url");
            this.apiKey = config.getString("apiKey");
            this.serviceKey = config.getString("serviceKey");
            this.schema = config.getString("schema", "public");
        }

        public String getUrl() {
            return this.url;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public String getServiceKey() {
            return this.serviceKey;
        }

        public String getSchema() {
            return this.schema;
        }

        public void validate() throws DatabaseException {
            if (this.url == null || this.url.trim().isEmpty()) {
                throw new DatabaseException("Supabase URL is required");
            }
            if (!this.url.startsWith("https://")) {
                throw new DatabaseException("Supabase URL must use HTTPS");
            }
            if (this.apiKey == null || this.apiKey.trim().isEmpty()) {
                throw new DatabaseException("Supabase API key is required");
            }
            if (this.serviceKey == null || this.serviceKey.trim().isEmpty()) {
                throw new DatabaseException("Supabase service key is required");
            }
            if (this.schema == null || this.schema.trim().isEmpty()) {
                throw new DatabaseException("Supabase schema cannot be empty");
            }
        }
    }

    public static class PostgreSQLConfig {
        private final String connectionString;

        public PostgreSQLConfig(ConfigurationSection config) throws DatabaseException {
            if (config == null) {
                throw new DatabaseException("PostgreSQL configuration section is required when using postgresql database type");
            }
            this.connectionString = config.getString("connectionString");
        }

        public String getConnectionString() {
            return this.connectionString;
        }

        public void validate() throws DatabaseException {
            if (this.connectionString == null || this.connectionString.trim().isEmpty()) {
                throw new DatabaseException("PostgreSQL connection string is required");
            }
            if (!this.connectionString.startsWith("postgresql://")) {
                throw new DatabaseException("PostgreSQL connection string must start with 'postgresql://'");
            }
        }
    }
}

