/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.DatabaseType;

public class DatabaseException
extends Exception {
    private final DatabaseType databaseType;
    private final String operation;

    public DatabaseException(String message) {
        super(message);
        this.databaseType = null;
        this.operation = null;
    }

    public DatabaseException(String message, Throwable cause) {
        super(message, cause);
        this.databaseType = null;
        this.operation = null;
    }

    public DatabaseException(String message, DatabaseType databaseType, String operation) {
        super(message);
        this.databaseType = databaseType;
        this.operation = operation;
    }

    public DatabaseException(String message, DatabaseType databaseType, String operation, Throwable cause) {
        super(message, cause);
        this.databaseType = databaseType;
        this.operation = operation;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getOperation() {
        return this.operation;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (this.databaseType != null) {
            sb.append(" [Database: ").append(this.databaseType.getDisplayName()).append("]");
        }
        if (this.operation != null) {
            sb.append(" [Operation: ").append(this.operation).append("]");
        }
        return sb.toString();
    }
}

