/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DatabaseMigrationUtils {
    private final VillagerTradeManager plugin;
    private final Connection databaseConnection;

    public DatabaseMigrationUtils(VillagerTradeManager plugin, Connection databaseConnection) {
        this.plugin = plugin;
        this.databaseConnection = databaseConnection;
    }

    public void performMigrations() {
        block3: {
            try {
                int currentVersion = this.getCurrentSchemaVersion();
                int targetVersion = 2;
                this.plugin.getLogger().info("Current database schema version: " + currentVersion);
                this.plugin.getLogger().info("Target database schema version: " + targetVersion);
                for (int version = currentVersion + 1; version <= targetVersion; ++version) {
                    this.applyMigration(version);
                    this.updateSchemaVersion(version);
                    this.plugin.getLogger().info("Applied migration to version " + version);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to perform database migrations: " + e.getMessage());
                this.plugin.getLogger().severe("Error details: " + e.getSQLState() + " - " + e.getErrorCode());
                if (!this.plugin.getConfig().getBoolean("logging.debug_database", false)) break block3;
                e.printStackTrace();
            }
        }
    }

    private int getCurrentSchemaVersion() throws SQLException {
        this.createSchemaVersionTableIfNotExists();
        String selectSQL = "SELECT version FROM schema_version ORDER BY version DESC LIMIT 1";
        try (Statement stmt = this.databaseConnection.createStatement();
             ResultSet rs = stmt.executeQuery(selectSQL);){
            if (rs.next()) {
                int n = rs.getInt("version");
                return n;
            }
        }
        return 0;
    }

    private void createSchemaVersionTableIfNotExists() throws SQLException {
        String createSQL = "CREATE TABLE IF NOT EXISTS schema_version (version INTEGER PRIMARY KEY, applied_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
        try (Statement stmt = this.databaseConnection.createStatement();){
            stmt.execute(createSQL);
        }
    }

    private void applyMigration(int version) throws SQLException {
        List<String> migrationStatements = this.getMigrationStatements(version);
        for (String sql : migrationStatements) {
            Statement stmt = this.databaseConnection.createStatement();
            try {
                stmt.execute(sql);
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
            }
        }
    }

    private void updateSchemaVersion(int version) throws SQLException {
        String insertSQL = "INSERT INTO schema_version (version) VALUES (?)";
        try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
            pstmt.setInt(1, version);
            pstmt.executeUpdate();
        }
    }

    private List<String> getMigrationStatements(int version) {
        ArrayList<String> statements = new ArrayList<String>();
        switch (version) {
            case 1: {
                statements.add("CREATE TABLE IF NOT EXISTS custom_prices (item_key TEXT PRIMARY KEY, price INTEGER NOT NULL);");
                statements.add("CREATE TABLE IF NOT EXISTS settings (key TEXT PRIMARY KEY, value TEXT);");
                statements.add("CREATE TABLE IF NOT EXISTS villager_restock_data (villager_uuid TEXT PRIMARY KEY, last_restock_time INTEGER, restock_count_today INTEGER, last_reset_day INTEGER);");
                statements.add("INSERT OR IGNORE INTO settings (key, value) VALUES ('trade_management_enabled', 'true')");
                statements.add("INSERT OR IGNORE INTO settings (key, value) VALUES ('custom_restock_enabled', 'false')");
                statements.add("INSERT OR IGNORE INTO settings (key, value) VALUES ('unlimited_restock', 'false')");
                statements.add("INSERT OR IGNORE INTO settings (key, value) VALUES ('instant_restock_enabled', 'false')");
                statements.add("INSERT OR IGNORE INTO settings (key, value) VALUES ('restock_interval_minutes', '30')");
                statements.add("INSERT OR IGNORE INTO settings (key, value) VALUES ('restock_limit_per_day', '3')");
                break;
            }
            case 2: {
                statements.add("CREATE TABLE IF NOT EXISTS dynamic_trades (trade_id TEXT PRIMARY KEY, profession TEXT NOT NULL, level INTEGER NOT NULL, input_item TEXT NOT NULL, input_amount INTEGER NOT NULL, output_item TEXT NOT NULL, output_amount INTEGER NOT NULL, simple_name TEXT, detected_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP, custom_price INTEGER);");
                statements.add("ALTER TABLE custom_prices ADD COLUMN trade_hash TEXT;");
                statements.add("CREATE INDEX IF NOT EXISTS idx_dynamic_trades_profession ON dynamic_trades(profession);");
                statements.add("CREATE INDEX IF NOT EXISTS idx_dynamic_trades_last_seen ON dynamic_trades(last_seen);");
                break;
            }
            default: {
                this.plugin.getLogger().warning("Unknown migration version: " + version);
            }
        }
        return statements;
    }

    public boolean validateSchema() {
        String[] requiredTables;
        for (String tableName : requiredTables = new String[]{"schema_version", "settings", "custom_prices", "villager_restock_data", "dynamic_trades"}) {
            if (this.tableExists(tableName)) continue;
            this.plugin.getLogger().severe("Required table '" + tableName + "' does not exist!");
            return false;
        }
        this.plugin.getLogger().info("Database schema validation passed");
        return true;
    }

    private boolean tableExists(String tableName) {
        boolean bl;
        block8: {
            DatabaseMetaData metaData = this.databaseConnection.getMetaData();
            ResultSet rs = metaData.getTables(null, null, tableName, new String[]{"TABLE"});
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().severe("Could not check if table exists: " + e.getMessage());
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }
}

