/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

public class MigrationOptions {
    public boolean createBackup = true;
    public boolean clearTargetTables = true;
    public boolean rollbackOnFailure = true;
    public boolean dryRun = false;
    public int batchSize = 1000;
    public long timeoutMs = 3600000L;
    public boolean continueOnError = false;

    public MigrationOptions() {
    }

    public MigrationOptions(boolean createBackup, boolean clearTargetTables, boolean rollbackOnFailure, boolean dryRun, int batchSize, long timeoutMs, boolean continueOnError) {
        this.createBackup = createBackup;
        this.clearTargetTables = clearTargetTables;
        this.rollbackOnFailure = rollbackOnFailure;
        this.dryRun = dryRun;
        this.batchSize = batchSize;
        this.timeoutMs = timeoutMs;
        this.continueOnError = continueOnError;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isCreateBackup() {
        return this.createBackup;
    }

    public boolean isClearTargetTables() {
        return this.clearTargetTables;
    }

    public boolean isRollbackOnFailure() {
        return this.rollbackOnFailure;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setCreateBackup(boolean createBackup) {
        this.createBackup = createBackup;
    }

    public void setClearTargetTables(boolean clearTargetTables) {
        this.clearTargetTables = clearTargetTables;
    }

    public void setRollbackOnFailure(boolean rollbackOnFailure) {
        this.rollbackOnFailure = rollbackOnFailure;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public String toString() {
        return String.format("MigrationOptions{backup=%s, clear=%s, rollback=%s, dryRun=%s, batchSize=%d, timeout=%dms}", this.createBackup, this.clearTargetTables, this.rollbackOnFailure, this.dryRun, this.batchSize, this.timeoutMs);
    }

    public static class Builder {
        private boolean createBackup = true;
        private boolean clearTargetTables = true;
        private boolean rollbackOnFailure = true;
        private boolean dryRun = false;
        private int batchSize = 1000;
        private long timeoutMs = 3600000L;
        private boolean continueOnError = false;

        public Builder createBackup(boolean createBackup) {
            this.createBackup = createBackup;
            return this;
        }

        public Builder clearTargetTables(boolean clearTargetTables) {
            this.clearTargetTables = clearTargetTables;
            return this;
        }

        public Builder rollbackOnFailure(boolean rollbackOnFailure) {
            this.rollbackOnFailure = rollbackOnFailure;
            return this;
        }

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public Builder continueOnError(boolean continueOnError) {
            this.continueOnError = continueOnError;
            return this;
        }

        public MigrationOptions build() {
            return new MigrationOptions(this.createBackup, this.clearTargetTables, this.rollbackOnFailure, this.dryRun, this.batchSize, this.timeoutMs, this.continueOnError);
        }
    }
}

