/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MigrationProgress {
    private final long startTime = System.currentTimeMillis();
    private volatile String status = "Initializing...";
    private volatile String currentTable;
    private final AtomicInteger totalTables = new AtomicInteger(0);
    private final AtomicInteger completedTables = new AtomicInteger(0);
    private final AtomicInteger totalRecords = new AtomicInteger(0);
    private final AtomicInteger currentRecords = new AtomicInteger(0);
    private final AtomicLong totalRecordsMigrated = new AtomicLong(0L);

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setCurrentTable(String currentTable) {
        this.currentTable = currentTable;
    }

    public String getCurrentTable() {
        return this.currentTable;
    }

    public void setTotalTables(int totalTables) {
        this.totalTables.set(totalTables);
    }

    public int getTotalTables() {
        return this.totalTables.get();
    }

    public void incrementCompletedTables() {
        this.completedTables.incrementAndGet();
    }

    public int getCompletedTables() {
        return this.completedTables.get();
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords.set(totalRecords);
    }

    public int getTotalRecords() {
        return this.totalRecords.get();
    }

    public void setCurrentRecords(int currentRecords) {
        this.currentRecords.set(currentRecords);
    }

    public int getCurrentRecords() {
        return this.currentRecords.get();
    }

    public void addMigratedRecords(int count) {
        this.totalRecordsMigrated.addAndGet(count);
    }

    public long getTotalRecordsMigrated() {
        return this.totalRecordsMigrated.get();
    }

    public long getElapsedTimeMs() {
        return System.currentTimeMillis() - this.startTime;
    }

    public double getOverallProgress() {
        int total = this.getTotalTables();
        if (total == 0) {
            return 0.0;
        }
        int completed = this.getCompletedTables();
        double tableProgress = (double)completed / (double)total;
        if (this.currentTable != null && this.getTotalRecords() > 0) {
            double currentTableProgress = (double)this.getCurrentRecords() / (double)this.getTotalRecords();
            tableProgress += currentTableProgress / (double)total;
        }
        return Math.min(tableProgress * 100.0, 100.0);
    }

    public long getEstimatedTimeRemainingMs() {
        long elapsed = this.getElapsedTimeMs();
        double progress = this.getOverallProgress() / 100.0;
        if (progress <= 0.0 || elapsed <= 0L) {
            return -1L;
        }
        double remainingProgress = 1.0 - progress;
        return (long)((double)elapsed / progress * remainingProgress);
    }

    public String getFormattedProgress() {
        return String.format("%.1f%% complete (%d/%d tables, %d records migrated)", this.getOverallProgress(), this.getCompletedTables(), this.getTotalTables(), this.getTotalRecordsMigrated());
    }

    public String getFormattedTimeRemaining() {
        long remaining = this.getEstimatedTimeRemainingMs();
        if (remaining < 0L) {
            return "Calculating...";
        }
        if (remaining < 1000L) {
            return "< 1 second";
        }
        if (remaining < 60000L) {
            return String.format("%.1f seconds", (double)remaining / 1000.0);
        }
        if (remaining < 3600000L) {
            return String.format("%.1f minutes", (double)remaining / 60000.0);
        }
        return String.format("%.1f hours", (double)remaining / 3600000.0);
    }

    public String toString() {
        return String.format("Migration Progress: %s | %s | ETA: %s", this.getStatus(), this.getFormattedProgress(), this.getFormattedTimeRemaining());
    }
}

