/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

public class MigrationResult {
    private final boolean success;
    private final String errorMessage;
    private final int recordsMigrated;
    private final long durationMs;

    private MigrationResult(boolean success, String errorMessage, int recordsMigrated, long durationMs) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.recordsMigrated = recordsMigrated;
        this.durationMs = durationMs;
    }

    public static MigrationResult success(int recordsMigrated) {
        return new MigrationResult(true, null, recordsMigrated, 0L);
    }

    public static MigrationResult failure(String errorMessage) {
        return new MigrationResult(false, errorMessage, 0, 0L);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getRecordsMigrated() {
        return this.recordsMigrated;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public String toString() {
        if (this.success) {
            return String.format("Migration successful: %d records migrated", this.recordsMigrated);
        }
        return String.format("Migration failed: %s", this.errorMessage);
    }
}

