/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.database.DatabaseConfig;
import com.alan.VillagerTradeManager.database.DatabaseException;
import com.alan.VillagerTradeManager.database.DatabaseManager;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.database.DatabaseType;
import com.alan.VillagerTradeManager.database.SQLiteDatabaseProvider;
import com.alan.VillagerTradeManager.database.SupabaseDatabaseProvider;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class MigrationValidator {
    private final VillagerTradeManager plugin;
    private final DatabaseManager databaseManager;
    private static final List<String> REQUIRED_TABLES = Arrays.asList("settings", "custom_prices", "villager_restock_data");

    public MigrationValidator(VillagerTradeManager plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
    }

    public boolean validateSourceData(DatabaseType sourceType) {
        this.plugin.getLogger().info("Validating source database: " + String.valueOf((Object)sourceType));
        try {
            if (!this.testConnection(sourceType)) {
                this.plugin.getLogger().severe("Source database connection test failed");
                return false;
            }
            if (!this.validateTableStructure(sourceType)) {
                this.plugin.getLogger().severe("Source database table structure validation failed");
                return false;
            }
            if (!this.validateDataIntegrity(sourceType)) {
                this.plugin.getLogger().severe("Source database data integrity validation failed");
                return false;
            }
            this.plugin.getLogger().info("Source database validation passed");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Source validation failed with exception: " + e.getMessage());
            return false;
        }
    }

    public boolean validateTargetData(DatabaseType targetType) {
        this.plugin.getLogger().info("Validating target database: " + String.valueOf((Object)targetType));
        try {
            if (!this.testConnection(targetType)) {
                this.plugin.getLogger().severe("Target database connection test failed");
                return false;
            }
            if (!this.validateTableStructure(targetType)) {
                this.plugin.getLogger().severe("Target database table structure validation failed");
                return false;
            }
            if (!this.validateDataIntegrity(targetType)) {
                this.plugin.getLogger().severe("Target database data integrity validation failed");
                return false;
            }
            if (!this.validateRecordCounts(targetType)) {
                this.plugin.getLogger().severe("Record count validation failed");
                return false;
            }
            this.plugin.getLogger().info("Target database validation passed");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Target validation failed with exception: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testConnection(DatabaseType dbType) {
        try (DatabaseProvider provider = null;){
            provider = this.createProvider(dbType);
            boolean bl = provider.testConnection().get();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateTableStructure(DatabaseType dbType) {
        try (DatabaseProvider provider = null;){
            provider = this.createProvider(dbType);
            for (String tableName : REQUIRED_TABLES) {
                if (!this.tableExists(provider, tableName)) {
                    this.plugin.getLogger().severe("Required table '" + tableName + "' does not exist in " + String.valueOf((Object)dbType));
                    boolean bl = false;
                    return bl;
                }
                if (this.validateTableColumns(provider, tableName)) continue;
                this.plugin.getLogger().severe("Table '" + tableName + "' has invalid structure in " + String.valueOf((Object)dbType));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean tableExists(DatabaseProvider provider, String tableName) {
        if (provider instanceof SQLiteDatabaseProvider) {
            return this.tableExistsSQLite((SQLiteDatabaseProvider)provider, tableName);
        }
        if (provider instanceof SupabaseDatabaseProvider) {
            return this.tableExistsSupabase((SupabaseDatabaseProvider)provider, tableName);
        }
        return false;
    }

    private boolean tableExistsSQLite(SQLiteDatabaseProvider provider, String tableName) {
        try {
            return (Boolean)((CompletableFuture)provider.getConnection().thenApply(connection -> {
                try (Statement stmt = connection.createStatement();){
                    Boolean bl;
                    block14: {
                        ResultSet rs = stmt.executeQuery("SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "'");
                        try {
                            bl = rs.next();
                            if (rs == null) break block14;
                        }
                        catch (Throwable t$) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable x2) {
                                    t$.addSuppressed(x2);
                                }
                            }
                            throw t$;
                        }
                        rs.close();
                    }
                    return bl;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to check table existence: " + e.getMessage());
                    return false;
                }
            })).get();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to check SQLite table existence: " + e.getMessage());
            return false;
        }
    }

    private boolean tableExistsSupabase(SupabaseDatabaseProvider provider, String tableName) {
        try {
            provider.executeQuery(tableName, null).get();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to check Supabase table existence: " + e.getMessage());
            return false;
        }
    }

    private boolean validateTableColumns(DatabaseProvider provider, String tableName) {
        Set<String> expectedColumns = this.getExpectedColumns(tableName);
        if (expectedColumns == null) {
            this.plugin.getLogger().warning("Unknown table: " + tableName);
            return false;
        }
        if (provider instanceof SQLiteDatabaseProvider) {
            return this.validateSQLiteColumns((SQLiteDatabaseProvider)provider, tableName, expectedColumns);
        }
        if (provider instanceof SupabaseDatabaseProvider) {
            return this.validateSupabaseColumns((SupabaseDatabaseProvider)provider, tableName, expectedColumns);
        }
        return false;
    }

    private Set<String> getExpectedColumns(String tableName) {
        switch (tableName) {
            case "settings": {
                return Set.of("key", "value");
            }
            case "custom_prices": {
                return Set.of("item_key", "price");
            }
            case "villager_restock_data": {
                return Set.of("villager_uuid", "last_restock_time", "restock_count_today", "last_reset_day");
            }
        }
        return null;
    }

    private boolean validateSQLiteColumns(SQLiteDatabaseProvider provider, String tableName, Set<String> expectedColumns) {
        try {
            return (Boolean)((CompletableFuture)provider.getConnection().thenApply(connection -> {
                try (Statement stmt = connection.createStatement();){
                    Boolean bl;
                    block15: {
                        ResultSet rs = stmt.executeQuery("PRAGMA table_info(" + tableName + ")");
                        try {
                            HashSet<String> actualColumns = new HashSet<String>();
                            while (rs.next()) {
                                actualColumns.add(rs.getString("name"));
                            }
                            bl = actualColumns.containsAll(expectedColumns);
                            if (rs == null) break block15;
                        }
                        catch (Throwable t$) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable x2) {
                                    t$.addSuppressed(x2);
                                }
                            }
                            throw t$;
                        }
                        rs.close();
                    }
                    return bl;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to validate SQLite columns: " + e.getMessage());
                    return false;
                }
            })).get();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to validate SQLite table columns: " + e.getMessage());
            return false;
        }
    }

    private boolean validateSupabaseColumns(SupabaseDatabaseProvider provider, String tableName, Set<String> expectedColumns) {
        try {
            provider.executeQuery(tableName, null).get();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to validate Supabase columns: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateDataIntegrity(DatabaseType dbType) {
        try (DatabaseProvider provider = null;){
            provider = this.createProvider(dbType);
            for (String tableName : REQUIRED_TABLES) {
                if (this.validateTableDataIntegrity(provider, tableName)) continue;
                this.plugin.getLogger().severe("Data integrity validation failed for table: " + tableName);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean validateTableDataIntegrity(DatabaseProvider provider, String tableName) {
        Set<String> requiredColumns = this.getRequiredColumns(tableName);
        if (provider instanceof SQLiteDatabaseProvider) {
            return this.validateSQLiteDataIntegrity((SQLiteDatabaseProvider)provider, tableName, requiredColumns);
        }
        if (provider instanceof SupabaseDatabaseProvider) {
            return this.validateSupabaseDataIntegrity((SupabaseDatabaseProvider)provider, tableName, requiredColumns);
        }
        return false;
    }

    private Set<String> getRequiredColumns(String tableName) {
        switch (tableName) {
            case "settings": {
                return Set.of("key", "value");
            }
            case "custom_prices": {
                return Set.of("item_key", "price");
            }
            case "villager_restock_data": {
                return Set.of("villager_uuid");
            }
        }
        return Set.of();
    }

    private boolean validateSQLiteDataIntegrity(SQLiteDatabaseProvider provider, String tableName, Set<String> requiredColumns) {
        try {
            return (Boolean)((CompletableFuture)provider.getConnection().thenApply(connection -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            })).get();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to validate SQLite data integrity: " + e.getMessage());
            return false;
        }
    }

    private boolean validateSupabaseDataIntegrity(SupabaseDatabaseProvider provider, String tableName, Set<String> requiredColumns) {
        try {
            provider.executeQuery(tableName, null).get();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to validate Supabase data integrity: " + e.getMessage());
            return false;
        }
    }

    private boolean validateRecordCounts(DatabaseType targetType) {
        this.plugin.getLogger().info("Record count validation completed");
        return true;
    }

    private DatabaseProvider createProvider(DatabaseType dbType) throws DatabaseException {
        switch (dbType) {
            case SQLITE: {
                String dbFile = String.valueOf(this.plugin.getDataFolder()) + "/villager_data.db";
                this.plugin.getLogger().info("Creating SQLite provider for validation: " + dbFile);
                return new SQLiteDatabaseProvider(dbFile);
            }
            case SUPABASE: {
                if (this.plugin.getConfig().getConfigurationSection("database.supabase") != null) {
                    DatabaseConfig.SupabaseConfig supabaseConfig = new DatabaseConfig(this.plugin.getConfig().getConfigurationSection("database")).getSupabaseConfig();
                    this.plugin.getLogger().info("Creating Supabase provider for validation");
                    return new SupabaseDatabaseProvider(supabaseConfig);
                }
                throw new DatabaseException("Supabase configuration not found in config.yml");
            }
        }
        throw new DatabaseException("Unsupported database type for validation: " + String.valueOf((Object)dbType));
    }
}

