/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.ConnectionException;
import com.alan.VillagerTradeManager.database.DatabaseCapabilities;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.database.DatabaseType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CompletableFuture;

public class PostgreSQLDatabaseProvider
implements DatabaseProvider {
    private final String connectionString;
    private Connection connection;
    private boolean connected = false;

    public PostgreSQLDatabaseProvider(String connectionString) {
        this.connectionString = connectionString;
    }

    @Override
    public DatabaseType getType() {
        return DatabaseType.POSTGRESQL;
    }

    @Override
    public CompletableFuture<Connection> getConnection() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    Class.forName("org.postgresql.Driver");
                    this.connection = DriverManager.getConnection(this.connectionString);
                    this.connected = true;
                }
                return this.connection;
            }
            catch (ClassNotFoundException | SQLException e) {
                this.connected = false;
                throw new RuntimeException(new ConnectionException("Failed to connect to PostgreSQL database", DatabaseType.POSTGRESQL, "getConnection", e));
            }
        });
    }

    @Override
    public boolean isConnected() {
        try {
            return this.connected && this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            this.connected = false;
            return false;
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.connected = false;
            this.connection = null;
        }
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public CompletableFuture<Boolean> testConnection() {
        return ((CompletableFuture)this.getConnection().thenApply(conn -> {
            try {
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT 1");
                rs.next();
                int result = rs.getInt(1);
                rs.close();
                stmt.close();
                return result == 1;
            }
            catch (SQLException e) {
                this.connected = false;
                return false;
            }
        })).exceptionally(throwable -> {
            this.connected = false;
            return false;
        });
    }

    @Override
    public DatabaseCapabilities getCapabilities() {
        return DatabaseCapabilities.postgresql();
    }
}

