/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.ConnectionException;
import com.alan.VillagerTradeManager.database.DatabaseCapabilities;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.database.DatabaseType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

public class SQLiteDatabaseProvider
implements DatabaseProvider {
    private final String databaseFile;
    private final String connectionString;
    private Connection connection;
    private boolean connected = false;

    public SQLiteDatabaseProvider(String databaseFile) {
        this.databaseFile = databaseFile;
        this.connectionString = "jdbc:sqlite:" + databaseFile;
    }

    @Override
    public DatabaseType getType() {
        return DatabaseType.SQLITE;
    }

    @Override
    public CompletableFuture<Connection> getConnection() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (this.connection != null && !this.connection.isClosed() && this.connection.isValid(5)) {
                    return this.connection;
                }
                this.connection = DriverManager.getConnection(this.connectionString);
                this.connected = true;
                try {
                    this.connection.setAutoCommit(true);
                    try (Statement stmt = this.connection.createStatement();){
                        stmt.execute("PRAGMA journal_mode=WAL;");
                        stmt.execute("PRAGMA synchronous=NORMAL;");
                        stmt.execute("PRAGMA cache_size=1000;");
                        stmt.execute("PRAGMA temp_store=memory;");
                    }
                }
                catch (SQLException configEx) {
                    try {
                        Logger.getLogger("VillagerTradeManager").warning("Failed to configure SQLite connection: " + configEx.getMessage());
                    }
                    catch (Exception loggerEx) {
                        System.err.println("Warning: Failed to configure SQLite connection: " + configEx.getMessage());
                    }
                }
                return this.connection;
            }
            catch (SQLException e) {
                this.connected = false;
                throw new RuntimeException(new ConnectionException("Failed to get SQLite connection", DatabaseType.SQLITE, "getConnection", e));
            }
        });
    }

    @Override
    public boolean isConnected() {
        try {
            return this.connected && this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            this.connected = false;
            return false;
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.connected = false;
            }
        }
        catch (SQLException e) {
            try {
                Logger.getLogger("VillagerTradeManager").warning("Failed to close SQLite connection: " + e.getMessage());
            }
            catch (Exception loggerEx) {
                System.err.println("Warning: Failed to close SQLite connection: " + e.getMessage());
            }
        }
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public CompletableFuture<Boolean> testConnection() {
        return ((CompletableFuture)this.getConnection().thenApply(conn -> {
            try {
                return !conn.isClosed();
            }
            catch (SQLException e) {
                return false;
            }
        })).exceptionally(throwable -> false);
    }

    @Override
    public DatabaseCapabilities getCapabilities() {
        return DatabaseCapabilities.sqlite();
    }

    public String getDatabaseFile() {
        return this.databaseFile;
    }

    public void initializeConnection() throws ConnectionException {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = DriverManager.getConnection(this.connectionString);
                this.connected = true;
            }
        }
        catch (SQLException e) {
            this.connected = false;
            throw new ConnectionException("Failed to initialize SQLite connection", DatabaseType.SQLITE, "initializeConnection", e);
        }
    }

    public Connection getRawConnection() throws ConnectionException {
        if (this.connection == null || !this.isConnected()) {
            this.initializeConnection();
        }
        return this.connection;
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("SQLite JDBC driver not found", e);
        }
    }
}

