/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.metrics;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.metrics.HealthCheckService;
import com.alan.VillagerTradeManager.metrics.MetricsService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;

public class MetricsEndpoint {
    private final VillagerTradeManager plugin;
    private final MetricsService metricsService;
    private final HealthCheckService healthCheckService;
    private final ObjectMapper objectMapper;

    public MetricsEndpoint(VillagerTradeManager plugin, MetricsService metricsService, HealthCheckService healthCheckService) {
        this.plugin = plugin;
        this.metricsService = metricsService;
        this.healthCheckService = healthCheckService;
        this.objectMapper = new ObjectMapper();
    }

    public String getHealthStatusJson() {
        try {
            HealthCheckService.HealthStatus healthStatus = this.healthCheckService.getLastHealthStatus();
            if (healthStatus == null || !this.healthCheckService.isHealthStatusCurrent()) {
                healthStatus = this.healthCheckService.performHealthCheck().get();
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("status", healthStatus.getOverallStatus().toString().toLowerCase());
            response.put("timestamp", healthStatus.getTimestamp().toString());
            HashMap components = new HashMap();
            for (Map.Entry<String, HealthCheckService.HealthComponent> entry : healthStatus.getComponents().entrySet()) {
                HashMap<String, Object> componentData = new HashMap<String, Object>();
                componentData.put("status", entry.getValue().getStatus().toString().toLowerCase());
                componentData.put("details", entry.getValue().getDetails());
                components.put(entry.getKey(), componentData);
            }
            response.put("components", components);
            return this.objectMapper.writeValueAsString(response);
        }
        catch (Exception e) {
            return "{\"status\":\"error\",\"message\":\"" + e.getMessage() + "\"}";
        }
    }

    public String getMetricsPrometheus() {
        return this.metricsService.exportPrometheus();
    }

    public String getMetricsJson() {
        try {
            HashMap<String, Map<String, Number>> metrics = new HashMap<String, Map<String, Number>>();
            metrics.put("database", Map.of("connections_active", 0L, "queries_total", 0L, "queries_failed", 0L));
            metrics.put("cache", Map.of("hits", 0L, "misses", 0L, "hit_ratio", this.metricsService.getCacheHitRatio()));
            metrics.put("plugin", Map.of("commands_executed", 0L, "migrations_completed", 0L, "health_status", 1.0));
            metrics.put("performance", Map.of("cache_hit_ratio", this.metricsService.getCacheHitRatio(), "query_success_rate", this.metricsService.getQuerySuccessRate()));
            return this.objectMapper.writeValueAsString(metrics);
        }
        catch (Exception e) {
            return "{\"error\":\"" + e.getMessage() + "\"}";
        }
    }

    public String getPluginInfoJson() {
        try {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("name", this.plugin.getDescription().getName());
            info.put("version", this.plugin.getDescription().getVersion());
            info.put("description", this.plugin.getDescription().getDescription());
            info.put("authors", this.plugin.getDescription().getAuthors());
            info.put("website", this.plugin.getDescription().getWebsite());
            HashMap<String, Object> server = new HashMap<String, Object>();
            server.put("version", this.plugin.getServer().getVersion());
            server.put("bukkit_version", this.plugin.getServer().getBukkitVersion());
            server.put("online_players", this.plugin.getServer().getOnlinePlayers().size());
            server.put("max_players", this.plugin.getServer().getMaxPlayers());
            server.put("tps", this.plugin.getServer().getTPS());
            info.put("server", server);
            info.put("database_type", this.plugin.getDatabaseManager().getDatabaseType().toString());
            info.put("uptime_seconds", System.currentTimeMillis() / 1000L);
            return this.objectMapper.writeValueAsString(info);
        }
        catch (Exception e) {
            return "{\"error\":\"" + e.getMessage() + "\"}";
        }
    }

    public boolean isReady() {
        boolean databaseReady = this.plugin.getDatabaseManager().isConnected();
        boolean pluginReady = this.plugin.isEnabled();
        return databaseReady && pluginReady;
    }

    public boolean isAlive() {
        return true;
    }

    public void initialize() {
        this.plugin.getLogger().info("Metrics endpoint service initialized");
    }

    public void shutdown() {
        this.plugin.getLogger().info("Metrics endpoint service shut down");
    }
}

