/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.metrics;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsService
implements MeterBinder {
    private final VillagerTradeManager plugin;
    private final MeterRegistry registry;
    private final ConcurrentMap<String, AtomicLong> customCounters;
    private final ConcurrentMap<String, AtomicLong> customGauges;
    private final AtomicLong activeConnections;
    private final AtomicLong totalQueries;
    private final AtomicLong failedQueries;
    private final AtomicLong cacheHits;
    private final AtomicLong cacheMisses;
    private final AtomicLong commandExecutions;
    private final AtomicLong migrationOperations;

    public MetricsService(VillagerTradeManager plugin) {
        this.plugin = plugin;
        this.registry = new SimpleMeterRegistry();
        this.customCounters = new ConcurrentHashMap<String, AtomicLong>();
        this.customGauges = new ConcurrentHashMap<String, AtomicLong>();
        this.activeConnections = new AtomicLong(0L);
        this.totalQueries = new AtomicLong(0L);
        this.failedQueries = new AtomicLong(0L);
        this.cacheHits = new AtomicLong(0L);
        this.cacheMisses = new AtomicLong(0L);
        this.commandExecutions = new AtomicLong(0L);
        this.migrationOperations = new AtomicLong(0L);
        this.bindSystemMetrics();
        this.bindTo(this.registry);
    }

    private void bindSystemMetrics() {
        new JvmMemoryMetrics().bindTo(this.registry);
        new JvmThreadMetrics().bindTo(this.registry);
        new ProcessorMetrics().bindTo(this.registry);
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.gauge("vtm.database.connections.active", this.activeConnections, AtomicLong::get);
        registry.gauge("vtm.database.queries.total", this.totalQueries, AtomicLong::get);
        registry.gauge("vtm.database.queries.failed", this.failedQueries, AtomicLong::get);
        registry.gauge("vtm.cache.hits", this.cacheHits, AtomicLong::get);
        registry.gauge("vtm.cache.misses", this.cacheMisses, AtomicLong::get);
        registry.gauge("vtm.commands.executed", this.commandExecutions, AtomicLong::get);
        registry.gauge("vtm.migrations.completed", this.migrationOperations, AtomicLong::get);
        registry.gauge("vtm.health.status", this, MetricsService::getHealthStatus);
    }

    public void recordConnectionOpened() {
        this.activeConnections.incrementAndGet();
    }

    public void recordConnectionClosed() {
        this.activeConnections.decrementAndGet();
    }

    public void recordQuerySuccess() {
        this.totalQueries.incrementAndGet();
    }

    public void recordQueryFailure() {
        this.totalQueries.incrementAndGet();
        this.failedQueries.incrementAndGet();
    }

    public void recordCacheHit() {
        this.cacheHits.incrementAndGet();
    }

    public void recordCacheMiss() {
        this.cacheMisses.incrementAndGet();
    }

    public void recordCommandExecution(String commandName) {
        this.commandExecutions.incrementAndGet();
        this.getOrCreateCounter("vtm.commands." + commandName).incrementAndGet();
    }

    public void recordMigrationOperation(String operationType) {
        this.migrationOperations.incrementAndGet();
        this.getOrCreateCounter("vtm.migrations." + operationType).incrementAndGet();
    }

    public void recordCustomMetric(String name, long value) {
        this.getOrCreateGauge(name).set(value);
    }

    public void incrementCounter(String name) {
        this.getOrCreateCounter(name).incrementAndGet();
    }

    private AtomicLong getOrCreateCounter(String name) {
        return this.customCounters.computeIfAbsent(name, key -> {
            AtomicLong counter = new AtomicLong(0L);
            this.registry.gauge((String)key, counter, AtomicLong::get);
            return counter;
        });
    }

    private AtomicLong getOrCreateGauge(String name) {
        return this.customGauges.computeIfAbsent(name, key -> {
            AtomicLong gauge = new AtomicLong(0L);
            this.registry.gauge((String)key, gauge);
            return gauge;
        });
    }

    private double getHealthStatus() {
        boolean databaseHealthy = this.plugin.getDatabaseManager().isConnected();
        boolean pluginEnabled = this.plugin.isEnabled();
        return databaseHealthy && pluginEnabled ? 1.0 : 0.0;
    }

    public double getCacheHitRatio() {
        long misses;
        long hits = this.cacheHits.get();
        long total = hits + (misses = this.cacheMisses.get());
        return total > 0L ? (double)hits / (double)total : 0.0;
    }

    public double getQuerySuccessRate() {
        long total = this.totalQueries.get();
        long failed = this.failedQueries.get();
        return total > 0L ? (double)(total - failed) / (double)total : 1.0;
    }

    public MeterRegistry getRegistry() {
        return this.registry;
    }

    public String exportPrometheus() {
        StringBuilder sb = new StringBuilder();
        sb.append("# VTM Plugin Metrics\n");
        sb.append("vtm_database_connections_active ").append(this.activeConnections.get()).append("\n");
        sb.append("vtm_database_queries_total ").append(this.totalQueries.get()).append("\n");
        sb.append("vtm_database_queries_failed ").append(this.failedQueries.get()).append("\n");
        sb.append("vtm_cache_hits ").append(this.cacheHits.get()).append("\n");
        sb.append("vtm_cache_misses ").append(this.cacheMisses.get()).append("\n");
        sb.append("vtm_commands_executed ").append(this.commandExecutions.get()).append("\n");
        sb.append("vtm_migrations_completed ").append(this.migrationOperations.get()).append("\n");
        sb.append("vtm_health_status ").append(this.getHealthStatus()).append("\n");
        return sb.toString();
    }

    public void reset() {
        this.activeConnections.set(0L);
        this.totalQueries.set(0L);
        this.failedQueries.set(0L);
        this.cacheHits.set(0L);
        this.cacheMisses.set(0L);
        this.commandExecutions.set(0L);
        this.migrationOperations.set(0L);
        this.customCounters.clear();
        this.customGauges.clear();
    }
}

