/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.database.AsyncDatabaseExecutor;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.services.DynamicTradeDetector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class DynamicTradeStorageService {
    private final VillagerTradeManager plugin;
    private final DatabaseProvider databaseProvider;
    private final AsyncDatabaseExecutor asyncExecutor;

    public DynamicTradeStorageService(VillagerTradeManager plugin, DatabaseProvider databaseProvider, AsyncDatabaseExecutor asyncExecutor) {
        this.plugin = plugin;
        this.databaseProvider = databaseProvider;
        this.asyncExecutor = asyncExecutor;
    }

    public CompletableFuture<Void> storeDetectedTrade(DynamicTradeDetector.DetectedTrade detectedTrade) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "INSERT OR REPLACE INTO dynamic_trades (trade_id, profession, level, input_item, input_amount, output_item, output_amount, simple_name, detected_at, last_seen, custom_price) VALUES (?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, ?)";
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, detectedTrade.getTradeId());
                    pstmt.setString(2, detectedTrade.getProfession());
                    pstmt.setInt(3, detectedTrade.getLevel());
                    pstmt.setString(4, this.itemToStorageString(detectedTrade.getIngredients().get(0)));
                    pstmt.setInt(5, detectedTrade.getIngredients().get(0).getAmount());
                    pstmt.setString(6, this.itemToStorageString(detectedTrade.getResult()));
                    pstmt.setInt(7, detectedTrade.getResult().getAmount());
                    pstmt.setString(8, detectedTrade.getSimpleName());
                    Integer customPrice = this.getCustomPriceForTrade(detectedTrade.getTradeId());
                    if (customPrice != null) {
                        pstmt.setInt(9, customPrice);
                    } else {
                        pstmt.setNull(9, 4);
                    }
                    pstmt.executeUpdate();
                    if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                        this.plugin.getLogger().fine("Stored dynamic trade: " + detectedTrade.getTradeId());
                    }
                    future.complete(null);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to store detected trade: " + detectedTrade.getTradeId() + " - " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> storeDetectedTradesBatch(List<DynamicTradeDetector.DetectedTrade> detectedTrades) {
        if (detectedTrades.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "INSERT OR REPLACE INTO dynamic_trades (trade_id, profession, level, input_item, input_amount, output_item, output_amount, simple_name, detected_at, last_seen, custom_price) VALUES (?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, ?)";
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    boolean originalAutoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    int batchSize = 0;
                    int MAX_BATCH_SIZE = 50;
                    for (DynamicTradeDetector.DetectedTrade detectedTrade : detectedTrades) {
                        pstmt.setString(1, detectedTrade.getTradeId());
                        pstmt.setString(2, detectedTrade.getProfession());
                        pstmt.setInt(3, detectedTrade.getLevel());
                        pstmt.setString(4, this.itemToStorageString(detectedTrade.getIngredients().get(0)));
                        pstmt.setInt(5, detectedTrade.getIngredients().get(0).getAmount());
                        pstmt.setString(6, this.itemToStorageString(detectedTrade.getResult()));
                        pstmt.setInt(7, detectedTrade.getResult().getAmount());
                        pstmt.setString(8, detectedTrade.getSimpleName());
                        Integer customPrice = this.getCustomPriceForTrade(detectedTrade.getTradeId());
                        if (customPrice != null) {
                            pstmt.setInt(9, customPrice);
                        } else {
                            pstmt.setNull(9, 4);
                        }
                        pstmt.addBatch();
                        if (++batchSize < 50) continue;
                        pstmt.executeBatch();
                        batchSize = 0;
                    }
                    if (batchSize > 0) {
                        pstmt.executeBatch();
                    }
                    conn.commit();
                    conn.setAutoCommit(originalAutoCommit);
                    if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                        this.plugin.getLogger().fine("Batch stored " + detectedTrades.size() + " dynamic trades");
                    }
                    future.complete(null);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to batch store detected trades: " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> updateTradeLastSeen(String tradeId) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "UPDATE dynamic_trades SET last_seen = CURRENT_TIMESTAMP WHERE trade_id = ?";
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, tradeId);
                    pstmt.executeUpdate();
                    future.complete(null);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to update trade last_seen: " + tradeId + " - " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Map<String, DynamicTradeDetector.DetectedTrade>> loadAllDynamicTrades() {
        CompletableFuture<Map<String, DynamicTradeDetector.DetectedTrade>> future = new CompletableFuture<Map<String, DynamicTradeDetector.DetectedTrade>>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                HashMap<String, DynamicTradeDetector.DetectedTrade> trades = new HashMap<String, DynamicTradeDetector.DetectedTrade>();
                String sql = "SELECT * FROM dynamic_trades ORDER BY profession, level";
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery(sql);){
                    while (rs.next()) {
                        DynamicTradeDetector.DetectedTrade trade = this.resultSetToDetectedTrade(rs);
                        if (trade == null) continue;
                        trades.put(trade.getTradeId(), trade);
                    }
                    this.plugin.getLogger().info("Loaded " + trades.size() + " dynamic trades from database");
                    future.complete(trades);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to load dynamic trades: " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<List<DynamicTradeDetector.DetectedTrade>> loadTradesForProfession(String profession) {
        CompletableFuture<List<DynamicTradeDetector.DetectedTrade>> future = new CompletableFuture<List<DynamicTradeDetector.DetectedTrade>>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                ArrayList<DynamicTradeDetector.DetectedTrade> trades = new ArrayList<DynamicTradeDetector.DetectedTrade>();
                String sql = "SELECT * FROM dynamic_trades WHERE profession = ? ORDER BY level, detected_at";
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, profession);
                    try (ResultSet rs = pstmt.executeQuery();){
                        while (rs.next()) {
                            DynamicTradeDetector.DetectedTrade trade = this.resultSetToDetectedTrade(rs);
                            if (trade == null) continue;
                            trades.add(trade);
                        }
                    }
                    future.complete(trades);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to load trades for profession " + profession + ": " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> tradeExists(String tradeId) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "SELECT COUNT(*) FROM dynamic_trades WHERE trade_id = ?";
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, tradeId);
                    try (ResultSet rs = pstmt.executeQuery();){
                        boolean exists = rs.next() && rs.getInt(1) > 0;
                        future.complete(exists);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to check if trade exists: " + tradeId + " - " + e.getMessage());
                    future.complete(false);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> setCustomPrice(String tradeId, int price) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "UPDATE dynamic_trades SET custom_price = ? WHERE trade_id = ?";
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setInt(1, price);
                    pstmt.setString(2, tradeId);
                    pstmt.executeUpdate();
                    if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                        this.plugin.getLogger().fine("Set custom price for dynamic trade: " + tradeId + " = " + price);
                    }
                    future.complete(null);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to set custom price for trade: " + tradeId + " - " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> removeCustomPrice(String tradeId) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "UPDATE dynamic_trades SET custom_price = NULL WHERE trade_id = ?";
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    pstmt.setString(1, tradeId);
                    pstmt.executeUpdate();
                    if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                        this.plugin.getLogger().fine("Removed custom price for dynamic trade: " + tradeId);
                    }
                    future.complete(null);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to remove custom price for trade: " + tradeId + " - " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Integer> cleanupOldTrades(int daysOld) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "DELETE FROM dynamic_trades WHERE last_seen < datetime('now', '-" + daysOld + " days')";
                try (Statement stmt = conn.createStatement();){
                    int deleted = stmt.executeUpdate(sql);
                    if (deleted > 0) {
                        this.plugin.getLogger().info("Cleaned up " + deleted + " old dynamic trades (" + daysOld + " days old)");
                    }
                    future.complete(deleted);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to cleanup old trades: " + e.getMessage());
                    future.complete(0);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Map<String, Integer>> getTradeStatistics() {
        CompletableFuture<Map<String, Integer>> future = new CompletableFuture<Map<String, Integer>>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                HashMap<String, Integer> stats = new HashMap<String, Integer>();
                String sql = "SELECT profession, COUNT(*) as count FROM dynamic_trades GROUP BY profession";
                try (Statement stmt = conn.createStatement();
                     ResultSet rs = stmt.executeQuery(sql);){
                    while (rs.next()) {
                        stats.put(rs.getString("profession"), rs.getInt("count"));
                    }
                    String totalSql = "SELECT COUNT(*) as total FROM dynamic_trades";
                    try (Statement totalStmt = conn.createStatement();
                         ResultSet totalRs = totalStmt.executeQuery(totalSql);){
                        if (totalRs.next()) {
                            stats.put("total", totalRs.getInt("total"));
                        }
                    }
                    future.complete(stats);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to get trade statistics: " + e.getMessage());
                    future.completeExceptionally(e);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private DynamicTradeDetector.DetectedTrade resultSetToDetectedTrade(ResultSet rs) throws SQLException {
        try {
            String tradeId = rs.getString("trade_id");
            String profession = rs.getString("profession");
            int level = rs.getInt("level");
            ItemStack inputItem = this.storageStringToItem(rs.getString("input_item"), rs.getInt("input_amount"));
            List<ItemStack> ingredients = Arrays.asList(inputItem);
            ItemStack result = this.storageStringToItem(rs.getString("output_item"), rs.getInt("output_amount"));
            String simpleName = rs.getString("simple_name");
            return new DynamicTradeDetector.DetectedTrade(tradeId, profession, level, ingredients, result, 0, 12, false, null, simpleName);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to convert ResultSet to DetectedTrade: " + e.getMessage());
            return null;
        }
    }

    private String itemToStorageString(ItemStack item) {
        if (item == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(item.getType().name().toLowerCase());
        if (!item.hasItemMeta() || item.getType().name().equals("ENCHANTED_BOOK")) {
            // empty if block
        }
        return sb.toString();
    }

    private ItemStack storageStringToItem(String storageString, int amount) {
        if (storageString == null || storageString.equals("null")) {
            return new ItemStack(Material.AIR, amount);
        }
        try {
            Material material = Material.valueOf((String)storageString.toUpperCase());
            return new ItemStack(material, amount);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Unknown material in storage string: " + storageString);
            return new ItemStack(Material.AIR, amount);
        }
    }

    public CompletableFuture<DynamicTradeDetector.DetectedTrade> getDetectedTrade(String profession, ItemStack result, List<ItemStack> ingredients) {
        CompletableFuture<DynamicTradeDetector.DetectedTrade> future = new CompletableFuture<DynamicTradeDetector.DetectedTrade>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                StringBuilder sql = new StringBuilder("SELECT * FROM dynamic_trades WHERE profession = ? AND output_item = ? AND output_amount = ?");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(profession);
                params.add(this.itemToStorageString(result));
                params.add(result.getAmount());
                if (!ingredients.isEmpty()) {
                    sql.append(" AND input_item = ? AND input_amount = ?");
                    ItemStack firstIngredient = (ItemStack)ingredients.get(0);
                    params.add(this.itemToStorageString(firstIngredient));
                    params.add(firstIngredient.getAmount());
                }
                try (PreparedStatement pstmt = conn.prepareStatement(sql.toString());){
                    for (int i = 0; i < params.size(); ++i) {
                        Object param = params.get(i);
                        if (param instanceof String) {
                            pstmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (!(param instanceof Integer)) continue;
                        pstmt.setInt(i + 1, (Integer)param);
                    }
                    try (ResultSet rs = pstmt.executeQuery();){
                        if (rs.next()) {
                            DynamicTradeDetector.DetectedTrade trade = this.resultSetToDetectedTrade(rs);
                            future.complete(trade);
                        } else {
                            future.complete(null);
                        }
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to get detected trade: " + e.getMessage());
                    future.complete(null);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Integer> clearOldTrades(int daysOld) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncExecutor.executeAsync(() -> {
            try {
                Connection conn = this.databaseProvider.getConnection().get();
                String sql = "DELETE FROM dynamic_trades WHERE last_seen < datetime('now', '-" + daysOld + " days')";
                try (Statement stmt = conn.createStatement();){
                    int deleted = stmt.executeUpdate(sql);
                    if (deleted > 0) {
                        this.plugin.getLogger().info("Cleared " + deleted + " old dynamic trade records (" + daysOld + " days old)");
                    }
                    future.complete(deleted);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to clear old trades: " + e.getMessage());
                    future.complete(0);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get database connection: " + e.getMessage());
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private Integer getCustomPriceForTrade(String tradeId) {
        return null;
    }
}

