/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.plugin.Plugin;

public class PerformanceMonitorService {
    private final VillagerTradeManager plugin;
    private final AtomicLong totalTradeDetections = new AtomicLong(0L);
    private final AtomicLong totalHashComputations = new AtomicLong(0L);
    private final AtomicLong hashCacheHits = new AtomicLong(0L);
    private final AtomicLong hashCacheMisses = new AtomicLong(0L);
    private final AtomicLong tradeProcessingTime = new AtomicLong(0L);
    private final AtomicLong databaseBatchOperations = new AtomicLong(0L);
    private final AtomicLong databaseSingleOperations = new AtomicLong(0L);
    private final Map<String, Long> performanceMetrics = new ConcurrentHashMap<String, Long>();

    public PerformanceMonitorService(VillagerTradeManager plugin) {
        this.plugin = plugin;
        this.startMetricsReporting();
    }

    public void recordTradeDetection(long processingTimeMs) {
        this.totalTradeDetections.incrementAndGet();
        this.tradeProcessingTime.addAndGet(processingTimeMs);
    }

    public void recordHashComputation(boolean wasCacheHit) {
        this.totalHashComputations.incrementAndGet();
        if (wasCacheHit) {
            this.hashCacheHits.incrementAndGet();
        } else {
            this.hashCacheMisses.incrementAndGet();
        }
    }

    public void recordDatabaseOperation(boolean wasBatch) {
        if (wasBatch) {
            this.databaseBatchOperations.incrementAndGet();
        } else {
            this.databaseSingleOperations.incrementAndGet();
        }
    }

    public Map<String, Object> getPerformanceStats() {
        ConcurrentHashMap<String, Object> stats = new ConcurrentHashMap<String, Object>();
        long totalDetections = this.totalTradeDetections.get();
        long totalHashes = this.totalHashComputations.get();
        long cacheHits = this.hashCacheHits.get();
        long cacheMisses = this.hashCacheMisses.get();
        stats.put("total_trade_detections", totalDetections);
        stats.put("total_hash_computations", totalHashes);
        stats.put("hash_cache_hit_rate", totalHashes > 0L ? (double)cacheHits / (double)totalHashes : 0.0);
        stats.put("hash_cache_hits", cacheHits);
        stats.put("hash_cache_misses", cacheMisses);
        stats.put("average_processing_time_ms", totalDetections > 0L ? (double)this.tradeProcessingTime.get() / (double)totalDetections : 0.0);
        stats.put("database_batch_operations", this.databaseBatchOperations.get());
        stats.put("database_single_operations", this.databaseSingleOperations.get());
        long totalDbOps = this.databaseBatchOperations.get() + this.databaseSingleOperations.get();
        stats.put("database_efficiency_ratio", totalDbOps > 0L ? (double)this.databaseBatchOperations.get() / (double)totalDbOps : 0.0);
        return stats;
    }

    public void resetCounters() {
        this.totalTradeDetections.set(0L);
        this.totalHashComputations.set(0L);
        this.hashCacheHits.set(0L);
        this.hashCacheMisses.set(0L);
        this.tradeProcessingTime.set(0L);
        this.databaseBatchOperations.set(0L);
        this.databaseSingleOperations.set(0L);
    }

    private void startMetricsReporting() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (this.plugin.getConfig().getBoolean("performance.monitoring_enabled", true)) {
                Map<String, Object> stats = this.getPerformanceStats();
                this.logPerformanceMetrics(stats);
            }
        }, 6000L, 6000L);
    }

    private void logPerformanceMetrics(Map<String, Object> stats) {
        this.plugin.getLogger().info("=== Dynamic Trade Detection Performance Metrics ===");
        this.plugin.getLogger().info(String.format("Trade Detections: %d (avg %.2f ms)", stats.get("total_trade_detections"), stats.get("average_processing_time_ms")));
        this.plugin.getLogger().info(String.format("Hash Cache: %.2f%% hit rate (%d hits, %d misses)", (Double)stats.get("hash_cache_hit_rate") * 100.0, stats.get("hash_cache_hits"), stats.get("hash_cache_misses")));
        this.plugin.getLogger().info(String.format("Database Ops: %d batch, %d single (%.2f%% efficiency)", stats.get("database_batch_operations"), stats.get("database_single_operations"), (Double)stats.get("database_efficiency_ratio") * 100.0));
        this.plugin.getLogger().info("==================================================");
    }

    public boolean arePerformanceTargetsMet() {
        boolean dbEfficiencyOk;
        Map<String, Object> stats = this.getPerformanceStats();
        double MAX_AVERAGE_PROCESSING_TIME_MS = 5.0;
        double MIN_HASH_CACHE_HIT_RATE = 0.8;
        double MIN_DATABASE_EFFICIENCY_RATIO = 0.7;
        double avgProcessingTime = (Double)stats.get("average_processing_time_ms");
        double hashHitRate = (Double)stats.get("hash_cache_hit_rate");
        double dbEfficiency = (Double)stats.get("database_efficiency_ratio");
        boolean processingTimeOk = avgProcessingTime <= 5.0;
        boolean cacheHitRateOk = hashHitRate >= 0.8;
        boolean bl = dbEfficiencyOk = dbEfficiency >= 0.7;
        if (!processingTimeOk) {
            this.plugin.getLogger().warning(String.format("Performance target missed: Average processing time %.2f ms > %.2f ms", avgProcessingTime, 5.0));
        }
        if (!cacheHitRateOk) {
            this.plugin.getLogger().warning(String.format("Performance target missed: Hash cache hit rate %.2f%% < %.2f%%", hashHitRate * 100.0, 80.0));
        }
        if (!dbEfficiencyOk) {
            this.plugin.getLogger().warning(String.format("Performance target missed: Database efficiency %.2f%% < %.2f%%", dbEfficiency * 100.0, 70.0));
        }
        return processingTimeOk && cacheHitRateOk && dbEfficiencyOk;
    }
}

