/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.database.AsyncDatabaseExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;

public class SettingsService {
    private final VillagerTradeManager plugin;
    private Connection databaseConnection;
    private final AsyncDatabaseExecutor databaseExecutor;
    private boolean tradeManagementEnabled = true;
    private boolean customRestockEnabled = false;
    private boolean unlimitedRestock = false;
    private boolean instantRestockEnabled = false;
    private int restockIntervalMinutes = 30;
    private int restockLimitPerDay = 3;

    public SettingsService(VillagerTradeManager plugin, Connection databaseConnection, AsyncDatabaseExecutor databaseExecutor) {
        this.plugin = plugin;
        this.databaseConnection = databaseConnection;
        this.databaseExecutor = databaseExecutor;
        this.initializeDatabase();
        this.loadSettingsFromDatabase();
    }

    public void initializeDatabase() {
        try {
            if (this.databaseConnection == null || this.databaseConnection.isClosed()) {
                this.plugin.getLogger().severe("Database connection is not available. Cannot initialize database tables.");
                return;
            }
            this.createTables();
            this.plugin.getLogger().info("Database tables initialized successfully");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not create database tables: " + e.getMessage());
            this.plugin.getLogger().severe("Error details: " + e.getSQLState() + " - " + e.getErrorCode());
        }
    }

    private void createTables() throws SQLException {
        String createPricesTableSQL = "CREATE TABLE IF NOT EXISTS custom_prices (item_key TEXT PRIMARY KEY, price INTEGER NOT NULL);";
        String createSettingsTableSQL = "CREATE TABLE IF NOT EXISTS settings (key TEXT PRIMARY KEY, value TEXT);";
        String createRestockTableSQL = "CREATE TABLE IF NOT EXISTS villager_restock_data (villager_uuid TEXT PRIMARY KEY, last_restock_time INTEGER, restock_count_today INTEGER, last_reset_day INTEGER);";
        String createBannedTradesTableSQL = "CREATE TABLE IF NOT EXISTS banned_trades (trade_id TEXT PRIMARY KEY, profession TEXT NOT NULL, banned_by TEXT, banned_at INTEGER, reason TEXT);";
        try (Statement stmt = this.databaseConnection.createStatement();){
            stmt.execute(createPricesTableSQL);
            stmt.execute(createSettingsTableSQL);
            stmt.execute(createRestockTableSQL);
            stmt.execute(createBannedTradesTableSQL);
        }
    }

    public void loadSettingsFromDatabase() {
        try {
            String selectSQL = "SELECT key, value FROM settings";
            try (Statement stmt = this.databaseConnection.createStatement();
                 ResultSet rs = stmt.executeQuery(selectSQL);){
                while (rs.next()) {
                    String key = rs.getString("key");
                    String value = rs.getString("value");
                    switch (key) {
                        case "trade_management_enabled": {
                            this.tradeManagementEnabled = Boolean.parseBoolean(value);
                            break;
                        }
                        case "custom_restock_enabled": {
                            this.customRestockEnabled = Boolean.parseBoolean(value);
                            break;
                        }
                        case "unlimited_restock": {
                            this.unlimitedRestock = Boolean.parseBoolean(value);
                            break;
                        }
                        case "instant_restock_enabled": {
                            this.instantRestockEnabled = Boolean.parseBoolean(value);
                            break;
                        }
                        case "restock_interval_minutes": {
                            try {
                                this.restockIntervalMinutes = Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                this.restockIntervalMinutes = 30;
                            }
                            break;
                        }
                        case "restock_limit_per_day": {
                            try {
                                this.restockLimitPerDay = Integer.parseInt(value);
                                break;
                            }
                            catch (NumberFormatException e) {
                                this.restockLimitPerDay = 3;
                            }
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not load settings from database: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBooleanSetting(String key) {
        try {
            String selectSQL = "SELECT value FROM settings WHERE key = ?";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(selectSQL);){
                pstmt.setString(1, key);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    boolean bl = Boolean.parseBoolean(rs.getString("value"));
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Could not retrieve boolean setting '" + key + "' from database: " + e.getMessage());
        }
        boolean defaultValue = this.getDefaultBooleanValue(key);
        return this.plugin.getConfig().getBoolean("settings." + key.replace("_", "_"), defaultValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIntSetting(String key) {
        try {
            String selectSQL = "SELECT value FROM settings WHERE key = ?";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(selectSQL);){
                pstmt.setString(1, key);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int n = Integer.parseInt(rs.getString("value"));
                    return n;
                }
            }
        }
        catch (NumberFormatException | SQLException e) {
            this.plugin.getLogger().warning("Could not retrieve integer setting '" + key + "' from database: " + e.getMessage());
        }
        int defaultValue = this.getDefaultIntValue(key);
        return this.plugin.getConfig().getInt("settings." + key.replace("_", "_"), defaultValue);
    }

    public void populateFromMap(Map<String, String> settingsMap) {
        settingsMap.forEach((key, value) -> {
            try {
                switch (key) {
                    case "trade_management_enabled": {
                        this.tradeManagementEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "custom_restock_enabled": {
                        this.customRestockEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "unlimited_restock": {
                        this.unlimitedRestock = Boolean.parseBoolean(value);
                        break;
                    }
                    case "instant_restock_enabled": {
                        this.instantRestockEnabled = Boolean.parseBoolean(value);
                        break;
                    }
                    case "restock_interval_minutes": {
                        this.restockIntervalMinutes = Integer.parseInt(value);
                        break;
                    }
                    case "restock_limit_per_day": {
                        this.restockLimitPerDay = Integer.parseInt(value);
                    }
                }
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Invalid value for setting '" + key + "': " + value);
            }
        });
    }

    private boolean getDefaultBooleanValue(String key) {
        switch (key) {
            case "trade_management_enabled": {
                return true;
            }
            case "custom_restock_enabled": 
            case "unlimited_restock": 
            case "instant_restock_enabled": {
                return false;
            }
        }
        return false;
    }

    private int getDefaultIntValue(String key) {
        switch (key) {
            case "restock_interval_minutes": {
                return 30;
            }
            case "restock_limit_per_day": {
                return 3;
            }
        }
        return 0;
    }

    public void saveSettingToDatabase(String key, String value) {
        this.databaseExecutor.executeAsync(() -> {
            block10: {
                try {
                    String insertSQL = "INSERT OR REPLACE INTO settings (key, value) VALUES (?, ?)";
                    try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
                        pstmt.setString(1, key);
                        pstmt.setString(2, value);
                        pstmt.executeUpdate();
                    }
                    if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                        this.plugin.getLogger().fine("Saved setting " + key + " = " + value);
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().severe("Could not save setting to database: " + e.getMessage());
                    if (!this.plugin.getConfig().getBoolean("logging.debug_database", false)) break block10;
                    e.printStackTrace();
                }
            }
        });
    }

    public void closeDatabase() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not close database connection: " + e.getMessage());
        }
    }

    public Connection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public boolean isTradeManagementEnabled() {
        return this.tradeManagementEnabled;
    }

    public void setTradeManagementEnabled(boolean enabled) {
        this.tradeManagementEnabled = enabled;
    }

    public boolean isCustomRestockEnabled() {
        return this.customRestockEnabled;
    }

    public void setCustomRestockEnabled(boolean enabled) {
        this.customRestockEnabled = enabled;
    }

    public boolean isUnlimitedRestock() {
        return this.unlimitedRestock;
    }

    public void setUnlimitedRestock(boolean unlimited) {
        this.unlimitedRestock = unlimited;
    }

    public boolean isInstantRestockEnabled() {
        return this.instantRestockEnabled;
    }

    public void setInstantRestockEnabled(boolean enabled) {
        this.instantRestockEnabled = enabled;
    }

    public int getRestockIntervalMinutes() {
        return this.restockIntervalMinutes;
    }

    public void setRestockIntervalMinutes(int minutes) {
        this.restockIntervalMinutes = minutes;
    }

    public int getRestockLimitPerDay() {
        return this.restockLimitPerDay;
    }

    public void setRestockLimitPerDay(int limit) {
        this.restockLimitPerDay = limit;
    }

    public void banTrade(String tradeId, String profession, String bannedBy, String reason) {
        this.databaseExecutor.executeAsync(() -> {
            try {
                String insertSQL = "INSERT OR REPLACE INTO banned_trades (trade_id, profession, banned_by, banned_at, reason) VALUES (?, ?, ?, ?, ?)";
                try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
                    pstmt.setString(1, tradeId);
                    pstmt.setString(2, profession);
                    pstmt.setString(3, bannedBy);
                    pstmt.setLong(4, System.currentTimeMillis());
                    pstmt.setString(5, reason != null ? reason : "");
                    pstmt.executeUpdate();
                }
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Banned trade: " + tradeId + " (profession: " + profession + ")");
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not ban trade in database: " + e.getMessage());
            }
        });
    }

    public void unbanTrade(String tradeId) {
        this.databaseExecutor.executeAsync(() -> {
            try {
                String deleteSQL = "DELETE FROM banned_trades WHERE trade_id = ?";
                try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(deleteSQL);){
                    pstmt.setString(1, tradeId);
                    int rowsAffected = pstmt.executeUpdate();
                    if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                        this.plugin.getLogger().fine("Unbanned trade: " + tradeId + " (rows affected: " + rowsAffected + ")");
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not unban trade in database: " + e.getMessage());
            }
        });
    }

    public boolean isTradeBanned(String tradeId) {
        boolean bl;
        block8: {
            String selectSQL = "SELECT trade_id FROM banned_trades WHERE trade_id = ?";
            PreparedStatement pstmt = this.databaseConnection.prepareStatement(selectSQL);
            try {
                pstmt.setString(1, tradeId);
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next();
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("Could not check if trade is banned: " + e.getMessage());
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public Map<String, String> getAllBannedTrades() {
        HashMap<String, String> bannedTrades = new HashMap<String, String>();
        try {
            String selectSQL = "SELECT trade_id, profession FROM banned_trades ORDER BY profession, trade_id";
            try (Statement stmt = this.databaseConnection.createStatement();
                 ResultSet rs = stmt.executeQuery(selectSQL);){
                while (rs.next()) {
                    bannedTrades.put(rs.getString("trade_id"), rs.getString("profession"));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not retrieve banned trades from database: " + e.getMessage());
        }
        return bannedTrades;
    }

    public List<String> getBannedTradesForProfession(String profession) {
        ArrayList<String> bannedTrades = new ArrayList<String>();
        try {
            String selectSQL = "SELECT trade_id FROM banned_trades WHERE profession = ? ORDER BY trade_id";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(selectSQL);){
                pstmt.setString(1, profession);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    bannedTrades.add(rs.getString("trade_id"));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not retrieve banned trades for profession '" + profession + "': " + e.getMessage());
        }
        return bannedTrades;
    }

    public void banItem(String itemType, String bannedBy) {
        String itemBanId = "ITEM:" + itemType.toUpperCase();
        this.databaseExecutor.executeAsync(() -> {
            try {
                String insertSQL = "INSERT OR REPLACE INTO banned_trades (trade_id, profession, banned_by, banned_at, reason) VALUES (?, ?, ?, ?, ?)";
                try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
                    pstmt.setString(1, itemBanId);
                    pstmt.setString(2, "GLOBAL");
                    pstmt.setString(3, bannedBy);
                    pstmt.setLong(4, System.currentTimeMillis());
                    pstmt.setString(5, "Item disabled from villager trades");
                    pstmt.executeUpdate();
                }
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Banned item: " + itemType + " (banned by: " + bannedBy + ")");
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not ban item in database: " + e.getMessage());
            }
        });
    }

    public void unbanItem(String itemType) {
        String itemBanId = "ITEM:" + itemType.toUpperCase();
        this.databaseExecutor.executeAsync(() -> {
            try {
                String deleteSQL = "DELETE FROM banned_trades WHERE trade_id = ?";
                try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(deleteSQL);){
                    pstmt.setString(1, itemBanId);
                    int rowsAffected = pstmt.executeUpdate();
                    if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                        this.plugin.getLogger().fine("Unbanned item: " + itemType + " (rows affected: " + rowsAffected + ")");
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not unban item in database: " + e.getMessage());
            }
        });
    }

    public boolean isItemBanned(String itemType) {
        boolean bl;
        block8: {
            String itemBanId = "ITEM:" + itemType.toUpperCase();
            String selectSQL = "SELECT trade_id FROM banned_trades WHERE trade_id = ?";
            PreparedStatement pstmt = this.databaseConnection.prepareStatement(selectSQL);
            try {
                pstmt.setString(1, itemBanId);
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next();
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("Could not check if item is banned: " + e.getMessage());
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public boolean isItemBanned(Material material) {
        return this.isItemBanned(material.name());
    }

    public List<String> getAllBannedItems() {
        ArrayList<String> bannedItems = new ArrayList<String>();
        try {
            String selectSQL = "SELECT trade_id FROM banned_trades WHERE trade_id LIKE 'ITEM:%' ORDER BY trade_id";
            try (Statement stmt = this.databaseConnection.createStatement();
                 ResultSet rs = stmt.executeQuery(selectSQL);){
                while (rs.next()) {
                    String tradeId = rs.getString("trade_id");
                    String itemType = tradeId.substring(5);
                    bannedItems.add(itemType);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not retrieve banned items from database: " + e.getMessage());
        }
        return bannedItems;
    }
}

