/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SimpleTradeMapper {
    private static final Map<String, Map<String, String>> PROFESSION_ITEM_MAP = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> REVERSE_MAP = new HashMap<String, Map<String, String>>();

    private static void initializeMappings() {
        SimpleTradeMapper.initializeArmorerMappings();
        SimpleTradeMapper.initializeButcherMappings();
        SimpleTradeMapper.initializeCartographerMappings();
        SimpleTradeMapper.initializeClericMappings();
        SimpleTradeMapper.initializeFarmerMappings();
        SimpleTradeMapper.initializeFishermanMappings();
        SimpleTradeMapper.initializeFletcherMappings();
        SimpleTradeMapper.initializeLeatherworkerMappings();
        SimpleTradeMapper.initializeLibrarianMappings();
        SimpleTradeMapper.initializeMasonMappings();
        SimpleTradeMapper.initializeShepherdMappings();
        SimpleTradeMapper.initializeToolsmithMappings();
        SimpleTradeMapper.initializeWeaponsmithMappings();
        SimpleTradeMapper.buildReverseMappings();
    }

    private static void initializeArmorerMappings() {
        LinkedHashMap<String, String> armorerItems = new LinkedHashMap<String, String>();
        armorerItems.put("coal", "armorer_l1_coal_15_emerald_1");
        armorerItems.put("iron_ingot", "armorer_l1_iron_ingot_4_emerald_1");
        armorerItems.put("lapis_lazuli", "armorer_l1_lapis_lazuli_1_emerald_1");
        armorerItems.put("iron_boots", "armorer_l1_emerald_7_iron_boots_1");
        armorerItems.put("iron_helmet", "armorer_l1_emerald_5_iron_helmet_1");
        armorerItems.put("iron_leggings", "armorer_l1_emerald_9_iron_leggings_1");
        armorerItems.put("iron_chestplate", "armorer_l1_emerald_11_iron_chestplate_1");
        armorerItems.put("chainmail_helmet", "armorer_l2_emerald_5_chainmail_helmet_1");
        armorerItems.put("chainmail_chestplate", "armorer_l2_emerald_4_chainmail_chestplate_1");
        armorerItems.put("chainmail_leggings", "armorer_l2_emerald_3_chainmail_leggings_1");
        armorerItems.put("chainmail_boots", "armorer_l2_emerald_1_chainmail_boots_1");
        armorerItems.put("diamond", "armorer_l3_diamond_1_emerald_1");
        armorerItems.put("bell", "armorer_l3_emerald_36_bell_1");
        armorerItems.put("shield", "armorer_l3_emerald_5_shield_1");
        armorerItems.put("diamond_leggings", "armorer_l4_emerald_30_diamond_leggings_1");
        armorerItems.put("diamond_boots", "armorer_l4_emerald_13_diamond_boots_1");
        armorerItems.put("diamond_helmet", "armorer_l4_emerald_30_diamond_helmet_1");
        armorerItems.put("diamond_chestplate", "armorer_l4_emerald_35_diamond_chestplate_1");
        armorerItems.put("diamond_helmet_respiration_3", "armorer_l5_emerald_30_diamond_helmet_respiration_3");
        armorerItems.put("diamond_helmet_aqua_affinity_1", "armorer_l5_emerald_30_diamond_helmet_aqua_affinity_1");
        armorerItems.put("diamond_chestplate_protection_3", "armorer_l5_emerald_30_diamond_chestplate_protection_3");
        armorerItems.put("diamond_chestplate_fire_protection_3", "armorer_l5_emerald_30_diamond_chestplate_fire_protection_3");
        armorerItems.put("diamond_chestplate_blast_protection_3", "armorer_l5_emerald_30_diamond_chestplate_blast_protection_3");
        armorerItems.put("diamond_chestplate_projectile_protection_3", "armorer_l5_emerald_30_diamond_chestplate_projectile_protection_3");
        armorerItems.put("diamond_leggings_blast_protection_3", "armorer_l5_emerald_30_diamond_leggings_blast_protection_3");
        armorerItems.put("diamond_leggings_fire_protection_3", "armorer_l5_emerald_30_diamond_leggings_fire_protection_3");
        armorerItems.put("diamond_leggings_protection_3", "armorer_l5_emerald_30_diamond_leggings_protection_3");
        armorerItems.put("diamond_leggings_projectile_protection_3", "armorer_l5_emerald_30_diamond_leggings_projectile_protection_3");
        armorerItems.put("diamond_boots_feather_falling_3", "armorer_l5_emerald_30_diamond_boots_feather_falling_3");
        armorerItems.put("diamond_boots_depth_strider_3", "armorer_l5_emerald_30_diamond_boots_depth_strider_3");
        armorerItems.put("diamond_boots_frost_walker_2", "armorer_l5_emerald_30_diamond_boots_frost_walker_2");
        armorerItems.put("diamond_boots_soul_speed_3", "armorer_l5_emerald_30_diamond_boots_soul_speed_3");
        armorerItems.put("netherite_helmet", "armorer_l5_emerald_13_netherite_helmet_1");
        armorerItems.put("netherite_chestplate", "armorer_l5_emerald_21_netherite_chestplate_1");
        armorerItems.put("netherite_leggings", "armorer_l5_emerald_19_netherite_leggings_1");
        armorerItems.put("netherite_boots", "armorer_l5_emerald_10_netherite_boots_1");
        PROFESSION_ITEM_MAP.put("armorer", armorerItems);
    }

    private static void initializeButcherMappings() {
        LinkedHashMap<String, String> butcherItems = new LinkedHashMap<String, String>();
        butcherItems.put("chicken", "butcher_l1_chicken_14_emerald_1");
        butcherItems.put("porkchop", "butcher_l1_porkchop_7_emerald_1");
        butcherItems.put("rabbit", "butcher_l1_rabbit_4_emerald_1");
        butcherItems.put("coal", "butcher_l1_coal_15_emerald_1");
        butcherItems.put("cooked_chicken", "butcher_l2_emerald_1_cooked_chicken_8");
        butcherItems.put("cooked_porkchop", "butcher_l2_emerald_1_cooked_porkchop_5");
        butcherItems.put("cooked_rabbit", "butcher_l2_emerald_2_cooked_rabbit_1");
        butcherItems.put("coal", "butcher_l3_coal_15_emerald_1");
        butcherItems.put("rabbit_stew", "butcher_l3_emerald_1_rabbit_stew_1");
        butcherItems.put("cooked_beef", "butcher_l4_emerald_1_cooked_beef_6");
        butcherItems.put("cooked_mutton", "butcher_l4_emerald_1_cooked_mutton_6");
        butcherItems.put("nether_wart", "butcher_l5_nether_wart_1_emerald_1");
        PROFESSION_ITEM_MAP.put("butcher", butcherItems);
    }

    private static void initializeCartographerMappings() {
        LinkedHashMap<String, String> cartographerItems = new LinkedHashMap<String, String>();
        cartographerItems.put("paper", "cartographer_l1_paper_24_emerald_1");
        cartographerItems.put("compass", "cartographer_l1_compass_1_emerald_1");
        cartographerItems.put("map", "cartographer_l2_emerald_7_map_1");
        cartographerItems.put("filled_map", "cartographer_l2_emerald_1_filled_map_1");
        cartographerItems.put("ocean_explorer_map", "cartographer_l3_emerald_12_ocean_explorer_map_1");
        cartographerItems.put("woodland_explorer_map", "cartographer_l3_emerald_12_woodland_explorer_map_1");
        cartographerItems.put("item_frame", "cartographer_l4_emerald_14_item_frame_1");
        cartographerItems.put("trial_explorer_map", "cartographer_l5_emerald_12_trial_explorer_map_1");
        cartographerItems.put("white_banner", "cartographer_l5_emerald_8_white_banner_1");
        cartographerItems.put("blue_banner", "cartographer_l5_emerald_8_blue_banner_1");
        cartographerItems.put("light_blue_banner", "cartographer_l5_emerald_8_light_blue_banner_1");
        cartographerItems.put("red_banner", "cartographer_l5_emerald_8_red_banner_1");
        cartographerItems.put("pink_banner", "cartographer_l5_emerald_8_pink_banner_1");
        cartographerItems.put("green_banner", "cartographer_l5_emerald_8_green_banner_1");
        cartographerItems.put("lime_banner", "cartographer_l5_emerald_8_lime_banner_1");
        cartographerItems.put("gray_banner", "cartographer_l5_emerald_8_gray_banner_1");
        cartographerItems.put("black_banner", "cartographer_l5_emerald_8_black_banner_1");
        cartographerItems.put("purple_banner", "cartographer_l5_emerald_8_purple_banner_1");
        cartographerItems.put("magenta_banner", "cartographer_l5_emerald_8_magenta_banner_1");
        cartographerItems.put("cyan_banner", "cartographer_l5_emerald_8_cyan_banner_1");
        cartographerItems.put("brown_banner", "cartographer_l5_emerald_8_brown_banner_1");
        cartographerItems.put("orange_banner", "cartographer_l5_emerald_8_orange_banner_1");
        cartographerItems.put("yellow_banner", "cartographer_l5_emerald_8_yellow_banner_1");
        PROFESSION_ITEM_MAP.put("cartographer", cartographerItems);
    }

    private static void initializeClericMappings() {
        LinkedHashMap<String, String> clericItems = new LinkedHashMap<String, String>();
        clericItems.put("rotten_flesh", "cleric_l1_rotten_flesh_32_emerald_1");
        clericItems.put("gold_ingot", "cleric_l1_gold_ingot_3_emerald_1");
        clericItems.put("redstone", "cleric_l2_emerald_2_redstone_1");
        clericItems.put("lapis_lazuli", "cleric_l2_emerald_1_lapis_lazuli_1");
        clericItems.put("glowstone", "cleric_l3_emerald_4_glowstone_1");
        clericItems.put("ender_pearl", "cleric_l3_emerald_1_ender_pearl_1");
        clericItems.put("experience_bottle", "cleric_l4_emerald_5_experience_bottle_1");
        clericItems.put("nether_wart", "cleric_l4_emerald_1_nether_wart_1");
        clericItems.put("blaze_rod", "cleric_l5_emerald_20_blaze_rod_1");
        PROFESSION_ITEM_MAP.put("cleric", clericItems);
    }

    private static void initializeFarmerMappings() {
        LinkedHashMap<String, String> farmerItems = new LinkedHashMap<String, String>();
        farmerItems.put("wheat", "farmer_l1_wheat_20_emerald_1");
        farmerItems.put("potato", "farmer_l1_potato_26_emerald_1");
        farmerItems.put("carrot", "farmer_l1_carrot_22_emerald_1");
        farmerItems.put("beetroot", "farmer_l1_beetroot_15_emerald_1");
        farmerItems.put("bread", "farmer_l2_emerald_1_bread_6");
        farmerItems.put("pumpkin", "farmer_l2_emerald_1_pumpkin_6");
        farmerItems.put("melon", "farmer_l2_emerald_1_melon_4");
        farmerItems.put("apple", "farmer_l3_emerald_1_apple_4");
        farmerItems.put("cookie", "farmer_l3_emerald_1_cookie_18");
        farmerItems.put("cake", "farmer_l4_emerald_3_cake_1");
        farmerItems.put("golden_carrot", "farmer_l4_emerald_1_golden_carrot_3");
        farmerItems.put("glistering_melon_slice", "farmer_l4_emerald_1_glistering_melon_slice_3");
        farmerItems.put("suspicious_stew", "farmer_l5_emerald_1_suspicious_stew_1");
        PROFESSION_ITEM_MAP.put("farmer", farmerItems);
    }

    private static void initializeFishermanMappings() {
        LinkedHashMap<String, String> fishermanItems = new LinkedHashMap<String, String>();
        fishermanItems.put("string", "fisherman_l1_string_20_emerald_1");
        fishermanItems.put("coal", "fisherman_l1_coal_10_emerald_1");
        fishermanItems.put("campfire", "fisherman_l2_emerald_6_campfire_1");
        fishermanItems.put("fishing_rod", "fisherman_l2_emerald_1_fishing_rod_1");
        fishermanItems.put("cod_bucket", "fisherman_l3_emerald_20_cod_bucket_1");
        fishermanItems.put("salmon_bucket", "fisherman_l3_emerald_10_salmon_bucket_1");
        fishermanItems.put("tropical_fish_bucket", "fisherman_l4_emerald_1_tropical_fish_bucket_1");
        fishermanItems.put("pufferfish_bucket", "fisherman_l5_emerald_1_pufferfish_bucket_1");
        fishermanItems.put("axolotl_bucket", "fisherman_l5_emerald_1_axolotl_bucket_1");
        PROFESSION_ITEM_MAP.put("fisherman", fishermanItems);
    }

    private static void initializeFletcherMappings() {
        LinkedHashMap<String, String> fletcherItems = new LinkedHashMap<String, String>();
        fletcherItems.put("stick", "fletcher_l1_stick_32_emerald_1");
        fletcherItems.put("string", "fletcher_l1_string_1_emerald_1");
        fletcherItems.put("arrow", "fletcher_l2_emerald_2_arrow_16");
        fletcherItems.put("bow", "fletcher_l2_emerald_1_bow_1");
        fletcherItems.put("crossbow", "fletcher_l3_emerald_13_crossbow_1");
        fletcherItems.put("arrow", "fletcher_l3_emerald_2_arrow_16");
        fletcherItems.put("trident", "fletcher_l4_emerald_2_trident_1");
        fletcherItems.put("nautilus_shell", "fletcher_l5_emerald_2_nautilus_shell_1");
        fletcherItems.put("bow_power_4", "fletcher_l5_emerald_2_bow_power_4");
        fletcherItems.put("bow_punch_2", "fletcher_l5_emerald_2_bow_punch_2");
        fletcherItems.put("bow_flame_1", "fletcher_l5_emerald_2_bow_flame_1");
        fletcherItems.put("bow_infinity_1", "fletcher_l5_emerald_2_bow_infinity_1");
        fletcherItems.put("crossbow_quick_charge_3", "fletcher_l5_emerald_2_crossbow_quick_charge_3");
        fletcherItems.put("crossbow_multishot_1", "fletcher_l5_emerald_2_crossbow_multishot_1");
        fletcherItems.put("crossbow_piercing_4", "fletcher_l5_emerald_2_crossbow_piercing_4");
        fletcherItems.put("trident_loyalty_3", "fletcher_l5_emerald_2_trident_loyalty_3");
        fletcherItems.put("trident_impaling_5", "fletcher_l5_emerald_2_trident_impaling_5");
        fletcherItems.put("trident_channeling_1", "fletcher_l5_emerald_2_trident_channeling_1");
        fletcherItems.put("trident_riptide_3", "fletcher_l5_emerald_2_trident_riptide_3");
        PROFESSION_ITEM_MAP.put("fletcher", fletcherItems);
    }

    private static void initializeLeatherworkerMappings() {
        LinkedHashMap<String, String> leatherworkerItems = new LinkedHashMap<String, String>();
        leatherworkerItems.put("leather", "leatherworker_l1_leather_6_emerald_1");
        leatherworkerItems.put("leather_leggings", "leatherworker_l2_emerald_3_leather_leggings_1");
        leatherworkerItems.put("leather_chestplate", "leatherworker_l2_emerald_7_leather_chestplate_1");
        leatherworkerItems.put("saddle", "leatherworker_l3_emerald_8_saddle_1");
        leatherworkerItems.put("flint", "leatherworker_l3_flint_26_emerald_1");
        leatherworkerItems.put("leather_helmet", "leatherworker_l4_emerald_6_leather_helmet_1");
        leatherworkerItems.put("leather_boots", "leatherworker_l4_emerald_5_leather_boots_1");
        leatherworkerItems.put("leather_chestplate", "leatherworker_l5_emerald_7_leather_chestplate_1");
        leatherworkerItems.put("leather_leggings", "leatherworker_l5_emerald_4_leather_leggings_1");
        leatherworkerItems.put("leather_helmet_protection_4", "leatherworker_l5_emerald_7_leather_helmet_protection_4");
        leatherworkerItems.put("leather_helmet_fire_protection_4", "leatherworker_l5_emerald_7_leather_helmet_fire_protection_4");
        leatherworkerItems.put("leather_helmet_blast_protection_4", "leatherworker_l5_emerald_7_leather_helmet_blast_protection_4");
        leatherworkerItems.put("leather_helmet_projectile_protection_4", "leatherworker_l5_emerald_7_leather_helmet_projectile_protection_4");
        leatherworkerItems.put("leather_helmet_thorns_3", "leatherworker_l5_emerald_7_leather_helmet_thorns_3");
        leatherworkerItems.put("leather_chestplate_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_protection_4");
        leatherworkerItems.put("leather_chestplate_fire_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_fire_protection_4");
        leatherworkerItems.put("leather_chestplate_blast_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_blast_protection_4");
        leatherworkerItems.put("leather_chestplate_projectile_protection_4", "leatherworker_l5_emerald_7_leather_chestplate_projectile_protection_4");
        leatherworkerItems.put("leather_chestplate_thorns_3", "leatherworker_l5_emerald_7_leather_chestplate_thorns_3");
        leatherworkerItems.put("leather_leggings_protection_4", "leatherworker_l5_emerald_4_leather_leggings_protection_4");
        leatherworkerItems.put("leather_leggings_fire_protection_4", "leatherworker_l5_emerald_4_leather_leggings_fire_protection_4");
        leatherworkerItems.put("leather_leggings_blast_protection_4", "leatherworker_l5_emerald_4_leather_leggings_blast_protection_4");
        leatherworkerItems.put("leather_leggings_projectile_protection_4", "leatherworker_l5_emerald_4_leather_leggings_projectile_protection_4");
        leatherworkerItems.put("leather_leggings_thorns_3", "leatherworker_l5_emerald_4_leather_leggings_thorns_3");
        leatherworkerItems.put("leather_boots_protection_4", "leatherworker_l5_emerald_4_leather_boots_protection_4");
        leatherworkerItems.put("leather_boots_fire_protection_4", "leatherworker_l5_emerald_4_leather_boots_fire_protection_4");
        leatherworkerItems.put("leather_boots_blast_protection_4", "leatherworker_l5_emerald_4_leather_boots_blast_protection_4");
        leatherworkerItems.put("leather_boots_projectile_protection_4", "leatherworker_l5_emerald_4_leather_boots_projectile_protection_4");
        leatherworkerItems.put("leather_boots_feather_falling_4", "leatherworker_l5_emerald_4_leather_boots_feather_falling_4");
        leatherworkerItems.put("leather_boots_depth_strider_3", "leatherworker_l5_emerald_4_leather_boots_depth_strider_3");
        leatherworkerItems.put("leather_boots_frost_walker_2", "leatherworker_l5_emerald_4_leather_boots_frost_walker_2");
        leatherworkerItems.put("leather_boots_soul_speed_3", "leatherworker_l5_emerald_4_leather_boots_soul_speed_3");
        PROFESSION_ITEM_MAP.put("leatherworker", leatherworkerItems);
    }

    private static void initializeLibrarianMappings() {
        LinkedHashMap<String, String> librarianItems = new LinkedHashMap<String, String>();
        librarianItems.put("protection_1", "librarian_l1_enchanted_book_protection_1");
        librarianItems.put("sharpness_1", "librarian_l1_enchanted_book_sharpness_1");
        librarianItems.put("efficiency_1", "librarian_l1_enchanted_book_efficiency_1");
        librarianItems.put("unbreaking_1", "librarian_l1_enchanted_book_unbreaking_1");
        librarianItems.put("protection_2", "librarian_l2_enchanted_book_protection_2");
        librarianItems.put("sharpness_2", "librarian_l2_enchanted_book_sharpness_2");
        librarianItems.put("efficiency_2", "librarian_l2_enchanted_book_efficiency_2");
        librarianItems.put("unbreaking_2", "librarian_l2_enchanted_book_unbreaking_2");
        librarianItems.put("fortune_1", "librarian_l2_enchanted_book_fortune_1");
        librarianItems.put("looting_1", "librarian_l2_enchanted_book_looting_1");
        librarianItems.put("power_1", "librarian_l2_enchanted_book_power_1");
        librarianItems.put("punch_1", "librarian_l2_enchanted_book_punch_1");
        librarianItems.put("flame_1", "librarian_l2_enchanted_book_flame_1");
        librarianItems.put("infinity_1", "librarian_l2_enchanted_book_infinity_1");
        librarianItems.put("protection_3", "librarian_l3_enchanted_book_protection_3");
        librarianItems.put("sharpness_3", "librarian_l3_enchanted_book_sharpness_3");
        librarianItems.put("efficiency_3", "librarian_l3_enchanted_book_efficiency_3");
        librarianItems.put("unbreaking_3", "librarian_l3_enchanted_book_unbreaking_3");
        librarianItems.put("fortune_2", "librarian_l3_enchanted_book_fortune_2");
        librarianItems.put("looting_2", "librarian_l3_enchanted_book_looting_2");
        librarianItems.put("power_2", "librarian_l3_enchanted_book_power_2");
        librarianItems.put("thorns_1", "librarian_l3_enchanted_book_thorns_1");
        librarianItems.put("aqua_affinity_1", "librarian_l3_enchanted_book_aqua_affinity_1");
        librarianItems.put("respiration_1", "librarian_l3_enchanted_book_respiration_1");
        librarianItems.put("protection_4", "librarian_l4_enchanted_book_protection_4");
        librarianItems.put("sharpness_4", "librarian_l4_enchanted_book_sharpness_4");
        librarianItems.put("efficiency_4", "librarian_l4_enchanted_book_efficiency_4");
        librarianItems.put("unbreaking_4", "librarian_l4_enchanted_book_unbreaking_4");
        librarianItems.put("fortune_3", "librarian_l4_enchanted_book_fortune_3");
        librarianItems.put("looting_3", "librarian_l4_enchanted_book_looting_3");
        librarianItems.put("power_3", "librarian_l4_enchanted_book_power_3");
        librarianItems.put("thorns_2", "librarian_l4_enchanted_book_thorns_2");
        librarianItems.put("aqua_affinity_1", "librarian_l4_enchanted_book_aqua_affinity_1");
        librarianItems.put("respiration_2", "librarian_l4_enchanted_book_respiration_2");
        librarianItems.put("frost_walker_1", "librarian_l4_enchanted_book_frost_walker_1");
        librarianItems.put("mending_1", "librarian_l4_enchanted_book_mending_1");
        librarianItems.put("protection_5", "librarian_l5_enchanted_book_protection_5");
        librarianItems.put("sharpness_5", "librarian_l5_enchanted_book_sharpness_5");
        librarianItems.put("efficiency_5", "librarian_l5_enchanted_book_efficiency_5");
        librarianItems.put("unbreaking_5", "librarian_l5_enchanted_book_unbreaking_5");
        librarianItems.put("fortune_4", "librarian_l5_enchanted_book_fortune_4");
        librarianItems.put("looting_4", "librarian_l5_enchanted_book_looting_4");
        librarianItems.put("power_4", "librarian_l5_enchanted_book_power_4");
        librarianItems.put("thorns_3", "librarian_l5_enchanted_book_thorns_3");
        librarianItems.put("aqua_affinity_1", "librarian_l5_enchanted_book_aqua_affinity_1");
        librarianItems.put("respiration_3", "librarian_l5_enchanted_book_respiration_3");
        librarianItems.put("frost_walker_2", "librarian_l5_enchanted_book_frost_walker_2");
        librarianItems.put("mending_1", "librarian_l5_enchanted_book_mending_1");
        PROFESSION_ITEM_MAP.put("librarian", librarianItems);
    }

    private static void initializeMasonMappings() {
        LinkedHashMap<String, String> masonItems = new LinkedHashMap<String, String>();
        masonItems.put("clay_ball", "mason_l1_clay_ball_10_emerald_1");
        masonItems.put("stone", "mason_l1_stone_20_emerald_1");
        masonItems.put("bricks", "mason_l2_emerald_1_bricks_10");
        masonItems.put("stone_bricks", "mason_l2_emerald_1_stone_bricks_4");
        masonItems.put("chiseled_stone_bricks", "mason_l3_emerald_1_chiseled_stone_bricks_1");
        masonItems.put("stone_brick_stairs", "mason_l3_emerald_1_stone_brick_stairs_1");
        masonItems.put("stone_brick_slab", "mason_l3_emerald_1_stone_brick_slab_1");
        masonItems.put("quartz_pillar", "mason_l4_emerald_1_quartz_pillar_1");
        masonItems.put("quartz_block", "mason_l4_emerald_1_quartz_block_1");
        masonItems.put("gilded_blackstone", "mason_l5_emerald_1_gilded_blackstone_1");
        PROFESSION_ITEM_MAP.put("mason", masonItems);
    }

    private static void initializeShepherdMappings() {
        LinkedHashMap<String, String> shepherdItems = new LinkedHashMap<String, String>();
        shepherdItems.put("white_wool", "shepherd_l1_white_wool_18_emerald_1");
        shepherdItems.put("brown_wool", "shepherd_l1_brown_wool_18_emerald_1");
        shepherdItems.put("black_wool", "shepherd_l1_black_wool_18_emerald_1");
        shepherdItems.put("gray_wool", "shepherd_l1_gray_wool_18_emerald_1");
        shepherdItems.put("shears", "shepherd_l2_emerald_1_shears_1");
        shepherdItems.put("white_wool", "shepherd_l2_emerald_2_white_wool_1");
        shepherdItems.put("orange_wool", "shepherd_l2_emerald_2_orange_wool_1");
        shepherdItems.put("magenta_wool", "shepherd_l2_emerald_2_magenta_wool_1");
        shepherdItems.put("light_blue_wool", "shepherd_l2_emerald_2_light_blue_wool_1");
        shepherdItems.put("yellow_wool", "shepherd_l2_emerald_2_yellow_wool_1");
        shepherdItems.put("lime_wool", "shepherd_l2_emerald_2_lime_wool_1");
        shepherdItems.put("pink_wool", "shepherd_l2_emerald_2_pink_wool_1");
        shepherdItems.put("gray_wool", "shepherd_l2_emerald_2_gray_wool_1");
        shepherdItems.put("light_gray_wool", "shepherd_l2_emerald_2_light_gray_wool_1");
        shepherdItems.put("cyan_wool", "shepherd_l2_emerald_2_cyan_wool_1");
        shepherdItems.put("purple_wool", "shepherd_l2_emerald_2_purple_wool_1");
        shepherdItems.put("blue_wool", "shepherd_l2_emerald_2_blue_wool_1");
        shepherdItems.put("brown_wool", "shepherd_l2_emerald_2_brown_wool_1");
        shepherdItems.put("green_wool", "shepherd_l2_emerald_2_green_wool_1");
        shepherdItems.put("red_wool", "shepherd_l2_emerald_2_red_wool_1");
        shepherdItems.put("black_wool", "shepherd_l2_emerald_2_black_wool_1");
        shepherdItems.put("white_carpet", "shepherd_l3_emerald_3_white_carpet_1");
        shepherdItems.put("orange_carpet", "shepherd_l3_emerald_3_orange_carpet_1");
        shepherdItems.put("magenta_carpet", "shepherd_l3_emerald_3_magenta_carpet_1");
        shepherdItems.put("light_blue_carpet", "shepherd_l3_emerald_3_light_blue_carpet_1");
        shepherdItems.put("yellow_carpet", "shepherd_l3_emerald_3_yellow_carpet_1");
        shepherdItems.put("lime_carpet", "shepherd_l3_emerald_3_lime_carpet_1");
        shepherdItems.put("pink_carpet", "shepherd_l3_emerald_3_pink_carpet_1");
        shepherdItems.put("gray_carpet", "shepherd_l3_emerald_3_gray_carpet_1");
        shepherdItems.put("light_gray_carpet", "shepherd_l3_emerald_3_light_gray_carpet_1");
        shepherdItems.put("cyan_carpet", "shepherd_l3_emerald_3_cyan_carpet_1");
        shepherdItems.put("purple_carpet", "shepherd_l3_emerald_3_purple_carpet_1");
        shepherdItems.put("blue_carpet", "shepherd_l3_emerald_3_blue_carpet_1");
        shepherdItems.put("brown_carpet", "shepherd_l3_emerald_3_brown_carpet_1");
        shepherdItems.put("green_carpet", "shepherd_l3_emerald_3_green_carpet_1");
        shepherdItems.put("red_carpet", "shepherd_l3_emerald_3_red_carpet_1");
        shepherdItems.put("black_carpet", "shepherd_l3_emerald_3_black_carpet_1");
        shepherdItems.put("white_bed", "shepherd_l4_emerald_1_white_bed_1");
        shepherdItems.put("orange_bed", "shepherd_l4_emerald_1_orange_bed_1");
        shepherdItems.put("magenta_bed", "shepherd_l4_emerald_1_magenta_bed_1");
        shepherdItems.put("light_blue_bed", "shepherd_l4_emerald_1_light_blue_bed_1");
        shepherdItems.put("yellow_bed", "shepherd_l4_emerald_1_yellow_bed_1");
        shepherdItems.put("lime_bed", "shepherd_l4_emerald_1_lime_bed_1");
        shepherdItems.put("pink_bed", "shepherd_l4_emerald_1_pink_bed_1");
        shepherdItems.put("gray_bed", "shepherd_l4_emerald_1_gray_bed_1");
        shepherdItems.put("light_gray_bed", "shepherd_l4_emerald_1_light_gray_bed_1");
        shepherdItems.put("cyan_bed", "shepherd_l4_emerald_1_cyan_bed_1");
        shepherdItems.put("purple_bed", "shepherd_l4_emerald_1_purple_bed_1");
        shepherdItems.put("blue_bed", "shepherd_l4_emerald_1_blue_bed_1");
        shepherdItems.put("brown_bed", "shepherd_l4_emerald_1_brown_bed_1");
        shepherdItems.put("green_bed", "shepherd_l4_emerald_1_green_bed_1");
        shepherdItems.put("red_bed", "shepherd_l4_emerald_1_red_bed_1");
        shepherdItems.put("black_bed", "shepherd_l4_emerald_1_black_bed_1");
        shepherdItems.put("white_banner", "shepherd_l5_emerald_2_white_banner_1");
        shepherdItems.put("blue_banner", "shepherd_l5_emerald_2_blue_banner_1");
        shepherdItems.put("light_blue_banner", "shepherd_l5_emerald_2_light_blue_banner_1");
        shepherdItems.put("red_banner", "shepherd_l5_emerald_2_red_banner_1");
        shepherdItems.put("pink_banner", "shepherd_l5_emerald_2_pink_banner_1");
        shepherdItems.put("green_banner", "shepherd_l5_emerald_2_green_banner_1");
        shepherdItems.put("lime_banner", "shepherd_l5_emerald_2_lime_banner_1");
        shepherdItems.put("gray_banner", "shepherd_l5_emerald_2_gray_banner_1");
        shepherdItems.put("black_banner", "shepherd_l5_emerald_2_black_banner_1");
        shepherdItems.put("purple_banner", "shepherd_l5_emerald_2_purple_banner_1");
        shepherdItems.put("magenta_banner", "shepherd_l5_emerald_2_magenta_banner_1");
        shepherdItems.put("cyan_banner", "shepherd_l5_emerald_2_cyan_banner_1");
        shepherdItems.put("brown_banner", "shepherd_l5_emerald_2_brown_banner_1");
        shepherdItems.put("orange_banner", "shepherd_l5_emerald_2_orange_banner_1");
        shepherdItems.put("yellow_banner", "shepherd_l5_emerald_2_yellow_banner_1");
        PROFESSION_ITEM_MAP.put("shepherd", shepherdItems);
    }

    private static void initializeToolsmithMappings() {
        LinkedHashMap<String, String> toolsmithItems = new LinkedHashMap<String, String>();
        toolsmithItems.put("coal", "toolsmith_l1_coal_15_emerald_1");
        toolsmithItems.put("iron_ingot", "toolsmith_l1_iron_ingot_4_emerald_1");
        toolsmithItems.put("stone_pickaxe", "toolsmith_l2_emerald_1_stone_pickaxe_1");
        toolsmithItems.put("stone_shovel", "toolsmith_l2_emerald_1_stone_shovel_1");
        toolsmithItems.put("stone_axe", "toolsmith_l2_emerald_3_stone_axe_1");
        toolsmithItems.put("stone_hoe", "toolsmith_l2_emerald_1_stone_hoe_1");
        toolsmithItems.put("bell", "toolsmith_l3_emerald_30_bell_1");
        toolsmithItems.put("iron_shovel", "toolsmith_l3_emerald_1_iron_shovel_1");
        toolsmithItems.put("iron_pickaxe", "toolsmith_l3_emerald_2_iron_pickaxe_1");
        toolsmithItems.put("iron_axe", "toolsmith_l3_emerald_3_iron_axe_1");
        toolsmithItems.put("diamond_shovel", "toolsmith_l4_emerald_4_diamond_shovel_1");
        toolsmithItems.put("diamond_pickaxe", "toolsmith_l4_emerald_3_diamond_pickaxe_1");
        toolsmithItems.put("diamond_hoe", "toolsmith_l5_emerald_36_diamond_hoe_1");
        toolsmithItems.put("diamond_pickaxe_efficiency_4", "toolsmith_l5_emerald_36_diamond_pickaxe_efficiency_4");
        toolsmithItems.put("diamond_pickaxe_fortune_3", "toolsmith_l5_emerald_36_diamond_pickaxe_fortune_3");
        toolsmithItems.put("diamond_axe_efficiency_4", "toolsmith_l5_emerald_36_diamond_axe_efficiency_4");
        toolsmithItems.put("diamond_axe_sharpness_4", "toolsmith_l5_emerald_36_diamond_axe_sharpness_4");
        toolsmithItems.put("diamond_shovel_efficiency_4", "toolsmith_l5_emerald_36_diamond_shovel_efficiency_4");
        toolsmithItems.put("diamond_shovel_fortune_3", "toolsmith_l5_emerald_36_diamond_shovel_fortune_3");
        toolsmithItems.put("diamond_hoe_efficiency_4", "toolsmith_l5_emerald_36_diamond_hoe_efficiency_4");
        toolsmithItems.put("diamond_hoe_fortune_3", "toolsmith_l5_emerald_36_diamond_hoe_fortune_3");
        toolsmithItems.put("netherite_pickaxe", "toolsmith_l5_emerald_36_netherite_pickaxe_1");
        toolsmithItems.put("netherite_axe", "toolsmith_l5_emerald_36_netherite_axe_1");
        toolsmithItems.put("netherite_shovel", "toolsmith_l5_emerald_36_netherite_shovel_1");
        toolsmithItems.put("netherite_hoe", "toolsmith_l5_emerald_36_netherite_hoe_1");
        PROFESSION_ITEM_MAP.put("toolsmith", toolsmithItems);
    }

    private static void initializeWeaponsmithMappings() {
        LinkedHashMap<String, String> weaponsmithItems = new LinkedHashMap<String, String>();
        weaponsmithItems.put("coal", "weaponsmith_l1_coal_15_emerald_1");
        weaponsmithItems.put("iron_ingot", "weaponsmith_l1_iron_ingot_4_emerald_1");
        weaponsmithItems.put("iron_sword", "weaponsmith_l2_emerald_3_iron_sword_1");
        weaponsmithItems.put("iron_axe", "weaponsmith_l2_emerald_1_iron_axe_1");
        weaponsmithItems.put("flint_and_steel", "weaponsmith_l3_emerald_1_flint_and_steel_1");
        weaponsmithItems.put("diamond_sword", "weaponsmith_l3_emerald_5_diamond_sword_1");
        weaponsmithItems.put("diamond_axe", "weaponsmith_l3_emerald_2_diamond_axe_1");
        weaponsmithItems.put("diamond_sword", "weaponsmith_l4_emerald_2_diamond_sword_1");
        weaponsmithItems.put("netherite_sword", "weaponsmith_l5_emerald_13_netherite_sword_1");
        weaponsmithItems.put("diamond_sword_sharpness_4", "weaponsmith_l5_emerald_13_diamond_sword_sharpness_4");
        weaponsmithItems.put("diamond_sword_looting_3", "weaponsmith_l5_emerald_13_diamond_sword_looting_3");
        weaponsmithItems.put("diamond_sword_fire_aspect_2", "weaponsmith_l5_emerald_13_diamond_sword_fire_aspect_2");
        weaponsmithItems.put("diamond_sword_knockback_2", "weaponsmith_l5_emerald_13_diamond_sword_knockback_2");
        weaponsmithItems.put("diamond_sword_sweeping_edge_3", "weaponsmith_l5_emerald_13_diamond_sword_sweeping_edge_3");
        weaponsmithItems.put("diamond_axe_sharpness_4", "weaponsmith_l5_emerald_13_diamond_axe_sharpness_4");
        weaponsmithItems.put("diamond_axe_efficiency_4", "weaponsmith_l5_emerald_13_diamond_axe_efficiency_4");
        weaponsmithItems.put("diamond_axe_fortune_3", "weaponsmith_l5_emerald_13_diamond_axe_fortune_3");
        weaponsmithItems.put("netherite_sword", "weaponsmith_l5_emerald_13_netherite_sword_1");
        weaponsmithItems.put("netherite_axe", "weaponsmith_l5_emerald_13_netherite_axe_1");
        PROFESSION_ITEM_MAP.put("weaponsmith", weaponsmithItems);
    }

    private static void buildReverseMappings() {
        for (Map.Entry<String, Map<String, String>> professionEntry : PROFESSION_ITEM_MAP.entrySet()) {
            String profession = professionEntry.getKey();
            Map<String, String> itemMap = professionEntry.getValue();
            HashMap<String, String> reverseMap = new HashMap<String, String>();
            for (Map.Entry<String, String> itemEntry : itemMap.entrySet()) {
                reverseMap.put(itemEntry.getValue(), itemEntry.getKey());
            }
            REVERSE_MAP.put(profession, reverseMap);
        }
    }

    public static String getTechnicalId(String profession, String simpleName) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null ? professionMap.get(simpleName.toLowerCase()) : null;
    }

    public static String getSimpleName(String profession, String technicalId) {
        Map<String, String> reverseMap = REVERSE_MAP.get(profession.toLowerCase());
        return reverseMap != null ? reverseMap.get(technicalId) : null;
    }

    public static Set<String> getSimpleNames(String profession) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null ? professionMap.keySet() : Collections.emptySet();
    }

    public static Set<String> getAllProfessions() {
        return PROFESSION_ITEM_MAP.keySet();
    }

    public static boolean hasProfession(String profession) {
        return PROFESSION_ITEM_MAP.containsKey(profession.toLowerCase());
    }

    public static boolean hasSimpleName(String profession, String simpleName) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null && professionMap.containsKey(simpleName.toLowerCase());
    }

    public static Collection<String> getTechnicalIds(String profession) {
        Map<String, String> professionMap = PROFESSION_ITEM_MAP.get(profession.toLowerCase());
        return professionMap != null ? professionMap.values() : Collections.emptyList();
    }

    static {
        SimpleTradeMapper.initializeMappings();
    }
}

