/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.services.DynamicTradeDetector;
import com.alan.VillagerTradeManager.services.DynamicTradeStorageService;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.util.StringUtil;

public class TradeCompletionService {
    private final VillagerTradeManager plugin;
    private final TradeRegistry tradeRegistry;
    private final SimpleTradeMapper simpleTradeMapper;
    private final DynamicTradeStorageService dynamicTradeStorage;
    private volatile Map<String, Set<String>> professionSimpleNames = new HashMap<String, Set<String>>();
    private volatile Map<String, Set<String>> professionTradeIds = new HashMap<String, Set<String>>();
    private volatile long lastCacheUpdate = 0L;
    private static final long CACHE_TIMEOUT_MS = 300000L;

    public TradeCompletionService(VillagerTradeManager plugin, TradeRegistry tradeRegistry, SimpleTradeMapper simpleTradeMapper, DynamicTradeStorageService dynamicTradeStorage) {
        this.plugin = plugin;
        this.tradeRegistry = tradeRegistry;
        this.simpleTradeMapper = simpleTradeMapper;
        this.dynamicTradeStorage = dynamicTradeStorage;
    }

    public Set<String> getAllProfessions() {
        HashSet<String> professions = new HashSet<String>();
        TradeCompletionService tradeCompletionService = this;
        professions.addAll(tradeCompletionService.tradeRegistry.getAllProfessions());
        try {
            ((CompletableFuture)this.dynamicTradeStorage.getTradeStatistics().thenAccept(stats -> stats.keySet().stream().filter(key -> !key.equals("total")).forEach(professions::add))).get();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load dynamic professions for completion: " + e.getMessage());
        }
        return professions;
    }

    public List<String> getProfessionCompletions(String input) {
        Set<String> professions = this.getAllProfessions();
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)input, professions, completions);
        Collections.sort(completions);
        return completions;
    }

    public List<String> getTradeCompletions(String profession, String input) {
        Set<String> tradeIds;
        this.ensureCacheFresh();
        HashSet<String> allTrades = new HashSet<String>();
        Set<String> simpleNames = this.professionSimpleNames.get(profession.toLowerCase());
        if (simpleNames != null) {
            allTrades.addAll(simpleNames);
        }
        if ((tradeIds = this.professionTradeIds.get(profession.toLowerCase())) != null) {
            allTrades.addAll(tradeIds);
        }
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)input, allTrades, completions);
        Collections.sort(completions);
        return completions;
    }

    public List<String> getEmeraldCostCompletions(String input) {
        List<String> commonCosts = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "64");
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)input, commonCosts, completions);
        Collections.sort(completions);
        return completions;
    }

    public CompletableFuture<Void> refreshCache() {
        return CompletableFuture.runAsync(() -> {
            try {
                HashMap<String, HashSet<String>> newSimpleNames = new HashMap<String, HashSet<String>>();
                HashMap<String, HashSet<String>> newTradeIds = new HashMap<String, HashSet<String>>();
                TradeCompletionService tradeCompletionService = this;
                for (String profession : tradeCompletionService.tradeRegistry.getAllProfessions()) {
                    List<String> tradeIds;
                    Set<String> simpleNames = SimpleTradeMapper.getSimpleNames(profession);
                    if (!simpleNames.isEmpty()) {
                        newSimpleNames.put(profession.toLowerCase(), new HashSet<String>(simpleNames));
                    }
                    if ((tradeIds = TradeRegistry.getTradesForProfession(profession)).isEmpty()) continue;
                    newTradeIds.put(profession.toLowerCase(), new HashSet<String>(tradeIds));
                }
                ((CompletableFuture)this.dynamicTradeStorage.loadAllDynamicTrades().thenAccept(dynamicTrades -> {
                    for (DynamicTradeDetector.DetectedTrade trade : dynamicTrades.values()) {
                        String prof = trade.getProfession().toLowerCase();
                        newSimpleNames.computeIfAbsent(prof, k -> new HashSet()).add(trade.getSimpleName());
                        newTradeIds.computeIfAbsent(prof, k -> new HashSet()).add(trade.getTradeId());
                    }
                    this.professionSimpleNames = newSimpleNames;
                    this.professionTradeIds = newTradeIds;
                    this.lastCacheUpdate = System.currentTimeMillis();
                    this.plugin.getLogger().fine("Refreshed trade completion cache with " + dynamicTrades.size() + " dynamic trades");
                })).get();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to refresh trade completion cache: " + e.getMessage());
            }
        });
    }

    private void ensureCacheFresh() {
        if (System.currentTimeMillis() - this.lastCacheUpdate > 300000L) {
            try {
                this.refreshCache().get();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to refresh completion cache: " + e.getMessage());
            }
        }
    }

    public Map<String, Integer> getCacheStatistics() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("professions", this.professionSimpleNames.size());
        stats.put("total_simple_names", this.professionSimpleNames.values().stream().mapToInt(Set::size).sum());
        stats.put("total_trade_ids", this.professionTradeIds.values().stream().mapToInt(Set::size).sum());
        stats.put("cache_age_seconds", (int)((System.currentTimeMillis() - this.lastCacheUpdate) / 1000L));
        return stats;
    }

    public boolean professionHasTrades(String profession) {
        this.ensureCacheFresh();
        String prof = profession.toLowerCase();
        return this.professionSimpleNames.containsKey(prof) && !this.professionSimpleNames.get(prof).isEmpty() || this.professionTradeIds.containsKey(prof) && !this.professionTradeIds.get(prof).isEmpty();
    }

    public String getProfessionTradeSummary(String profession) {
        this.ensureCacheFresh();
        String prof = profession.toLowerCase();
        int simpleNames = this.professionSimpleNames.getOrDefault(prof, Collections.emptySet()).size();
        int tradeIds = this.professionTradeIds.getOrDefault(prof, Collections.emptySet()).size();
        return String.format("%s: %d simple names, %d trade IDs", profession, simpleNames, tradeIds);
    }

    public void forceCacheRefresh() {
        this.lastCacheUpdate = 0L;
    }
}

