/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public class TradeRegistry {
    private static final Map<String, TradeDefinition> TRADE_REGISTRY = new HashMap<String, TradeDefinition>();
    private static final Map<String, List<String>> PROFESSION_TRADES = new HashMap<String, List<String>>();
    public static final String ARMORER = "armorer";
    public static final String BUTCHER = "butcher";
    public static final String CARTOGRAPHER = "cartographer";
    public static final String CLERIC = "cleric";
    public static final String FARMER = "farmer";
    public static final String FISHERMAN = "fisherman";
    public static final String FLETCHER = "fletcher";
    public static final String LEATHERWORKER = "leatherworker";
    public static final String LIBRARIAN = "librarian";
    public static final String MASON = "mason";
    public static final String SHEPHERD = "shepherd";
    public static final String TOOLSMITH = "toolsmith";
    public static final String WEAPONSMITH = "weaponsmith";

    private static void initializeTradeRegistry() {
        TradeRegistry.registerArmorTrades();
        TradeRegistry.registerButcherTrades();
        TradeRegistry.registerCartographerTrades();
        TradeRegistry.registerClericTrades();
        TradeRegistry.registerFarmerTrades();
        TradeRegistry.registerFishermanTrades();
        TradeRegistry.registerFletcherTrades();
        TradeRegistry.registerLeatherworkerTrades();
        TradeRegistry.registerLibrarianTrades();
        TradeRegistry.registerMasonTrades();
        TradeRegistry.registerShepherdTrades();
        TradeRegistry.registerToolsmithTrades();
        TradeRegistry.registerWeaponsmithTrades();
    }

    private static void registerArmorTrades() {
        ArrayList<String> armorerTrades = new ArrayList<String>();
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 1, Material.COAL, 15, Material.EMERALD, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 1, Material.IRON_INGOT, 5, Material.EMERALD, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 1, Material.LAPIS_LAZULI, 1, Material.EMERALD, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 2, Material.EMERALD, 4, Material.IRON_BOOTS, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 2, Material.EMERALD, 5, Material.IRON_HELMET, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 2, Material.EMERALD, 4, Material.IRON_LEGGINGS, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 2, Material.EMERALD, 7, Material.IRON_CHESTPLATE, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 3, Material.EMERALD, 1, Material.BELL, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 3, Material.EMERALD, 5, Material.CHAINMAIL_HELMET, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 3, Material.EMERALD, 4, Material.CHAINMAIL_CHESTPLATE, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 4, Material.EMERALD, 1, Material.SHIELD, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 4, Material.EMERALD, 3, Material.CHAINMAIL_LEGGINGS, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 4, Material.EMERALD, 1, Material.CHAINMAIL_BOOTS, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 5, Material.EMERALD, 30, Material.DIAMOND_LEGGINGS, 1));
        armorerTrades.add(TradeRegistry.registerTrade(ARMORER, 5, Material.EMERALD, 13, Material.DIAMOND_BOOTS, 1));
        PROFESSION_TRADES.put(ARMORER, armorerTrades);
    }

    private static void registerButcherTrades() {
        ArrayList<String> butcherTrades = new ArrayList<String>();
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 1, Material.CHICKEN, 14, Material.EMERALD, 1));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 1, Material.PORKCHOP, 7, Material.EMERALD, 1));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 1, Material.RABBIT, 4, Material.EMERALD, 1));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 1, Material.COAL, 15, Material.EMERALD, 1));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 2, Material.EMERALD, 1, Material.COOKED_CHICKEN, 8));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 2, Material.EMERALD, 1, Material.COOKED_PORKCHOP, 5));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 2, Material.EMERALD, 2, Material.COOKED_RABBIT, 1));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 3, Material.COAL, 15, Material.EMERALD, 1));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 3, Material.EMERALD, 1, Material.RABBIT_STEW, 1));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 4, Material.EMERALD, 1, Material.COOKED_BEEF, 6));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 4, Material.EMERALD, 1, Material.COOKED_MUTTON, 6));
        butcherTrades.add(TradeRegistry.registerTrade(BUTCHER, 5, Material.NETHER_WART, 1, Material.EMERALD, 1));
        PROFESSION_TRADES.put(BUTCHER, butcherTrades);
    }

    private static void registerCartographerTrades() {
        ArrayList<String> cartographerTrades = new ArrayList<String>();
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 1, Material.PAPER, 24, Material.EMERALD, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 1, Material.COMPASS, 1, Material.EMERALD, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 2, Material.EMERALD, 7, Material.MAP, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 2, Material.EMERALD, 1, Material.FILLED_MAP, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 3, Material.EMERALD, 1, Material.FILLED_MAP, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 3, Material.EMERALD, 1, Material.FILLED_MAP, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 4, Material.EMERALD, 14, Material.ITEM_FRAME, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.WHITE_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.BLUE_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.LIGHT_BLUE_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.RED_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.PINK_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.GREEN_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.LIME_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.GRAY_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.BLACK_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.PURPLE_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.MAGENTA_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.CYAN_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.BROWN_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.ORANGE_BANNER, 1));
        cartographerTrades.add(TradeRegistry.registerTrade(CARTOGRAPHER, 5, Material.EMERALD, 8, Material.YELLOW_BANNER, 1));
        PROFESSION_TRADES.put(CARTOGRAPHER, cartographerTrades);
    }

    private static void registerClericTrades() {
        ArrayList<String> clericTrades = new ArrayList<String>();
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 1, Material.ROTTEN_FLESH, 32, Material.EMERALD, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 1, Material.GOLD_INGOT, 3, Material.EMERALD, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 2, Material.EMERALD, 2, Material.REDSTONE, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 2, Material.EMERALD, 1, Material.LAPIS_LAZULI, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 3, Material.EMERALD, 4, Material.GLOWSTONE, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 3, Material.EMERALD, 1, Material.ENDER_PEARL, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 4, Material.EMERALD, 5, Material.EXPERIENCE_BOTTLE, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 4, Material.EMERALD, 1, Material.NETHER_WART, 1));
        clericTrades.add(TradeRegistry.registerTrade(CLERIC, 5, Material.EMERALD, 20, Material.BLAZE_ROD, 1));
        PROFESSION_TRADES.put(CLERIC, clericTrades);
    }

    private static void registerFarmerTrades() {
        ArrayList<String> farmerTrades = new ArrayList<String>();
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 1, Material.WHEAT, 20, Material.EMERALD, 1));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 1, Material.POTATO, 26, Material.EMERALD, 1));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 1, Material.CARROT, 22, Material.EMERALD, 1));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 1, Material.BEETROOT, 15, Material.EMERALD, 1));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 2, Material.EMERALD, 1, Material.BREAD, 6));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 2, Material.EMERALD, 1, Material.PUMPKIN, 6));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 2, Material.EMERALD, 1, Material.MELON, 4));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 3, Material.EMERALD, 1, Material.APPLE, 4));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 3, Material.EMERALD, 1, Material.COOKIE, 18));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 4, Material.EMERALD, 3, Material.CAKE, 1));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 4, Material.EMERALD, 1, Material.GOLDEN_CARROT, 3));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 4, Material.EMERALD, 1, Material.GLISTERING_MELON_SLICE, 3));
        farmerTrades.add(TradeRegistry.registerTrade(FARMER, 5, Material.EMERALD, 1, Material.SUSPICIOUS_STEW, 1));
        PROFESSION_TRADES.put(FARMER, farmerTrades);
    }

    private static void registerFishermanTrades() {
        ArrayList<String> fishermanTrades = new ArrayList<String>();
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 1, Material.STRING, 20, Material.EMERALD, 1));
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 1, Material.COAL, 10, Material.EMERALD, 1));
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 2, Material.EMERALD, 6, Material.CAMPFIRE, 1));
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 2, Material.EMERALD, 1, Material.FISHING_ROD, 1));
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 3, Material.EMERALD, 20, Material.COD_BUCKET, 1));
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 3, Material.EMERALD, 10, Material.SALMON_BUCKET, 1));
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 4, Material.EMERALD, 1, Material.TROPICAL_FISH_BUCKET, 1));
        fishermanTrades.add(TradeRegistry.registerTrade(FISHERMAN, 5, Material.EMERALD, 1, Material.PUFFERFISH_BUCKET, 1));
        PROFESSION_TRADES.put(FISHERMAN, fishermanTrades);
    }

    private static void registerFletcherTrades() {
        ArrayList<String> fletcherTrades = new ArrayList<String>();
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 1, Material.STICK, 32, Material.EMERALD, 1));
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 1, Material.STRING, 1, Material.EMERALD, 1));
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 2, Material.EMERALD, 2, Material.ARROW, 16));
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 2, Material.EMERALD, 1, Material.BOW, 1));
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 3, Material.EMERALD, 13, Material.CROSSBOW, 1));
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 3, Material.EMERALD, 2, Material.ARROW, 16));
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 4, Material.EMERALD, 2, Material.TRIDENT, 1));
        fletcherTrades.add(TradeRegistry.registerTrade(FLETCHER, 5, Material.EMERALD, 2, Material.NAUTILUS_SHELL, 1));
        PROFESSION_TRADES.put(FLETCHER, fletcherTrades);
    }

    private static void registerLeatherworkerTrades() {
        ArrayList<String> leatherworkerTrades = new ArrayList<String>();
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 1, Material.LEATHER, 6, Material.EMERALD, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 2, Material.EMERALD, 3, Material.LEATHER_LEGGINGS, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 2, Material.EMERALD, 7, Material.LEATHER_CHESTPLATE, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 3, Material.EMERALD, 8, Material.SADDLE, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 3, Material.FLINT, 26, Material.EMERALD, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 4, Material.EMERALD, 6, Material.LEATHER_HELMET, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 4, Material.EMERALD, 5, Material.LEATHER_BOOTS, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 5, Material.EMERALD, 7, Material.LEATHER_CHESTPLATE, 1));
        leatherworkerTrades.add(TradeRegistry.registerTrade(LEATHERWORKER, 5, Material.EMERALD, 4, Material.LEATHER_LEGGINGS, 1));
        PROFESSION_TRADES.put(LEATHERWORKER, leatherworkerTrades);
    }

    private static void registerLibrarianTrades() {
        ArrayList<String> librarianTrades = new ArrayList<String>();
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 1, Enchantment.PROTECTION, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 1, Enchantment.SHARPNESS, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 1, Enchantment.EFFICIENCY, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 1, Enchantment.UNBREAKING, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.PROTECTION, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.SHARPNESS, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.EFFICIENCY, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.UNBREAKING, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.FORTUNE, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.LOOTING, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.POWER, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.PUNCH, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.FLAME, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 2, Enchantment.INFINITY, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.PROTECTION, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.SHARPNESS, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.EFFICIENCY, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.UNBREAKING, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.FORTUNE, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.LOOTING, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.POWER, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.THORNS, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.AQUA_AFFINITY, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 3, Enchantment.RESPIRATION, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.PROTECTION, 4));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.SHARPNESS, 4));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.EFFICIENCY, 4));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.UNBREAKING, 4));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.FORTUNE, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.LOOTING, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.POWER, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.THORNS, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.AQUA_AFFINITY, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.RESPIRATION, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.FROST_WALKER, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 4, Enchantment.MENDING, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.PROTECTION, 5));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.SHARPNESS, 5));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.EFFICIENCY, 5));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.UNBREAKING, 5));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.FORTUNE, 4));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.LOOTING, 4));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.POWER, 4));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.THORNS, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.AQUA_AFFINITY, 1));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.RESPIRATION, 3));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.FROST_WALKER, 2));
        librarianTrades.add(TradeRegistry.registerEnchantedBookTrade(LIBRARIAN, 5, Enchantment.MENDING, 1));
        PROFESSION_TRADES.put(LIBRARIAN, librarianTrades);
    }

    private static void registerMasonTrades() {
        ArrayList<String> masonTrades = new ArrayList<String>();
        masonTrades.add(TradeRegistry.registerTrade(MASON, 1, Material.CLAY_BALL, 10, Material.EMERALD, 1));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 1, Material.STONE, 20, Material.EMERALD, 1));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 2, Material.EMERALD, 1, Material.BRICKS, 10));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 2, Material.EMERALD, 1, Material.STONE_BRICKS, 4));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 3, Material.EMERALD, 1, Material.STONE_BRICKS, 1));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 3, Material.EMERALD, 1, Material.STONE_BRICKS, 1));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 3, Material.EMERALD, 1, Material.STONE_BRICKS, 1));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 4, Material.EMERALD, 1, Material.QUARTZ_PILLAR, 1));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 4, Material.EMERALD, 1, Material.QUARTZ_BLOCK, 1));
        masonTrades.add(TradeRegistry.registerTrade(MASON, 5, Material.EMERALD, 1, Material.GILDED_BLACKSTONE, 1));
        PROFESSION_TRADES.put(MASON, masonTrades);
    }

    private static void registerShepherdTrades() {
        ArrayList<String> shepherdTrades = new ArrayList<String>();
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 1, Material.WHITE_WOOL, 18, Material.EMERALD, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 1, Material.BROWN_WOOL, 18, Material.EMERALD, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 1, Material.BLACK_WOOL, 18, Material.EMERALD, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 1, Material.GRAY_WOOL, 18, Material.EMERALD, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 1, Material.SHEARS, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.WHITE_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.ORANGE_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.MAGENTA_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.LIGHT_BLUE_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.YELLOW_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.LIME_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.PINK_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.GRAY_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.LIGHT_GRAY_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.CYAN_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.PURPLE_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.BLUE_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.BROWN_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.GREEN_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.RED_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 2, Material.EMERALD, 2, Material.BLACK_WOOL, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.WHITE_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.ORANGE_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.MAGENTA_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.LIGHT_BLUE_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.YELLOW_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.LIME_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.PINK_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.GRAY_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.LIGHT_GRAY_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.CYAN_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.PURPLE_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.BLUE_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.BROWN_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.GREEN_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.RED_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 3, Material.EMERALD, 3, Material.BLACK_CARPET, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.WHITE_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.ORANGE_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.MAGENTA_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.LIGHT_BLUE_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.YELLOW_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.LIME_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.PINK_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.GRAY_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.LIGHT_GRAY_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.CYAN_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.PURPLE_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.BLUE_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.BROWN_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.GREEN_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.RED_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 4, Material.EMERALD, 1, Material.BLACK_BED, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.WHITE_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.BLUE_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.LIGHT_BLUE_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.RED_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.PINK_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.GREEN_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.LIME_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.GRAY_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.BLACK_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.PURPLE_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.MAGENTA_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.CYAN_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.BROWN_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.ORANGE_BANNER, 1));
        shepherdTrades.add(TradeRegistry.registerTrade(SHEPHERD, 5, Material.EMERALD, 2, Material.YELLOW_BANNER, 1));
        PROFESSION_TRADES.put(SHEPHERD, shepherdTrades);
    }

    private static void registerToolsmithTrades() {
        ArrayList<String> toolsmithTrades = new ArrayList<String>();
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 1, Material.COAL, 15, Material.EMERALD, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 1, Material.IRON_INGOT, 4, Material.EMERALD, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 2, Material.EMERALD, 1, Material.STONE_PICKAXE, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 2, Material.EMERALD, 1, Material.STONE_SHOVEL, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 2, Material.EMERALD, 3, Material.STONE_AXE, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 2, Material.EMERALD, 1, Material.STONE_HOE, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 3, Material.EMERALD, 30, Material.BELL, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 3, Material.EMERALD, 1, Material.IRON_SHOVEL, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 3, Material.EMERALD, 2, Material.IRON_PICKAXE, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 3, Material.EMERALD, 3, Material.IRON_AXE, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 4, Material.EMERALD, 4, Material.DIAMOND_SHOVEL, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 4, Material.EMERALD, 3, Material.DIAMOND_PICKAXE, 1));
        toolsmithTrades.add(TradeRegistry.registerTrade(TOOLSMITH, 5, Material.EMERALD, 36, Material.DIAMOND_HOE, 1));
        PROFESSION_TRADES.put(TOOLSMITH, toolsmithTrades);
    }

    private static void registerWeaponsmithTrades() {
        ArrayList<String> weaponsmithTrades = new ArrayList<String>();
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 1, Material.COAL, 15, Material.EMERALD, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 1, Material.IRON_INGOT, 4, Material.EMERALD, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 2, Material.EMERALD, 3, Material.IRON_SWORD, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 2, Material.EMERALD, 1, Material.IRON_AXE, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 3, Material.EMERALD, 1, Material.FLINT_AND_STEEL, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 3, Material.EMERALD, 5, Material.DIAMOND_SWORD, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 3, Material.EMERALD, 2, Material.DIAMOND_AXE, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 4, Material.EMERALD, 2, Material.DIAMOND_SWORD, 1));
        weaponsmithTrades.add(TradeRegistry.registerTrade(WEAPONSMITH, 5, Material.EMERALD, 13, Material.NETHERITE_SWORD, 1));
        PROFESSION_TRADES.put(WEAPONSMITH, weaponsmithTrades);
    }

    private static String registerTrade(String profession, int level, Material input, int inputAmount, Material output, int outputAmount) {
        String tradeId = TradeRegistry.generateTradeId(profession, level, input, inputAmount, output, outputAmount);
        TradeDefinition definition = new TradeDefinition(profession, level, input, inputAmount, output, outputAmount);
        TRADE_REGISTRY.put(tradeId, definition);
        return tradeId;
    }

    private static String registerEnchantedBookTrade(String profession, int level, Enchantment enchantment, int enchantmentLevel) {
        String tradeId = TradeRegistry.generateEnchantedBookTradeId(profession, level, enchantment, enchantmentLevel);
        TradeDefinition definition = new TradeDefinition(profession, level, enchantment, enchantmentLevel);
        TRADE_REGISTRY.put(tradeId, definition);
        return tradeId;
    }

    private static String generateTradeId(String profession, int level, Material input, int inputAmount, Material output, int outputAmount) {
        return String.format("%s_l%d_%s_%d_%s_%d", profession, level, input.name().toLowerCase(), inputAmount, output.name().toLowerCase(), outputAmount);
    }

    private static String generateEnchantedBookTradeId(String profession, int level, Enchantment enchantment, int enchantmentLevel) {
        return String.format("%s_l%d_enchanted_book_%s_%d", profession, level, enchantment.getKey().getKey().toLowerCase(), enchantmentLevel);
    }

    public static Set<String> getAllProfessions() {
        return PROFESSION_TRADES.keySet();
    }

    public static List<String> getTradesForProfession(String profession) {
        return PROFESSION_TRADES.getOrDefault(profession, Collections.emptyList());
    }

    public static TradeDefinition getTradeDefinition(String tradeId) {
        return TRADE_REGISTRY.get(tradeId);
    }

    public static String identifyTrade(String profession, ItemStack result, List<ItemStack> ingredients) {
        String contentHash = TradeRegistry.generateContentHash(result, ingredients);
        List<String> professionTrades = TradeRegistry.getTradesForProfession(profession);
        for (String tradeId : professionTrades) {
            TradeDefinition definition = TradeRegistry.getTradeDefinition(tradeId);
            if (definition == null || !definition.matchesContent(result, ingredients)) continue;
            return tradeId;
        }
        return null;
    }

    private static String generateContentHash(ItemStack result, List<ItemStack> ingredients) {
        EnchantmentStorageMeta meta;
        StringBuilder hash = new StringBuilder();
        hash.append(result.getType().name()).append(":").append(result.getAmount());
        if (result.getType() == Material.ENCHANTED_BOOK && result.hasItemMeta() && (meta = (EnchantmentStorageMeta)result.getItemMeta()).hasStoredEnchants()) {
            meta.getStoredEnchants().forEach((ench, level) -> hash.append("_").append(ench.getKey().getKey()).append(":").append(level));
        }
        hash.append("|");
        for (ItemStack ingredient : ingredients) {
            hash.append(ingredient.getType().name()).append(":").append(ingredient.getAmount()).append(",");
        }
        return hash.toString();
    }

    public static String getTradeDescription(String tradeId) {
        TradeDefinition definition = TradeRegistry.getTradeDefinition(tradeId);
        if (definition == null) {
            return "Unknown trade";
        }
        return definition.getDescription();
    }

    public static Set<String> getAllTradeIds() {
        return TRADE_REGISTRY.keySet();
    }

    public static boolean isValidProfession(String profession) {
        return PROFESSION_TRADES.containsKey(profession);
    }

    public static String getProfessionDisplayName(String profession) {
        switch (profession.toLowerCase()) {
            case "armorer": {
                return "Armorer";
            }
            case "butcher": {
                return "Butcher";
            }
            case "cartographer": {
                return "Cartographer";
            }
            case "cleric": {
                return "Cleric";
            }
            case "farmer": {
                return "Farmer";
            }
            case "fisherman": {
                return "Fisherman";
            }
            case "fletcher": {
                return "Fletcher";
            }
            case "leatherworker": {
                return "Leatherworker";
            }
            case "librarian": {
                return "Librarian";
            }
            case "mason": {
                return "Mason";
            }
            case "shepherd": {
                return "Shepherd";
            }
            case "toolsmith": {
                return "Toolsmith";
            }
            case "weaponsmith": {
                return "Weaponsmith";
            }
        }
        return profession;
    }

    static {
        TradeRegistry.initializeTradeRegistry();
    }

    public static class TradeDefinition {
        private final String profession;
        private final int level;
        private final boolean isEnchantedBook;
        private final Material inputMaterial;
        private final int inputAmount;
        private final Material outputMaterial;
        private final int outputAmount;
        private final Enchantment enchantment;
        private final int enchantmentLevel;

        public TradeDefinition(String profession, int level, Material input, int inputAmount, Material output, int outputAmount) {
            this.profession = profession;
            this.level = level;
            this.isEnchantedBook = false;
            this.inputMaterial = input;
            this.inputAmount = inputAmount;
            this.outputMaterial = output;
            this.outputAmount = outputAmount;
            this.enchantment = null;
            this.enchantmentLevel = 0;
        }

        public TradeDefinition(String profession, int level, Enchantment enchantment, int enchantmentLevel) {
            this.profession = profession;
            this.level = level;
            this.isEnchantedBook = true;
            this.inputMaterial = Material.BOOK;
            this.inputAmount = 1;
            this.outputMaterial = Material.ENCHANTED_BOOK;
            this.outputAmount = 1;
            this.enchantment = enchantment;
            this.enchantmentLevel = enchantmentLevel;
        }

        public boolean matchesContent(ItemStack result, List<ItemStack> ingredients) {
            if (this.isEnchantedBook) {
                if (result.getType() != Material.ENCHANTED_BOOK) {
                    return false;
                }
                if (!result.hasItemMeta()) {
                    return false;
                }
                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)result.getItemMeta();
                if (!meta.hasStoredEnchants()) {
                    return false;
                }
                return meta.getStoredEnchants().containsKey(this.enchantment) && meta.getStoredEnchantLevel(this.enchantment) == this.enchantmentLevel;
            }
            if (result.getType() != this.outputMaterial || result.getAmount() != this.outputAmount) {
                return false;
            }
            if (ingredients.size() != 2) {
                return false;
            }
            ItemStack firstIngredient = ingredients.get(0);
            if (firstIngredient.getType() != this.inputMaterial || firstIngredient.getAmount() != this.inputAmount) {
                return false;
            }
            ItemStack secondIngredient = ingredients.get(1);
            return secondIngredient.getType() == Material.EMERALD;
        }

        public String getDescription() {
            if (this.isEnchantedBook) {
                return String.format("%s %d (Enchanted Book)", this.enchantment.getKey().getKey().replace("_", " "), this.enchantmentLevel);
            }
            return String.format("%d %s \u2192 %d %s", this.inputAmount, this.inputMaterial.name().toLowerCase().replace("_", " "), this.outputAmount, this.outputMaterial.name().toLowerCase().replace("_", " "));
        }

        public String getProfession() {
            return this.profession;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isEnchantedBook() {
            return this.isEnchantedBook;
        }

        public Material getInputMaterial() {
            return this.inputMaterial;
        }

        public int getInputAmount() {
            return this.inputAmount;
        }

        public Material getOutputMaterial() {
            return this.outputMaterial;
        }

        public int getOutputAmount() {
            return this.outputAmount;
        }

        public Enchantment getEnchantment() {
            return this.enchantment;
        }

        public int getEnchantmentLevel() {
            return this.enchantmentLevel;
        }
    }
}

