/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.DynamicTradeDetector;
import com.alan.VillagerTradeManager.services.DynamicTradeStorageService;
import com.alan.VillagerTradeManager.services.PerformanceMonitorService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.potion.PotionEffectType;

public class TradeService {
    private final VillagerTradeManager plugin;
    private final SettingsService settingsService;
    private final DynamicTradeDetector dynamicTradeDetector;
    private final DynamicTradeStorageService dynamicTradeStorage;
    private final PerformanceMonitorService performanceMonitor;
    private boolean tradeManagementEnabled;
    private boolean hasHeroOfTheVillageEffect = true;
    private boolean hasRaidEvents = true;
    private Map<String, Integer> customPrices = new ConcurrentHashMap<String, Integer>();
    private final Map<UUID, VillagerCacheEntry> villagerCache = new ConcurrentHashMap<UUID, VillagerCacheEntry>();
    private final Map<UUID, Long> playerCacheTimestamps = new ConcurrentHashMap<UUID, Long>();
    private static final long CACHE_TIMEOUT_MS = 60000L;

    public TradeService(VillagerTradeManager plugin, SettingsService settingsService, DynamicTradeStorageService dynamicTradeStorage, PerformanceMonitorService performanceMonitor) {
        this.plugin = plugin;
        this.settingsService = settingsService;
        this.dynamicTradeStorage = dynamicTradeStorage;
        this.performanceMonitor = performanceMonitor;
        this.dynamicTradeDetector = new DynamicTradeDetector(new TradeRegistry(), new SimpleTradeMapper(), performanceMonitor, plugin.getLogger());
        this.tradeManagementEnabled = settingsService.isTradeManagementEnabled();
        try {
            this.detectServerCapabilities();
        }
        catch (Exception e) {
            plugin.getLogger().info("Server capability detection failed, using defaults");
        }
    }

    private void detectServerCapabilities() {
        try {
            PotionEffectType.HERO_OF_THE_VILLAGE.getClass();
        }
        catch (NoSuchFieldError e) {
            this.hasHeroOfTheVillageEffect = false;
            this.plugin.getLogger().info("Hero of the Village effect not available on this server version");
        }
        try {
            Class.forName("org.bukkit.event.raid.RaidFinishEvent");
        }
        catch (ClassNotFoundException e) {
            this.hasRaidEvents = false;
            this.plugin.getLogger().info("Raid events not available on this server version");
        }
    }

    public void processVillagerTrades(Villager villager) {
        block21: {
            if (villager == null || !villager.isValid()) {
                return;
            }
            if (!this.tradeManagementEnabled) {
                if (this.plugin != null && this.plugin.getConfig() != null && this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                    this.plugin.getLogger().fine("Trade management disabled, skipping villager: " + String.valueOf(villager.getUniqueId()));
                }
                return;
            }
            long startTime = System.currentTimeMillis();
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            boolean modified = false;
            try {
                String profession = this.getVillagerProfession(villager);
                for (MerchantRecipe recipe : villager.getRecipes()) {
                    MerchantRecipe customRecipe;
                    ItemStack result = recipe.getResult();
                    List ingredients = recipe.getIngredients();
                    String tradeId = TradeRegistry.identifyTrade(profession, result, ingredients);
                    String priceKey = null;
                    Integer customPrice = null;
                    if (tradeId != null) {
                        priceKey = profession + "_" + tradeId;
                        customPrice = this.customPrices.get(priceKey);
                    } else {
                        String cacheKey = this.generateTradeCacheKey(profession, villager.getVillagerLevel(), ingredients, result);
                        DynamicTradeDetector.DetectedTrade cachedTrade = this.getCachedDetectedTrade(cacheKey);
                        if (cachedTrade != null) {
                            tradeId = cachedTrade.getTradeId();
                            priceKey = profession + "_" + tradeId;
                            customPrice = this.customPrices.get(priceKey);
                        } else {
                            DynamicTradeDetector.DetectedTrade detectedTrade = this.dynamicTradeDetector.detectTrade(villager, recipe);
                            if (detectedTrade != null) {
                                tradeId = detectedTrade.getTradeId();
                                priceKey = profession + "_" + tradeId;
                                customPrice = this.customPrices.get(priceKey);
                                this.cacheDetectedTrade(cacheKey, detectedTrade);
                                if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                                    this.plugin.getLogger().fine("Dynamically detected trade: " + tradeId + " (" + detectedTrade.getSimpleName() + ") for villager: " + String.valueOf(villager.getUniqueId()));
                                }
                            }
                        }
                    }
                    boolean isBanned = false;
                    if (tradeId != null && this.settingsService.isTradeBanned(tradeId)) {
                        isBanned = true;
                    }
                    if (!isBanned && result != null && this.settingsService.isItemBanned(result.getType())) {
                        isBanned = true;
                    }
                    if (isBanned) {
                        if (!this.plugin.getConfig().getBoolean("logging.debug_trades", false)) continue;
                        this.plugin.getLogger().fine("Skipped banned trade: " + tradeId + " for villager: " + String.valueOf(villager.getUniqueId()));
                        continue;
                    }
                    if (customPrice != null && tradeId != null && (customRecipe = this.createCustomTradeRecipe(recipe, customPrice)) != null) {
                        recipes.add(customRecipe);
                        modified = true;
                        continue;
                    }
                    if (result.getType() == Material.ENCHANTED_BOOK && result.hasItemMeta() && (customRecipe = this.createCustomEnchantedBookRecipe(recipe)) != null) {
                        recipes.add(customRecipe);
                        modified = true;
                        continue;
                    }
                    MerchantRecipe neutralizedRecipe = this.createNeutralizedRecipe(recipe);
                    if (neutralizedRecipe != null) {
                        recipes.add(neutralizedRecipe);
                        modified = true;
                        continue;
                    }
                    recipes.add(recipe);
                }
                if (modified) {
                    villager.setRecipes(recipes);
                    if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                        this.plugin.getLogger().fine("Modified " + recipes.size() + " trades for villager: " + String.valueOf(villager.getUniqueId()));
                    }
                }
                long duration = System.currentTimeMillis() - startTime;
                if (this.plugin.getConfig().getBoolean("logging.debug_trades", false) && duration > 10L) {
                    this.plugin.getLogger().info("Trade processing took " + duration + "ms for villager: " + String.valueOf(villager.getUniqueId()));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to process trades for villager " + String.valueOf(villager.getUniqueId()) + ": " + e.getMessage());
                if (!this.plugin.getConfig().getBoolean("logging.debug_database", false)) break block21;
                e.printStackTrace();
            }
        }
    }

    private String generateTradeCacheKey(String profession, int level, List<ItemStack> ingredients, ItemStack result) {
        StringBuilder key = new StringBuilder();
        key.append(profession).append("_").append(level).append("_");
        ingredients.stream().map(this::itemToSimpleString).sorted().forEach(s2 -> key.append((String)s2).append(","));
        key.append("_").append(this.itemToSimpleString(result));
        return key.toString();
    }

    private String itemToSimpleString(ItemStack item) {
        if (item == null) {
            return "null";
        }
        return item.getType().name() + ":" + item.getAmount();
    }

    private DynamicTradeDetector.DetectedTrade getCachedDetectedTrade(String cacheKey) {
        return null;
    }

    private void cacheDetectedTrade(String cacheKey, DynamicTradeDetector.DetectedTrade trade) {
    }

    private MerchantRecipe createCustomEnchantedBookRecipe(MerchantRecipe originalRecipe) {
        EnchantmentStorageMeta meta;
        ItemStack result = originalRecipe.getResult();
        Object enchantKey = "enchanted_book";
        if (result.hasItemMeta() && result.getItemMeta() instanceof EnchantmentStorageMeta && (meta = (EnchantmentStorageMeta)result.getItemMeta()).hasStoredEnchants()) {
            Map.Entry firstEnchant = meta.getStoredEnchants().entrySet().iterator().next();
            String enchantName = this.getEnchantmentKey((Enchantment)firstEnchant.getKey());
            int level = (Integer)firstEnchant.getValue();
            enchantKey = "enchanted_book_" + enchantName + "_" + level;
        }
        int emeraldCost = Math.min(this.customPrices.getOrDefault(enchantKey, 15), 64);
        MerchantRecipe customRecipe = this.createMerchantRecipe(result, this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack books = new ItemStack(Material.BOOK, 1);
        ingredients.add(books);
        ItemStack emeralds = new ItemStack(Material.EMERALD, emeraldCost);
        ingredients.add(emeralds);
        customRecipe.setIngredients(ingredients);
        this.setRecipeDemand(customRecipe, 0);
        this.setRecipeSpecialPrice(customRecipe, 0);
        this.setRecipePriceMultiplier(customRecipe, 0.0f);
        return customRecipe;
    }

    private MerchantRecipe createNeutralizedRecipe(MerchantRecipe originalRecipe) {
        MerchantRecipe neutralizedRecipe = this.createMerchantRecipe(originalRecipe.getResult(), this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        neutralizedRecipe.setIngredients(new ArrayList(originalRecipe.getIngredients()));
        this.setRecipeDemand(neutralizedRecipe, 0);
        this.setRecipeSpecialPrice(neutralizedRecipe, 0);
        this.setRecipePriceMultiplier(neutralizedRecipe, 0.0f);
        return neutralizedRecipe;
    }

    private MerchantRecipe createCustomTradeRecipe(MerchantRecipe originalRecipe, int emeraldCost) {
        MerchantRecipe customRecipe = this.createMerchantRecipe(originalRecipe.getResult(), this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(originalRecipe.getIngredients());
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack ingredient = (ItemStack)ingredients.get(i);
            if (ingredient.getType() != Material.EMERALD) continue;
            ingredients.set(i, new ItemStack(Material.EMERALD, Math.min(emeraldCost, 64)));
            break;
        }
        customRecipe.setIngredients(ingredients);
        this.setRecipeDemand(customRecipe, 0);
        this.setRecipeSpecialPrice(customRecipe, 0);
        this.setRecipePriceMultiplier(customRecipe, 0.0f);
        return customRecipe;
    }

    private String getVillagerProfession(Villager villager) {
        if (villager.getProfession() == null) {
            return "none";
        }
        try {
            return villager.getProfession().getKey().getKey().toLowerCase();
        }
        catch (Exception e) {
            try {
                Registry registry = Registry.VILLAGER_PROFESSION;
                for (Villager.Profession prof : registry) {
                    if (!prof.equals((Object)villager.getProfession())) continue;
                    return prof.getKey().getKey().toLowerCase();
                }
                return villager.getProfession().toString().toLowerCase();
            }
            catch (Exception ex) {
                return "none";
            }
        }
    }

    public void removeHeroEffect(Player player) {
        if (!this.tradeManagementEnabled || !this.hasHeroOfTheVillageEffect) {
            return;
        }
        try {
            player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
        }
        catch (NoSuchMethodError e) {
            try {
                Method removePotionEffectMethod = player.getClass().getMethod("removePotionEffect", PotionEffectType.class);
                removePotionEffectMethod.invoke((Object)player, PotionEffectType.HERO_OF_THE_VILLAGE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getEnchantmentKey(Enchantment enchantment) {
        try {
            return enchantment.getKey().getKey();
        }
        catch (NoSuchMethodError e) {
            return enchantment.getName().toLowerCase();
        }
    }

    private int getRecipeUses(MerchantRecipe recipe) {
        try {
            return recipe.getUses();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private int getRecipeMaxUses(MerchantRecipe recipe) {
        try {
            return recipe.getMaxUses();
        }
        catch (NoSuchMethodError e) {
            return 99999;
        }
    }

    private boolean getRecipeHasExperienceReward(MerchantRecipe recipe) {
        try {
            return recipe.hasExperienceReward();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private int getRecipeVillagerExperience(MerchantRecipe recipe) {
        try {
            return recipe.getVillagerExperience();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private void setRecipeDemand(MerchantRecipe recipe, int demand) {
        try {
            recipe.setDemand(demand);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipeSpecialPrice(MerchantRecipe recipe, int specialPrice) {
        try {
            recipe.setSpecialPrice(specialPrice);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipePriceMultiplier(MerchantRecipe recipe, float multiplier) {
        try {
            recipe.setPriceMultiplier(multiplier);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private MerchantRecipe createMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int villagerExperience, float priceMultiplier) {
        try {
            return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
        }
        catch (NoSuchMethodError e) {
            try {
                return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
            }
            catch (Exception ex) {
                return new MerchantRecipe(result, maxUses);
            }
        }
    }

    public void saveCustomPricesToFile(File pricesFile) {
        try {
            if (!pricesFile.exists()) {
                pricesFile.createNewFile();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(pricesFile));){
                oos.writeObject(new HashMap<String, Integer>(this.customPrices));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save custom prices to file: " + e.getMessage());
        }
    }

    public void loadCustomPricesFromFile(File pricesFile) {
        if (!pricesFile.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(pricesFile));){
            Object obj = ois.readObject();
            if (obj instanceof Map) {
                this.customPrices = new ConcurrentHashMap<String, Integer>((Map)obj);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.plugin.getLogger().severe("Could not load custom prices from file: " + e.getMessage());
        }
    }

    public String convertToUserFriendlyFormat(String internalKey) {
        if (internalKey.startsWith("enchanted_book_")) {
            return internalKey.substring(15).replace("_", " ");
        }
        return internalKey;
    }

    public void startTradeMonitor(PlatformService platformService, TaskScheduler taskScheduler) {
        long frequencyTicks = this.plugin.getConfig().getLong("performance.trade_monitor_frequency", 120L);
        long initialDelay = 40L;
        taskScheduler.runSyncRepeating(() -> {
            if (!this.tradeManagementEnabled) {
                return;
            }
            if (this.hasHeroOfTheVillageEffect) {
                for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                    this.removeHeroEffect(player);
                }
            }
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (platformService.isFoliaPlatform()) {
                    taskScheduler.runSyncAtLocation(player.getLocation(), () -> this.processPlayerVillagers(player));
                    continue;
                }
                this.processPlayerVillagers(player);
            }
        }, initialDelay, frequencyTicks);
    }

    private void processPlayerVillagers(Player player) {
        boolean useCache;
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        int scanRadius = this.plugin.getConfig().getInt("performance.villager_scan_radius", 32);
        Long lastScanTime = this.playerCacheTimestamps.get(playerId);
        boolean bl = useCache = lastScanTime != null && currentTime - lastScanTime < 30000L;
        if (useCache) {
            Set<UUID> cachedVillagerIds = this.getCachedVillagersForPlayer(player, scanRadius);
            int processedCount = 0;
            for (UUID villagerId : cachedVillagerIds) {
                Villager villager = this.getVillagerById(villagerId);
                if (villager == null || !this.isVillagerNearPlayer(villager, player, scanRadius)) continue;
                this.processVillagerTrades(villager);
                ++processedCount;
            }
            if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                this.plugin.getLogger().fine("Processed " + processedCount + " cached villagers for player: " + player.getName());
            }
            return;
        }
        this.playerCacheTimestamps.put(playerId, currentTime);
        List<Object> nearbyVillagers = new ArrayList();
        try {
            nearbyVillagers = player.getNearbyEntities((double)scanRadius, (double)scanRadius, (double)scanRadius).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).collect(Collectors.toList());
        }
        catch (NoSuchMethodError e) {
            for (Entity entity2 : player.getWorld().getEntities()) {
                if (!(entity2 instanceof Villager) || !(entity2.getLocation().distance(player.getLocation()) <= (double)scanRadius)) continue;
                nearbyVillagers.add((Villager)entity2);
            }
        }
        for (Villager villager : nearbyVillagers) {
            UUID villagerId = villager.getUniqueId();
            this.villagerCache.put(villagerId, new VillagerCacheEntry(villagerId, villager.getLocation().clone()));
            this.processVillagerTrades(villager);
        }
        if (this.villagerCache.size() > 1000) {
            this.villagerCache.entrySet().removeIf(entry -> ((VillagerCacheEntry)entry.getValue()).isExpired());
        }
        if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
            this.plugin.getLogger().fine("Scanned and cached " + nearbyVillagers.size() + " villagers for player: " + player.getName());
        }
    }

    private Set<UUID> getCachedVillagersForPlayer(Player player, int radius) {
        HashSet<UUID> validVillagers = new HashSet<UUID>();
        Location playerLoc = player.getLocation();
        for (Map.Entry<UUID, VillagerCacheEntry> entry : this.villagerCache.entrySet()) {
            if (entry.getValue().isExpired() || !entry.getValue().isWithinRadius(playerLoc, radius)) continue;
            validVillagers.add(entry.getKey());
        }
        return validVillagers;
    }

    private boolean isVillagerNearPlayer(Villager villager, Player player, int radius) {
        if (villager == null || !villager.isValid()) {
            return false;
        }
        return villager.getLocation().distance(player.getLocation()) <= (double)radius;
    }

    private Villager getVillagerById(UUID villagerId) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            Chunk playerChunk = player.getLocation().getChunk();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Chunk chunk = player.getWorld().getChunkAt(playerChunk.getX() + x, playerChunk.getZ() + z);
                    if (!chunk.isLoaded()) continue;
                    for (Entity entity : chunk.getEntities()) {
                        if (!(entity instanceof Villager) || !entity.getUniqueId().equals(villagerId)) continue;
                        return (Villager)entity;
                    }
                }
            }
        }
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                for (Entity entity : chunk.getEntities()) {
                    if (!(entity instanceof Villager) || !entity.getUniqueId().equals(villagerId)) continue;
                    return (Villager)entity;
                }
            }
        }
        return null;
    }

    public void saveTradeManagementEnabled(boolean enabled) {
        this.tradeManagementEnabled = enabled;
        this.settingsService.saveSettingToDatabase("trade_management_enabled", String.valueOf(enabled));
        if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
            this.plugin.getLogger().fine("Persisted trade management enabled state: " + enabled);
        }
    }

    public void persistState() {
        this.settingsService.setTradeManagementEnabled(this.tradeManagementEnabled);
        this.settingsService.saveSettingToDatabase("trade_management_enabled", String.valueOf(this.tradeManagementEnabled));
    }

    public boolean isTradeManagementEnabled() {
        return this.tradeManagementEnabled;
    }

    public void setTradeManagementEnabled(boolean enabled) {
        this.tradeManagementEnabled = enabled;
        this.persistState();
    }

    public boolean hasHeroOfTheVillageEffect() {
        return this.hasHeroOfTheVillageEffect;
    }

    public boolean hasRaidEvents() {
        return this.hasRaidEvents;
    }

    public Map<String, Integer> getCustomPrices() {
        return this.customPrices;
    }

    private static class VillagerCacheEntry {
        final UUID villagerId;
        final Location location;
        final long lastProcessed;

        VillagerCacheEntry(UUID villagerId, Location location) {
            this.villagerId = villagerId;
            this.location = location;
            this.lastProcessed = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.lastProcessed > 60000L;
        }

        boolean isWithinRadius(Location playerLocation, int radius) {
            return this.location.distance(playerLocation) <= (double)radius;
        }
    }
}

