/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager;

import com.alan.VillagerTradeManager.commands.VillagerTradeCommand;
import com.alan.VillagerTradeManager.database.AsyncDatabaseExecutor;
import com.alan.VillagerTradeManager.listeners.VillagerTradeListener;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.TradeService;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class VillagerTradeManager
extends JavaPlugin {
    private PlatformService platformService;
    private TaskScheduler taskScheduler;
    private AsyncDatabaseExecutor databaseExecutor;
    private TradeService tradeService;
    private RestockService restockService;
    private SettingsService settingsService;
    private Connection databaseConnection;
    private File pricesFile;

    public void onEnable() {
        this.platformService = new PlatformService((Plugin)this);
        this.taskScheduler = this.platformService.getScheduler();
        this.pricesFile = new File(this.getDataFolder(), "prices.dat");
        this.getDataFolder().mkdirs();
        this.databaseExecutor = new AsyncDatabaseExecutor((Plugin)this, 2);
        this.initializeDatabase();
        this.settingsService = new SettingsService(this, this.databaseConnection, this.databaseExecutor);
        this.tradeService = new TradeService(this);
        this.restockService = new RestockService(this, this.databaseConnection, this.databaseExecutor);
        this.loadCustomPricesFromFile();
        this.settingsService.loadSettingsFromDatabase();
        this.getServer().getPluginManager().registerEvents((Listener)new VillagerTradeListener(this, this.tradeService, this.restockService, this.platformService), (Plugin)this);
        this.getCommand("villagertrade").setExecutor((CommandExecutor)new VillagerTradeCommand(this, this.settingsService, this.tradeService, this.restockService));
        this.getCommand("villagertrade").setTabCompleter((TabCompleter)new VillagerTradeCommand(this, this.settingsService, this.tradeService, this.restockService));
        this.startTradeMonitor();
        this.startRestockMonitor();
        this.getLogger().info("Minecraft Villager Trade Manager plugin enabled!");
        this.getLogger().info("Complete control over villager trading economics.");
        this.getLogger().info("Compatible with Minecraft versions 1.20.x - 1.21.x");
        this.getLogger().info("Platform: " + String.valueOf((Object)this.platformService.getDetectedPlatform()) + " | Scheduler: " + this.taskScheduler.getSchedulerName());
    }

    public void onDisable() {
        if (this.taskScheduler != null) {
            this.taskScheduler.cancelAllTasks();
        }
        if (this.databaseExecutor != null) {
            this.databaseExecutor.shutdown();
        }
        if (this.tradeService != null) {
            this.saveCustomPricesToFile();
        }
        this.closeDatabase();
    }

    private void initializeDatabase() {
        try {
            File dbFile = new File(this.getDataFolder(), "villager_data.db");
            if (!dbFile.exists()) {
                this.getDataFolder().mkdirs();
            }
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.databaseConnection = DriverManager.getConnection(url);
            this.getLogger().info("Database connection established successfully");
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not initialize database: " + e.getMessage());
        }
    }

    private void closeDatabase() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
                this.getLogger().info("Database connection closed successfully");
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not close database connection: " + e.getMessage());
        }
    }

    private void startTradeMonitor() {
        if (this.tradeService != null) {
            this.tradeService.startTradeMonitor(this.platformService, this.taskScheduler);
        }
    }

    private void startRestockMonitor() {
        if (this.restockService != null) {
            this.restockService.startRestockMonitor(this.platformService, this.taskScheduler);
        }
    }

    private void saveCustomPricesToFile() {
        if (this.tradeService != null) {
            this.tradeService.saveCustomPricesToFile(this.pricesFile);
        }
    }

    private void loadCustomPricesFromFile() {
        if (this.tradeService != null) {
            this.tradeService.loadCustomPricesFromFile(this.pricesFile);
        }
    }

    public PlatformService getPlatformService() {
        return this.platformService;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public AsyncDatabaseExecutor getDatabaseExecutor() {
        return this.databaseExecutor;
    }

    public TradeService getTradeService() {
        return this.tradeService;
    }

    public RestockService getRestockService() {
        return this.restockService;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    public Connection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public File getPricesFile() {
        return this.pricesFile;
    }
}

