/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.TradeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.util.StringUtil;

public class VillagerTradeCommand
implements CommandExecutor,
TabCompleter {
    private final VillagerTradeManager plugin;
    private final SettingsService settingsService;
    private final TradeService tradeService;
    private final RestockService restockService;

    public VillagerTradeCommand(VillagerTradeManager plugin, SettingsService settingsService, TradeService tradeService, RestockService restockService) {
        this.plugin = plugin;
        this.settingsService = settingsService;
        this.tradeService = tradeService;
        this.restockService = restockService;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("villagertrade")) {
            if (args.length == 0) {
                sender.sendMessage("\u00a7cUsage: /villagertrade <on|off|status|setprice|restock|restocktime|restocklimit|unlimitedrestock|instantrestock>");
                sender.sendMessage("\u00a77Current status: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "on": {
                    return this.handleOnCommand(sender);
                }
                case "off": {
                    return this.handleOffCommand(sender);
                }
                case "status": {
                    return this.handleStatusCommand(sender);
                }
                case "setprice": {
                    return this.handleSetPriceCommand(sender, args);
                }
                case "restock": {
                    return this.handleRestockCommand(sender, args);
                }
                case "restocktime": {
                    return this.handleRestockTimeCommand(sender, args);
                }
                case "restocklimit": {
                    return this.handleRestockLimitCommand(sender, args);
                }
                case "unlimitedrestock": {
                    return this.handleUnlimitedRestockCommand(sender, args);
                }
                case "instantrestock": {
                    return this.handleInstantRestockCommand(sender, args);
                }
            }
            sender.sendMessage("\u00a7cUsage: /villagertrade <on|off|status|setprice|restock|restocktime|restocklimit|unlimitedrestock|instantrestock>");
            sender.sendMessage("\u00a77Current status: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
            return true;
        }
        return false;
    }

    private boolean handleOnCommand(CommandSender sender) {
        if (this.tradeService.isTradeManagementEnabled()) {
            sender.sendMessage("\u00a7cVillager trade management is already active!");
            return true;
        }
        this.tradeService.setTradeManagementEnabled(true);
        sender.sendMessage("\u00a7aVillager trade management activated!");
        return true;
    }

    private boolean handleOffCommand(CommandSender sender) {
        if (!this.tradeService.isTradeManagementEnabled()) {
            sender.sendMessage("\u00a7cVillager trade management is already inactive!");
            return true;
        }
        this.tradeService.setTradeManagementEnabled(false);
        sender.sendMessage("\u00a7aVillager trade management deactivated!");
        return true;
    }

    private boolean handleStatusCommand(CommandSender sender) {
        sender.sendMessage("\u00a77Villager trade management is currently: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
        sender.sendMessage("\u00a77Custom prices:");
        if (this.tradeService.getCustomPrices().isEmpty()) {
            sender.sendMessage("  \u00a77No custom prices set");
        } else {
            for (Map.Entry<String, Integer> entry : this.tradeService.getCustomPrices().entrySet()) {
                String userFriendlyKey = this.tradeService.convertToUserFriendlyFormat(entry.getKey());
                sender.sendMessage("  \u00a77" + userFriendlyKey + ": \u00a7a" + String.valueOf(entry.getValue()) + " \u00a77emeralds");
            }
        }
        sender.sendMessage("\u00a77Restock Settings:");
        sender.sendMessage("  \u00a77Custom Restock: " + (this.restockService.isCustomRestockEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("  \u00a77Restock Interval: \u00a7a" + this.restockService.getRestockIntervalMinutes() + " \u00a77minutes");
        sender.sendMessage("  \u00a77Restock Limit: \u00a7a" + this.restockService.getRestockLimitPerDay() + " \u00a77per day");
        sender.sendMessage("  \u00a77Unlimited Restock: " + (this.restockService.isUnlimitedRestock() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("  \u00a77Instant Restock: " + (this.restockService.isInstantRestockEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("\u00a77Platform Info:");
        sender.sendMessage("  \u00a77Platform: \u00a7a" + String.valueOf((Object)this.plugin.getPlatformService().getDetectedPlatform()));
        sender.sendMessage("  \u00a77Scheduler: \u00a7a" + this.plugin.getTaskScheduler().getSchedulerName());
        return true;
    }

    private boolean handleSetPriceCommand(CommandSender sender, String[] args) {
        int price;
        int level;
        if (args.length < 4) {
            sender.sendMessage("\u00a7cUsage: /villagertrade setprice <enchant> <level> <price>");
            sender.sendMessage("\u00a77Examples:");
            sender.sendMessage("  \u00a77/villagertrade setprice efficiency 1 20");
            sender.sendMessage("  \u00a77/villagertrade setprice protection 4 35");
            sender.sendMessage("  \u00a77/villagertrade setprice mending 1 50");
            sender.sendMessage("  \u00a77/villagertrade setprice fortune 3 40");
            return true;
        }
        String enchantName = args[1].toLowerCase();
        try {
            level = Integer.parseInt(args[2]);
            price = Integer.parseInt(args[3]);
            if (level <= 0) {
                sender.sendMessage("\u00a7cLevel must be a positive number!");
                return true;
            }
            if (price <= 0) {
                sender.sendMessage("\u00a7cPrice must be a positive number!");
                return true;
            }
            price = Math.min(price, 64);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid level or price! Please enter valid numbers.");
            return true;
        }
        String itemKey = "enchanted_book_" + enchantName + "_" + level;
        this.tradeService.getCustomPrices().put(itemKey, price);
        this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
        sender.sendMessage("\u00a7aSet custom price for \u00a77" + enchantName + " " + level + " \u00a7ato \u00a7e" + price + " \u00a7aemeralds.");
        return true;
    }

    private boolean handleRestockCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
            return true;
        }
        if (args[1].equalsIgnoreCase("on")) {
            this.restockService.setCustomRestockEnabled(true);
            this.settingsService.saveSettingToDatabase("custom_restock_enabled", "true");
            sender.sendMessage("\u00a7aCustom villager restock system enabled!");
            return true;
        }
        if (args[1].equalsIgnoreCase("off")) {
            this.restockService.setCustomRestockEnabled(false);
            this.settingsService.saveSettingToDatabase("custom_restock_enabled", "false");
            sender.sendMessage("\u00a7aCustom villager restock system disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
        return true;
    }

    private boolean handleRestockTimeCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restocktime <minutes>");
            sender.sendMessage("\u00a77Current restock time: \u00a7a" + this.restockService.getRestockIntervalMinutes() + " \u00a77minutes");
            return true;
        }
        try {
            int minutes = Integer.parseInt(args[1]);
            if (minutes <= 0) {
                sender.sendMessage("\u00a7cRestock time must be a positive number!");
                return true;
            }
            this.restockService.setRestockIntervalMinutes(minutes);
            this.settingsService.saveSettingToDatabase("restock_interval_minutes", String.valueOf(minutes));
            sender.sendMessage("\u00a7aSet villager restock interval to \u00a7e" + minutes + " \u00a7aminutes.");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid number! Please enter a valid number of minutes.");
            return true;
        }
    }

    private boolean handleRestockLimitCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restocklimit <count>");
            sender.sendMessage("\u00a77Current restock limit: \u00a7a" + this.restockService.getRestockLimitPerDay() + " \u00a77per day");
            return true;
        }
        try {
            int limit = Integer.parseInt(args[1]);
            if (limit <= 0) {
                sender.sendMessage("\u00a7cRestock limit must be a positive number!");
                return true;
            }
            this.restockService.setRestockLimitPerDay(limit);
            this.settingsService.saveSettingToDatabase("restock_limit_per_day", String.valueOf(limit));
            sender.sendMessage("\u00a7aSet villager restock limit to \u00a7e" + limit + " \u00a7aper day.");
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid number! Please enter a valid restock limit.");
            return true;
        }
    }

    private boolean handleUnlimitedRestockCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
            return true;
        }
        if (args[1].equalsIgnoreCase("on")) {
            this.restockService.setUnlimitedRestock(true);
            this.settingsService.saveSettingToDatabase("unlimited_restock", "true");
            sender.sendMessage("\u00a7aUnlimited villager restock enabled!");
            return true;
        }
        if (args[1].equalsIgnoreCase("off")) {
            this.restockService.setUnlimitedRestock(false);
            this.settingsService.saveSettingToDatabase("unlimited_restock", "false");
            sender.sendMessage("\u00a7aUnlimited villager restock disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
        return true;
    }

    private boolean handleInstantRestockCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /villagertrade instantrestock <on|off>");
            return true;
        }
        if (args[1].equalsIgnoreCase("on")) {
            this.restockService.setInstantRestockEnabled(true);
            this.settingsService.saveSettingToDatabase("instant_restock_enabled", "true");
            sender.sendMessage("\u00a7aInstant villager restock enabled!");
            return true;
        }
        if (args[1].equalsIgnoreCase("off")) {
            this.restockService.setInstantRestockEnabled(false);
            this.settingsService.saveSettingToDatabase("instant_restock_enabled", "false");
            sender.sendMessage("\u00a7aInstant villager restock disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade instantrestock <on|off>");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("villagertrade")) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                List<String> commands = Arrays.asList("on", "off", "status", "setprice", "restock", "restocktime", "restocklimit", "unlimitedrestock", "instantrestock");
                StringUtil.copyPartialMatches((String)args[0], commands, completions);
                Collections.sort(completions);
                return completions;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                for (Enchantment enchantment : Enchantment.values()) {
                    String enchantName = this.tradeService.getEnchantmentKey(enchantment);
                    completions.add(enchantName);
                }
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 2 && (args[0].equalsIgnoreCase("restock") || args[0].equalsIgnoreCase("unlimitedrestock") || args[0].equalsIgnoreCase("instantrestock"))) {
                List<String> completions = Arrays.asList("on", "off");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                String enchantName = args[1].toLowerCase();
                Enchantment targetEnchant = null;
                for (Enchantment enchantment : Enchantment.values()) {
                    if (!this.tradeService.getEnchantmentKey(enchantment).equals(enchantName)) continue;
                    targetEnchant = enchantment;
                    break;
                }
                if (targetEnchant != null) {
                    try {
                        for (int i = 1; i <= targetEnchant.getMaxLevel(); ++i) {
                            completions.add(String.valueOf(i));
                        }
                    }
                    catch (NoSuchMethodError e) {
                        completions.addAll(Arrays.asList("1", "2", "3", "4", "5"));
                    }
                } else {
                    completions.addAll(Arrays.asList("1", "2", "3", "4", "5"));
                }
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[2], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("setprice")) {
                List<String> completions = Arrays.asList("10", "20", "30", "40", "50", "60", "64");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[3], completions, matches);
                Collections.sort(matches);
                return matches;
            }
        }
        return Collections.emptyList();
    }
}

