/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.listeners;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.TradeService;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;

public class VillagerTradeListener
implements Listener {
    private final VillagerTradeManager plugin;
    private final TradeService tradeService;
    private final RestockService restockService;
    private final PlatformService platformService;

    public VillagerTradeListener(VillagerTradeManager plugin, TradeService tradeService, RestockService restockService, PlatformService platformService) {
        this.plugin = plugin;
        this.tradeService = tradeService;
        this.restockService = restockService;
        this.platformService = platformService;
    }

    @EventHandler
    public void onVillagerInteract(PlayerInteractEntityEvent event) {
        if (!this.tradeService.isTradeManagementEnabled()) {
            return;
        }
        if (event.getRightClicked().getType() == EntityType.VILLAGER) {
            Player player = event.getPlayer();
            this.tradeService.removeHeroEffect(player);
            Villager villager = (Villager)event.getRightClicked();
            TaskScheduler taskScheduler = this.plugin.getTaskScheduler();
            if (this.platformService.isFoliaPlatform()) {
                taskScheduler.runSyncForEntity((Entity)villager, () -> this.tradeService.processVillagerTrades(villager));
            } else {
                this.tradeService.processVillagerTrades(villager);
            }
            taskScheduler.runSyncLaterForEntity((Entity)villager, () -> this.tradeService.processVillagerTrades(villager), 1L);
            if (this.restockService.isInstantRestockEnabled()) {
                this.restockService.handleInstantRestock(villager, this.platformService, taskScheduler);
            }
        }
    }

    @EventHandler
    public void onVillagerTransform(EntityTransformEvent event) {
        if (!this.tradeService.isTradeManagementEnabled()) {
            return;
        }
        if (event.getEntity().getType() == EntityType.VILLAGER && event.getTransformReason() == EntityTransformEvent.TransformReason.CURED) {
            Villager villager = (Villager)event.getEntity();
            TaskScheduler taskScheduler = this.plugin.getTaskScheduler();
            if (this.platformService.isFoliaPlatform()) {
                taskScheduler.runSyncForEntity((Entity)villager, () -> this.tradeService.processVillagerTrades(villager));
            } else {
                this.tradeService.processVillagerTrades(villager);
            }
        }
    }

    @EventHandler
    public void onRaidFinish(RaidFinishEvent event) {
        if (!this.tradeService.isTradeManagementEnabled() || !this.tradeService.hasRaidEvents()) {
            return;
        }
        for (Player player : event.getWinners()) {
            if (!this.tradeService.hasHeroOfTheVillageEffect()) continue;
            this.tradeService.removeHeroEffect(player);
        }
    }
}

