/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.scheduler;

import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class BukkitSchedulerWrapper
implements TaskScheduler {
    private final Plugin plugin;
    private final BukkitScheduler scheduler;

    public BukkitSchedulerWrapper(Plugin plugin) {
        this.plugin = plugin;
        this.scheduler = Bukkit.getScheduler();
    }

    @Override
    public void runSync(Runnable task) {
        this.scheduler.runTask(this.plugin, task);
    }

    @Override
    public void runSyncLater(Runnable task, long delayTicks) {
        this.scheduler.runTaskLater(this.plugin, task, delayTicks);
    }

    @Override
    public void runSyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        this.scheduler.runTaskTimer(this.plugin, task, delayTicks, periodTicks);
    }

    @Override
    public void runAsync(Runnable task) {
        this.scheduler.runTaskAsynchronously(this.plugin, task);
    }

    @Override
    public void runAsyncLater(Runnable task, long delayTicks) {
        this.scheduler.runTaskLaterAsynchronously(this.plugin, task, delayTicks);
    }

    @Override
    public void runAsyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        this.scheduler.runTaskTimerAsynchronously(this.plugin, task, delayTicks, periodTicks);
    }

    @Override
    public void runSyncForEntity(Entity entity, Runnable task) {
        this.runSync(task);
    }

    @Override
    public void runSyncLaterForEntity(Entity entity, Runnable task, long delayTicks) {
        this.runSyncLater(task, delayTicks);
    }

    @Override
    public void runSyncAtLocation(Location location, Runnable task) {
        this.runSync(task);
    }

    @Override
    public void runSyncLaterAtLocation(Location location, Runnable task, long delayTicks) {
        this.runSyncLater(task, delayTicks);
    }

    @Override
    public void cancelAllTasks() {
        this.scheduler.cancelTasks(this.plugin);
    }

    @Override
    public String getSchedulerName() {
        return "BukkitScheduler";
    }
}

