/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.scheduler;

import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements TaskScheduler {
    private final Plugin plugin;

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void runSync(Runnable task) {
        try {
            Bukkit.getGlobalRegionScheduler().execute(this.plugin, task);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTask(this.plugin, task);
        }
    }

    @Override
    public void runSyncLater(Runnable task, long delayTicks) {
        try {
            Bukkit.getGlobalRegionScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), delayTicks);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskLater(this.plugin, task, delayTicks);
        }
    }

    @Override
    public void runSyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        try {
            Bukkit.getGlobalRegionScheduler().runAtFixedRate(this.plugin, scheduledTask -> task.run(), delayTicks, periodTicks);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskTimer(this.plugin, task, delayTicks, periodTicks);
        }
    }

    @Override
    public void runAsync(Runnable task) {
        try {
            Bukkit.getAsyncScheduler().runNow(this.plugin, scheduledTask -> task.run());
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task);
        }
    }

    @Override
    public void runAsyncLater(Runnable task, long delayTicks) {
        long delayMillis = delayTicks * 50L;
        try {
            Bukkit.getAsyncScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), delayMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, task, delayTicks);
        }
    }

    @Override
    public void runAsyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        long delayMillis = delayTicks * 50L;
        long periodMillis = periodTicks * 50L;
        try {
            Bukkit.getAsyncScheduler().runAtFixedRate(this.plugin, scheduledTask -> task.run(), delayMillis, periodMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, task, delayTicks, periodTicks);
        }
    }

    @Override
    public void runSyncForEntity(Entity entity, Runnable task) {
        try {
            entity.getScheduler().run(this.plugin, scheduledTask -> task.run(), null);
        }
        catch (Exception e) {
            this.runSync(task);
        }
    }

    @Override
    public void runSyncLaterForEntity(Entity entity, Runnable task, long delayTicks) {
        try {
            entity.getScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), null, delayTicks);
        }
        catch (Exception e) {
            this.runSyncLater(task, delayTicks);
        }
    }

    @Override
    public void runSyncAtLocation(Location location, Runnable task) {
        try {
            Bukkit.getRegionScheduler().run(this.plugin, location, scheduledTask -> task.run());
        }
        catch (Exception e) {
            this.runSync(task);
        }
    }

    @Override
    public void runSyncLaterAtLocation(Location location, Runnable task, long delayTicks) {
        try {
            Bukkit.getRegionScheduler().runDelayed(this.plugin, location, scheduledTask -> task.run(), delayTicks);
        }
        catch (Exception e) {
            this.runSyncLater(task, delayTicks);
        }
    }

    @Override
    public void cancelAllTasks() {
        try {
            Bukkit.getGlobalRegionScheduler().cancelTasks(this.plugin);
            Bukkit.getAsyncScheduler().cancelTasks(this.plugin);
        }
        catch (Exception e) {
            Bukkit.getScheduler().cancelTasks(this.plugin);
        }
    }

    @Override
    public String getSchedulerName() {
        return "FoliaRegionScheduler";
    }
}

