/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.database.AsyncDatabaseExecutor;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SettingsService {
    private final VillagerTradeManager plugin;
    private Connection databaseConnection;
    private final AsyncDatabaseExecutor databaseExecutor;

    public SettingsService(VillagerTradeManager plugin, Connection databaseConnection, AsyncDatabaseExecutor databaseExecutor) {
        this.plugin = plugin;
        this.databaseConnection = databaseConnection;
        this.databaseExecutor = databaseExecutor;
    }

    public void initializeDatabase() {
        try {
            File dbFile = new File(this.plugin.getDataFolder(), "villager_data.db");
            if (!dbFile.exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.databaseConnection = DriverManager.getConnection(url);
            this.createTables();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not initialize database: " + e.getMessage());
        }
    }

    private void createTables() throws SQLException {
        String createPricesTableSQL = "CREATE TABLE IF NOT EXISTS custom_prices (item_key TEXT PRIMARY KEY, price INTEGER NOT NULL);";
        String createSettingsTableSQL = "CREATE TABLE IF NOT EXISTS settings (key TEXT PRIMARY KEY, value TEXT);";
        String createRestockTableSQL = "CREATE TABLE IF NOT EXISTS villager_restock_data (villager_uuid TEXT PRIMARY KEY, last_restock_time INTEGER, restock_count_today INTEGER, last_reset_day INTEGER);";
        try (Statement stmt = this.databaseConnection.createStatement();){
            stmt.execute(createPricesTableSQL);
            stmt.execute(createSettingsTableSQL);
            stmt.execute(createRestockTableSQL);
        }
    }

    public void loadSettingsFromDatabase() {
        this.databaseExecutor.executeAsync(() -> {
            try {
                String selectSQL = "SELECT key, value FROM settings";
                try (Statement stmt = this.databaseConnection.createStatement();
                     ResultSet rs = stmt.executeQuery(selectSQL);){
                    while (rs.next()) {
                        String key = rs.getString("key");
                        String value = rs.getString("value");
                        this.plugin.getTaskScheduler().runSync(() -> {});
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not load settings from database: " + e.getMessage());
            }
        });
    }

    public void saveSettingToDatabase(String key, String value) {
        this.databaseExecutor.executeAsync(() -> {
            try {
                String insertSQL = "INSERT OR REPLACE INTO settings (key, value) VALUES (?, ?)";
                try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
                    pstmt.setString(1, key);
                    pstmt.setString(2, value);
                    pstmt.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not save setting to database: " + e.getMessage());
            }
        });
    }

    public void closeDatabase() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not close database connection: " + e.getMessage());
        }
    }

    public Connection getDatabaseConnection() {
        return this.databaseConnection;
    }
}

