/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.potion.PotionEffectType;

public class TradeService {
    private final VillagerTradeManager plugin;
    private boolean tradeManagementEnabled = true;
    private boolean hasHeroOfTheVillageEffect = true;
    private boolean hasRaidEvents = true;
    private Map<String, Integer> customPrices = new ConcurrentHashMap<String, Integer>();

    public TradeService(VillagerTradeManager plugin) {
        this.plugin = plugin;
        this.detectServerCapabilities();
    }

    private void detectServerCapabilities() {
        try {
            PotionEffectType.HERO_OF_THE_VILLAGE.getClass();
        }
        catch (NoSuchFieldError e) {
            this.hasHeroOfTheVillageEffect = false;
            this.plugin.getLogger().info("Hero of the Village effect not available on this server version");
        }
        try {
            Class.forName("org.bukkit.event.raid.RaidFinishEvent");
        }
        catch (ClassNotFoundException e) {
            this.hasRaidEvents = false;
            this.plugin.getLogger().info("Raid events not available on this server version");
        }
    }

    public void processVillagerTrades(Villager villager) {
        if (!this.tradeManagementEnabled) {
            return;
        }
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        boolean modified = false;
        try {
            for (MerchantRecipe recipe : villager.getRecipes()) {
                ItemStack result = recipe.getResult();
                if (result.getType() == Material.ENCHANTED_BOOK && result.hasItemMeta()) {
                    MerchantRecipe customRecipe = this.createCustomEnchantedBookRecipe(recipe);
                    recipes.add(customRecipe);
                    modified = true;
                    continue;
                }
                MerchantRecipe neutralizedRecipe = this.createNeutralizedRecipe(recipe);
                recipes.add(neutralizedRecipe);
                modified = true;
            }
            if (modified) {
                villager.setRecipes(recipes);
            }
        }
        catch (NoSuchMethodError e) {
            this.plugin.getLogger().warning("Could not process villager trades on this server version");
        }
    }

    private MerchantRecipe createCustomEnchantedBookRecipe(MerchantRecipe originalRecipe) {
        EnchantmentStorageMeta meta;
        ItemStack result = originalRecipe.getResult();
        Object enchantKey = "enchanted_book";
        if (result.hasItemMeta() && result.getItemMeta() instanceof EnchantmentStorageMeta && (meta = (EnchantmentStorageMeta)result.getItemMeta()).hasStoredEnchants()) {
            Map.Entry firstEnchant = meta.getStoredEnchants().entrySet().iterator().next();
            String enchantName = this.getEnchantmentKey((Enchantment)firstEnchant.getKey());
            int level = (Integer)firstEnchant.getValue();
            enchantKey = "enchanted_book_" + enchantName + "_" + level;
        }
        int emeraldCost = Math.min(this.customPrices.getOrDefault(enchantKey, 15), 64);
        MerchantRecipe customRecipe = this.createMerchantRecipe(result, this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack books = new ItemStack(Material.BOOK, 1);
        ingredients.add(books);
        ItemStack emeralds = new ItemStack(Material.EMERALD, emeraldCost);
        ingredients.add(emeralds);
        customRecipe.setIngredients(ingredients);
        this.setRecipeDemand(customRecipe, 0);
        this.setRecipeSpecialPrice(customRecipe, 0);
        this.setRecipePriceMultiplier(customRecipe, 0.0f);
        return customRecipe;
    }

    private MerchantRecipe createNeutralizedRecipe(MerchantRecipe originalRecipe) {
        MerchantRecipe neutralizedRecipe = this.createMerchantRecipe(originalRecipe.getResult(), this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        neutralizedRecipe.setIngredients(new ArrayList(originalRecipe.getIngredients()));
        this.setRecipeDemand(neutralizedRecipe, 0);
        this.setRecipeSpecialPrice(neutralizedRecipe, 0);
        this.setRecipePriceMultiplier(neutralizedRecipe, 0.0f);
        return neutralizedRecipe;
    }

    public void removeHeroEffect(Player player) {
        if (!this.tradeManagementEnabled || !this.hasHeroOfTheVillageEffect) {
            return;
        }
        try {
            player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
        }
        catch (NoSuchMethodError e) {
            try {
                Method removePotionEffectMethod = player.getClass().getMethod("removePotionEffect", PotionEffectType.class);
                removePotionEffectMethod.invoke((Object)player, PotionEffectType.HERO_OF_THE_VILLAGE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getEnchantmentKey(Enchantment enchantment) {
        try {
            return enchantment.getKey().getKey();
        }
        catch (NoSuchMethodError e) {
            return enchantment.getName().toLowerCase();
        }
    }

    private int getRecipeUses(MerchantRecipe recipe) {
        try {
            return recipe.getUses();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private int getRecipeMaxUses(MerchantRecipe recipe) {
        try {
            return recipe.getMaxUses();
        }
        catch (NoSuchMethodError e) {
            return 99999;
        }
    }

    private boolean getRecipeHasExperienceReward(MerchantRecipe recipe) {
        try {
            return recipe.hasExperienceReward();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private int getRecipeVillagerExperience(MerchantRecipe recipe) {
        try {
            return recipe.getVillagerExperience();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private void setRecipeDemand(MerchantRecipe recipe, int demand) {
        try {
            recipe.setDemand(demand);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipeSpecialPrice(MerchantRecipe recipe, int specialPrice) {
        try {
            recipe.setSpecialPrice(specialPrice);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipePriceMultiplier(MerchantRecipe recipe, float multiplier) {
        try {
            recipe.setPriceMultiplier(multiplier);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private MerchantRecipe createMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int villagerExperience, float priceMultiplier) {
        try {
            return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
        }
        catch (NoSuchMethodError e) {
            try {
                return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
            }
            catch (Exception ex) {
                return new MerchantRecipe(result, maxUses);
            }
        }
    }

    public void saveCustomPricesToFile(File pricesFile) {
        try {
            if (!pricesFile.exists()) {
                pricesFile.createNewFile();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(pricesFile));){
                oos.writeObject(new HashMap<String, Integer>(this.customPrices));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save custom prices to file: " + e.getMessage());
        }
    }

    public void loadCustomPricesFromFile(File pricesFile) {
        if (!pricesFile.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(pricesFile));){
            Object obj = ois.readObject();
            if (obj instanceof Map) {
                this.customPrices = new ConcurrentHashMap<String, Integer>((Map)obj);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.plugin.getLogger().severe("Could not load custom prices from file: " + e.getMessage());
        }
    }

    public String convertToUserFriendlyFormat(String internalKey) {
        if (internalKey.startsWith("enchanted_book_")) {
            return internalKey.substring(15).replace("_", " ");
        }
        return internalKey;
    }

    public void startTradeMonitor(PlatformService platformService, TaskScheduler taskScheduler) {
        taskScheduler.runSyncRepeating(() -> {
            if (!this.tradeManagementEnabled) {
                return;
            }
            if (this.hasHeroOfTheVillageEffect) {
                for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                    this.removeHeroEffect(player);
                }
            }
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                if (platformService.isFoliaPlatform()) {
                    taskScheduler.runSyncAtLocation(player.getLocation(), () -> this.processPlayerVillagers(player));
                    continue;
                }
                this.processPlayerVillagers(player);
            }
        }, 20L, 60L);
    }

    private void processPlayerVillagers(Player player) {
        try {
            player.getNearbyEntities(32.0, 32.0, 32.0).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).forEach(villager -> this.processVillagerTrades((Villager)villager));
        }
        catch (NoSuchMethodError e) {
            for (Entity entity2 : player.getWorld().getEntities()) {
                if (!(entity2 instanceof Villager) || !(entity2.getLocation().distance(player.getLocation()) <= 32.0)) continue;
                Villager villager2 = (Villager)entity2;
                this.processVillagerTrades(villager2);
            }
        }
    }

    public boolean isTradeManagementEnabled() {
        return this.tradeManagementEnabled;
    }

    public void setTradeManagementEnabled(boolean enabled) {
        this.tradeManagementEnabled = enabled;
    }

    public boolean hasHeroOfTheVillageEffect() {
        return this.hasHeroOfTheVillageEffect;
    }

    public boolean hasRaidEvents() {
        return this.hasRaidEvents;
    }

    public Map<String, Integer> getCustomPrices() {
        return this.customPrices;
    }
}

