/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.scheduler;

import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements TaskScheduler {
    private final Plugin plugin;

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void runSync(Runnable task) {
        try {
            Class<?> globalRegionSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            Object globalRegionScheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            globalRegionSchedulerClass.getMethod("execute", Plugin.class, Runnable.class).invoke(globalRegionScheduler, this.plugin, task);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTask(this.plugin, task);
        }
    }

    @Override
    public void runSyncLater(Runnable task, long delayTicks) {
        try {
            Class<?> globalRegionSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            Object globalRegionScheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            globalRegionSchedulerClass.getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE).invoke(globalRegionScheduler, this.plugin, scheduledTask -> task.run(), delayTicks);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskLater(this.plugin, task, delayTicks);
        }
    }

    @Override
    public void runSyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        try {
            Class<?> globalRegionSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            Object globalRegionScheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            globalRegionSchedulerClass.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE).invoke(globalRegionScheduler, this.plugin, scheduledTask -> task.run(), delayTicks, periodTicks);
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskTimer(this.plugin, task, delayTicks, periodTicks);
        }
    }

    @Override
    public void runAsync(Runnable task) {
        try {
            Class<?> asyncSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            Object asyncScheduler = Bukkit.class.getMethod("getAsyncScheduler", new Class[0]).invoke(null, new Object[0]);
            asyncSchedulerClass.getMethod("runNow", Plugin.class, Consumer.class).invoke(asyncScheduler, this.plugin, scheduledTask -> task.run());
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task);
        }
    }

    @Override
    public void runAsyncLater(Runnable task, long delayTicks) {
        long delayMillis = delayTicks * 50L;
        try {
            Class<?> asyncSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            Object asyncScheduler = Bukkit.class.getMethod("getAsyncScheduler", new Class[0]).invoke(null, new Object[0]);
            asyncSchedulerClass.getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class).invoke(asyncScheduler, new Object[]{this.plugin, scheduledTask -> task.run(), delayMillis, TimeUnit.MILLISECONDS});
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, task, delayTicks);
        }
    }

    @Override
    public void runAsyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        long delayMillis = delayTicks * 50L;
        long periodMillis = periodTicks * 50L;
        try {
            Class<?> asyncSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            Object asyncScheduler = Bukkit.class.getMethod("getAsyncScheduler", new Class[0]).invoke(null, new Object[0]);
            asyncSchedulerClass.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class).invoke(asyncScheduler, new Object[]{this.plugin, scheduledTask -> task.run(), delayMillis, periodMillis, TimeUnit.MILLISECONDS});
        }
        catch (Exception e) {
            Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, task, delayTicks, periodTicks);
        }
    }

    @Override
    public void runSyncForEntity(Entity entity, Runnable task) {
        try {
            Class<?> entitySchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
            Object entityScheduler = entity.getClass().getMethod("getScheduler", new Class[0]).invoke((Object)entity, new Object[0]);
            entitySchedulerClass.getMethod("run", Plugin.class, Consumer.class, Runnable.class).invoke(entityScheduler, this.plugin, scheduledTask -> task.run(), null);
        }
        catch (Exception e) {
            this.runSync(task);
        }
    }

    @Override
    public void runSyncLaterForEntity(Entity entity, Runnable task, long delayTicks) {
        try {
            Class<?> entitySchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
            Object entityScheduler = entity.getClass().getMethod("getScheduler", new Class[0]).invoke((Object)entity, new Object[0]);
            entitySchedulerClass.getMethod("runDelayed", Plugin.class, Consumer.class, Runnable.class, Long.TYPE).invoke(entityScheduler, this.plugin, scheduledTask -> task.run(), null, delayTicks);
        }
        catch (Exception e) {
            this.runSyncLater(task, delayTicks);
        }
    }

    @Override
    public void runSyncAtLocation(Location location, Runnable task) {
        try {
            Class<?> regionSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.RegionScheduler");
            Object regionScheduler = Bukkit.class.getMethod("getRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            regionSchedulerClass.getMethod("run", Plugin.class, Location.class, Consumer.class).invoke(regionScheduler, this.plugin, location, scheduledTask -> task.run());
        }
        catch (Exception e) {
            this.runSync(task);
        }
    }

    @Override
    public void runSyncLaterAtLocation(Location location, Runnable task, long delayTicks) {
        try {
            Class<?> regionSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.RegionScheduler");
            Object regionScheduler = Bukkit.class.getMethod("getRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            regionSchedulerClass.getMethod("runDelayed", Plugin.class, Location.class, Consumer.class, Long.TYPE).invoke(regionScheduler, this.plugin, location, scheduledTask -> task.run(), delayTicks);
        }
        catch (Exception e) {
            this.runSyncLater(task, delayTicks);
        }
    }

    @Override
    public void cancelAllTasks() {
        try {
            Class<?> globalRegionSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            Object globalRegionScheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            globalRegionSchedulerClass.getMethod("cancelTasks", Plugin.class).invoke(globalRegionScheduler, this.plugin);
            Class<?> asyncSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            Object asyncScheduler = Bukkit.class.getMethod("getAsyncScheduler", new Class[0]).invoke(null, new Object[0]);
            asyncSchedulerClass.getMethod("cancelTasks", Plugin.class).invoke(asyncScheduler, this.plugin);
        }
        catch (Exception e) {
            Bukkit.getScheduler().cancelTasks(this.plugin);
        }
    }

    @Override
    public String getSchedulerName() {
        return "FoliaRegionScheduler";
    }
}

