/*
 * Decompiled with CFR 0.152.
 */
package com.alan.noDiscounts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.StringUtil;

public final class NoDiscounts
extends JavaPlugin
implements Listener,
TabExecutor {
    private boolean discountsDisabled = true;
    private BukkitRunnable tradeMonitorTask;
    private Map<String, Integer> customPrices = new ConcurrentHashMap<String, Integer>();
    private File pricesFile;
    private boolean hasHeroOfTheVillageEffect = true;
    private boolean hasRaidEvents = true;

    public void onEnable() {
        this.detectServerCapabilities();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("nodiscounts").setExecutor((CommandExecutor)this);
        this.getCommand("nodiscounts").setTabCompleter((TabCompleter)this);
        this.pricesFile = new File(this.getDataFolder(), "prices.dat");
        this.getDataFolder().mkdirs();
        this.loadCustomPricesFromFile();
        this.startTradeMonitor();
        this.getLogger().info("NoDiscounts plugin enabled! All villager discounts neutralized.");
        this.getLogger().info("Compatible with Minecraft versions 1.20.x - 1.21.x");
    }

    public void onDisable() {
        if (this.tradeMonitorTask != null) {
            this.tradeMonitorTask.cancel();
        }
        this.saveCustomPricesToFile();
    }

    private void detectServerCapabilities() {
        try {
            PotionEffectType.HERO_OF_THE_VILLAGE.getClass();
        }
        catch (NoSuchFieldError e) {
            this.hasHeroOfTheVillageEffect = false;
            this.getLogger().info("Hero of the Village effect not available on this server version");
        }
        try {
            Class.forName("org.bukkit.event.raid.RaidFinishEvent");
        }
        catch (ClassNotFoundException e) {
            this.hasRaidEvents = false;
            this.getLogger().info("Raid events not available on this server version");
        }
    }

    @EventHandler
    public void onVillagerInteract(PlayerInteractEntityEvent event) {
        if (!this.discountsDisabled) {
            return;
        }
        if (event.getRightClicked().getType() == EntityType.VILLAGER) {
            Player player = event.getPlayer();
            if (this.hasHeroOfTheVillageEffect) {
                this.removeHeroEffect(player);
            }
            final Villager villager = (Villager)event.getRightClicked();
            this.processVillagerTrades(villager);
            new BukkitRunnable(this){
                final /* synthetic */ NoDiscounts this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.processVillagerTrades(villager);
                }
            }.runTaskLater((Plugin)this, 1L);
        }
    }

    @EventHandler
    public void onVillagerTransform(EntityTransformEvent event) {
        if (!this.discountsDisabled) {
            return;
        }
        if (event.getEntity().getType() == EntityType.VILLAGER && event.getTransformReason() == EntityTransformEvent.TransformReason.CURED) {
            Villager villager = (Villager)event.getEntity();
            this.processVillagerTrades(villager);
        }
    }

    @EventHandler
    public void onRaidFinish(RaidFinishEvent event) {
        if (!this.discountsDisabled || !this.hasRaidEvents) {
            return;
        }
        for (Player player : event.getWinners()) {
            if (!this.hasHeroOfTheVillageEffect) continue;
            this.removeHeroEffect(player);
        }
    }

    private void startTradeMonitor() {
        this.tradeMonitorTask = new BukkitRunnable(){

            public void run() {
                if (!NoDiscounts.this.discountsDisabled) {
                    return;
                }
                if (NoDiscounts.this.hasHeroOfTheVillageEffect) {
                    for (Player player : NoDiscounts.this.getServer().getOnlinePlayers()) {
                        NoDiscounts.this.removeHeroEffect(player);
                    }
                }
                for (Player player : NoDiscounts.this.getServer().getOnlinePlayers()) {
                    try {
                        player.getNearbyEntities(32.0, 32.0, 32.0).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).forEach(NoDiscounts.this::processVillagerTrades);
                    }
                    catch (NoSuchMethodError e) {
                        for (Entity entity2 : player.getWorld().getEntities()) {
                            if (!(entity2 instanceof Villager) || !(entity2.getLocation().distance(player.getLocation()) <= 32.0)) continue;
                            NoDiscounts.this.processVillagerTrades((Villager)entity2);
                        }
                    }
                }
            }
        };
        this.tradeMonitorTask.runTaskTimer((Plugin)this, 20L, 60L);
    }

    private void processVillagerTrades(Villager villager) {
        if (!this.discountsDisabled) {
            return;
        }
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        boolean modified = false;
        try {
            for (MerchantRecipe recipe : villager.getRecipes()) {
                ItemStack result = recipe.getResult();
                if (result.getType() == Material.ENCHANTED_BOOK && result.hasItemMeta()) {
                    MerchantRecipe customRecipe = this.createCustomEnchantedBookRecipe(recipe);
                    recipes.add(customRecipe);
                    modified = true;
                    continue;
                }
                MerchantRecipe neutralizedRecipe = this.createNeutralizedRecipe(recipe);
                recipes.add(neutralizedRecipe);
                modified = true;
            }
            if (modified) {
                villager.setRecipes(recipes);
            }
        }
        catch (NoSuchMethodError e) {
            this.getLogger().warning("Could not process villager trades on this server version");
        }
    }

    private MerchantRecipe createCustomEnchantedBookRecipe(MerchantRecipe originalRecipe) {
        EnchantmentStorageMeta meta;
        ItemStack result = originalRecipe.getResult();
        Object enchantKey = "enchanted_book";
        if (result.hasItemMeta() && result.getItemMeta() instanceof EnchantmentStorageMeta && (meta = (EnchantmentStorageMeta)result.getItemMeta()).hasStoredEnchants()) {
            Map.Entry firstEnchant = meta.getStoredEnchants().entrySet().iterator().next();
            String enchantName = this.getEnchantmentKey((Enchantment)firstEnchant.getKey());
            int level = (Integer)firstEnchant.getValue();
            enchantKey = "enchanted_book_" + enchantName + "_" + level;
        }
        int emeraldCost = Math.min(this.customPrices.getOrDefault(enchantKey, 15), 64);
        MerchantRecipe customRecipe = this.createMerchantRecipe(result, this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack books = new ItemStack(Material.BOOK, 1);
        ingredients.add(books);
        ItemStack emeralds = new ItemStack(Material.EMERALD, emeraldCost);
        ingredients.add(emeralds);
        customRecipe.setIngredients(ingredients);
        this.setRecipeDemand(customRecipe, 0);
        this.setRecipeSpecialPrice(customRecipe, 0);
        this.setRecipePriceMultiplier(customRecipe, 0.0f);
        return customRecipe;
    }

    private MerchantRecipe createNeutralizedRecipe(MerchantRecipe originalRecipe) {
        MerchantRecipe neutralizedRecipe = this.createMerchantRecipe(originalRecipe.getResult(), this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        neutralizedRecipe.setIngredients(new ArrayList(originalRecipe.getIngredients()));
        this.setRecipeDemand(neutralizedRecipe, 0);
        this.setRecipeSpecialPrice(neutralizedRecipe, 0);
        this.setRecipePriceMultiplier(neutralizedRecipe, 0.0f);
        return neutralizedRecipe;
    }

    private void removeHeroEffect(Player player) {
        if (!this.discountsDisabled || !this.hasHeroOfTheVillageEffect) {
            return;
        }
        try {
            player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
        }
        catch (NoSuchMethodError e) {
            try {
                Method removePotionEffectMethod = player.getClass().getMethod("removePotionEffect", PotionEffectType.class);
                removePotionEffectMethod.invoke((Object)player, PotionEffectType.HERO_OF_THE_VILLAGE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getEnchantmentKey(Enchantment enchantment) {
        try {
            return enchantment.getKey().getKey();
        }
        catch (NoSuchMethodError e) {
            return enchantment.getName().toLowerCase();
        }
    }

    private int getRecipeUses(MerchantRecipe recipe) {
        try {
            return recipe.getUses();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private int getRecipeMaxUses(MerchantRecipe recipe) {
        try {
            return recipe.getMaxUses();
        }
        catch (NoSuchMethodError e) {
            return 99999;
        }
    }

    private boolean getRecipeHasExperienceReward(MerchantRecipe recipe) {
        try {
            return recipe.hasExperienceReward();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private int getRecipeVillagerExperience(MerchantRecipe recipe) {
        try {
            return recipe.getVillagerExperience();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private void setRecipeDemand(MerchantRecipe recipe, int demand) {
        try {
            recipe.setDemand(demand);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipeSpecialPrice(MerchantRecipe recipe, int specialPrice) {
        try {
            recipe.setSpecialPrice(specialPrice);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipePriceMultiplier(MerchantRecipe recipe, float multiplier) {
        try {
            recipe.setPriceMultiplier(multiplier);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private MerchantRecipe createMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int villagerExperience, float priceMultiplier) {
        try {
            return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
        }
        catch (NoSuchMethodError e) {
            try {
                return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
            }
            catch (Exception ex) {
                return new MerchantRecipe(result, maxUses);
            }
        }
    }

    private void saveCustomPricesToFile() {
        try {
            if (!this.pricesFile.exists()) {
                this.pricesFile.createNewFile();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.pricesFile));){
                oos.writeObject(new HashMap<String, Integer>(this.customPrices));
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save custom prices to file: " + e.getMessage());
        }
    }

    private void loadCustomPricesFromFile() {
        if (!this.pricesFile.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.pricesFile));){
            Object obj = ois.readObject();
            if (obj instanceof Map) {
                this.customPrices = new ConcurrentHashMap<String, Integer>((Map)obj);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.getLogger().severe("Could not load custom prices from file: " + e.getMessage());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("nodiscounts")) {
            if (args.length == 0) {
                sender.sendMessage("\u00a7cUsage: /nodiscounts <on|off|status|setprice>");
                sender.sendMessage("\u00a77Current status: " + (this.discountsDisabled ? "\u00a7aActive" : "\u00a7cInactive"));
                return true;
            }
            if (args[0].equalsIgnoreCase("on")) {
                if (this.discountsDisabled) {
                    sender.sendMessage("\u00a7cVillager discount neutralizer is already active!");
                    return true;
                }
                this.discountsDisabled = true;
                sender.sendMessage("\u00a7aVillager discount neutralizer activated!");
                return true;
            }
            if (args[0].equalsIgnoreCase("off")) {
                if (!this.discountsDisabled) {
                    sender.sendMessage("\u00a7cVillager discount neutralizer is already inactive!");
                    return true;
                }
                this.discountsDisabled = false;
                sender.sendMessage("\u00a7aVillager discount neutralizer deactivated!");
                return true;
            }
            if (args[0].equalsIgnoreCase("status")) {
                sender.sendMessage("\u00a77Villager discount neutralizer is currently: " + (this.discountsDisabled ? "\u00a7aActive" : "\u00a7cInactive"));
                sender.sendMessage("\u00a77Custom prices:");
                if (this.customPrices.isEmpty()) {
                    sender.sendMessage("  \u00a77No custom prices set");
                } else {
                    for (Map.Entry<String, Integer> entry : this.customPrices.entrySet()) {
                        String userFriendlyKey = this.convertToUserFriendlyFormat(entry.getKey());
                        sender.sendMessage("  \u00a77" + userFriendlyKey + ": \u00a7a" + String.valueOf(entry.getValue()) + " \u00a77emeralds");
                    }
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("setprice")) {
                int price;
                int level;
                if (args.length < 4) {
                    sender.sendMessage("\u00a7cUsage: /nodiscounts setprice <enchant> <level> <price>");
                    sender.sendMessage("\u00a77Examples:");
                    sender.sendMessage("  \u00a77/nodiscounts setprice efficiency 1 20");
                    sender.sendMessage("  \u00a77/nodiscounts setprice protection 4 35");
                    sender.sendMessage("  \u00a77/nodiscounts setprice mending 1 50");
                    sender.sendMessage("  \u00a77/nodiscounts setprice fortune 3 40");
                    return true;
                }
                String enchantName = args[1].toLowerCase();
                try {
                    level = Integer.parseInt(args[2]);
                    price = Integer.parseInt(args[3]);
                    if (level <= 0) {
                        sender.sendMessage("\u00a7cLevel must be a positive number!");
                        return true;
                    }
                    if (price <= 0) {
                        sender.sendMessage("\u00a7cPrice must be a positive number!");
                        return true;
                    }
                    price = Math.min(price, 64);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cInvalid level or price! Please enter valid numbers.");
                    return true;
                }
                String itemKey = "enchanted_book_" + enchantName + "_" + level;
                this.customPrices.put(itemKey, price);
                this.saveCustomPricesToFile();
                sender.sendMessage("\u00a7aSet custom price for \u00a77" + enchantName + " " + level + " \u00a7ato \u00a7e" + price + " \u00a7aemeralds.");
                return true;
            }
            sender.sendMessage("\u00a7cUsage: /nodiscounts <on|off|status|setprice>");
            sender.sendMessage("\u00a77Current status: " + (this.discountsDisabled ? "\u00a7aActive" : "\u00a7cInactive"));
            return true;
        }
        return false;
    }

    private String convertToUserFriendlyFormat(String internalKey) {
        if (internalKey.startsWith("enchanted_book_")) {
            return internalKey.substring(15).replace("_", " ");
        }
        return internalKey;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("nodiscounts")) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("on");
                commands.add("off");
                commands.add("status");
                commands.add("setprice");
                StringUtil.copyPartialMatches((String)args[0], commands, completions);
                Collections.sort(completions);
                return completions;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                for (Enchantment enchantment : Enchantment.values()) {
                    String enchantName = this.getEnchantmentKey(enchantment);
                    completions.add(enchantName);
                }
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                String enchantName = args[1].toLowerCase();
                Enchantment targetEnchant = null;
                for (Enchantment enchantment : Enchantment.values()) {
                    if (!this.getEnchantmentKey(enchantment).equals(enchantName)) continue;
                    targetEnchant = enchantment;
                    break;
                }
                if (targetEnchant != null) {
                    try {
                        for (int i = 1; i <= targetEnchant.getMaxLevel(); ++i) {
                            completions.add(String.valueOf(i));
                        }
                    }
                    catch (NoSuchMethodError e) {
                        completions.add("1");
                        completions.add("2");
                        completions.add("3");
                        completions.add("4");
                        completions.add("5");
                    }
                } else {
                    completions.add("1");
                    completions.add("2");
                    completions.add("3");
                    completions.add("4");
                    completions.add("5");
                }
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[2], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("10");
                completions.add("20");
                completions.add("30");
                completions.add("40");
                completions.add("50");
                completions.add("60");
                completions.add("64");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[3], completions, matches);
                Collections.sort(matches);
                return matches;
            }
        }
        return Collections.emptyList();
    }
}

