/*
 * Decompiled with CFR 0.152.
 */
package com.alan.noDiscounts;

import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.StringUtil;

public final class NoDiscounts
extends JavaPlugin
implements Listener,
TabExecutor {
    private boolean discountsDisabled = true;
    private BukkitRunnable tradeMonitorTask;
    private Connection databaseConnection;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("nodiscounts").setExecutor((CommandExecutor)this);
        this.getCommand("nodiscounts").setTabCompleter((TabCompleter)this);
        this.initializeDatabase();
        this.startTradeMonitor();
        this.getLogger().info("NoDiscounts plugin enabled! All villager discounts neutralized.");
    }

    public void onDisable() {
        if (this.tradeMonitorTask != null) {
            this.tradeMonitorTask.cancel();
        }
        this.closeDatabase();
    }

    @EventHandler
    public void onVillagerInteract(PlayerInteractEntityEvent event) {
        if (!this.discountsDisabled) {
            return;
        }
        if (event.getRightClicked().getType() == EntityType.VILLAGER) {
            Player player = event.getPlayer();
            this.removeHeroEffect(player);
            final Villager villager = (Villager)event.getRightClicked();
            this.processVillagerTrades(villager);
            new BukkitRunnable(this){
                final /* synthetic */ NoDiscounts this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.processVillagerTrades(villager);
                }
            }.runTaskLater((Plugin)this, 1L);
        }
    }

    @EventHandler
    public void onVillagerTransform(EntityTransformEvent event) {
        if (!this.discountsDisabled) {
            return;
        }
        if (event.getEntity().getType() == EntityType.VILLAGER && event.getTransformReason() == EntityTransformEvent.TransformReason.CURED) {
            Villager villager = (Villager)event.getEntity();
            this.processVillagerTrades(villager);
        }
    }

    @EventHandler
    public void onRaidFinish(RaidFinishEvent event) {
        if (!this.discountsDisabled) {
            return;
        }
        for (Player player : event.getWinners()) {
            this.removeHeroEffect(player);
        }
    }

    private void startTradeMonitor() {
        this.tradeMonitorTask = new BukkitRunnable(){

            public void run() {
                if (!NoDiscounts.this.discountsDisabled) {
                    return;
                }
                for (Player player : NoDiscounts.this.getServer().getOnlinePlayers()) {
                    NoDiscounts.this.removeHeroEffect(player);
                }
                for (Player player : NoDiscounts.this.getServer().getOnlinePlayers()) {
                    player.getNearbyEntities(32.0, 32.0, 32.0).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).forEach(NoDiscounts.this::processVillagerTrades);
                }
            }
        };
        this.tradeMonitorTask.runTaskTimer((Plugin)this, 20L, 60L);
    }

    private void processVillagerTrades(Villager villager) {
        if (!this.discountsDisabled) {
            return;
        }
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        boolean modified = false;
        for (MerchantRecipe recipe : villager.getRecipes()) {
            ItemStack result = recipe.getResult();
            if (result.getType() == Material.ENCHANTED_BOOK && result.hasItemMeta()) {
                MerchantRecipe customRecipe = this.createCustomEnchantedBookRecipe(recipe);
                recipes.add(customRecipe);
                modified = true;
                continue;
            }
            MerchantRecipe neutralizedRecipe = this.createNeutralizedRecipe(recipe);
            recipes.add(neutralizedRecipe);
            modified = true;
        }
        if (modified) {
            villager.setRecipes(recipes);
        }
    }

    private MerchantRecipe createCustomEnchantedBookRecipe(MerchantRecipe originalRecipe) {
        EnchantmentStorageMeta meta;
        ItemStack result = originalRecipe.getResult();
        Object enchantKey = "enchanted_book";
        if (result.hasItemMeta() && result.getItemMeta() instanceof EnchantmentStorageMeta && (meta = (EnchantmentStorageMeta)result.getItemMeta()).hasStoredEnchants()) {
            Map.Entry firstEnchant = meta.getStoredEnchants().entrySet().iterator().next();
            String enchantName = ((Enchantment)firstEnchant.getKey()).getKey().getKey();
            int level = (Integer)firstEnchant.getValue();
            enchantKey = "enchanted_book_" + enchantName + "_" + level;
        }
        int emeraldCost = this.getCustomPrice((String)enchantKey, 15);
        MerchantRecipe customRecipe = new MerchantRecipe(result, originalRecipe.getUses(), originalRecipe.getMaxUses(), false, 0, 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack books = new ItemStack(Material.BOOK, 3 + new Random().nextInt(3));
        ingredients.add(books);
        ItemStack emeralds = new ItemStack(Material.EMERALD, emeraldCost);
        ingredients.add(emeralds);
        customRecipe.setIngredients(ingredients);
        customRecipe.setDemand(0);
        customRecipe.setSpecialPrice(0);
        customRecipe.setPriceMultiplier(0.0f);
        return customRecipe;
    }

    private MerchantRecipe createNeutralizedRecipe(MerchantRecipe originalRecipe) {
        MerchantRecipe neutralizedRecipe = new MerchantRecipe(originalRecipe.getResult(), originalRecipe.getUses(), originalRecipe.getMaxUses(), originalRecipe.hasExperienceReward(), originalRecipe.getVillagerExperience(), 0.0f);
        neutralizedRecipe.setIngredients(new ArrayList(originalRecipe.getIngredients()));
        neutralizedRecipe.setDemand(0);
        neutralizedRecipe.setSpecialPrice(0);
        neutralizedRecipe.setPriceMultiplier(0.0f);
        return neutralizedRecipe;
    }

    private void removeHeroEffect(Player player) {
        if (!this.discountsDisabled) {
            return;
        }
        player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
    }

    private void initializeDatabase() {
        try {
            File dbFile = new File(this.getDataFolder(), "prices.db");
            if (!dbFile.exists()) {
                this.getDataFolder().mkdirs();
            }
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.databaseConnection = DriverManager.getConnection(url);
            String createTableSQL = "CREATE TABLE IF NOT EXISTS custom_prices (item_key TEXT PRIMARY KEY, price INTEGER NOT NULL);";
            try (Statement stmt = this.databaseConnection.createStatement();){
                stmt.execute(createTableSQL);
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not initialize database: " + e.getMessage());
        }
    }

    private void closeDatabase() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not close database connection: " + e.getMessage());
        }
    }

    private void saveCustomPrice(String itemKey, int price) {
        try {
            String insertSQL = "INSERT OR REPLACE INTO custom_prices (item_key, price) VALUES (?, ?)";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
                pstmt.setString(1, itemKey);
                pstmt.setInt(2, price);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not save custom price: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getCustomPrice(String itemKey, int defaultValue) {
        try {
            String selectSQL = "SELECT price FROM custom_prices WHERE item_key = ?";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(selectSQL);){
                pstmt.setString(1, itemKey);
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) return defaultValue;
                int n = rs.getInt("price");
                return n;
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not retrieve custom price: " + e.getMessage());
        }
        return defaultValue;
    }

    private Map<String, Integer> getAllCustomPrices() {
        HashMap<String, Integer> prices = new HashMap<String, Integer>();
        try {
            String selectSQL = "SELECT item_key, price FROM custom_prices";
            try (Statement stmt = this.databaseConnection.createStatement();
                 ResultSet rs = stmt.executeQuery(selectSQL);){
                while (rs.next()) {
                    prices.put(rs.getString("item_key"), rs.getInt("price"));
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not retrieve all custom prices: " + e.getMessage());
        }
        return prices;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("nodiscounts")) {
            if (args.length == 0) {
                sender.sendMessage("\u00a7cUsage: /nodiscounts <on|off|status|setprice>");
                sender.sendMessage("\u00a77Current status: " + (this.discountsDisabled ? "\u00a7aActive" : "\u00a7cInactive"));
                return true;
            }
            if (args[0].equalsIgnoreCase("on")) {
                if (this.discountsDisabled) {
                    sender.sendMessage("\u00a7cVillager discount neutralizer is already active!");
                    return true;
                }
                this.discountsDisabled = true;
                sender.sendMessage("\u00a7aVillager discount neutralizer activated!");
                return true;
            }
            if (args[0].equalsIgnoreCase("off")) {
                if (!this.discountsDisabled) {
                    sender.sendMessage("\u00a7cVillager discount neutralizer is already inactive!");
                    return true;
                }
                this.discountsDisabled = false;
                sender.sendMessage("\u00a7aVillager discount neutralizer deactivated!");
                return true;
            }
            if (args[0].equalsIgnoreCase("status")) {
                sender.sendMessage("\u00a77Villager discount neutralizer is currently: " + (this.discountsDisabled ? "\u00a7aActive" : "\u00a7cInactive"));
                sender.sendMessage("\u00a77Custom prices:");
                Map<String, Integer> allPrices = this.getAllCustomPrices();
                if (allPrices.isEmpty()) {
                    sender.sendMessage("  \u00a77No custom prices set");
                } else {
                    for (Map.Entry<String, Integer> entry : allPrices.entrySet()) {
                        sender.sendMessage("  \u00a77" + entry.getKey() + ": \u00a7a" + String.valueOf(entry.getValue()) + " \u00a77emeralds");
                    }
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("setprice")) {
                int price;
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /nodiscounts setprice <item_key> <price>");
                    sender.sendMessage("\u00a77Examples:");
                    sender.sendMessage("  \u00a77/nodiscounts setprice enchanted_book_sharpness_1 20");
                    sender.sendMessage("  \u00a77/nodiscounts setprice enchanted_book_protection_4 35");
                    sender.sendMessage("  \u00a77/nodiscounts setprice enchanted_book_mending_1 50");
                    sender.sendMessage("  \u00a77/nodiscounts setprice enchanted_book_unbreaking_3 25");
                    sender.sendMessage("  \u00a77(Format: enchanted_book_<enchant_name>_<level>)");
                    return true;
                }
                String itemKey = args[1].toLowerCase();
                try {
                    price = Integer.parseInt(args[2]);
                    if (price <= 0) {
                        sender.sendMessage("\u00a7cPrice must be a positive number!");
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cInvalid price! Please enter a valid number.");
                    return true;
                }
                this.saveCustomPrice(itemKey, price);
                sender.sendMessage("\u00a7aSet custom price for \u00a77" + itemKey + " \u00a7ato \u00a7e" + price + " \u00a7aemeralds.");
                return true;
            }
            sender.sendMessage("\u00a7cUsage: /nodiscounts <on|off|status|setprice>");
            sender.sendMessage("\u00a77Current status: " + (this.discountsDisabled ? "\u00a7aActive" : "\u00a7cInactive"));
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("nodiscounts")) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("on");
                commands.add("off");
                commands.add("status");
                commands.add("setprice");
                StringUtil.copyPartialMatches((String)args[0], commands, completions);
                Collections.sort(completions);
                return completions;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<CallSite> completions = new ArrayList<CallSite>();
                for (Enchantment enchantment : Enchantment.values()) {
                    String enchantName = enchantment.getKey().getKey();
                    for (int level = 1; level <= enchantment.getMaxLevel(); ++level) {
                        String enchantKey = "enchanted_book_" + enchantName + "_" + level;
                        completions.add((CallSite)((Object)enchantKey));
                    }
                }
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
        }
        return Collections.emptyList();
    }
}

