/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.StringUtil;

public final class VillagerTradeManager
extends JavaPlugin
implements Listener,
TabExecutor {
    private boolean tradeManagementEnabled = true;
    private BukkitRunnable tradeMonitorTask;
    private BukkitRunnable restockTask;
    private Map<String, Integer> customPrices = new ConcurrentHashMap<String, Integer>();
    private File pricesFile;
    private boolean hasHeroOfTheVillageEffect = true;
    private boolean hasRaidEvents = true;
    private boolean customRestockEnabled = false;
    private int restockIntervalMinutes = 30;
    private int restockLimitPerDay = 5;
    private boolean unlimitedRestock = false;
    private Connection databaseConnection;
    private Map<UUID, RestockData> villagerRestockData = new ConcurrentHashMap<UUID, RestockData>();

    public void onEnable() {
        this.detectServerCapabilities();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("villagertrade").setExecutor((CommandExecutor)this);
        this.getCommand("villagertrade").setTabCompleter((TabCompleter)this);
        this.pricesFile = new File(this.getDataFolder(), "prices.dat");
        this.getDataFolder().mkdirs();
        this.initializeDatabase();
        this.loadCustomPricesFromFile();
        this.loadSettingsFromDatabase();
        this.startTradeMonitor();
        this.startRestockMonitor();
        this.getLogger().info("Minecraft Villager Trade Manager plugin enabled!");
        this.getLogger().info("Complete control over villager trading economics.");
        this.getLogger().info("Compatible with Minecraft versions 1.20.x - 1.21.x");
    }

    public void onDisable() {
        if (this.tradeMonitorTask != null) {
            this.tradeMonitorTask.cancel();
        }
        if (this.restockTask != null) {
            this.restockTask.cancel();
        }
        this.saveCustomPricesToFile();
        this.closeDatabase();
    }

    private void detectServerCapabilities() {
        try {
            PotionEffectType.HERO_OF_THE_VILLAGE.getClass();
        }
        catch (NoSuchFieldError e) {
            this.hasHeroOfTheVillageEffect = false;
            this.getLogger().info("Hero of the Village effect not available on this server version");
        }
        try {
            Class.forName("org.bukkit.event.raid.RaidFinishEvent");
        }
        catch (ClassNotFoundException e) {
            this.hasRaidEvents = false;
            this.getLogger().info("Raid events not available on this server version");
        }
    }

    private void initializeDatabase() {
        try {
            File dbFile = new File(this.getDataFolder(), "villager_data.db");
            if (!dbFile.exists()) {
                this.getDataFolder().mkdirs();
            }
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.databaseConnection = DriverManager.getConnection(url);
            String createPricesTableSQL = "CREATE TABLE IF NOT EXISTS custom_prices (item_key TEXT PRIMARY KEY, price INTEGER NOT NULL);";
            String createSettingsTableSQL = "CREATE TABLE IF NOT EXISTS settings (key TEXT PRIMARY KEY, value TEXT);";
            String createRestockTableSQL = "CREATE TABLE IF NOT EXISTS villager_restock_data (villager_uuid TEXT PRIMARY KEY, last_restock_time INTEGER, restock_count_today INTEGER, last_reset_day INTEGER);";
            try (Statement stmt = this.databaseConnection.createStatement();){
                stmt.execute(createPricesTableSQL);
                stmt.execute(createSettingsTableSQL);
                stmt.execute(createRestockTableSQL);
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not initialize database: " + e.getMessage());
        }
    }

    private void closeDatabase() {
        try {
            if (this.databaseConnection != null && !this.databaseConnection.isClosed()) {
                this.databaseConnection.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not close database connection: " + e.getMessage());
        }
    }

    private void loadSettingsFromDatabase() {
        try {
            String selectSQL = "SELECT key, value FROM settings";
            try (Statement stmt = this.databaseConnection.createStatement();
                 ResultSet rs = stmt.executeQuery(selectSQL);){
                while (rs.next()) {
                    String key = rs.getString("key");
                    String value = rs.getString("value");
                    switch (key) {
                        case "custom_restock_enabled": {
                            this.customRestockEnabled = Boolean.parseBoolean(value);
                            break;
                        }
                        case "restock_interval_minutes": {
                            this.restockIntervalMinutes = Integer.parseInt(value);
                            break;
                        }
                        case "restock_limit_per_day": {
                            this.restockLimitPerDay = Integer.parseInt(value);
                            break;
                        }
                        case "unlimited_restock": {
                            this.unlimitedRestock = Boolean.parseBoolean(value);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not load settings from database: " + e.getMessage());
        }
    }

    private void saveSettingToDatabase(String key, String value) {
        try {
            String insertSQL = "INSERT OR REPLACE INTO settings (key, value) VALUES (?, ?)";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
                pstmt.setString(1, key);
                pstmt.setString(2, value);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not save setting to database: " + e.getMessage());
        }
    }

    @EventHandler
    public void onVillagerInteract(PlayerInteractEntityEvent event) {
        if (!this.tradeManagementEnabled) {
            return;
        }
        if (event.getRightClicked().getType() == EntityType.VILLAGER) {
            Player player = event.getPlayer();
            if (this.hasHeroOfTheVillageEffect) {
                this.removeHeroEffect(player);
            }
            final Villager villager = (Villager)event.getRightClicked();
            this.processVillagerTrades(villager);
            new BukkitRunnable(this){
                final /* synthetic */ VillagerTradeManager this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.processVillagerTrades(villager);
                }
            }.runTaskLater((Plugin)this, 1L);
        }
    }

    @EventHandler
    public void onVillagerTransform(EntityTransformEvent event) {
        if (!this.tradeManagementEnabled) {
            return;
        }
        if (event.getEntity().getType() == EntityType.VILLAGER && event.getTransformReason() == EntityTransformEvent.TransformReason.CURED) {
            Villager villager = (Villager)event.getEntity();
            this.processVillagerTrades(villager);
        }
    }

    @EventHandler
    public void onRaidFinish(RaidFinishEvent event) {
        if (!this.tradeManagementEnabled || !this.hasRaidEvents) {
            return;
        }
        for (Player player : event.getWinners()) {
            if (!this.hasHeroOfTheVillageEffect) continue;
            this.removeHeroEffect(player);
        }
    }

    private void startTradeMonitor() {
        this.tradeMonitorTask = new BukkitRunnable(){

            public void run() {
                if (!VillagerTradeManager.this.tradeManagementEnabled) {
                    return;
                }
                if (VillagerTradeManager.this.hasHeroOfTheVillageEffect) {
                    for (Player player : VillagerTradeManager.this.getServer().getOnlinePlayers()) {
                        VillagerTradeManager.this.removeHeroEffect(player);
                    }
                }
                for (Player player : VillagerTradeManager.this.getServer().getOnlinePlayers()) {
                    try {
                        player.getNearbyEntities(32.0, 32.0, 32.0).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).forEach(VillagerTradeManager.this::processVillagerTrades);
                    }
                    catch (NoSuchMethodError e) {
                        for (Entity entity2 : player.getWorld().getEntities()) {
                            if (!(entity2 instanceof Villager) || !(entity2.getLocation().distance(player.getLocation()) <= 32.0)) continue;
                            VillagerTradeManager.this.processVillagerTrades((Villager)entity2);
                        }
                    }
                }
            }
        };
        this.tradeMonitorTask.runTaskTimer((Plugin)this, 20L, 60L);
    }

    private void startRestockMonitor() {
        this.restockTask = new BukkitRunnable(){

            public void run() {
                if (!VillagerTradeManager.this.tradeManagementEnabled || !VillagerTradeManager.this.customRestockEnabled) {
                    return;
                }
                for (Player player : VillagerTradeManager.this.getServer().getOnlinePlayers()) {
                    player.getNearbyEntities(64.0, 64.0, 64.0).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).forEach(VillagerTradeManager.this::processVillagerRestock);
                }
            }
        };
        this.restockTask.runTaskTimer((Plugin)this, 1200L, 1200L);
    }

    private void processVillagerTrades(Villager villager) {
        if (!this.tradeManagementEnabled) {
            return;
        }
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        boolean modified = false;
        try {
            for (MerchantRecipe recipe : villager.getRecipes()) {
                ItemStack result = recipe.getResult();
                if (result.getType() == Material.ENCHANTED_BOOK && result.hasItemMeta()) {
                    MerchantRecipe customRecipe = this.createCustomEnchantedBookRecipe(recipe);
                    recipes.add(customRecipe);
                    modified = true;
                    continue;
                }
                MerchantRecipe neutralizedRecipe = this.createNeutralizedRecipe(recipe);
                recipes.add(neutralizedRecipe);
                modified = true;
            }
            if (modified) {
                villager.setRecipes(recipes);
            }
        }
        catch (NoSuchMethodError e) {
            this.getLogger().warning("Could not process villager trades on this server version");
        }
    }

    private void processVillagerRestock(Villager villager) {
        if (!this.customRestockEnabled) {
            return;
        }
        UUID villagerUUID = villager.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long currentDay = currentTime / 86400000L;
        RestockData restockData = this.loadVillagerRestockData(villagerUUID);
        if (restockData.lastResetDay != currentDay) {
            restockData.restockCountToday = 0;
            restockData.lastResetDay = currentDay;
        }
        if (!this.unlimitedRestock && restockData.restockCountToday >= this.restockLimitPerDay) {
            return;
        }
        if (currentTime - restockData.lastRestockTime < (long)(this.restockIntervalMinutes * 60) * 1000L) {
            return;
        }
        this.restockVillagerTrades(villager);
        restockData.lastRestockTime = currentTime;
        ++restockData.restockCountToday;
        this.saveVillagerRestockData(villagerUUID, restockData);
    }

    private void restockVillagerTrades(Villager villager) {
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        for (MerchantRecipe recipe : villager.getRecipes()) {
            MerchantRecipe newRecipe = new MerchantRecipe(recipe.getResult(), 0, recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier());
            newRecipe.setIngredients(new ArrayList(recipe.getIngredients()));
            newRecipe.setDemand(recipe.getDemand());
            newRecipe.setSpecialPrice(recipe.getSpecialPrice());
            recipes.add(newRecipe);
        }
        villager.setRecipes(recipes);
    }

    private RestockData loadVillagerRestockData(UUID villagerUUID) {
        RestockData data = this.villagerRestockData.get(villagerUUID);
        if (data != null) {
            return data;
        }
        try {
            String selectSQL = "SELECT last_restock_time, restock_count_today, last_reset_day FROM villager_restock_data WHERE villager_uuid = ?";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(selectSQL);){
                pstmt.setString(1, villagerUUID.toString());
                ResultSet rs = pstmt.executeQuery();
                data = rs.next() ? new RestockData(rs.getLong("last_restock_time"), rs.getInt("restock_count_today"), rs.getLong("last_reset_day")) : new RestockData(0L, 0, 0L);
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not load villager restock data: " + e.getMessage());
            data = new RestockData(0L, 0, 0L);
        }
        this.villagerRestockData.put(villagerUUID, data);
        return data;
    }

    private void saveVillagerRestockData(UUID villagerUUID, RestockData data) {
        try {
            String insertSQL = "INSERT OR REPLACE INTO villager_restock_data (villager_uuid, last_restock_time, restock_count_today, last_reset_day) VALUES (?, ?, ?, ?)";
            try (PreparedStatement pstmt = this.databaseConnection.prepareStatement(insertSQL);){
                pstmt.setString(1, villagerUUID.toString());
                pstmt.setLong(2, data.lastRestockTime);
                pstmt.setInt(3, data.restockCountToday);
                pstmt.setLong(4, data.lastResetDay);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not save villager restock data: " + e.getMessage());
        }
    }

    private MerchantRecipe createCustomEnchantedBookRecipe(MerchantRecipe originalRecipe) {
        EnchantmentStorageMeta meta;
        ItemStack result = originalRecipe.getResult();
        Object enchantKey = "enchanted_book";
        if (result.hasItemMeta() && result.getItemMeta() instanceof EnchantmentStorageMeta && (meta = (EnchantmentStorageMeta)result.getItemMeta()).hasStoredEnchants()) {
            Map.Entry firstEnchant = meta.getStoredEnchants().entrySet().iterator().next();
            String enchantName = this.getEnchantmentKey((Enchantment)firstEnchant.getKey());
            int level = (Integer)firstEnchant.getValue();
            enchantKey = "enchanted_book_" + enchantName + "_" + level;
        }
        int emeraldCost = Math.min(this.customPrices.getOrDefault(enchantKey, 15), 64);
        MerchantRecipe customRecipe = this.createMerchantRecipe(result, this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack books = new ItemStack(Material.BOOK, 1);
        ingredients.add(books);
        ItemStack emeralds = new ItemStack(Material.EMERALD, emeraldCost);
        ingredients.add(emeralds);
        customRecipe.setIngredients(ingredients);
        this.setRecipeDemand(customRecipe, 0);
        this.setRecipeSpecialPrice(customRecipe, 0);
        this.setRecipePriceMultiplier(customRecipe, 0.0f);
        return customRecipe;
    }

    private MerchantRecipe createNeutralizedRecipe(MerchantRecipe originalRecipe) {
        MerchantRecipe neutralizedRecipe = this.createMerchantRecipe(originalRecipe.getResult(), this.getRecipeUses(originalRecipe), this.getRecipeMaxUses(originalRecipe), this.getRecipeHasExperienceReward(originalRecipe), this.getRecipeVillagerExperience(originalRecipe), 0.0f);
        neutralizedRecipe.setIngredients(new ArrayList(originalRecipe.getIngredients()));
        this.setRecipeDemand(neutralizedRecipe, 0);
        this.setRecipeSpecialPrice(neutralizedRecipe, 0);
        this.setRecipePriceMultiplier(neutralizedRecipe, 0.0f);
        return neutralizedRecipe;
    }

    private void removeHeroEffect(Player player) {
        if (!this.tradeManagementEnabled || !this.hasHeroOfTheVillageEffect) {
            return;
        }
        try {
            player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
        }
        catch (NoSuchMethodError e) {
            try {
                Method removePotionEffectMethod = player.getClass().getMethod("removePotionEffect", PotionEffectType.class);
                removePotionEffectMethod.invoke((Object)player, PotionEffectType.HERO_OF_THE_VILLAGE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getEnchantmentKey(Enchantment enchantment) {
        try {
            return enchantment.getKey().getKey();
        }
        catch (NoSuchMethodError e) {
            return enchantment.getName().toLowerCase();
        }
    }

    private int getRecipeUses(MerchantRecipe recipe) {
        try {
            return recipe.getUses();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private int getRecipeMaxUses(MerchantRecipe recipe) {
        try {
            return recipe.getMaxUses();
        }
        catch (NoSuchMethodError e) {
            return 99999;
        }
    }

    private boolean getRecipeHasExperienceReward(MerchantRecipe recipe) {
        try {
            return recipe.hasExperienceReward();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private int getRecipeVillagerExperience(MerchantRecipe recipe) {
        try {
            return recipe.getVillagerExperience();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private void setRecipeDemand(MerchantRecipe recipe, int demand) {
        try {
            recipe.setDemand(demand);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipeSpecialPrice(MerchantRecipe recipe, int specialPrice) {
        try {
            recipe.setSpecialPrice(specialPrice);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void setRecipePriceMultiplier(MerchantRecipe recipe, float multiplier) {
        try {
            recipe.setPriceMultiplier(multiplier);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private MerchantRecipe createMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int villagerExperience, float priceMultiplier) {
        try {
            return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
        }
        catch (NoSuchMethodError e) {
            try {
                return new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
            }
            catch (Exception ex) {
                return new MerchantRecipe(result, maxUses);
            }
        }
    }

    private void saveCustomPricesToFile() {
        try {
            if (!this.pricesFile.exists()) {
                this.pricesFile.createNewFile();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.pricesFile));){
                oos.writeObject(new HashMap<String, Integer>(this.customPrices));
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save custom prices to file: " + e.getMessage());
        }
    }

    private void loadCustomPricesFromFile() {
        if (!this.pricesFile.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.pricesFile));){
            Object obj = ois.readObject();
            if (obj instanceof Map) {
                this.customPrices = new ConcurrentHashMap<String, Integer>((Map)obj);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.getLogger().severe("Could not load custom prices from file: " + e.getMessage());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("villagertrade")) {
            if (args.length == 0) {
                sender.sendMessage("\u00a7cUsage: /villagertrade <on|off|status|setprice|restock|restocktime|restocklimit|unlimitedrestock>");
                sender.sendMessage("\u00a77Current status: " + (this.tradeManagementEnabled ? "\u00a7aActive" : "\u00a7cInactive"));
                return true;
            }
            if (args[0].equalsIgnoreCase("on")) {
                if (this.tradeManagementEnabled) {
                    sender.sendMessage("\u00a7cVillager trade management is already active!");
                    return true;
                }
                this.tradeManagementEnabled = true;
                sender.sendMessage("\u00a7aVillager trade management activated!");
                return true;
            }
            if (args[0].equalsIgnoreCase("off")) {
                if (!this.tradeManagementEnabled) {
                    sender.sendMessage("\u00a7cVillager trade management is already inactive!");
                    return true;
                }
                this.tradeManagementEnabled = false;
                sender.sendMessage("\u00a7aVillager trade management deactivated!");
                return true;
            }
            if (args[0].equalsIgnoreCase("status")) {
                sender.sendMessage("\u00a77Villager trade management is currently: " + (this.tradeManagementEnabled ? "\u00a7aActive" : "\u00a7cInactive"));
                sender.sendMessage("\u00a77Custom prices:");
                if (this.customPrices.isEmpty()) {
                    sender.sendMessage("  \u00a77No custom prices set");
                } else {
                    for (Map.Entry<String, Integer> entry : this.customPrices.entrySet()) {
                        String userFriendlyKey = this.convertToUserFriendlyFormat(entry.getKey());
                        sender.sendMessage("  \u00a77" + userFriendlyKey + ": \u00a7a" + String.valueOf(entry.getValue()) + " \u00a77emeralds");
                    }
                }
                sender.sendMessage("\u00a77Restock Settings:");
                sender.sendMessage("  \u00a77Custom Restock: " + (this.customRestockEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
                sender.sendMessage("  \u00a77Restock Interval: \u00a7a" + this.restockIntervalMinutes + " \u00a77minutes");
                sender.sendMessage("  \u00a77Restock Limit: \u00a7a" + this.restockLimitPerDay + " \u00a77per day");
                sender.sendMessage("  \u00a77Unlimited Restock: " + (this.unlimitedRestock ? "\u00a7aEnabled" : "\u00a7cDisabled"));
                return true;
            }
            if (args[0].equalsIgnoreCase("setprice")) {
                int price;
                int level;
                if (args.length < 4) {
                    sender.sendMessage("\u00a7cUsage: /villagertrade setprice <enchant> <level> <price>");
                    sender.sendMessage("\u00a77Examples:");
                    sender.sendMessage("  \u00a77/villagertrade setprice efficiency 1 20");
                    sender.sendMessage("  \u00a77/villagertrade setprice protection 4 35");
                    sender.sendMessage("  \u00a77/villagertrade setprice mending 1 50");
                    sender.sendMessage("  \u00a77/villagertrade setprice fortune 3 40");
                    return true;
                }
                String enchantName = args[1].toLowerCase();
                try {
                    level = Integer.parseInt(args[2]);
                    price = Integer.parseInt(args[3]);
                    if (level <= 0) {
                        sender.sendMessage("\u00a7cLevel must be a positive number!");
                        return true;
                    }
                    if (price <= 0) {
                        sender.sendMessage("\u00a7cPrice must be a positive number!");
                        return true;
                    }
                    price = Math.min(price, 64);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cInvalid level or price! Please enter valid numbers.");
                    return true;
                }
                String itemKey = "enchanted_book_" + enchantName + "_" + level;
                this.customPrices.put(itemKey, price);
                this.saveCustomPricesToFile();
                sender.sendMessage("\u00a7aSet custom price for \u00a77" + enchantName + " " + level + " \u00a7ato \u00a7e" + price + " \u00a7aemeralds.");
                return true;
            }
            if (args[0].equalsIgnoreCase("restock")) {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
                    return true;
                }
                if (args[1].equalsIgnoreCase("on")) {
                    this.customRestockEnabled = true;
                    this.saveSettingToDatabase("custom_restock_enabled", "true");
                    sender.sendMessage("\u00a7aCustom villager restock system enabled!");
                    return true;
                }
                if (args[1].equalsIgnoreCase("off")) {
                    this.customRestockEnabled = false;
                    this.saveSettingToDatabase("custom_restock_enabled", "false");
                    sender.sendMessage("\u00a7aCustom villager restock system disabled!");
                    return true;
                }
                sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
                return true;
            }
            if (args[0].equalsIgnoreCase("restocktime")) {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /villagertrade restocktime <minutes>");
                    sender.sendMessage("\u00a77Current restock time: \u00a7a" + this.restockIntervalMinutes + " \u00a77minutes");
                    return true;
                }
                try {
                    int minutes = Integer.parseInt(args[1]);
                    if (minutes <= 0) {
                        sender.sendMessage("\u00a7cRestock time must be a positive number!");
                        return true;
                    }
                    this.restockIntervalMinutes = minutes;
                    this.saveSettingToDatabase("restock_interval_minutes", String.valueOf(minutes));
                    sender.sendMessage("\u00a7aSet villager restock interval to \u00a7e" + minutes + " \u00a7aminutes.");
                    return true;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cInvalid number! Please enter a valid number of minutes.");
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("restocklimit")) {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /villagertrade restocklimit <count>");
                    sender.sendMessage("\u00a77Current restock limit: \u00a7a" + this.restockLimitPerDay + " \u00a77per day");
                    return true;
                }
                try {
                    int limit = Integer.parseInt(args[1]);
                    if (limit <= 0) {
                        sender.sendMessage("\u00a7cRestock limit must be a positive number!");
                        return true;
                    }
                    this.restockLimitPerDay = limit;
                    this.saveSettingToDatabase("restock_limit_per_day", String.valueOf(limit));
                    sender.sendMessage("\u00a7aSet villager restock limit to \u00a7e" + limit + " \u00a7aper day.");
                    return true;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cInvalid number! Please enter a valid restock limit.");
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("unlimitedrestock")) {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
                    return true;
                }
                if (args[1].equalsIgnoreCase("on")) {
                    this.unlimitedRestock = true;
                    this.saveSettingToDatabase("unlimited_restock", "true");
                    sender.sendMessage("\u00a7aUnlimited villager restock enabled!");
                    return true;
                }
                if (args[1].equalsIgnoreCase("off")) {
                    this.unlimitedRestock = false;
                    this.saveSettingToDatabase("unlimited_restock", "false");
                    sender.sendMessage("\u00a7aUnlimited villager restock disabled!");
                    return true;
                }
                sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
                return true;
            }
            sender.sendMessage("\u00a7cUsage: /villagertrade <on|off|status|setprice|restock|restocktime|restocklimit|unlimitedrestock>");
            sender.sendMessage("\u00a77Current status: " + (this.tradeManagementEnabled ? "\u00a7aActive" : "\u00a7cInactive"));
            return true;
        }
        return false;
    }

    private String convertToUserFriendlyFormat(String internalKey) {
        if (internalKey.startsWith("enchanted_book_")) {
            return internalKey.substring(15).replace("_", " ");
        }
        return internalKey;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("villagertrade")) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("on");
                commands.add("off");
                commands.add("status");
                commands.add("setprice");
                commands.add("restock");
                commands.add("restocktime");
                commands.add("restocklimit");
                commands.add("unlimitedrestock");
                StringUtil.copyPartialMatches((String)args[0], commands, completions);
                Collections.sort(completions);
                return completions;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                for (Enchantment enchantment : Enchantment.values()) {
                    String enchantName = this.getEnchantmentKey(enchantment);
                    completions.add(enchantName);
                }
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("restock")) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("on");
                completions.add("off");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("unlimitedrestock")) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("on");
                completions.add("off");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                String enchantName = args[1].toLowerCase();
                Enchantment targetEnchant = null;
                for (Enchantment enchantment : Enchantment.values()) {
                    if (!this.getEnchantmentKey(enchantment).equals(enchantName)) continue;
                    targetEnchant = enchantment;
                    break;
                }
                if (targetEnchant != null) {
                    try {
                        for (int i = 1; i <= targetEnchant.getMaxLevel(); ++i) {
                            completions.add(String.valueOf(i));
                        }
                    }
                    catch (NoSuchMethodError e) {
                        completions.add("1");
                        completions.add("2");
                        completions.add("3");
                        completions.add("4");
                        completions.add("5");
                    }
                } else {
                    completions.add("1");
                    completions.add("2");
                    completions.add("3");
                    completions.add("4");
                    completions.add("5");
                }
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[2], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("setprice")) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("10");
                completions.add("20");
                completions.add("30");
                completions.add("40");
                completions.add("50");
                completions.add("60");
                completions.add("64");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[3], completions, matches);
                Collections.sort(matches);
                return matches;
            }
        }
        return Collections.emptyList();
    }

    private static class RestockData {
        long lastRestockTime;
        int restockCountToday;
        long lastResetDay;

        RestockData(long lastRestockTime, int restockCountToday, long lastResetDay) {
            this.lastRestockTime = lastRestockTime;
            this.restockCountToday = restockCountToday;
            this.lastResetDay = lastResetDay;
        }
    }
}

