/*
 * Decompiled with CFR 0.152.
 */
package yo.mod.util.handler;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import yo.mod.util.handler.OffHandAttackHelper;

public class OffhandSwingPacket
implements IMessage {
    private float swingProgress;
    private int targetId;

    public OffhandSwingPacket() {
    }

    public OffhandSwingPacket(float swingProgress, int targetId) {
        this.swingProgress = swingProgress;
        this.targetId = targetId;
    }

    public float getSwingProgress() {
        return this.swingProgress;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void fromBytes(ByteBuf buf) {
        this.swingProgress = buf.readFloat();
        this.targetId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.swingProgress);
        buf.writeInt(this.targetId);
    }

    public static class Handler
    implements IMessageHandler<OffhandSwingPacket, IMessage> {
        public IMessage onMessage(OffhandSwingPacket message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                Entity target = player.field_70170_p.func_73045_a(message.getTargetId());
                if (target instanceof EntityLivingBase) {
                    OffHandAttackHelper.attackWithOffhand(player, (EntityLivingBase)target, message.getSwingProgress());
                }
            });
            return null;
        }
    }
}

