/*
 * Decompiled with CFR 0.152.
 */
package yo.mod.util.handler;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yo.mod.GuiHeartsRender;
import yo.mod.Main;
import yo.mod.entity.BlockEventListener;
import yo.mod.entity.GuiHandler;
import yo.mod.init.BlockInit;
import yo.mod.init.EnchantmentInit;
import yo.mod.init.EntityInit;
import yo.mod.init.Iteminit;
import yo.mod.init.PotionInit;
import yo.mod.util.IHasModel;
import yo.mod.util.handler.ConfigHandler;
import yo.mod.util.handler.PacketHandler;
import yo.mod.util.handler.RenderHandler;
import yo.mod.world.gen.WorldGenOres;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])Iteminit.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockInit.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onEnchantmentRegister(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])EnchantmentInit.ENCHANTMENTS.toArray(new Enchantment[0]));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        RenderHandler.registerEntityRenders();
        for (Item item : Iteminit.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : BlockInit.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries(FMLPreInitializationEvent event) {
        PacketHandler.init();
        EntityInit.registerEntities();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOres(), (int)3);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Main.instance, (IGuiHandler)new GuiHandler());
        PotionInit.registerPotions();
        MinecraftForge.EVENT_BUS.register(BlockEventListener.class);
        MinecraftForge.EVENT_BUS.register((Object)new GuiHeartsRender());
        ConfigHandler.registerConfig(event);
    }

    public static void initRegistries() {
    }

    public static void postInitRegistries() {
    }

    public static void OtherRegistries() {
    }

    public static void serverRegistries(FMLServerStartingEvent event) {
    }
}

