/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchool;
import net.spell_power.internals.CustomEntityAttribute;
import net.spell_power.internals.SpellStatusEffect;
import org.jetbrains.annotations.Nullable;

public class SpellSchools {
    public static final String DEFAULT_NAMESPACE = "spell_power";
    private static final LinkedHashMap<ResourceLocation, SpellSchool> REGISTRY = new LinkedHashMap();
    public static final SpellSchool GENERIC = SpellSchools.register(SpellSchools.createMagic("generic", 0x9999BB, 100));
    public static final SpellSchool ARCANE = SpellSchools.register(SpellSchools.createMagic("arcane", 0xFF66FF));
    public static final SpellSchool FIRE = SpellSchools.register(SpellSchools.createMagic("fire", 0xFF3300));
    public static final SpellSchool FROST = SpellSchools.register(SpellSchools.createMagic("frost", 0xCCFFFF));
    public static final SpellSchool HEALING = SpellSchools.register(SpellSchools.createMagic("healing", 0x66FF66));
    public static final SpellSchool LIGHTNING = SpellSchools.register(SpellSchools.createMagic("lightning", 0xFFFF99));
    public static final SpellSchool SOUL = SpellSchools.register(SpellSchools.createMagic("soul", 3003610));

    public static SpellSchool register(SpellSchool school) {
        REGISTRY.put(school.id, school);
        return school;
    }

    public static Set<SpellSchool> all() {
        return new LinkedHashSet<SpellSchool>(REGISTRY.values());
    }

    public static SpellSchool createMagic(String name, int color) {
        return SpellSchools.createMagic(ResourceLocation.fromNamespaceAndPath((String)DEFAULT_NAMESPACE, (String)name.toLowerCase()), color, 0);
    }

    public static SpellSchool createMagic(String name, int color, int base) {
        return SpellSchools.createMagic(ResourceLocation.fromNamespaceAndPath((String)DEFAULT_NAMESPACE, (String)name.toLowerCase()), color, base);
    }

    public static SpellSchool createMagic(ResourceLocation id, int color) {
        return SpellSchools.createMagic(id, color, 0);
    }

    public static SpellSchool createMagic(ResourceLocation id, int color, int base) {
        SpellStatusEffect powerEffect = new SpellStatusEffect(MobEffectCategory.BENEFICIAL, color);
        String translationPrefix = "attribute.name." + id.getNamespace() + ".";
        Attribute attribute = new CustomEntityAttribute(translationPrefix + id.getPath(), base, 0.0, 2048.0, id).setSyncable(true);
        return SpellSchools.createMagic(id, color, true, attribute, powerEffect);
    }

    public static SpellSchool createMagic(ResourceLocation id, int color, boolean customDamageType, Attribute powerAttribute, MobEffect powerEffect) {
        SpellSchool school = new SpellSchool(SpellSchool.Archetype.MAGIC, id, color, (ResourceKey<DamageType>)(customDamageType ? ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)id) : DamageTypes.MAGIC), powerAttribute, powerEffect);
        return SpellSchools.configureAsMagic(school);
    }

    public static SpellSchool configureAsMagic(SpellSchool school) {
        school.addSource(SpellSchool.Trait.POWER, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> query.entity().getAttributeValue(school.getAttributeEntry())));
        SpellSchools.configureSpellHaste(school);
        SpellSchools.configureSpellCritChance(school);
        SpellSchools.configureSpellCritDamage(school);
        return school;
    }

    public static SpellSchool configureSpellHaste(SpellSchool school) {
        school.addSource(SpellSchool.Trait.HASTE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.HASTE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        }));
        return school;
    }

    public static SpellSchool configureSpellCritChance(SpellSchool school) {
        school.addSource(SpellSchool.Trait.CRIT_CHANCE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry);
            return value / 100.0 - 1.0;
        }));
        return school;
    }

    public static SpellSchool configureSpellCritDamage(SpellSchool school) {
        school.addSource(SpellSchool.Trait.CRIT_DAMAGE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_DAMAGE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        }));
        return school;
    }

    @Nullable
    public static SpellSchool getSchool(String idString) {
        String string = idString.toLowerCase(Locale.US);
        ResourceLocation id = ResourceLocation.parse((String)string);
        if (id.getNamespace().equals("minecraft")) {
            id = ResourceLocation.fromNamespaceAndPath((String)DEFAULT_NAMESPACE, (String)id.getPath());
        }
        return REGISTRY.get(id);
    }
}

