/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.ModifierDefinitions;
import net.spell_power.internals.CustomEntityAttribute;
import net.spell_power.internals.SpellStatusEffect;
import org.jetbrains.annotations.Nullable;

public class SpellPowerMechanics {
    public static final float PERCENT_ATTRIBUTE_BASELINE = 100.0f;
    public static final HashMap<String, Entry> all = new HashMap();
    public static final Entry CRITICAL_CHANCE = SpellPowerMechanics.entry("critical_chance", 100.0f, 100.0f, 1000.0f, 0x66CCFF).innateModifier(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, (float)SpellPowerMod.safeLoadedConfig().base_spell_critical_chance_percentage / 100.0f);
    public static final Entry CRITICAL_DAMAGE = SpellPowerMechanics.entry("critical_damage", 100.0f, 100.0f, 1000.0f, 0x66FFCC).innateModifier(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, (float)SpellPowerMod.safeLoadedConfig().base_spell_critical_damage_percentage / 100.0f);
    public static final Entry HASTE = SpellPowerMechanics.entry("haste", 100.0f, 100.0f, 1000.0f, 0xCC99FF);

    public static String translationPrefix() {
        return "attribute.name.spell_power.";
    }

    public static Entry entry(String name, float defaultValue, float min, float max, int color) {
        Entry entry = new Entry(name, defaultValue, min, max, color);
        all.put(name, entry);
        return entry;
    }

    public static class Entry {
        public final String name;
        public final ResourceLocation id;
        public final float defaultValue;
        public final float min;
        public final float max;
        public final CustomEntityAttribute attribute;
        public final MobEffect boostEffect;
        @Nullable
        public AttributeModifier innateModifier;
        @Nullable
        public Holder<Attribute> attributeEntry;
        @Nullable
        public Holder<MobEffect> effectEntry;

        public Entry(String name, float defaultValue, float min, float max, int color) {
            this.name = name;
            this.id = ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)name);
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
            this.attribute = new CustomEntityAttribute(SpellPowerMechanics.translationPrefix() + name, defaultValue, min, max, this.id);
            this.attribute.setSyncable(true);
            this.boostEffect = new SpellStatusEffect(MobEffectCategory.BENEFICIAL, color);
        }

        public void registerAttribute() {
            this.attributeEntry = Registry.registerForHolder((Registry)BuiltInRegistries.ATTRIBUTE, (ResourceLocation)this.id, (Object)((Object)this.attribute));
        }

        public void registerEffect() {
            this.effectEntry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)this.id, (Object)this.boostEffect);
        }

        public Entry innateModifier(AttributeModifier.Operation operation, float value) {
            this.innateModifier = new AttributeModifier(ModifierDefinitions.INNATE_BONUS, (double)value, operation);
            return this;
        }
    }
}

