/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.config;

import java.util.Map;
import net.spell_power.api.DamageCurve;

public class AttributesConfig {
    public AttributeScope attributes_container_injection_scope = AttributeScope.LIVING_ENTITY;
    public double base_spell_critical_chance_percentage = 5.0;
    public double base_spell_critical_damage_percentage = 50.0;
    public EffectConfig spell_power_effect = new EffectConfig(0.1f);
    public Map<String, EffectConfig> secondary_effects;
    public DamageCurve resistance_curve = DamageCurve.HYPERBOLIC;
    public float resistance_multiplier = 1.0f;
    public float resistance_tuning_constant = 20.0f;
    public float resistance_reduction_cap = 0.9f;
    public boolean register_potions = false;

    public static AttributesConfig defaults() {
        AttributesConfig config = new AttributesConfig();
        config.secondary_effects = Map.of("critical_chance", new EffectConfig(0.05f), "critical_damage", new EffectConfig(0.1f), "haste", new EffectConfig(0.05f));
        return config;
    }

    public boolean isValid() {
        AttributesConfig defaults = AttributesConfig.defaults();
        if (this.attributes_container_injection_scope == null) {
            return false;
        }
        if (this.secondary_effects == null) {
            return false;
        }
        for (Map.Entry<String, EffectConfig> entry : defaults.secondary_effects.entrySet()) {
            if (this.secondary_effects.containsKey(entry.getKey())) continue;
            return false;
        }
        return this.spell_power_effect != null;
    }

    public static enum AttributeScope {
        LIVING_ENTITY,
        PLAYER_ENTITY;

    }

    public static class EffectConfig {
        public float bonus_per_stack = 0.1f;

        public EffectConfig() {
        }

        public EffectConfig(float bonus_per_stack) {
            this.bonus_per_stack = bonus_per_stack;
        }
    }
}

