/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.spell_power.SpellPowerMod;
import net.spell_power.config.AttributesConfig;
import org.jetbrains.annotations.Nullable;

public class SpellResistance {
    public static double resist(LivingEntity target, double damage, DamageSource source) {
        double modifier = 1.0;
        AttributesConfig config = (AttributesConfig)SpellPowerMod.attributesConfig.value;
        for (Attributes.Entry resistanceType : Attributes.all) {
            if (!target.getAttributes().hasAttribute(resistanceType.attributeEntry) || !source.is(resistanceType.damageTypes)) continue;
            float resistancePoints = (float)target.getAttributeValue(resistanceType.attributeEntry);
            float reduction = 0.0f;
            switch (config.resistance_curve) {
                case LINEAR: {
                    reduction = resistancePoints / config.resistance_tuning_constant;
                    break;
                }
                case QUADRATIC: {
                    reduction = (float)Math.sqrt(resistancePoints * config.resistance_tuning_constant) * config.resistance_tuning_constant;
                    break;
                }
                case HYPERBOLIC: {
                    reduction = resistancePoints / (resistancePoints + config.resistance_tuning_constant);
                }
            }
            reduction = Math.min(reduction * config.resistance_multiplier, config.resistance_reduction_cap);
            modifier *= (double)(1.0f - reduction);
        }
        return damage * modifier;
    }

    public static class Attributes {
        public static final ArrayList<Entry> all = new ArrayList();
        public static final Entry GENERIC = Attributes.entry("generic", "resistable", 1024.0, true);

        public static Entry entry(String name, String tagName, double maxValue, boolean tracked) {
            return Attributes.entry("resistance." + name, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)tagName), maxValue, tracked);
        }

        public static Entry entry(String name, ResourceLocation damageTagId, double maxValue, boolean tracked) {
            TagKey tag = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)damageTagId);
            Entry entry = new Entry(name, (TagKey<DamageType>)tag, maxValue, tracked);
            all.add(entry);
            return entry;
        }

        public static class Entry {
            public final ResourceLocation id;
            public final String translationKey;
            public final Attribute attribute;
            public final double baseValue;
            public final TagKey<DamageType> damageTypes;
            public final double maxValue;
            @Nullable
            public Holder<Attribute> attributeEntry;

            public Entry(String name, TagKey<DamageType> tag, double maxValue, boolean tracked) {
                this.id = ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)name);
                this.translationKey = "attribute.name.spell_power." + name;
                double baseValue = 0.0;
                double minValue = 0.0;
                this.attribute = new RangedAttribute(this.translationKey, baseValue, minValue, maxValue).setSyncable(tracked);
                this.baseValue = baseValue;
                this.maxValue = maxValue;
                this.damageTypes = tag;
            }

            public void registerAttribute() {
                this.attributeEntry = Registry.registerForHolder((Registry)BuiltInRegistries.ATTRIBUTE, (ResourceLocation)this.id, (Object)this.attribute);
            }
        }
    }
}

