/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.mixin;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import net.spell_power.api.ModifierDefinitions;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellResistance;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> info) {
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry secondary = entry.getValue();
            ((AttributeSupplier.Builder)info.getReturnValue()).add(secondary.attributeEntry);
        }
        for (SpellSchool school : SpellSchools.all()) {
            if (!school.ownsAttribute()) continue;
            Holder<Attribute> attribute = school.attributeEntry;
            ((AttributeSupplier.Builder)info.getReturnValue()).add(attribute);
        }
        for (SpellResistance.Attributes.Entry resistance : SpellResistance.Attributes.all) {
            ((AttributeSupplier.Builder)info.getReturnValue()).add(resistance.attributeEntry);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void onConstructed(EntityType entityType, Level world, CallbackInfo ci) {
        AttributeMap attributes = ((LivingEntity)this).getAttributes();
        for (SpellPowerMechanics.Entry mechanic : SpellPowerMechanics.all.values()) {
            if (mechanic.innateModifier == null || attributes.hasModifier(mechanic.attributeEntry, ModifierDefinitions.INNATE_BONUS)) continue;
            attributes.getInstance(mechanic.attributeEntry).addPermanentModifier(mechanic.innateModifier);
        }
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), ordinal=0)
    private float damage_resistance(float amount, DamageSource source) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.isInvulnerableTo(source) || entity.isDeadOrDying()) {
            return amount;
        }
        return (float)SpellResistance.resist(entity, amount, source);
    }
}

