/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1842;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8110;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.misc.SpellSchoolJSONAdapter;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=SpellSchoolJSONAdapter.class)
public class SpellSchool {
    public final Archetype archetype;
    public final class_2960 id;
    public final int color;
    @Nullable
    private final class_1320 ownedAttribute;
    @Nullable
    public final class_1291 ownedBoostEffect;
    public final class_5321<class_8110> damageType;
    @Nullable
    public class_6880<class_1320> attributeEntry;
    @Nullable
    public class_6880<class_1842> potionEntry;
    private HashMap<Trait, ArrayList<Source>> sources = SpellSchool.emptyTraits();

    public SpellSchool(Archetype archetype, class_2960 id, int color, class_5321<class_8110> damageType, class_6880<class_1320> attributeEntry) {
        this(archetype, id, color, damageType, null, null);
        this.attributeEntry = attributeEntry;
    }

    public SpellSchool(Archetype archetype, class_2960 id, int color, class_5321<class_8110> damageType, class_1320 attribute, @Nullable class_1291 boostEffect) {
        this.archetype = archetype;
        this.id = id;
        this.color = color;
        this.damageType = damageType;
        this.ownedAttribute = attribute;
        this.ownedBoostEffect = boostEffect;
    }

    public float attributeBaseValue() {
        return this.ownedAttribute != null ? (float)this.ownedAttribute.method_6169() : 0.0f;
    }

    public void registerAttribute() {
        if (this.ownedAttribute != null) {
            this.attributeEntry = class_2378.method_47985((class_2378)class_7923.field_41190, (class_2960)this.id, (Object)this.ownedAttribute);
        }
    }

    public void registerPotion() {
        class_6880 entry;
        if (this.ownedBoostEffect != null && (entry = class_7923.field_41174.method_47983((Object)this.ownedBoostEffect)) != null) {
            class_1842 potion = new class_1842(new class_1293[]{new class_1293(entry, 3600)});
            class_2960 potionId = SpellPowerMod.potionIdFrom(this.id);
            class_2378.method_10230((class_2378)class_7923.field_41179, (class_2960)potionId, (Object)potion);
        }
    }

    public class_6880<class_1320> getAttributeEntry() {
        return this.attributeEntry;
    }

    public boolean ownsAttribute() {
        return this.ownedAttribute != null;
    }

    public boolean isMagicArchetype() {
        return this.archetype == Archetype.MAGIC;
    }

    private static HashMap<Trait, ArrayList<Source>> emptyTraits() {
        HashMap<Trait, ArrayList<Source>> map = new HashMap<Trait, ArrayList<Source>>();
        for (Trait trait : Trait.values()) {
            map.put(trait, new ArrayList());
        }
        return map;
    }

    public void addSource(Trait trait, Apply apply, Function<QueryArgs, Double> function) {
        this.addSource(trait, new Source(apply, function));
    }

    public void addSource(Trait trait, Source source) {
        this.sources.get((Object)trait).add(source);
        this.sources.get((Object)trait).sort(Comparator.comparingInt(a -> a.apply.ordinal()));
    }

    public double getValue(Trait trait, QueryArgs query) {
        ArrayList<Source> traitSources = this.sources.get((Object)trait);
        float value = 0.0f;
        switch (trait.ordinal()) {
            case 0: 
            case 2: {
                value = 0.0f;
                break;
            }
            case 1: 
            case 3: {
                value = 1.0f;
            }
        }
        float multiplier = 1.0f;
        for (Source source : traitSources) {
            switch (source.apply.ordinal()) {
                case 0: {
                    value = (float)((double)value + source.function.apply(query));
                    break;
                }
                case 1: {
                    multiplier = (float)((double)multiplier + source.function.apply(query));
                }
            }
        }
        return value *= multiplier;
    }

    public static enum Archetype {
        ARCHERY,
        MAGIC,
        MELEE;

    }

    public static enum Trait {
        POWER,
        HASTE,
        CRIT_CHANCE,
        CRIT_DAMAGE;

    }

    public record Source(Apply apply, Function<QueryArgs, Double> function) {
    }

    public static enum Apply {
        ADD,
        MULTIPLY;

    }

    public record QueryArgs(class_1309 entity) {
    }
}

