/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.tradingpost.client.renderer.blockentity.state.TradingPostRenderState;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TradingPostRenderer
implements BlockEntityRenderer<TradingPostBlockEntity, TradingPostRenderState> {
    private final ItemModelResolver itemModelResolver;

    public TradingPostRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public TradingPostRenderState createRenderState() {
        return new TradingPostRenderState();
    }

    public void extractRenderState(TradingPostBlockEntity blockEntity, TradingPostRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.item.clear();
        this.itemModelResolver.updateForTopItem(renderState.item, new ItemStack((ItemLike)Items.EMERALD), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, (int)blockEntity.getBlockPos().asLong());
        renderState.itemLightCoords = blockEntity.getLevel() != null ? LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().above()) : 0xF000F0;
        blockEntity.getAnimationController().extractRenderState(renderState.animationController, partialTick);
    }

    public void submit(TradingPostRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.03125f, 0.5f);
        poseStack.scale(0.8f, 0.8f, 0.8f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.animationController.rotation));
        float open = renderState.animationController.open;
        poseStack.translate(0.0, (double)open, Math.sin((double)open * Math.PI));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f * (open - 1.0f)));
        float hoverAmount = (float)Math.sin(renderState.animationController.time * 0.06f) * open * 0.2f;
        poseStack.translate(0.0f, hoverAmount, 0.0f);
        renderState.item.submit(poseStack, nodeCollector, renderState.itemLightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }
}

