/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network;

import fuzs.puzzleslib.api.client.searchtree.v1.SearchRegistryHelper;
import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.WritableMessage;
import fuzs.puzzleslib.api.network.v4.message.play.ClientboundPlayMessage;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.client.gui.screens.inventory.TradingPostScreen;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class ClientboundBuildOffersMessage
implements ClientboundPlayMessage,
WritableMessage<RegistryFriendlyByteBuf> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundBuildOffersMessage> STREAM_CODEC = WritableMessage.streamCodec(ClientboundBuildOffersMessage::new);
    private final int containerId;
    private final Int2IntOpenHashMap idToOfferCount;

    public ClientboundBuildOffersMessage(int containerId, Int2IntOpenHashMap idToOfferCount) {
        this.containerId = containerId;
        this.idToOfferCount = idToOfferCount;
    }

    private ClientboundBuildOffersMessage(RegistryFriendlyByteBuf buf) {
        this.containerId = buf.readVarInt();
        Int2IntOpenHashMap idToOfferCount = new Int2IntOpenHashMap();
        int length = buf.readVarInt();
        for (int i = 0; i < length; ++i) {
            idToOfferCount.put(buf.readInt(), buf.readVarInt());
        }
        this.idToOfferCount = idToOfferCount;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.containerId);
        buf.writeVarInt(this.idToOfferCount.size());
        for (Int2IntMap.Entry entry : this.idToOfferCount.int2IntEntrySet()) {
            buf.writeInt(entry.getIntKey());
            buf.writeVarInt(entry.getIntValue());
        }
    }

    public MessageListener<ClientboundPlayMessage.Context> getListener() {
        return new MessageListener<ClientboundPlayMessage.Context>(){

            public void accept(ClientboundPlayMessage.Context context) {
                AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
                if (abstractContainerMenu instanceof TradingPostMenu) {
                    Screen screen;
                    TradingPostMenu menu = (TradingPostMenu)abstractContainerMenu;
                    if (ClientboundBuildOffersMessage.this.containerId == menu.containerId && (screen = context.client().screen) instanceof TradingPostScreen) {
                        TradingPostScreen screen2 = (TradingPostScreen)screen;
                        menu.getTraders().buildOffers(ClientboundBuildOffersMessage.this.idToOfferCount);
                        SearchRegistryHelper.populateSearchTree(TradingPostClient.MERCHANT_OFFERS_SEARCH_TREE, (List)menu.getOffers());
                        screen2.refreshSearchResults();
                    }
                }
            }
        };
    }
}

